/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2020-12-02 14:50:07 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `hm_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `scheduled_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_ci,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `attempts` int(11) NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`)
) ENGINE=InnoDB AUTO_INCREMENT=77 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=92 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `log_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=183 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4;

CREATE TABLE `hm_itsec_bans` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `host` varchar(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'ip',
  `created_at` datetime NOT NULL,
  `actor_type` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `actor_id` varchar(128) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `comment` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `host` (`host`),
  KEY `actor` (`actor_type`,`actor_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `hm_itsec_distributed_storage` (
  `storage_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `storage_group` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `storage_key` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `storage_chunk` int(11) NOT NULL DEFAULT '0',
  `storage_data` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `storage_updated` datetime NOT NULL,
  PRIMARY KEY (`storage_id`),
  UNIQUE KEY `storage_group__key__chunk` (`storage_group`,`storage_key`,`storage_chunk`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_itsec_fingerprints` (
  `fingerprint_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `fingerprint_user` bigint(20) unsigned NOT NULL,
  `fingerprint_hash` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fingerprint_created_at` datetime NOT NULL,
  `fingerprint_approved_at` datetime NOT NULL,
  `fingerprint_data` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `fingerprint_snapshot` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `fingerprint_last_seen` datetime NOT NULL,
  `fingerprint_uses` int(11) NOT NULL DEFAULT '0',
  `fingerprint_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fingerprint_uuid` char(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`fingerprint_id`),
  UNIQUE KEY `fingerprint_user__hash` (`fingerprint_user`,`fingerprint_hash`),
  UNIQUE KEY `fingerprint_uuid` (`fingerprint_uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_itsec_geolocation_cache` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_host` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `location_lat` decimal(10,8) NOT NULL,
  `location_long` decimal(11,8) NOT NULL,
  `location_label` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `location_credit` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `location_time` datetime NOT NULL,
  PRIMARY KEY (`location_id`),
  UNIQUE KEY `location_host` (`location_host`),
  KEY `location_time` (`location_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_itsec_lockouts` (
  `lockout_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `lockout_type` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lockout_start` datetime NOT NULL,
  `lockout_start_gmt` datetime NOT NULL,
  `lockout_expire` datetime NOT NULL,
  `lockout_expire_gmt` datetime NOT NULL,
  `lockout_host` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lockout_user` bigint(20) unsigned DEFAULT NULL,
  `lockout_username` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lockout_active` int(1) NOT NULL DEFAULT '1',
  `lockout_context` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lockout_id`),
  KEY `lockout_expire_gmt` (`lockout_expire_gmt`),
  KEY `lockout_host` (`lockout_host`),
  KEY `lockout_user` (`lockout_user`),
  KEY `lockout_username` (`lockout_username`),
  KEY `lockout_active` (`lockout_active`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_itsec_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `module` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `code` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `data` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'notice',
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `init_timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `memory_current` bigint(20) unsigned NOT NULL DEFAULT '0',
  `memory_peak` bigint(20) unsigned NOT NULL DEFAULT '0',
  `url` varchar(500) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `blog_id` bigint(20) NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `remote_ip` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `module` (`module`),
  KEY `code` (`code`),
  KEY `type` (`type`),
  KEY `timestamp` (`timestamp`),
  KEY `init_timestamp` (`init_timestamp`),
  KEY `user_id` (`user_id`),
  KEY `blog_id` (`blog_id`)
) ENGINE=InnoDB AUTO_INCREMENT=70 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_itsec_mutexes` (
  `mutex_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `mutex_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mutex_expires` int(11) unsigned NOT NULL,
  PRIMARY KEY (`mutex_id`),
  UNIQUE KEY `mutex_name` (`mutex_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_itsec_opaque_tokens` (
  `token_id` char(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token_hashed` char(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token_type` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token_data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `token_created_at` datetime NOT NULL,
  PRIMARY KEY (`token_id`),
  UNIQUE KEY `token_hashed` (`token_hashed`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_itsec_temp` (
  `temp_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `temp_type` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `temp_date` datetime NOT NULL,
  `temp_date_gmt` datetime NOT NULL,
  `temp_host` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `temp_user` bigint(20) unsigned DEFAULT NULL,
  `temp_username` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`temp_id`),
  KEY `temp_date_gmt` (`temp_date_gmt`),
  KEY `temp_host` (`temp_host`),
  KEY `temp_user` (`temp_user`),
  KEY `temp_username` (`temp_username`)
) ENGINE=InnoDB AUTO_INCREMENT=57 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_itsec_user_groups` (
  `group_id` char(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `group_label` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `group_roles` text COLLATE utf8mb4_unicode_ci,
  `group_canonical` text COLLATE utf8mb4_unicode_ci,
  `group_users` text COLLATE utf8mb4_unicode_ci,
  `group_min_role` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `group_created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_learndash_pro_quiz_category` (
  `category_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_name` varchar(200) NOT NULL,
  PRIMARY KEY (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `hm_learndash_pro_quiz_form` (
  `form_id` int(11) NOT NULL AUTO_INCREMENT,
  `quiz_id` int(11) NOT NULL,
  `fieldname` varchar(100) NOT NULL,
  `type` tinyint(4) NOT NULL,
  `required` tinyint(1) unsigned NOT NULL,
  `sort` tinyint(4) NOT NULL,
  `data` mediumtext,
  PRIMARY KEY (`form_id`),
  KEY `quiz_id` (`quiz_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `hm_learndash_pro_quiz_lock` (
  `quiz_id` int(11) NOT NULL,
  `lock_ip` varchar(100) NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `lock_type` tinyint(3) unsigned NOT NULL,
  `lock_date` int(11) NOT NULL,
  PRIMARY KEY (`quiz_id`,`lock_ip`,`user_id`,`lock_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `hm_learndash_pro_quiz_master` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `text` text NOT NULL,
  `result_text` text NOT NULL,
  `result_grade_enabled` tinyint(1) NOT NULL,
  `title_hidden` tinyint(1) NOT NULL,
  `btn_restart_quiz_hidden` tinyint(1) NOT NULL,
  `btn_view_question_hidden` tinyint(1) NOT NULL,
  `question_random` tinyint(1) NOT NULL,
  `answer_random` tinyint(1) NOT NULL,
  `time_limit` int(11) NOT NULL,
  `statistics_on` tinyint(1) NOT NULL,
  `statistics_ip_lock` int(10) unsigned NOT NULL,
  `show_points` tinyint(1) NOT NULL,
  `quiz_run_once` tinyint(1) NOT NULL,
  `quiz_run_once_type` tinyint(4) NOT NULL,
  `quiz_run_once_cookie` tinyint(1) NOT NULL,
  `quiz_run_once_time` int(10) unsigned NOT NULL,
  `numbered_answer` tinyint(1) NOT NULL,
  `hide_answer_message_box` tinyint(1) NOT NULL,
  `disabled_answer_mark` tinyint(1) NOT NULL,
  `show_max_question` tinyint(1) NOT NULL,
  `show_max_question_value` int(10) unsigned NOT NULL,
  `show_max_question_percent` tinyint(1) NOT NULL,
  `toplist_activated` tinyint(1) NOT NULL,
  `toplist_data` text NOT NULL,
  `show_average_result` tinyint(1) NOT NULL,
  `prerequisite` tinyint(1) NOT NULL,
  `quiz_modus` tinyint(3) unsigned NOT NULL,
  `show_review_question` tinyint(1) NOT NULL,
  `quiz_summary_hide` tinyint(1) NOT NULL,
  `skip_question_disabled` tinyint(1) NOT NULL,
  `email_notification` tinyint(3) unsigned NOT NULL,
  `user_email_notification` tinyint(1) unsigned NOT NULL,
  `show_category_score` tinyint(1) unsigned NOT NULL,
  `hide_result_correct_question` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `hide_result_quiz_time` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `hide_result_points` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `autostart` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `forcing_question_solve` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `hide_question_position_overview` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `hide_question_numbering` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `form_activated` tinyint(1) unsigned NOT NULL,
  `form_show_position` tinyint(3) unsigned NOT NULL,
  `start_only_registered_user` tinyint(1) unsigned NOT NULL,
  `questions_per_page` tinyint(3) unsigned NOT NULL,
  `sort_categories` tinyint(1) unsigned NOT NULL,
  `show_category` tinyint(1) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `hm_learndash_pro_quiz_prerequisite` (
  `prerequisite_quiz_id` int(11) NOT NULL,
  `quiz_id` int(11) NOT NULL,
  PRIMARY KEY (`prerequisite_quiz_id`,`quiz_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `hm_learndash_pro_quiz_question` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `quiz_id` int(11) NOT NULL,
  `online` tinyint(1) unsigned NOT NULL,
  `sort` smallint(5) unsigned NOT NULL,
  `title` varchar(200) NOT NULL,
  `points` int(11) NOT NULL,
  `question` text NOT NULL,
  `correct_msg` text NOT NULL,
  `incorrect_msg` text NOT NULL,
  `correct_same_text` tinyint(1) NOT NULL,
  `tip_enabled` tinyint(1) NOT NULL,
  `tip_msg` text NOT NULL,
  `answer_type` varchar(50) NOT NULL,
  `show_points_in_box` tinyint(1) NOT NULL,
  `answer_points_activated` tinyint(1) NOT NULL,
  `answer_data` longtext NOT NULL,
  `category_id` int(10) unsigned NOT NULL,
  `answer_points_diff_modus_activated` tinyint(1) unsigned NOT NULL,
  `disable_correct` tinyint(1) unsigned NOT NULL,
  `matrix_sort_answer_criteria_width` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `quiz_id` (`quiz_id`),
  KEY `category_id` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `hm_learndash_pro_quiz_statistic` (
  `statistic_ref_id` int(10) unsigned NOT NULL,
  `question_id` int(11) NOT NULL,
  `correct_count` int(10) unsigned NOT NULL,
  `incorrect_count` int(10) unsigned NOT NULL,
  `hint_count` int(10) unsigned NOT NULL,
  `points` int(10) unsigned NOT NULL,
  `question_time` int(10) unsigned NOT NULL,
  `answer_data` text,
  PRIMARY KEY (`statistic_ref_id`,`question_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `hm_learndash_pro_quiz_statistic_ref` (
  `statistic_ref_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `quiz_id` int(11) NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `create_time` int(11) NOT NULL,
  `is_old` tinyint(1) unsigned NOT NULL,
  `form_data` text,
  PRIMARY KEY (`statistic_ref_id`),
  KEY `quiz_id` (`quiz_id`,`user_id`),
  KEY `time` (`create_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `hm_learndash_pro_quiz_template` (
  `template_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `type` tinyint(3) unsigned NOT NULL,
  `data` text NOT NULL,
  PRIMARY KEY (`template_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `hm_learndash_pro_quiz_toplist` (
  `toplist_id` int(11) NOT NULL AUTO_INCREMENT,
  `quiz_id` int(11) NOT NULL,
  `date` int(10) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `name` varchar(30) NOT NULL,
  `email` varchar(200) NOT NULL,
  `points` int(10) unsigned NOT NULL,
  `result` float unsigned NOT NULL,
  `ip` varchar(100) NOT NULL,
  PRIMARY KEY (`toplist_id`,`quiz_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `hm_learndash_user_activity` (
  `activity_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `course_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `activity_type` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `activity_status` tinyint(1) unsigned DEFAULT NULL,
  `activity_started` int(11) unsigned DEFAULT NULL,
  `activity_completed` int(11) unsigned DEFAULT NULL,
  `activity_updated` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`activity_id`),
  KEY `user_id` (`user_id`),
  KEY `post_id` (`post_id`),
  KEY `course_id` (`course_id`),
  KEY `activity_status` (`activity_status`),
  KEY `activity_type` (`activity_type`),
  KEY `activity_started` (`activity_started`),
  KEY `activity_completed` (`activity_completed`),
  KEY `activity_updated` (`activity_updated`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_learndash_user_activity_meta` (
  `activity_meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `activity_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `activity_meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `activity_meta_value` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`activity_meta_id`),
  KEY `activity_id` (`activity_id`),
  KEY `activity_meta_key` (`activity_meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_learnpress_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `learnpress_order_item_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `meta_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_learnpress_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_learnpress_question_answermeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `learnpress_question_answer_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `meta_value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_learnpress_question_answers` (
  `question_answer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `question_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `answer_data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `answer_order` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`question_answer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_learnpress_quiz_questions` (
  `quiz_question_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `quiz_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `question_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `question_order` bigint(20) unsigned NOT NULL DEFAULT '1',
  `params` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`quiz_question_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_learnpress_review_logs` (
  `review_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `course_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `status` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_type` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`review_log_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_learnpress_section_items` (
  `section_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `section_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `item_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `item_order` bigint(20) unsigned NOT NULL DEFAULT '0',
  `item_type` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`section_item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_learnpress_sections` (
  `section_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `section_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `section_course_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `section_order` bigint(5) unsigned NOT NULL DEFAULT '0',
  `section_description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`section_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_learnpress_sessions` (
  `session_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `session_key` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `session_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `session_expiry` bigint(20) NOT NULL,
  PRIMARY KEY (`session_key`),
  UNIQUE KEY `session_id` (`session_id`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_learnpress_user_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `learnpress_user_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `meta_value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_learnpress_user_items` (
  `user_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `item_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `start_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `start_time_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `end_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `end_time_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `item_type` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `status` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ref_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `ref_type` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=9398 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3790 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=919 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_smush_dir_images` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `path` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `path_hash` char(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `resize` varchar(55) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lossy` varchar(55) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `error` varchar(55) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image_size` int(10) unsigned DEFAULT NULL,
  `orig_size` int(10) unsigned DEFAULT NULL,
  `file_time` int(10) unsigned DEFAULT NULL,
  `last_scan` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `meta` text COLLATE utf8mb4_unicode_ci,
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `path_hash` (`path_hash`),
  KEY `image_size` (`image_size`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=150 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `query` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_primary` tinyint(1) NOT NULL DEFAULT '0',
  `actioned_text` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=846 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `locale` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `content_data` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT '0',
  `layout` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `image` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `icon` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `first_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `postcode` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `city` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `state` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`),
  CONSTRAINT `fk_hm_wc_download_log_permission_id` FOREIGN KEY (`permission_id`) REFERENCES `hm_woocommerce_downloadable_product_permissions` (`permission_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT '0',
  `product_gross_revenue` double NOT NULL DEFAULT '0',
  `coupon_amount` double NOT NULL DEFAULT '0',
  `tax_amount` double NOT NULL DEFAULT '0',
  `shipping_amount` double NOT NULL DEFAULT '0',
  `shipping_tax_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT '0',
  `total_sales` double NOT NULL DEFAULT '0',
  `tax_total` double NOT NULL DEFAULT '0',
  `shipping_total` double NOT NULL DEFAULT '0',
  `net_total` double NOT NULL DEFAULT '0',
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT '0',
  `order_tax` double NOT NULL DEFAULT '0',
  `total_tax` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT '0',
  `downloadable` tinyint(1) DEFAULT '0',
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT '0',
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT '0',
  `average_rating` decimal(3,2) DEFAULT '0.00',
  `total_sales` bigint(20) DEFAULT '0',
  `tax_status` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT 'taxable',
  `tax_class` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT '0',
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `secret` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `topic` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT '0',
  `pending_delivery` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `permissions` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `consumer_key` char(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `consumer_secret` char(43) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nonces` longtext COLLATE utf8mb4_unicode_ci,
  `truncated_key` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribute_label` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attribute_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribute_orderby` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `order_key` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_email` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_woocommerce_ir` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text1` text CHARACTER SET utf8 COLLATE utf8_persian_ci NOT NULL,
  `text2` text CHARACTER SET utf8 COLLATE utf8_persian_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `hm_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `context` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `order_item_type` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `type` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `session_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT '0',
  `tax_rate_shipping` int(1) NOT NULL DEFAULT '1',
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_yoast_indexable` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `permalink` longtext COLLATE utf8mb4_unicode_ci,
  `permalink_hash` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `object_id` int(11) unsigned DEFAULT NULL,
  `object_type` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `object_sub_type` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `author_id` int(11) unsigned DEFAULT NULL,
  `post_parent` int(11) unsigned DEFAULT NULL,
  `title` text COLLATE utf8mb4_unicode_ci,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `breadcrumb_title` text COLLATE utf8mb4_unicode_ci,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT '0',
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int(11) unsigned DEFAULT NULL,
  `canonical` longtext COLLATE utf8mb4_unicode_ci,
  `primary_focus_keyword` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `primary_focus_keyword_score` int(3) DEFAULT NULL,
  `readability_score` int(3) DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT '0',
  `is_robots_noindex` tinyint(1) DEFAULT '0',
  `is_robots_nofollow` tinyint(1) DEFAULT '0',
  `is_robots_noarchive` tinyint(1) DEFAULT '0',
  `is_robots_noimageindex` tinyint(1) DEFAULT '0',
  `is_robots_nosnippet` tinyint(1) DEFAULT '0',
  `twitter_title` text COLLATE utf8mb4_unicode_ci,
  `twitter_image` longtext COLLATE utf8mb4_unicode_ci,
  `twitter_description` longtext COLLATE utf8mb4_unicode_ci,
  `twitter_image_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `twitter_image_source` text COLLATE utf8mb4_unicode_ci,
  `open_graph_title` text COLLATE utf8mb4_unicode_ci,
  `open_graph_description` longtext COLLATE utf8mb4_unicode_ci,
  `open_graph_image` longtext COLLATE utf8mb4_unicode_ci,
  `open_graph_image_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `open_graph_image_source` text COLLATE utf8mb4_unicode_ci,
  `open_graph_image_meta` mediumtext COLLATE utf8mb4_unicode_ci,
  `link_count` int(11) DEFAULT NULL,
  `incoming_link_count` int(11) DEFAULT NULL,
  `prominent_words_version` int(11) unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint(20) NOT NULL DEFAULT '1',
  `language` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `region` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `schema_page_type` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `schema_article_type` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`)
) ENGINE=InnoDB AUTO_INCREMENT=257 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_yoast_indexable_hierarchy` (
  `indexable_id` int(11) unsigned NOT NULL,
  `ancestor_id` int(11) unsigned NOT NULL,
  `depth` int(11) unsigned DEFAULT NULL,
  `blog_id` bigint(20) NOT NULL DEFAULT '1',
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_yoast_migrations` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hm_yoast_migrations_version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_yoast_primary_term` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` int(11) unsigned NOT NULL,
  `term_id` int(11) unsigned NOT NULL,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint(20) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_yoast_seo_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_id` bigint(20) unsigned NOT NULL,
  `target_post_id` bigint(20) unsigned NOT NULL,
  `type` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL,
  `indexable_id` int(11) unsigned DEFAULT NULL,
  `target_indexable_id` int(11) unsigned DEFAULT NULL,
  `height` int(11) unsigned DEFAULT NULL,
  `width` int(11) unsigned DEFAULT NULL,
  `size` int(11) unsigned DEFAULT NULL,
  `language` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `region` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=12673 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_yoast_seo_meta` (
  `object_id` bigint(20) unsigned NOT NULL,
  `internal_link_count` int(10) unsigned DEFAULT NULL,
  `incoming_link_count` int(10) unsigned DEFAULT NULL,
  UNIQUE KEY `object_id` (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `hm_zhk_updater_logs` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `type` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ver` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_ci,
  `parent` bigint(20) unsigned DEFAULT NULL,
  `level` tinyint(3) unsigned DEFAULT '0',
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


/* INSERT TABLE DATA: hm_actionscheduler_actions */
INSERT INTO `hm_actionscheduler_actions` VALUES("65", "wc-admin_import_customers", "complete", "2020-11-01 18:00:26", "2020-11-01 21:30:26", "[3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1604253626;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1604253626;}", "3", "1", "2020-11-01 18:01:26", "2020-11-01 21:31:26", "0", NULL);
INSERT INTO `hm_actionscheduler_actions` VALUES("66", "wc-admin_import_orders", "complete", "2020-11-01 18:00:26", "2020-11-01 21:30:26", "[851]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1604253626;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1604253626;}", "3", "1", "2020-11-01 18:01:27", "2020-11-01 21:31:27", "0", NULL);
INSERT INTO `hm_actionscheduler_actions` VALUES("67", "wc-admin_import_customers", "complete", "2020-11-01 18:03:50", "2020-11-01 21:33:50", "[3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1604253830;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1604253830;}", "3", "1", "2020-11-01 18:04:01", "2020-11-01 21:34:01", "0", NULL);
INSERT INTO `hm_actionscheduler_actions` VALUES("68", "wc-admin_import_orders", "complete", "2020-11-01 18:03:50", "2020-11-01 21:33:50", "[852]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1604253830;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1604253830;}", "3", "1", "2020-11-01 18:04:01", "2020-11-01 21:34:01", "0", NULL);
INSERT INTO `hm_actionscheduler_actions` VALUES("69", "wc-admin_import_customers", "complete", "2020-11-01 18:09:54", "2020-11-01 21:39:54", "[3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1604254194;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1604254194;}", "3", "1", "2020-11-01 18:10:01", "2020-11-01 21:40:01", "0", NULL);
INSERT INTO `hm_actionscheduler_actions` VALUES("70", "wc-admin_import_orders", "complete", "2020-11-01 18:09:54", "2020-11-01 21:39:54", "[853]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1604254194;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1604254194;}", "3", "1", "2020-11-01 18:10:01", "2020-11-01 21:40:01", "0", NULL);
INSERT INTO `hm_actionscheduler_actions` VALUES("71", "wc-admin_import_orders", "complete", "2020-11-01 18:16:02", "2020-11-01 21:46:02", "[853]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1604254562;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1604254562;}", "3", "1", "2020-11-01 18:16:03", "2020-11-01 21:46:03", "0", NULL);
INSERT INTO `hm_actionscheduler_actions` VALUES("72", "wc-admin_import_orders", "complete", "2020-11-01 18:16:03", "2020-11-01 21:46:03", "[852]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1604254563;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1604254563;}", "3", "1", "2020-11-01 18:16:03", "2020-11-01 21:46:03", "0", NULL);
INSERT INTO `hm_actionscheduler_actions` VALUES("73", "wc-admin_import_orders", "complete", "2020-11-01 18:16:03", "2020-11-01 21:46:03", "[851]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1604254563;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1604254563;}", "3", "1", "2020-11-01 18:16:04", "2020-11-01 21:46:04", "0", NULL);
INSERT INTO `hm_actionscheduler_actions` VALUES("74", "wc-admin_delete_user_customers", "complete", "2020-11-01 18:16:47", "2020-11-01 21:46:47", "[3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1604254607;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1604254607;}", "3", "1", "2020-11-01 18:16:59", "2020-11-01 21:46:59", "0", NULL);
INSERT INTO `hm_actionscheduler_actions` VALUES("75", "action_scheduler/migration_hook", "complete", "2020-11-07 20:05:07", "2020-11-07 23:35:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1604779507;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1604779507;}", "1", "1", "2020-11-07 20:09:54", "2020-11-07 23:39:54", "0", NULL);
INSERT INTO `hm_actionscheduler_actions` VALUES("76", "action_scheduler/migration_hook", "complete", "2020-11-07 20:11:22", "2020-11-07 23:41:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1604779882;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1604779882;}", "1", "1", "2020-11-07 20:11:41", "2020-11-07 23:41:41", "0", NULL);

/* INSERT TABLE DATA: hm_actionscheduler_groups */
INSERT INTO `hm_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `hm_actionscheduler_groups` VALUES("2", "action-scheduler-migration");
INSERT INTO `hm_actionscheduler_groups` VALUES("3", "wc-admin-data");
INSERT INTO `hm_actionscheduler_groups` VALUES("4", "woocommerce-db-updates");

/* INSERT TABLE DATA: hm_actionscheduler_logs */
INSERT INTO `hm_actionscheduler_logs` VALUES("147", "65", "ایجاد فعالیت", "2020-11-01 18:00:21", "2020-11-01 21:30:21");
INSERT INTO `hm_actionscheduler_logs` VALUES("148", "66", "ایجاد فعالیت", "2020-11-01 18:00:21", "2020-11-01 21:30:21");
INSERT INTO `hm_actionscheduler_logs` VALUES("149", "65", "عملیات با WP Cron شروع شد", "2020-11-01 18:01:26", "2020-11-01 21:31:26");
INSERT INTO `hm_actionscheduler_logs` VALUES("150", "65", "عملیات با WP Cron تکمیل شد", "2020-11-01 18:01:26", "2020-11-01 21:31:26");
INSERT INTO `hm_actionscheduler_logs` VALUES("151", "66", "عملیات با WP Cron شروع شد", "2020-11-01 18:01:26", "2020-11-01 21:31:26");
INSERT INTO `hm_actionscheduler_logs` VALUES("152", "66", "عملیات با WP Cron تکمیل شد", "2020-11-01 18:01:27", "2020-11-01 21:31:27");
INSERT INTO `hm_actionscheduler_logs` VALUES("153", "67", "ایجاد فعالیت", "2020-11-01 18:03:45", "2020-11-01 21:33:45");
INSERT INTO `hm_actionscheduler_logs` VALUES("154", "68", "ایجاد فعالیت", "2020-11-01 18:03:45", "2020-11-01 21:33:45");
INSERT INTO `hm_actionscheduler_logs` VALUES("155", "67", "عملیات با WP Cron شروع شد", "2020-11-01 18:04:01", "2020-11-01 21:34:01");
INSERT INTO `hm_actionscheduler_logs` VALUES("156", "67", "عملیات با WP Cron تکمیل شد", "2020-11-01 18:04:01", "2020-11-01 21:34:01");
INSERT INTO `hm_actionscheduler_logs` VALUES("157", "68", "عملیات با WP Cron شروع شد", "2020-11-01 18:04:01", "2020-11-01 21:34:01");
INSERT INTO `hm_actionscheduler_logs` VALUES("158", "68", "عملیات با WP Cron تکمیل شد", "2020-11-01 18:04:01", "2020-11-01 21:34:01");
INSERT INTO `hm_actionscheduler_logs` VALUES("159", "69", "ایجاد فعالیت", "2020-11-01 18:09:49", "2020-11-01 21:39:49");
INSERT INTO `hm_actionscheduler_logs` VALUES("160", "70", "ایجاد فعالیت", "2020-11-01 18:09:49", "2020-11-01 21:39:49");
INSERT INTO `hm_actionscheduler_logs` VALUES("161", "69", "عملیات با WP Cron شروع شد", "2020-11-01 18:10:00", "2020-11-01 21:40:00");
INSERT INTO `hm_actionscheduler_logs` VALUES("162", "69", "عملیات با WP Cron تکمیل شد", "2020-11-01 18:10:01", "2020-11-01 21:40:01");
INSERT INTO `hm_actionscheduler_logs` VALUES("163", "70", "عملیات با WP Cron شروع شد", "2020-11-01 18:10:01", "2020-11-01 21:40:01");
INSERT INTO `hm_actionscheduler_logs` VALUES("164", "70", "عملیات با WP Cron تکمیل شد", "2020-11-01 18:10:01", "2020-11-01 21:40:01");
INSERT INTO `hm_actionscheduler_logs` VALUES("165", "71", "ایجاد فعالیت", "2020-11-01 18:15:57", "2020-11-01 21:45:57");
INSERT INTO `hm_actionscheduler_logs` VALUES("166", "72", "ایجاد فعالیت", "2020-11-01 18:15:58", "2020-11-01 21:45:58");
INSERT INTO `hm_actionscheduler_logs` VALUES("167", "73", "ایجاد فعالیت", "2020-11-01 18:15:58", "2020-11-01 21:45:58");
INSERT INTO `hm_actionscheduler_logs` VALUES("168", "71", "عملیات با WP Cron شروع شد", "2020-11-01 18:16:03", "2020-11-01 21:46:03");
INSERT INTO `hm_actionscheduler_logs` VALUES("169", "71", "عملیات با WP Cron تکمیل شد", "2020-11-01 18:16:03", "2020-11-01 21:46:03");
INSERT INTO `hm_actionscheduler_logs` VALUES("170", "72", "عملیات با WP Cron شروع شد", "2020-11-01 18:16:03", "2020-11-01 21:46:03");
INSERT INTO `hm_actionscheduler_logs` VALUES("171", "72", "عملیات با WP Cron تکمیل شد", "2020-11-01 18:16:03", "2020-11-01 21:46:03");
INSERT INTO `hm_actionscheduler_logs` VALUES("172", "73", "عملیات با WP Cron شروع شد", "2020-11-01 18:16:03", "2020-11-01 21:46:03");
INSERT INTO `hm_actionscheduler_logs` VALUES("173", "73", "عملیات با WP Cron تکمیل شد", "2020-11-01 18:16:04", "2020-11-01 21:46:04");
INSERT INTO `hm_actionscheduler_logs` VALUES("174", "74", "ایجاد فعالیت", "2020-11-01 18:16:42", "2020-11-01 21:46:42");
INSERT INTO `hm_actionscheduler_logs` VALUES("175", "74", "عملیات با WP Cron شروع شد", "2020-11-01 18:16:58", "2020-11-01 21:46:58");
INSERT INTO `hm_actionscheduler_logs` VALUES("176", "74", "عملیات با WP Cron تکمیل شد", "2020-11-01 18:16:59", "2020-11-01 21:46:59");
INSERT INTO `hm_actionscheduler_logs` VALUES("177", "75", "ایجاد فعالیت", "2020-11-07 20:04:07", "2020-11-07 23:34:07");
INSERT INTO `hm_actionscheduler_logs` VALUES("178", "75", "عملیات با WP Cron شروع شد", "2020-11-07 20:09:54", "2020-11-07 23:39:54");
INSERT INTO `hm_actionscheduler_logs` VALUES("179", "75", "عملیات با WP Cron تکمیل شد", "2020-11-07 20:09:54", "2020-11-07 23:39:54");
INSERT INTO `hm_actionscheduler_logs` VALUES("180", "76", "ایجاد فعالیت", "2020-11-07 20:10:22", "2020-11-07 23:40:22");
INSERT INTO `hm_actionscheduler_logs` VALUES("181", "76", "عملیات با WP Cron شروع شد", "2020-11-07 20:11:40", "2020-11-07 23:41:40");
INSERT INTO `hm_actionscheduler_logs` VALUES("182", "76", "عملیات با WP Cron تکمیل شد", "2020-11-07 20:11:41", "2020-11-07 23:41:41");

/* INSERT TABLE DATA: hm_commentmeta */
INSERT INTO `hm_commentmeta` VALUES("6", "26", "rating", "5");
INSERT INTO `hm_commentmeta` VALUES("7", "26", "verified", "0");
INSERT INTO `hm_commentmeta` VALUES("8", "27", "rating", "5");
INSERT INTO `hm_commentmeta` VALUES("9", "27", "verified", "0");
INSERT INTO `hm_commentmeta` VALUES("10", "28", "rating", "5");
INSERT INTO `hm_commentmeta` VALUES("11", "28", "verified", "0");
INSERT INTO `hm_commentmeta` VALUES("12", "29", "rating", "5");
INSERT INTO `hm_commentmeta` VALUES("13", "29", "verified", "0");
INSERT INTO `hm_commentmeta` VALUES("14", "30", "rating", "3");
INSERT INTO `hm_commentmeta` VALUES("15", "30", "verified", "0");
INSERT INTO `hm_commentmeta` VALUES("16", "31", "rating", "5");
INSERT INTO `hm_commentmeta` VALUES("17", "31", "verified", "0");

/* INSERT TABLE DATA: hm_comments */
INSERT INTO `hm_comments` VALUES("3", "177", "ووکامرس", "", "", "", "2020-01-05 22:39:58", "2020-01-05 19:09:58", "وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `hm_comments` VALUES("4", "180", "ووکامرس", "", "", "", "2020-01-05 23:35:02", "2020-01-05 20:05:02", "وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `hm_comments` VALUES("5", "181", "ووکامرس", "", "", "", "2020-01-05 23:36:41", "2020-01-05 20:06:41", "وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `hm_comments` VALUES("6", "240", "ووکامرس", "", "", "", "2020-01-28 19:02:39", "2020-01-28 15:32:39", "خطا در هنگام ارسال به بانک :  تراکنش ناموفق بود- کد خطا : -11", "0", "1", "", "order_note", "0", "0");
INSERT INTO `hm_comments` VALUES("7", "240", "ووکامرس", "", "", "", "2020-01-28 19:03:25", "2020-01-28 15:33:25", "سفارش توسط مشتری لغو شد. وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `hm_comments` VALUES("8", "241", "ووکامرس", "", "", "", "2020-01-28 19:03:01", "2020-01-28 15:33:01", "وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `hm_comments` VALUES("9", "444", "ووکامرس", "", "", "", "2020-06-01 23:16:29", "2020-06-01 18:46:29", "خطا در هنگام ارسال به بانک :  تراکنش ناموفق بود- کد خطا : -11", "0", "1", "", "order_note", "0", "0");
INSERT INTO `hm_comments` VALUES("10", "444", "ووکامرس", "", "", "", "2020-06-01 23:16:34", "2020-06-01 18:46:34", "خطا در هنگام ارسال به بانک :  تراکنش ناموفق بود- کد خطا : -11", "0", "1", "", "order_note", "0", "0");
INSERT INTO `hm_comments` VALUES("11", "444", "ووکامرس", "", "", "", "2020-06-01 23:16:41", "2020-06-01 18:46:41", "خطا در هنگام ارسال به بانک :  تراکنش ناموفق بود- کد خطا : -11", "0", "1", "", "order_note", "0", "0");
INSERT INTO `hm_comments` VALUES("12", "444", "ووکامرس", "", "", "", "2020-06-02 00:23:55", "2020-06-01 19:53:55", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `hm_comments` VALUES("13", "445", "ووکامرس", "", "", "", "2020-06-02 03:25:32", "2020-06-01 22:55:32", "خطا در هنگام ارسال به بانک :  تراکنش ناموفق بود- کد خطا : -11", "0", "1", "", "order_note", "0", "0");
INSERT INTO `hm_comments` VALUES("14", "445", "ووکامرس", "", "", "", "2020-06-02 06:07:18", "2020-06-02 01:37:18", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `hm_comments` VALUES("15", "447", "ووکامرس", "", "", "", "2020-06-10 13:24:48", "2020-06-10 08:54:48", "وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `hm_comments` VALUES("16", "448", "ووکامرس", "", "", "", "2020-06-14 13:42:58", "2020-06-14 09:12:58", "وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `hm_comments` VALUES("17", "449", "ووکامرس", "", "", "", "2020-06-15 19:28:13", "2020-06-15 14:58:13", "وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `hm_comments` VALUES("18", "450", "ووکامرس", "", "", "", "2020-06-16 13:59:06", "2020-06-16 09:29:06", "خطا در هنگام ارسال به بانک :  تراکنش ناموفق بود- کد خطا : -11", "0", "1", "", "order_note", "0", "0");
INSERT INTO `hm_comments` VALUES("19", "450", "ووکامرس", "", "", "", "2020-06-16 13:59:12", "2020-06-16 09:29:12", "خطا در هنگام ارسال به بانک :  تراکنش ناموفق بود- کد خطا : -11", "0", "1", "", "order_note", "0", "0");
INSERT INTO `hm_comments` VALUES("20", "450", "ووکامرس", "", "", "", "2020-06-16 15:30:57", "2020-06-16 11:00:57", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `hm_comments` VALUES("21", "451", "ووکامرس", "", "", "", "2020-06-17 23:51:28", "2020-06-17 19:21:28", "وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `hm_comments` VALUES("22", "452", "ووکامرس", "", "", "", "2020-06-18 14:57:44", "2020-06-18 10:27:44", "وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `hm_comments` VALUES("23", "602", "ووکامرس", "", "", "", "2020-07-01 21:25:52", "2020-07-01 16:55:52", "خطا در هنگام ارسال به بانک :  تراکنش ناموفق بود- کد خطا : -11", "0", "1", "", "order_note", "0", "0");
INSERT INTO `hm_comments` VALUES("24", "602", "ووکامرس", "", "", "", "2020-07-01 21:25:57", "2020-07-01 16:55:57", "خطا در هنگام ارسال به بانک :  تراکنش ناموفق بود- کد خطا : -11", "0", "1", "", "order_note", "0", "0");
INSERT INTO `hm_comments` VALUES("25", "602", "ووکامرس", "", "", "", "2020-07-01 23:53:13", "2020-07-01 19:23:13", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `hm_comments` VALUES("26", "629", "shayanwebcomhm", "info@email.com", "http://localhost/hamyarlearn", "::1", "2020-08-06 20:29:24", "2020-08-06 15:59:24", "بسیار عالی آموزش دادند", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36", "review", "0", "1");
INSERT INTO `hm_comments` VALUES("27", "628", "shayanwebcomhm", "info@email.com", "http://localhost/hamyarlearn", "::1", "2020-08-06 20:29:48", "2020-08-06 15:59:48", "خیلی عالی <a href=\"https://shayanweb.com/academy/\" rel=\"nofollow ugc\">آموزش طراحی وب</a> رو به ما یاد دادند", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36", "review", "0", "1");
INSERT INTO `hm_comments` VALUES("28", "627", "shayanwebcomhm", "info@email.com", "http://localhost/hamyarlearn", "::1", "2020-08-06 20:30:07", "2020-08-06 16:00:07", "یکی از بهترین آموزش‌های گرافیک بود", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36", "review", "0", "1");
INSERT INTO `hm_comments` VALUES("29", "627", "shayanwebcomhm", "info@email.com", "http://localhost/hamyarlearn", "::1", "2020-08-06 20:30:36", "2020-08-06 16:00:36", "من که کلی چیز یاد گرفتم توی این دوره", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36", "review", "0", "1");
INSERT INTO `hm_comments` VALUES("30", "629", "shayanwebcomhm", "info@email.com", "http://localhost/hamyarlearn", "::1", "2020-08-06 20:32:36", "2020-08-06 16:02:36", "آموزش خوب بود.", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36", "review", "0", "1");
INSERT INTO `hm_comments` VALUES("31", "629", "shayanwebcomhm", "info@email.com", "http://localhost/hamyarlearn", "::1", "2020-08-06 20:32:50", "2020-08-06 16:02:50", "آموزشی بسیار عالی", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36", "review", "0", "1");
INSERT INTO `hm_comments` VALUES("32", "827", "ووکامرس", "", "", "", "2020-09-18 17:38:13", "2020-09-18 13:08:13", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");

/* INSERT TABLE DATA: hm_duplicator_packages */
INSERT INTO `hm_duplicator_packages` VALUES("6", "hamyarlearn_56", "50c3216e5d7b3f167785_20201202144948", "21", "2020-12-02 14:50:06", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2020-12-02 14:49:48\";s:7:\"Version\";s:6:\"1.3.40\";s:9:\"VersionWP\";s:5:\"5.5.3\";s:9:\"VersionDB\";s:6:\"5.7.24\";s:10:\"VersionPHP\";s:6:\"7.2.19\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";i:6;s:4:\"Name\";s:14:\"hamyarlearn_56\";s:4:\"Hash\";s:35:\"50c3216e5d7b3f167785_20201202144948\";s:8:\"NameHash\";s:50:\"hamyarlearn_56_50c3216e5d7b3f167785_20201202144948\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:60:\"hamyarlearn_56_50c3216e5d7b3f167785_20201202144948_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"20.7\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":21:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:62:\"hamyarlearn_56_50c3216e5d7b3f167785_20201202144948_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:26:\"C:/laragon/www/hamyarlearn\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":5:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":6:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2020-12-02 14:49:48\";s:7:\"Version\";s:6:\"1.3.40\";s:9:\"VersionWP\";s:5:\"5.5.3\";s:9:\"VersionDB\";s:6:\"5.7.24\";s:10:\"VersionPHP\";s:6:\"7.2.19\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";N;s:4:\"Name\";s:14:\"hamyarlearn_56\";s:4:\"Hash\";s:35:\"50c3216e5d7b3f167785_20201202144948\";s:8:\"NameHash\";s:50:\"hamyarlearn_56_50c3216e5d7b3f167785_20201202144948\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";s:64:\"hamyarlearn_56_50c3216e5d7b3f167785_20201202144948_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:61;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:63:\"hamyarlearn_56_50c3216e5d7b3f167785_20201202144948_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":15:{s:9:\"buildMode\";N;s:13:\"collationList\";a:0:{}s:17:\"isTablesUpperCase\";N;s:15:\"isNameUpperCase\";N;s:4:\"name\";N;s:15:\"tablesBaseCount\";N;s:16:\"tablesFinalCount\";N;s:14:\"tablesRowCount\";N;s:16:\"tablesSizeOnDisk\";N;s:18:\"varLowerCaseTables\";i:1;s:7:\"version\";N;s:14:\"versionComment\";N;s:18:\"tableWiseRowCounts\";a:5:{s:26:\"hm_actionscheduler_actions\";s:2:\"12\";s:25:\"hm_actionscheduler_claims\";s:1:\"0\";s:25:\"hm_actionscheduler_groups\";s:1:\"4\";s:23:\"hm_actionscheduler_logs\";s:2:\"36\";s:14:\"hm_commentmeta\";s:2:\"12\";}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:122:\"C:/laragon/www/hamyarlearn/wp-content/backups-dup-lite/tmp/hamyarlearn_56_50c3216e5d7b3f167785_20201202144948_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:61;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:35:\"C:/laragon/www/hamyarlearn/wp-admin\";i:1;s:45:\"C:/laragon/www/hamyarlearn/wp-content/uploads\";i:2;s:47:\"C:/laragon/www/hamyarlearn/wp-content/languages\";i:3;s:44:\"C:/laragon/www/hamyarlearn/wp-content/themes\";i:4;s:38:\"C:/laragon/www/hamyarlearn/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:26:\"C:/laragon/www/hamyarlearn\";i:1;s:37:\"C:/laragon/www/hamyarlearn/wp-content\";}}s:9:\"Installer\";r:82;s:8:\"Database\";r:96;s:13:\"BuildProgress\";r:132;}");

/* INSERT TABLE DATA: hm_itsec_lockouts */
INSERT INTO `hm_itsec_lockouts` VALUES("1", "brute_force", "2020-10-25 16:24:12", "2020-10-25 12:54:12", "1970-01-01 00:00:01", "1970-01-01 00:00:01", "::1", NULL, NULL, "1", "O:40:\"iThemesSecurity\\Lib\\Lockout\\Host_Context\":5:{s:46:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0host\";s:3:\"::1\";s:55:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0login_user_id\";i:2;s:56:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0login_username\";N;s:62:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0user_limit_triggered\";b:0;s:51:\"\0iThemesSecurity\\Lib\\Lockout\\Context\0lockout_module\";s:11:\"brute_force\";}");
INSERT INTO `hm_itsec_lockouts` VALUES("2", "brute_force", "2020-11-07 23:28:06", "2020-11-07 19:58:06", "1970-01-01 00:00:01", "1970-01-01 00:00:01", "::1", NULL, NULL, "1", "O:40:\"iThemesSecurity\\Lib\\Lockout\\Host_Context\":5:{s:46:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0host\";s:3:\"::1\";s:55:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0login_user_id\";i:2;s:56:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0login_username\";N;s:62:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0user_limit_triggered\";b:0;s:51:\"\0iThemesSecurity\\Lib\\Lockout\\Context\0lockout_module\";s:11:\"brute_force\";}");
INSERT INTO `hm_itsec_lockouts` VALUES("3", "brute_force", "2020-11-07 23:28:23", "2020-11-07 19:58:23", "1970-01-01 00:00:01", "1970-01-01 00:00:01", "::1", NULL, NULL, "1", "O:40:\"iThemesSecurity\\Lib\\Lockout\\Host_Context\":5:{s:46:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0host\";s:3:\"::1\";s:55:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0login_user_id\";i:2;s:56:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0login_username\";N;s:62:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0user_limit_triggered\";b:0;s:51:\"\0iThemesSecurity\\Lib\\Lockout\\Context\0lockout_module\";s:11:\"brute_force\";}");
INSERT INTO `hm_itsec_lockouts` VALUES("4", "brute_force", "2020-11-07 23:28:40", "2020-11-07 19:58:40", "1970-01-01 00:00:01", "1970-01-01 00:00:01", "::1", NULL, NULL, "1", "O:40:\"iThemesSecurity\\Lib\\Lockout\\Host_Context\":5:{s:46:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0host\";s:3:\"::1\";s:55:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0login_user_id\";i:2;s:56:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0login_username\";N;s:62:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0user_limit_triggered\";b:0;s:51:\"\0iThemesSecurity\\Lib\\Lockout\\Context\0lockout_module\";s:11:\"brute_force\";}");
INSERT INTO `hm_itsec_lockouts` VALUES("5", "brute_force", "2020-11-07 23:28:59", "2020-11-07 19:58:59", "1970-01-01 00:00:01", "1970-01-01 00:00:01", "::1", NULL, NULL, "1", "O:40:\"iThemesSecurity\\Lib\\Lockout\\Host_Context\":5:{s:46:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0host\";s:3:\"::1\";s:55:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0login_user_id\";i:2;s:56:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0login_username\";N;s:62:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0user_limit_triggered\";b:0;s:51:\"\0iThemesSecurity\\Lib\\Lockout\\Context\0lockout_module\";s:11:\"brute_force\";}");

/* INSERT TABLE DATA: hm_itsec_logs */
INSERT INTO `hm_itsec_logs` VALUES("26", "0", "notification_center", "send_scheduled", "a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}", "debug", "2020-09-14 11:36:02", "2020-09-14 11:36:00", "75393192", "77066584", "http://localhost/hamyarlearn/", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("27", "0", "notification_center", "send_scheduled", "a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}", "debug", "2020-09-14 11:36:54", "2020-09-14 11:36:51", "76901432", "78255216", "http://localhost/hamyarlearn/", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("28", "0", "notification_center", "send_scheduled", "a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}", "debug", "2020-09-16 08:06:18", "2020-09-16 08:06:12", "75006096", "76923272", "wp-cron", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("29", "0", "notification_center", "send_scheduled", "a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}", "debug", "2020-09-17 08:06:55", "2020-09-17 08:06:53", "87893112", "87953440", "http://localhost/hamyarlearn/wp-admin/admin-ajax.php", "1", "2", "::1");
INSERT INTO `hm_itsec_logs` VALUES("30", "0", "notification_center", "send_scheduled", "a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}", "debug", "2020-09-18 10:25:19", "2020-09-18 10:24:55", "88301616", "88345928", "http://localhost/hamyarlearn/wp-admin/admin-ajax.php", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("31", "0", "notification_center", "send_scheduled", "a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}", "debug", "2020-09-18 10:26:49", "2020-09-18 10:26:47", "88301616", "88345928", "http://localhost/hamyarlearn/wp-admin/admin-ajax.php", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("32", "0", "notification_center", "send_scheduled", "a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}", "debug", "2020-10-22 07:56:18", "2020-10-22 07:56:15", "77243096", "78566672", "http://localhost/hamyarlearn/wp-login.php?redirect_to=http%3A%2F%2Flocalhost%2Fhamyarlearn%2Fwp-admin%2Fadmin.php%3Fpage%3Dduplicator-tools%26tab%3Ddiagnostics%26in%3Dinstaller.php%26sm%3D0%26action%3Dinstaller", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("33", "0", "notification_center", "send_scheduled", "a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}", "debug", "2020-10-22 07:57:43", "2020-10-22 07:57:41", "75398008", "77156800", "wp-cron", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("34", "0", "notification_center", "send_scheduled", "a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}", "debug", "2020-10-25 12:53:23", "2020-10-25 12:53:17", "76826152", "77615744", "wp-cron", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("35", "0", "brute_force", "invalid-login::user-2", "a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:12:\"wp-login.php\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:261:\"<strong>خطا</strong>: رمز عبوری که برای نام کاربری <strong>hamyarlearn</strong> وارد شده درست نیست. <a href=\"http://localhost/hamyarlearn/my-account/lost-password/\">رمز عبورتان را گم کرده‌اید؟</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:11:\"hamyarlearn\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:24:{s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:9:\"HTTP_HOST\";s:9:\"localhost\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:14:\"CONTENT_LENGTH\";s:3:\"140\";s:18:\"HTTP_CACHE_CONTROL\";s:9:\"max-age=0\";s:11:\"HTTP_ORIGIN\";s:16:\"http://localhost\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:8:\"HTTP_DNT\";s:1:\"1\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.75 Safari/537.36\";s:11:\"HTTP_ACCEPT\";s:135:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9\";s:19:\"HTTP_SEC_FETCH_SITE\";s:11:\"same-origin\";s:19:\"HTTP_SEC_FETCH_MODE\";s:8:\"navigate\";s:19:\"HTTP_SEC_FETCH_USER\";s:2:\"?1\";s:19:\"HTTP_SEC_FETCH_DEST\";s:8:\"document\";s:12:\"HTTP_REFERER\";s:113:\"http://localhost/hamyarlearn/wp-login.php?redirect_to=http%3A%2F%2Flocalhost%2Fhamyarlearn%2Fwp-admin%2F&reauth=1\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:56:\"en-US,en;q=0.9,my-ZG;q=0.8,my;q=0.7,fa-IR;q=0.6,fa;q=0.5\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"SCRIPT_FILENAME\";s:39:\"C:/laragon/www/hamyarlearn/wp-login.php\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:18:\"REQUEST_TIME_FLOAT\";d:1603630415.886;s:12:\"REQUEST_TIME\";i:1603630415;}}", "notice", "2020-10-25 12:53:37", "2020-10-25 12:53:36", "78062416", "79038752", "http://localhost/hamyarlearn/wp-login.php", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("36", "0", "brute_force", "invalid-login::username-shayanfp", "a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:12:\"wp-login.php\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:16:\"invalid_username\";a:1:{i:0;s:137:\"نام کاربری ناشناس. دوباره بررسی نمایید یا از آدرس ایمیل خود استفاده نمایید. \";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:8:\"shayanfp\";s:7:\"user_id\";i:0;s:6:\"SERVER\";a:24:{s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:9:\"HTTP_HOST\";s:9:\"localhost\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:14:\"CONTENT_LENGTH\";s:3:\"136\";s:18:\"HTTP_CACHE_CONTROL\";s:9:\"max-age=0\";s:11:\"HTTP_ORIGIN\";s:16:\"http://localhost\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:8:\"HTTP_DNT\";s:1:\"1\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.75 Safari/537.36\";s:11:\"HTTP_ACCEPT\";s:135:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9\";s:19:\"HTTP_SEC_FETCH_SITE\";s:11:\"same-origin\";s:19:\"HTTP_SEC_FETCH_MODE\";s:8:\"navigate\";s:19:\"HTTP_SEC_FETCH_USER\";s:2:\"?1\";s:19:\"HTTP_SEC_FETCH_DEST\";s:8:\"document\";s:12:\"HTTP_REFERER\";s:41:\"http://localhost/hamyarlearn/wp-login.php\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:56:\"en-US,en;q=0.9,my-ZG;q=0.8,my;q=0.7,fa-IR;q=0.6,fa;q=0.5\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"SCRIPT_FILENAME\";s:39:\"C:/laragon/www/hamyarlearn/wp-login.php\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:18:\"REQUEST_TIME_FLOAT\";d:1603630423.369;s:12:\"REQUEST_TIME\";i:1603630423;}}", "notice", "2020-10-25 12:53:44", "2020-10-25 12:53:43", "77886696", "78958328", "http://localhost/hamyarlearn/wp-login.php", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("37", "0", "brute_force", "invalid-login::user-2", "a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:12:\"wp-login.php\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:261:\"<strong>خطا</strong>: رمز عبوری که برای نام کاربری <strong>hamyarlearn</strong> وارد شده درست نیست. <a href=\"http://localhost/hamyarlearn/my-account/lost-password/\">رمز عبورتان را گم کرده‌اید؟</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:11:\"hamyarlearn\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:24:{s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:9:\"HTTP_HOST\";s:9:\"localhost\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:14:\"CONTENT_LENGTH\";s:3:\"139\";s:18:\"HTTP_CACHE_CONTROL\";s:9:\"max-age=0\";s:11:\"HTTP_ORIGIN\";s:16:\"http://localhost\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:8:\"HTTP_DNT\";s:1:\"1\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.75 Safari/537.36\";s:11:\"HTTP_ACCEPT\";s:135:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9\";s:19:\"HTTP_SEC_FETCH_SITE\";s:11:\"same-origin\";s:19:\"HTTP_SEC_FETCH_MODE\";s:8:\"navigate\";s:19:\"HTTP_SEC_FETCH_USER\";s:2:\"?1\";s:19:\"HTTP_SEC_FETCH_DEST\";s:8:\"document\";s:12:\"HTTP_REFERER\";s:41:\"http://localhost/hamyarlearn/wp-login.php\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:56:\"en-US,en;q=0.9,my-ZG;q=0.8,my;q=0.7,fa-IR;q=0.6,fa;q=0.5\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"SCRIPT_FILENAME\";s:39:\"C:/laragon/www/hamyarlearn/wp-login.php\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:18:\"REQUEST_TIME_FLOAT\";d:1603630430.851;s:12:\"REQUEST_TIME\";i:1603630430;}}", "notice", "2020-10-25 12:53:54", "2020-10-25 12:53:52", "77981992", "78958328", "http://localhost/hamyarlearn/wp-login.php", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("38", "0", "brute_force", "invalid-login::user-2", "a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:12:\"wp-login.php\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:261:\"<strong>خطا</strong>: رمز عبوری که برای نام کاربری <strong>hamyarlearn</strong> وارد شده درست نیست. <a href=\"http://localhost/hamyarlearn/my-account/lost-password/\">رمز عبورتان را گم کرده‌اید؟</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:11:\"hamyarlearn\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:24:{s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:9:\"HTTP_HOST\";s:9:\"localhost\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:14:\"CONTENT_LENGTH\";s:3:\"138\";s:18:\"HTTP_CACHE_CONTROL\";s:9:\"max-age=0\";s:11:\"HTTP_ORIGIN\";s:16:\"http://localhost\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:8:\"HTTP_DNT\";s:1:\"1\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.75 Safari/537.36\";s:11:\"HTTP_ACCEPT\";s:135:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9\";s:19:\"HTTP_SEC_FETCH_SITE\";s:11:\"same-origin\";s:19:\"HTTP_SEC_FETCH_MODE\";s:8:\"navigate\";s:19:\"HTTP_SEC_FETCH_USER\";s:2:\"?1\";s:19:\"HTTP_SEC_FETCH_DEST\";s:8:\"document\";s:12:\"HTTP_REFERER\";s:41:\"http://localhost/hamyarlearn/wp-login.php\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:56:\"en-US,en;q=0.9,my-ZG;q=0.8,my;q=0.7,fa-IR;q=0.6,fa;q=0.5\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"SCRIPT_FILENAME\";s:39:\"C:/laragon/www/hamyarlearn/wp-login.php\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:18:\"REQUEST_TIME_FLOAT\";d:1603630445.255;s:12:\"REQUEST_TIME\";i:1603630445;}}", "notice", "2020-10-25 12:54:06", "2020-10-25 12:54:05", "78013984", "78990072", "http://localhost/hamyarlearn/wp-login.php", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("39", "0", "brute_force", "invalid-login::user-2", "a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:12:\"wp-login.php\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:261:\"<strong>خطا</strong>: رمز عبوری که برای نام کاربری <strong>hamyarlearn</strong> وارد شده درست نیست. <a href=\"http://localhost/hamyarlearn/my-account/lost-password/\">رمز عبورتان را گم کرده‌اید؟</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:11:\"hamyarlearn\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:24:{s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:9:\"HTTP_HOST\";s:9:\"localhost\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:14:\"CONTENT_LENGTH\";s:3:\"148\";s:18:\"HTTP_CACHE_CONTROL\";s:9:\"max-age=0\";s:11:\"HTTP_ORIGIN\";s:16:\"http://localhost\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:8:\"HTTP_DNT\";s:1:\"1\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:15:\"HTTP_USER_AGENT\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.75 Safari/537.36\";s:11:\"HTTP_ACCEPT\";s:135:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9\";s:19:\"HTTP_SEC_FETCH_SITE\";s:11:\"same-origin\";s:19:\"HTTP_SEC_FETCH_MODE\";s:8:\"navigate\";s:19:\"HTTP_SEC_FETCH_USER\";s:2:\"?1\";s:19:\"HTTP_SEC_FETCH_DEST\";s:8:\"document\";s:12:\"HTTP_REFERER\";s:41:\"http://localhost/hamyarlearn/wp-login.php\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:56:\"en-US,en;q=0.9,my-ZG;q=0.8,my;q=0.7,fa-IR;q=0.6,fa;q=0.5\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"SCRIPT_FILENAME\";s:39:\"C:/laragon/www/hamyarlearn/wp-login.php\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:18:\"REQUEST_TIME_FLOAT\";d:1603630451.86;s:12:\"REQUEST_TIME\";i:1603630451;}}", "notice", "2020-10-25 12:54:13", "2020-10-25 12:54:12", "78014048", "78990136", "http://localhost/hamyarlearn/wp-login.php", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("40", "0", "lockout", "whitelisted-host-triggered-host-lockout", "a:14:{s:6:\"module\";s:11:\"brute_force\";s:4:\"host\";s:3:\"::1\";s:7:\"user_id\";b:0;s:8:\"username\";b:0;s:14:\"module_details\";a:6:{s:4:\"type\";s:11:\"brute_force\";s:6:\"reason\";s:53:\"تعداد زیادی تلاش بد برای ورود\";s:5:\"label\";s:22:\"حملات Brute Force\";s:4:\"host\";i:5;s:4:\"user\";i:10;s:6:\"period\";i:5;}s:11:\"whitelisted\";b:1;s:11:\"blacklisted\";b:0;s:12:\"lockout_type\";s:11:\"brute_force\";s:13:\"lockout_start\";s:19:\"2020-10-25 16:24:12\";s:17:\"lockout_start_gmt\";s:19:\"2020-10-25 12:54:12\";s:15:\"lockout_context\";s:401:\"O:40:\"iThemesSecurity\\Lib\\Lockout\\Host_Context\":5:{s:46:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0host\";s:3:\"::1\";s:55:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0login_user_id\";i:2;s:56:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0login_username\";N;s:62:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0user_limit_triggered\";b:0;s:51:\"\0iThemesSecurity\\Lib\\Lockout\\Context\0lockout_module\";s:11:\"brute_force\";}\";s:14:\"lockout_expire\";s:19:\"1970-01-01 00:00:01\";s:18:\"lockout_expire_gmt\";s:19:\"1970-01-01 00:00:01\";s:12:\"lockout_host\";s:3:\"::1\";}", "notice", "2020-10-25 12:54:13", "2020-10-25 12:54:12", "78066464", "78990136", "http://localhost/hamyarlearn/wp-login.php", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("41", "0", "notification_center", "send_scheduled", "a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}", "debug", "2020-11-01 17:22:11", "2020-11-01 17:22:04", "76796856", "77586200", "wp-cron", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("42", "0", "notification_center", "send::digest", "a:2:{s:10:\"recipients\";a:1:{i:0;s:22:\"shayanfp@shayanweb.com\";}s:7:\"subject\";s:58:\"[localhost/hamyarlearn] خلاصه امنیت روزانه\";}", "debug", "2020-11-01 17:22:13", "2020-11-01 17:22:04", "77255504", "77586200", "wp-cron", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("43", "0", "notification_center", "send_failed::digest", "a:1:{s:5:\"error\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:14:\"wp_mail_failed\";a:1:{i:0;s:45:\"Invalid address:  (From): wordpress@localhost\";}}s:10:\"error_data\";a:1:{s:14:\"wp_mail_failed\";a:6:{s:2:\"to\";a:1:{i:0;s:22:\"shayanfp@shayanweb.com\";}s:7:\"subject\";s:58:\"[localhost/hamyarlearn] خلاصه امنیت روزانه\";s:7:\"message\";s:61022:\"\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"fa-IR\">\n\n<head>\n	<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n	<title>خلاصه امنیت روزانه</title>\n	<meta name=\"viewport\" content=\"width=device-width\">\n\n	<style type=\"text/css\">\n		/* From: https://litmus.com/community/learning/13-foundations-email-coding-101 */\n\n		/* GENERAL STYLE RESETS */\n		body,#body-table,#body-cell{height:100%!important;width:100%!important;margin:0;padding:0;}\n		img,aimg{border:0;outline:none;text-decoration:none;}\n		.imageFix{display:block;}\n		table,td{border-collapse:collapse;border-spacing:0;}\n\n		/* CLIENT-SPECIFIC RESETS */\n		.ReadMsgBody{width:100%;}\n		.ExternalClass{width:100%;}\n		.ExternalClass,.ExternalClass p,.ExternalClass span,.ExternalClass font,.ExternalClass td,.ExternalClass div{line-height:100%;}\n		table,td{mso-table-lspace:0pt;mso-table-rspace:0pt;}\n		img{-ms-interpolation-mode:bicubic;}\n		body,table,td,p,a,li,blockquote{-ms-text-size-adjust:100%;-webkit-text-size-adjust:100%;}\n\n\n		h1,h2,h3,h4,h5,h6{color:#202020;font-family:Helvetica;font-size:20px;font-weight:bold;line-height:150%;margin:0;padding:0;text-align:center;}\n		p{font-family:Helvetica;font-size:16px;line-height:150%;margin-top:10px;margin-right:0;margin-bottom:10px;margin-left:0;padding:0;text-align:center;}\n		a{color:#0084CB;font-family:Helvetica;font-size:16px;line-height:150%;text-align:center;text-decoration:none;}\n		img{height:auto;}\n\n		body,#body-table{background-color:#FFFFFF;}\n		#body-cell{padding-bottom:20px;}\n		.section-padding{padding-top:20px;padding-right:20px;padding-left:20px;}\n		.section-padding-bottom{padding-bottom:20px;}\n		.container-cell{color:#808080;font-family:Helvetica;font-size:16px;line-height:150%;text-align:center;padding-bottom:20px;}\n		#top-banner{background-color:#FFCE08;}\n		#top-banner .container-cell{color:#413F39;font-size:13px;}\n		#top-logo .container-cell{padding-top:20px;}\n		#title-container h1{font-size:34px;}\n		.info-box{padding-top:20px;padding-bottom:20px;}\n		.info-box .container{border:1px solid #CDCECE;background-color:#F2F2F2;}\n		.info-box .section-padding{padding-top:40px;padding-right:40px;padding-left:40px;}\n		.info-box .container-cell{padding-bottom:40px;}\n		.info-box .info-icon{width:33px;height:23px;vertical-align:middle;}\n		.section-heading .container-cell{padding-bottom:0;}\n		.section-heading h4{color:#0084CB;font-size:16px;}\n		.section-heading h4 img{padding-top:2px;padding-right:5px;vertical-align:top;}\n		.lockouts-summary .container.left-column{margin-right:60px;}\n		.lockouts-summary h4{color:#ACAAAA;font-size:16px;font-weight:normal;}\n		.lockouts-summary p{color:#505050;font-size:30px;font-weight:bold;}\n		.table{border:1px solid #cdcece;color: #808080;font-family:Helvetica;font-size:14px;}\n		.table th,.table td{border:1px solid #cdcece;padding:10px;}\n		.table th{text-align:left;font-weight:bold;padding:5px 10px;}\n		.table .row-label{font-style:italic;}\n		.table a,.table b{font-size:14px;}\n		.large-text h4{color:#505050;margin-bottom:10px;}\n		.details-box-container{padding-top:20px;padding-bottom:20px;}\n		.details-box{background-color:#E4EEF7;border:1px solid #CDCECE;}\n		.details-box .container-cell{color:#6A6A6A;}\n		.divider .divider-border{border-top-width:1px;border-top-style:solid;border-top-color:#E8E8E8;}\n		.divider .container-cell{line-height:1px;padding-bottom:20px;width:450px;}\n		.module-button .border-radius{-webkit-border-radius:5px;-moz-border-radius:5px;border-radius:5px;}\n		.module-button a{background-color:#FFCD08;border:1px solid #FFCD08;color:#2E280E;display:inline-block;font-size:18px;font-weight:bold;line-height:100%;padding-top:20px;padding-right:30px;padding-bottom:20px;padding-left:30px;}\n		.pro-callout{padding-top:20px;}\n		.pro-callout-background{background-color:#0B1A23;}\n		.pro-callout .section-padding{padding-top:40px;}\n		.pro-callout .two-factor{color:#FFFFFF;margin-top:20px;margin-bottom:20px;}\n		.pro-callout .module-button a{font-size:30px;}\n		.pro-callout .why-pro{color:#999999;font-style:italic;margin-top:20px;margin-bottom:20px;}\n		.footer-heading h2{color:#002030;font-size:26px;}\n		.pro-flag{background-color:#FFCC00;color:#000000;font-size:10px;display:inline-block;padding:3px;line-height:1;position:relative;bottom:10px;text-transform:uppercase;}\n		#security-guide-container{border:1px solid #CDCECE;background-color:#D3E8E9;}\n		#security-guide .container-cell{color:#6C6C6C;text-align:left;}\n		#security-guide h4{color:#6C6C6C;font-size:18px;padding-bottom:10px;text-align:left;}\n		#security-guide a{font-weight:bold;}\n		#footer-source-details .container-cell{line-height:200%;padding-top:60px;padding-bottom:0;}\n		#footer-source-details a{font-size:11px;font-weight:bold;line-height:200%;}\n		.template-container {max-width: 600px !important;}\n\n		@media only screen and (max-width:600px){\n			body{width:100% !important;min-width:100% !important;}\n			#body-cell{padding:10px !important;}\n			#main-container, .container{width:100% !important;}\n			.preserve-ratio{height:auto !important;width:100% !important;}\n			.container-cell-bottom{padding-top:20px !important;}\n			.lockouts-summary .container{width:auto !important;}\n		}\n\n		@media only screen and (max-width:450px){\n			.divider .container-cell{width:auto !important;}\n		}\n	</style>\n</head>\n\n<body style=\"margin: 0;padding: 0;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;background-color: #FFFFFF;height: 100%!important;width: 100%!important;\">\n	<center>\n		<table id=\"body-table\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" height=\"100%\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;margin: 0;padding: 0;background-color: #FFFFFF;height: 100%!important;width: 100%!important;\">\n			<tr>\n				<td id=\"body-cell\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;margin: 0;padding: 0;padding-bottom: 20px;height: 100%!important;width: 100%!important;\">\n					<table id=\"main-container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n						<tr>\n							<td id=\"top-banner\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;background-color: #FFCE08;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n												<tr>\n													<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n														<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #413F39;font-family: Helvetica;font-size: 13px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n																	خلاصه امنیت روزانه شما برای <b>۱۱ آبان ۱۳۹۹</b>\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n						<tr>\n							<td id=\"top-logo\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n												<tr>\n													<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n														<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;padding-top: 20px;\">\n																	<img class=\"preserve-ratio\" src=\"http://localhost/hamyarlearn/wp-content/plugins/better-wp-security/core/img/mail/logo.png\" style=\"max-width: 300px;border: 0;outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;height: auto;\" alt=\"\" align=\"center\">\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n						<tr>\n							<td id=\"title-container\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n												<tr>\n													<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n														<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n																	<h1 style=\"color: #202020;font-family: Helvetica;font-size: 34px;font-weight: bold;line-height: 150%;margin: 0;padding: 0;text-align: center;\">خلاصه امنیت روزانه</h1>\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n						<tr>\n							<td class=\"info-box\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-bottom: 20px;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;border: 1px solid #CDCECE;background-color: #F2F2F2;\">\n												<tr>\n													<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 40px;padding-right: 40px;padding-left: 40px;\">\n														<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 40px;\">\n																	<img class=\"info-icon\" src=\"http://localhost/hamyarlearn/wp-content/plugins/better-wp-security/core/img/mail/info_icon.png\" alt=\"\" align=\"center\" width=\"33\" height=\"23\" style=\"border: 0;outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;height: 23px;width: 33px;vertical-align: middle;\">\n																	در زیر خلاصه ای از فعالیت مرتبط با امنیت در سایت شما است: <b>localhost/hamyarlearn</b>\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n						<tr>\n							<td class=\"section-heading\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n												<tr>\n													<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n														<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 0;\">\n																	<h4 style=\"color: #0084CB;font-family: Helvetica;font-size: 16px;font-weight: bold;line-height: 150%;margin: 0;padding: 0;text-align: center;\">\n																		<img src=\"http://localhost/hamyarlearn/wp-content/plugins/better-wp-security/core/img/mail/icon_lock.png\" alt=\"\" align=\"center\" style=\"border: 0;outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;height: auto;padding-top: 2px;padding-right: 5px;vertical-align: top;\">\n																		قفل کردن\n																	</h4>\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n						<tr>\n							<td class=\"lockouts-summary\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n												<tr>\n													<td class=\"section-padding\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n														<table class=\"container left-column\" align=\"left\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;margin-right: 60px;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n																	<h4 style=\"color: #ACAAAA;font-family: Helvetica;font-size: 16px;font-weight: normal;line-height: 150%;margin: 0;padding: 0;text-align: center;\">کاربران</h4>\n																	<p style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;font-family: Helvetica;font-size: 30px;line-height: 150%;margin-top: 10px;margin-right: 0;margin-bottom: 10px;margin-left: 0;padding: 0;text-align: center;color: #505050;font-weight: bold;\">0</p>\n																</td>\n															</tr>\n														</table>\n														<table class=\"container right-column\" align=\"right\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n																	<h4 style=\"color: #ACAAAA;font-family: Helvetica;font-size: 16px;font-weight: normal;line-height: 150%;margin: 0;padding: 0;text-align: center;\">هاست‌ها</h4>\n																	<p style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;font-family: Helvetica;font-size: 30px;line-height: 150%;margin-top: 10px;margin-right: 0;margin-bottom: 10px;margin-left: 0;padding: 0;text-align: center;color: #505050;font-weight: bold;\">1</p>\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n						<tr>\n							<td class=\"details-box-container\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-bottom: 20px;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"details-box container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;background-color: #E4EEF7;border: 1px solid #CDCECE;\">\n												<tr>\n													<td class=\"section-padding\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n														<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #6A6A6A;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n																	برای جزئیات بیشتر،  <a href=\"http://localhost/hamyarlearn/wp-admin/admin.php?page=itsec-logs\"><b> گزارشات امینیتی را ببینید</b></a>\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n						<tr>\n							<td class=\"divider\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"450\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n												<tr>\n													<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"450\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n														<table class=\"divider-border\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;border-top-width: 1px;border-top-style: solid;border-top-color: #E8E8E8;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 1px;text-align: center;padding-bottom: 20px;width: 450px;\">\n																	&nbsp;\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n						<tr>\n							<td class=\"large-text\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n												<tr>\n													<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n														<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n																	<h4 style=\"color: #505050;font-family: Helvetica;font-size: 20px;font-weight: bold;line-height: 150%;margin: 0;padding: 0;text-align: center;margin-bottom: 10px;\">آیا سایت شما به همان اندازه که می تواند امن است؟</h4>\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n						<tr>\n							<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n												<tr>\n													<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n														<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n																	اطمینان حاصل کنید که سایت شما با استفاده از بررسی امنیتی، از تنظیمات و ویژگی های توصیه شده استفاده می کند.\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n<tr>\n	<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n		<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n			<tr>\n				<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n					<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n						<tr>\n							<td class=\"section-padding section-padding-bottom\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;padding-bottom: 20px;\">\n								<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"module-button\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n												<tr>\n													<td class=\"border-radius\" align=\"center\" bgcolor=\"#FFCD08\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;-webkit-border-radius: 5px;-moz-border-radius: 5px;border-radius: 5px;\">\n														<a class=\"border-radius\" href=\"http://localhost/hamyarlearn/wp-admin/admin.php?page=itsec&module=security-check\" target=\"_blank\" style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #2E280E;font-family: Helvetica;font-size: 18px;line-height: 100%;text-align: center;text-decoration: none;background-color: #FFCD08;border: 1px solid #FFCD08;display: inline-block;font-weight: bold;padding-top: 20px;padding-right: 30px;padding-bottom: 20px;padding-left: 30px;-webkit-border-radius: 5px;-moz-border-radius: 5px;border-radius: 5px;\">بررسی امنیت ✓</a>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n					</table>\n				</td>\n			</tr>\n		</table>\n	</td>\n</tr>\n						<tr>\n							<td class=\"pro-callout\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;\">\n								<table class=\"pro-callout-background\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;background-color: #0B1A23;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" class=\"container\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n												<tr>\n													<td align=\"center\" valign=\"top\" width=\"600\" class=\"section-padding\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 40px;padding-right: 20px;padding-left: 20px;\">\n														<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n															<tr>\n																<td valign=\"top\" class=\"container-cell\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n																	<img class=\"preserve-ratio\" src=\"http://localhost/hamyarlearn/wp-content/plugins/better-wp-security/core/img/mail/pro_logo_no_text.png\" style=\"max-width: 100px;border: 0;outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;height: auto;\" width=\"100\" alt=\"\" align=\"center\">\n																	<p class=\"two-factor\" style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;font-family: Helvetica;font-size: 16px;line-height: 150%;margin-top: 20px;margin-right: 0;margin-bottom: 20px;margin-left: 0;padding: 0;text-align: center;color: #FFFFFF;\">Want two-factor authentication, scheduled site scanning, ticketed support and more?</p>\n																	<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n																		<tr>\n																			<td style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n																				<table class=\"module-button\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n																					<tr>\n																						<td class=\"border-radius\" align=\"center\" bgcolor=\"#FFCD08\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;-webkit-border-radius: 5px;-moz-border-radius: 5px;border-radius: 5px;\">\n																							<a href=\"https://ithemes.com/security/#plugin-pricing\" target=\"_blank\" class=\"border-radius\" style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #2E280E;font-family: Helvetica;font-size: 30px;line-height: 100%;text-align: center;text-decoration: none;background-color: #FFCD08;border: 1px solid #FFCD08;display: inline-block;font-weight: bold;padding-top: 20px;padding-right: 30px;padding-bottom: 20px;padding-left: 30px;-webkit-border-radius: 5px;-moz-border-radius: 5px;border-radius: 5px;\">گرفتن نسخه پولی افزونه</a>\n																						</td>\n																					</tr>\n																				</table>\n																			</td>\n																		</tr>\n																	</table>\n																	<p class=\"why-pro\" style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;font-family: Helvetica;font-size: 16px;line-height: 150%;margin-top: 20px;margin-right: 0;margin-bottom: 20px;margin-left: 0;padding: 0;text-align: center;color: #999999;font-style: italic;\">چرا به پولی مهاجرت کنیم؟<a href=\"https://ithemes.com/security/why-go-pro/\">بررسی نسخه رایگان و پولی.</a></p>\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n<tr>\n	<td class=\"footer-heading\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n		<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n			<tr>\n				<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n					<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n						<tr>\n							<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n											<h2 style=\"color: #002030;font-family: Helvetica;font-size: 26px;font-weight: bold;line-height: 150%;margin: 0;padding: 0;text-align: center;\">منابع امنیت</h2>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n					</table>\n				</td>\n			</tr>\n		</table>\n	</td>\n</tr>\n<tr>\n	<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n		<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n			<tr>\n				<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n					<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n						<tr>\n							<td class=\"section-padding\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n								<table class=\"container\" align=\"left\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"260\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n											<img class=\"preserve-ratio\" src=\"http://localhost/hamyarlearn/wp-content/plugins/better-wp-security/core/img/mail/article_icon.png\" style=\"max-width: 61px;border: 0;outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;height: auto;\" width=\"61\" alt=\"\" align=\"center\">\n											<br>\n											<h4 style=\"color: #202020;font-family: Helvetica;font-size: 20px;font-weight: bold;line-height: 150%;margin: 0;padding: 0;text-align: center;\">\n												<a href=\"https://ithemes.com/category/wordpress-security/\" target=\"_blank\" style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #0084CB;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;text-decoration: none;\">مقالات</a>\n											</h4>\n											<br>\n											<p style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;font-family: Helvetica;font-size: 16px;line-height: 150%;margin-top: 10px;margin-right: 0;margin-bottom: 10px;margin-left: 0;padding: 0;text-align: center;\">بخوانید آخرین اخبار امنیتی وردپرس،نکات و بروزرسانی‌ها در <a href=\"https://ithemes.com/category/wordpress-security/\">iThemes Blog</a>.</p>\n										</td>\n									</tr>\n								</table>\n								<table class=\"container\" align=\"right\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"260\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td class=\"container-cell container-cell-bottom\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n											<img class=\"preserve-ratio\" src=\"http://localhost/hamyarlearn/wp-content/plugins/better-wp-security/core/img/mail/video_icon.png\" style=\"max-width: 61px;border: 0;outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;height: auto;\" width=\"61\" alt=\"\" align=\"center\">\n											<br>\n											<h4 style=\"color: #202020;font-family: Helvetica;font-size: 20px;font-weight: bold;line-height: 150%;margin: 0;padding: 0;text-align: center;\">\n												<a href=\"https://ithemes.com/tutorial/category/ithemes-security/\" target=\"_blank\" style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #0084CB;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;text-decoration: none;\">آموزش‌ها</a>\n											</h4>\n											<br>\n											<p style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;font-family: Helvetica;font-size: 16px;line-height: 150%;margin-top: 10px;margin-right: 0;margin-bottom: 10px;margin-left: 0;padding: 0;text-align: center;\">استفاده از ویژگی های امنیتی iThemes با <a href=\"https://ithemes.com/tutorial/category/ithemes-security/\">آموزش رایگان iThemes Security</a>.</p>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n					</table>\n				</td>\n			</tr>\n		</table>\n	</td>\n</tr>\n<tr>\n	<td class=\"divider\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n		<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n			<tr>\n				<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n					<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"450\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n						<tr>\n							<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"450\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n								<table class=\"divider-border\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;border-top-width: 1px;border-top-style: solid;border-top-color: #E8E8E8;\">\n									<tr>\n										<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 1px;text-align: center;padding-bottom: 20px;width: 450px;\">\n											&nbsp;\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n					</table>\n				</td>\n			</tr>\n		</table>\n	</td>\n</tr>\n<tr>\n	<td class=\"footer-heading\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n		<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n			<tr>\n				<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n					<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n						<tr>\n							<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n											<h2 style=\"color: #002030;font-family: Helvetica;font-size: 26px;font-weight: bold;line-height: 150%;margin: 0;padding: 0;text-align: center;\">کمک و پشتیبانی</h2>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n					</table>\n				</td>\n			</tr>\n		</table>\n	</td>\n</tr>\n<tr>\n	<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n		<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n			<tr>\n				<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n					<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n						<tr>\n							<td class=\"section-padding\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n								<table class=\"container\" align=\"left\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"260\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n											<img class=\"preserve-ratio\" src=\"http://localhost/hamyarlearn/wp-content/plugins/better-wp-security/core/img/mail/documentation_icon.png\" style=\"max-width: 62px;border: 0;outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;height: auto;\" width=\"62\" alt=\"\" align=\"center\">\n											<br>\n											<h4 style=\"color: #202020;font-family: Helvetica;font-size: 20px;font-weight: bold;line-height: 150%;margin: 0;padding: 0;text-align: center;\">\n												<a href=\"http://ithemes.com/codex/page/IThemes_Security\" target=\"_blank\" style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #0084CB;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;text-decoration: none;\">مستندات</a>\n											</h4>\n											<br>\n											<p style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;font-family: Helvetica;font-size: 16px;line-height: 150%;margin-top: 10px;margin-right: 0;margin-bottom: 10px;margin-left: 0;padding: 0;text-align: center;\">بخوانید مستندات و سوالات و پاسخ های افزونه را در <a href=\"http://ithemes.com/codex/page/IThemes_Security\">the Codex</a>.</p>\n										</td>\n									</tr>\n								</table>\n								<table class=\"container\" align=\"right\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"260\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td class=\"container-cell container-cell-bottom\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n											<img class=\"preserve-ratio\" src=\"http://localhost/hamyarlearn/wp-content/plugins/better-wp-security/core/img/mail/support_icon.png\" style=\"max-width: 62px;border: 0;outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;height: auto;\" width=\"62\" alt=\"\" align=\"center\">\n											<br>\n											<h4 style=\"color: #202020;font-family: Helvetica;font-size: 20px;font-weight: bold;line-height: 150%;margin: 0;padding: 0;text-align: center;\">\n												<a href=\"https://members.ithemes.com/panel/helpdesk.php\" target=\"_blank\" style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #0084CB;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;text-decoration: none;\">پشتیبانی</a>\n												<span class=\"pro-flag\" style=\"background-color: #FFCC00;color: #000000;font-size: 10px;display: inline-block;padding: 3px;line-height: 1;position: relative;bottom: 10px;text-transform: uppercase;\">پیشرفته</span>\n											</h4>\n											<br>\n											<p style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;font-family: Helvetica;font-size: 16px;line-height: 150%;margin-top: 10px;margin-right: 0;margin-bottom: 10px;margin-left: 0;padding: 0;text-align: center;\">مشتریان نسخه پولی می توانند با بخش <a href=\"https://members.ithemes.com/panel/helpdesk.php\">iThemes Helpdesk</a> برای کمک تماس بگیرند.تیم پشتیبانی ما در روزهای دوشنبه - جمعه ساعت 8 صبح-5بعدظهر پاسخگو است.</p>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n					</table>\n				</td>\n			</tr>\n		</table>\n	</td>\n</tr>\n<tr>\n	<td id=\"security-guide\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n		<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n			<tr>\n				<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n					<table id=\"security-guide-container\" class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;border: 1px solid #CDCECE;background-color: #D3E8E9;\">\n						<tr>\n							<td class=\"section-padding\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n								<table class=\"container\" align=\"left\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"104\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td class=\"section-padding-bottom\" align=\"left\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-bottom: 20px;\">\n											<img class=\"preserve-ratio\" src=\"http://localhost/hamyarlearn/wp-content/plugins/better-wp-security/core/img/mail/wp_security_book.png\" style=\"max-width: 84px;border: 0;outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;height: auto;\" width=\"84\" alt=\"\" align=\"center\">\n										</td>\n									</tr>\n								</table>\n								<table class=\"container\" align=\"right\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"454\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #6C6C6C;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: left;padding-bottom: 20px;\">\n											<h4 style=\"color: #6C6C6C;font-family: Helvetica;font-size: 18px;font-weight: bold;line-height: 150%;margin: 0;padding: 0;text-align: left;padding-bottom: 10px;\">راهنمای رایگان امنیت وردپرس</h4>\n											یادگیری نکات ابتدایی امنیتی وردپرس - شامل سه نوع امنیت برای سایت شما و 4 تمرین عالی برای اینکه سایت شما را امن نگاه دارد مشاهده کنید بخش <a href=\"https://ithemes.com/publishing/wordpress-security/\">free guide</a>.\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n					</table>\n				</td>\n			</tr>\n		</table>\n	</td>\n</tr>\n<tr>\n	<td id=\"footer-source-details\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n		<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n			<tr>\n				<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n					<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n						<tr>\n							<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 200%;text-align: center;padding-bottom: 0;padding-top: 60px;\">\n											<img class=\"preserve-ratio\" src=\"http://localhost/hamyarlearn/wp-content/plugins/better-wp-security/core/img/mail/footer_logo.png\" style=\"max-width: 50px;border: 0;outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;height: auto;\" width=\"50\" alt=\"\" align=\"center\"><br>\n											<br>\n											<span style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #666f72;font-family: Helvetica;font-size: 11px;line-height: 200%;text-align: center;text-decoration: none;font-weight: bold;\">\n												این ایمیل توسط افزونه iThemes Security ایجاد شده است.<br>برای لغو اشتراک از این بروزرسانی ها،مشاهده کنید <a href=\"http://localhost/hamyarlearn/wp-admin/admin.php?page=itsec\" style=\"color: #0084CB\">برگه تنظیمات</a> در فهرست افزونه امنیتی.\n											</span>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n					</table>\n				</td>\n			</tr>\n		</table>\n	</td>\n</tr>					</table>\n				</td>\n			</tr>\n		</table>\n	</center>\n</body>\n\n</html>\n\";s:7:\"headers\";a:0:{}s:11:\"attachments\";a:0:{}s:24:\"phpmailer_exception_code\";i:0;}}}}", "error", "2020-11-01 17:22:13", "2020-11-01 17:22:04", "77928408", "78310376", "wp-cron", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("44", "0", "brute_force", "invalid-login::user-2", "a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:12:\"wp-login.php\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:261:\"<strong>خطا</strong>: رمز عبوری که برای نام کاربری <strong>hamyarlearn</strong> وارد شده درست نیست. <a href=\"http://localhost/hamyarlearn/my-account/lost-password/\">رمز عبورتان را گم کرده‌اید؟</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:11:\"hamyarlearn\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:24:{s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:9:\"HTTP_HOST\";s:9:\"localhost\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:14:\"CONTENT_LENGTH\";s:3:\"140\";s:18:\"HTTP_CACHE_CONTROL\";s:9:\"max-age=0\";s:11:\"HTTP_ORIGIN\";s:16:\"http://localhost\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:8:\"HTTP_DNT\";s:1:\"1\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.111 Safari/537.36\";s:11:\"HTTP_ACCEPT\";s:135:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9\";s:19:\"HTTP_SEC_FETCH_SITE\";s:11:\"same-origin\";s:19:\"HTTP_SEC_FETCH_MODE\";s:8:\"navigate\";s:19:\"HTTP_SEC_FETCH_USER\";s:2:\"?1\";s:19:\"HTTP_SEC_FETCH_DEST\";s:8:\"document\";s:12:\"HTTP_REFERER\";s:113:\"http://localhost/hamyarlearn/wp-login.php?redirect_to=http%3A%2F%2Flocalhost%2Fhamyarlearn%2Fwp-admin%2F&reauth=1\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:56:\"en-US,en;q=0.9,my-ZG;q=0.8,my;q=0.7,fa-IR;q=0.6,fa;q=0.5\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"SCRIPT_FILENAME\";s:39:\"C:/laragon/www/hamyarlearn/wp-login.php\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:18:\"REQUEST_TIME_FLOAT\";d:1604251344.876;s:12:\"REQUEST_TIME\";i:1604251344;}}", "notice", "2020-11-01 17:22:27", "2020-11-01 17:22:25", "78015592", "78991680", "http://localhost/hamyarlearn/wp-login.php", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("45", "0", "brute_force", "invalid-login::user-2", "a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:12:\"wp-login.php\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:261:\"<strong>خطا</strong>: رمز عبوری که برای نام کاربری <strong>hamyarlearn</strong> وارد شده درست نیست. <a href=\"http://localhost/hamyarlearn/my-account/lost-password/\">رمز عبورتان را گم کرده‌اید؟</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:11:\"hamyarlearn\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:24:{s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:9:\"HTTP_HOST\";s:9:\"localhost\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:14:\"CONTENT_LENGTH\";s:3:\"137\";s:18:\"HTTP_CACHE_CONTROL\";s:9:\"max-age=0\";s:11:\"HTTP_ORIGIN\";s:16:\"http://localhost\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:8:\"HTTP_DNT\";s:1:\"1\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.111 Safari/537.36\";s:11:\"HTTP_ACCEPT\";s:135:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9\";s:19:\"HTTP_SEC_FETCH_SITE\";s:11:\"same-origin\";s:19:\"HTTP_SEC_FETCH_MODE\";s:8:\"navigate\";s:19:\"HTTP_SEC_FETCH_USER\";s:2:\"?1\";s:19:\"HTTP_SEC_FETCH_DEST\";s:8:\"document\";s:12:\"HTTP_REFERER\";s:41:\"http://localhost/hamyarlearn/wp-login.php\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:56:\"en-US,en;q=0.9,my-ZG;q=0.8,my;q=0.7,fa-IR;q=0.6,fa;q=0.5\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"SCRIPT_FILENAME\";s:39:\"C:/laragon/www/hamyarlearn/wp-login.php\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:18:\"REQUEST_TIME_FLOAT\";d:1604251356.454;s:12:\"REQUEST_TIME\";i:1604251356;}}", "notice", "2020-11-01 17:22:38", "2020-11-01 17:22:36", "78012344", "78988432", "http://localhost/hamyarlearn/wp-login.php", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("46", "0", "brute_force", "invalid-login::user-2", "a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:12:\"wp-login.php\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:261:\"<strong>خطا</strong>: رمز عبوری که برای نام کاربری <strong>hamyarlearn</strong> وارد شده درست نیست. <a href=\"http://localhost/hamyarlearn/my-account/lost-password/\">رمز عبورتان را گم کرده‌اید؟</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:11:\"hamyarlearn\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:24:{s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:9:\"HTTP_HOST\";s:9:\"localhost\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:14:\"CONTENT_LENGTH\";s:3:\"138\";s:18:\"HTTP_CACHE_CONTROL\";s:9:\"max-age=0\";s:11:\"HTTP_ORIGIN\";s:16:\"http://localhost\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:8:\"HTTP_DNT\";s:1:\"1\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.111 Safari/537.36\";s:11:\"HTTP_ACCEPT\";s:135:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9\";s:19:\"HTTP_SEC_FETCH_SITE\";s:11:\"same-origin\";s:19:\"HTTP_SEC_FETCH_MODE\";s:8:\"navigate\";s:19:\"HTTP_SEC_FETCH_USER\";s:2:\"?1\";s:19:\"HTTP_SEC_FETCH_DEST\";s:8:\"document\";s:12:\"HTTP_REFERER\";s:41:\"http://localhost/hamyarlearn/wp-login.php\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:56:\"en-US,en;q=0.9,my-ZG;q=0.8,my;q=0.7,fa-IR;q=0.6,fa;q=0.5\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"SCRIPT_FILENAME\";s:39:\"C:/laragon/www/hamyarlearn/wp-login.php\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:18:\"REQUEST_TIME_FLOAT\";d:1604251417.326;s:12:\"REQUEST_TIME\";i:1604251417;}}", "notice", "2020-11-01 17:23:38", "2020-11-01 17:23:37", "77873056", "78988432", "http://localhost/hamyarlearn/wp-login.php", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("47", "0", "notification_center", "send_scheduled", "a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}", "debug", "2020-11-07 19:55:40", "2020-11-07 19:53:55", "107091200", "107135984", "http://localhost/hamyarlearn/wp-admin/", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("48", "0", "notification_center", "send::digest", "a:2:{s:10:\"recipients\";a:1:{i:0;s:22:\"shayanfp@shayanweb.com\";}s:7:\"subject\";s:58:\"[localhost/hamyarlearn] خلاصه امنیت روزانه\";}", "debug", "2020-11-07 19:55:42", "2020-11-07 19:53:55", "107480864", "107520280", "http://localhost/hamyarlearn/wp-admin/", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("49", "0", "notification_center", "send_failed::digest", "a:1:{s:5:\"error\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:14:\"wp_mail_failed\";a:1:{i:0;s:45:\"Invalid address:  (From): wordpress@localhost\";}}s:10:\"error_data\";a:1:{s:14:\"wp_mail_failed\";a:6:{s:2:\"to\";a:1:{i:0;s:22:\"shayanfp@shayanweb.com\";}s:7:\"subject\";s:58:\"[localhost/hamyarlearn] خلاصه امنیت روزانه\";s:7:\"message\";s:61022:\"\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"fa-IR\">\n\n<head>\n	<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n	<title>خلاصه امنیت روزانه</title>\n	<meta name=\"viewport\" content=\"width=device-width\">\n\n	<style type=\"text/css\">\n		/* From: https://litmus.com/community/learning/13-foundations-email-coding-101 */\n\n		/* GENERAL STYLE RESETS */\n		body,#body-table,#body-cell{height:100%!important;width:100%!important;margin:0;padding:0;}\n		img,aimg{border:0;outline:none;text-decoration:none;}\n		.imageFix{display:block;}\n		table,td{border-collapse:collapse;border-spacing:0;}\n\n		/* CLIENT-SPECIFIC RESETS */\n		.ReadMsgBody{width:100%;}\n		.ExternalClass{width:100%;}\n		.ExternalClass,.ExternalClass p,.ExternalClass span,.ExternalClass font,.ExternalClass td,.ExternalClass div{line-height:100%;}\n		table,td{mso-table-lspace:0pt;mso-table-rspace:0pt;}\n		img{-ms-interpolation-mode:bicubic;}\n		body,table,td,p,a,li,blockquote{-ms-text-size-adjust:100%;-webkit-text-size-adjust:100%;}\n\n\n		h1,h2,h3,h4,h5,h6{color:#202020;font-family:Helvetica;font-size:20px;font-weight:bold;line-height:150%;margin:0;padding:0;text-align:center;}\n		p{font-family:Helvetica;font-size:16px;line-height:150%;margin-top:10px;margin-right:0;margin-bottom:10px;margin-left:0;padding:0;text-align:center;}\n		a{color:#0084CB;font-family:Helvetica;font-size:16px;line-height:150%;text-align:center;text-decoration:none;}\n		img{height:auto;}\n\n		body,#body-table{background-color:#FFFFFF;}\n		#body-cell{padding-bottom:20px;}\n		.section-padding{padding-top:20px;padding-right:20px;padding-left:20px;}\n		.section-padding-bottom{padding-bottom:20px;}\n		.container-cell{color:#808080;font-family:Helvetica;font-size:16px;line-height:150%;text-align:center;padding-bottom:20px;}\n		#top-banner{background-color:#FFCE08;}\n		#top-banner .container-cell{color:#413F39;font-size:13px;}\n		#top-logo .container-cell{padding-top:20px;}\n		#title-container h1{font-size:34px;}\n		.info-box{padding-top:20px;padding-bottom:20px;}\n		.info-box .container{border:1px solid #CDCECE;background-color:#F2F2F2;}\n		.info-box .section-padding{padding-top:40px;padding-right:40px;padding-left:40px;}\n		.info-box .container-cell{padding-bottom:40px;}\n		.info-box .info-icon{width:33px;height:23px;vertical-align:middle;}\n		.section-heading .container-cell{padding-bottom:0;}\n		.section-heading h4{color:#0084CB;font-size:16px;}\n		.section-heading h4 img{padding-top:2px;padding-right:5px;vertical-align:top;}\n		.lockouts-summary .container.left-column{margin-right:60px;}\n		.lockouts-summary h4{color:#ACAAAA;font-size:16px;font-weight:normal;}\n		.lockouts-summary p{color:#505050;font-size:30px;font-weight:bold;}\n		.table{border:1px solid #cdcece;color: #808080;font-family:Helvetica;font-size:14px;}\n		.table th,.table td{border:1px solid #cdcece;padding:10px;}\n		.table th{text-align:left;font-weight:bold;padding:5px 10px;}\n		.table .row-label{font-style:italic;}\n		.table a,.table b{font-size:14px;}\n		.large-text h4{color:#505050;margin-bottom:10px;}\n		.details-box-container{padding-top:20px;padding-bottom:20px;}\n		.details-box{background-color:#E4EEF7;border:1px solid #CDCECE;}\n		.details-box .container-cell{color:#6A6A6A;}\n		.divider .divider-border{border-top-width:1px;border-top-style:solid;border-top-color:#E8E8E8;}\n		.divider .container-cell{line-height:1px;padding-bottom:20px;width:450px;}\n		.module-button .border-radius{-webkit-border-radius:5px;-moz-border-radius:5px;border-radius:5px;}\n		.module-button a{background-color:#FFCD08;border:1px solid #FFCD08;color:#2E280E;display:inline-block;font-size:18px;font-weight:bold;line-height:100%;padding-top:20px;padding-right:30px;padding-bottom:20px;padding-left:30px;}\n		.pro-callout{padding-top:20px;}\n		.pro-callout-background{background-color:#0B1A23;}\n		.pro-callout .section-padding{padding-top:40px;}\n		.pro-callout .two-factor{color:#FFFFFF;margin-top:20px;margin-bottom:20px;}\n		.pro-callout .module-button a{font-size:30px;}\n		.pro-callout .why-pro{color:#999999;font-style:italic;margin-top:20px;margin-bottom:20px;}\n		.footer-heading h2{color:#002030;font-size:26px;}\n		.pro-flag{background-color:#FFCC00;color:#000000;font-size:10px;display:inline-block;padding:3px;line-height:1;position:relative;bottom:10px;text-transform:uppercase;}\n		#security-guide-container{border:1px solid #CDCECE;background-color:#D3E8E9;}\n		#security-guide .container-cell{color:#6C6C6C;text-align:left;}\n		#security-guide h4{color:#6C6C6C;font-size:18px;padding-bottom:10px;text-align:left;}\n		#security-guide a{font-weight:bold;}\n		#footer-source-details .container-cell{line-height:200%;padding-top:60px;padding-bottom:0;}\n		#footer-source-details a{font-size:11px;font-weight:bold;line-height:200%;}\n		.template-container {max-width: 600px !important;}\n\n		@media only screen and (max-width:600px){\n			body{width:100% !important;min-width:100% !important;}\n			#body-cell{padding:10px !important;}\n			#main-container, .container{width:100% !important;}\n			.preserve-ratio{height:auto !important;width:100% !important;}\n			.container-cell-bottom{padding-top:20px !important;}\n			.lockouts-summary .container{width:auto !important;}\n		}\n\n		@media only screen and (max-width:450px){\n			.divider .container-cell{width:auto !important;}\n		}\n	</style>\n</head>\n\n<body style=\"margin: 0;padding: 0;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;background-color: #FFFFFF;height: 100%!important;width: 100%!important;\">\n	<center>\n		<table id=\"body-table\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" height=\"100%\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;margin: 0;padding: 0;background-color: #FFFFFF;height: 100%!important;width: 100%!important;\">\n			<tr>\n				<td id=\"body-cell\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;margin: 0;padding: 0;padding-bottom: 20px;height: 100%!important;width: 100%!important;\">\n					<table id=\"main-container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n						<tr>\n							<td id=\"top-banner\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;background-color: #FFCE08;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n												<tr>\n													<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n														<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #413F39;font-family: Helvetica;font-size: 13px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n																	خلاصه امنیت روزانه شما برای <b>۱۷ آبان ۱۳۹۹</b>\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n						<tr>\n							<td id=\"top-logo\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n												<tr>\n													<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n														<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;padding-top: 20px;\">\n																	<img class=\"preserve-ratio\" src=\"http://localhost/hamyarlearn/wp-content/plugins/better-wp-security/core/img/mail/logo.png\" style=\"max-width: 300px;border: 0;outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;height: auto;\" alt=\"\" align=\"center\">\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n						<tr>\n							<td id=\"title-container\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n												<tr>\n													<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n														<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n																	<h1 style=\"color: #202020;font-family: Helvetica;font-size: 34px;font-weight: bold;line-height: 150%;margin: 0;padding: 0;text-align: center;\">خلاصه امنیت روزانه</h1>\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n						<tr>\n							<td class=\"info-box\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-bottom: 20px;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;border: 1px solid #CDCECE;background-color: #F2F2F2;\">\n												<tr>\n													<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 40px;padding-right: 40px;padding-left: 40px;\">\n														<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 40px;\">\n																	<img class=\"info-icon\" src=\"http://localhost/hamyarlearn/wp-content/plugins/better-wp-security/core/img/mail/info_icon.png\" alt=\"\" align=\"center\" width=\"33\" height=\"23\" style=\"border: 0;outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;height: 23px;width: 33px;vertical-align: middle;\">\n																	در زیر خلاصه ای از فعالیت مرتبط با امنیت در سایت شما است: <b>localhost/hamyarlearn</b>\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n						<tr>\n							<td class=\"section-heading\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n												<tr>\n													<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n														<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 0;\">\n																	<h4 style=\"color: #0084CB;font-family: Helvetica;font-size: 16px;font-weight: bold;line-height: 150%;margin: 0;padding: 0;text-align: center;\">\n																		<img src=\"http://localhost/hamyarlearn/wp-content/plugins/better-wp-security/core/img/mail/icon_lock.png\" alt=\"\" align=\"center\" style=\"border: 0;outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;height: auto;padding-top: 2px;padding-right: 5px;vertical-align: top;\">\n																		قفل کردن\n																	</h4>\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n						<tr>\n							<td class=\"lockouts-summary\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n												<tr>\n													<td class=\"section-padding\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n														<table class=\"container left-column\" align=\"left\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;margin-right: 60px;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n																	<h4 style=\"color: #ACAAAA;font-family: Helvetica;font-size: 16px;font-weight: normal;line-height: 150%;margin: 0;padding: 0;text-align: center;\">کاربران</h4>\n																	<p style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;font-family: Helvetica;font-size: 30px;line-height: 150%;margin-top: 10px;margin-right: 0;margin-bottom: 10px;margin-left: 0;padding: 0;text-align: center;color: #505050;font-weight: bold;\">0</p>\n																</td>\n															</tr>\n														</table>\n														<table class=\"container right-column\" align=\"right\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n																	<h4 style=\"color: #ACAAAA;font-family: Helvetica;font-size: 16px;font-weight: normal;line-height: 150%;margin: 0;padding: 0;text-align: center;\">هاست‌ها</h4>\n																	<p style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;font-family: Helvetica;font-size: 30px;line-height: 150%;margin-top: 10px;margin-right: 0;margin-bottom: 10px;margin-left: 0;padding: 0;text-align: center;color: #505050;font-weight: bold;\">1</p>\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n						<tr>\n							<td class=\"details-box-container\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-bottom: 20px;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"details-box container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;background-color: #E4EEF7;border: 1px solid #CDCECE;\">\n												<tr>\n													<td class=\"section-padding\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n														<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #6A6A6A;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n																	برای جزئیات بیشتر،  <a href=\"http://localhost/hamyarlearn/wp-admin/admin.php?page=itsec-logs\"><b> گزارشات امینیتی را ببینید</b></a>\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n						<tr>\n							<td class=\"divider\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"450\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n												<tr>\n													<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"450\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n														<table class=\"divider-border\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;border-top-width: 1px;border-top-style: solid;border-top-color: #E8E8E8;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 1px;text-align: center;padding-bottom: 20px;width: 450px;\">\n																	&nbsp;\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n						<tr>\n							<td class=\"large-text\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n												<tr>\n													<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n														<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n																	<h4 style=\"color: #505050;font-family: Helvetica;font-size: 20px;font-weight: bold;line-height: 150%;margin: 0;padding: 0;text-align: center;margin-bottom: 10px;\">آیا سایت شما به همان اندازه که می تواند امن است؟</h4>\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n						<tr>\n							<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n												<tr>\n													<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n														<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n																	اطمینان حاصل کنید که سایت شما با استفاده از بررسی امنیتی، از تنظیمات و ویژگی های توصیه شده استفاده می کند.\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n<tr>\n	<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n		<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n			<tr>\n				<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n					<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n						<tr>\n							<td class=\"section-padding section-padding-bottom\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;padding-bottom: 20px;\">\n								<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"module-button\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n												<tr>\n													<td class=\"border-radius\" align=\"center\" bgcolor=\"#FFCD08\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;-webkit-border-radius: 5px;-moz-border-radius: 5px;border-radius: 5px;\">\n														<a class=\"border-radius\" href=\"http://localhost/hamyarlearn/wp-admin/admin.php?page=itsec&module=security-check\" target=\"_blank\" style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #2E280E;font-family: Helvetica;font-size: 18px;line-height: 100%;text-align: center;text-decoration: none;background-color: #FFCD08;border: 1px solid #FFCD08;display: inline-block;font-weight: bold;padding-top: 20px;padding-right: 30px;padding-bottom: 20px;padding-left: 30px;-webkit-border-radius: 5px;-moz-border-radius: 5px;border-radius: 5px;\">بررسی امنیت ✓</a>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n					</table>\n				</td>\n			</tr>\n		</table>\n	</td>\n</tr>\n						<tr>\n							<td class=\"pro-callout\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;\">\n								<table class=\"pro-callout-background\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;background-color: #0B1A23;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" class=\"container\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n												<tr>\n													<td align=\"center\" valign=\"top\" width=\"600\" class=\"section-padding\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 40px;padding-right: 20px;padding-left: 20px;\">\n														<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n															<tr>\n																<td valign=\"top\" class=\"container-cell\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n																	<img class=\"preserve-ratio\" src=\"http://localhost/hamyarlearn/wp-content/plugins/better-wp-security/core/img/mail/pro_logo_no_text.png\" style=\"max-width: 100px;border: 0;outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;height: auto;\" width=\"100\" alt=\"\" align=\"center\">\n																	<p class=\"two-factor\" style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;font-family: Helvetica;font-size: 16px;line-height: 150%;margin-top: 20px;margin-right: 0;margin-bottom: 20px;margin-left: 0;padding: 0;text-align: center;color: #FFFFFF;\">Want two-factor authentication, scheduled site scanning, ticketed support and more?</p>\n																	<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n																		<tr>\n																			<td style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n																				<table class=\"module-button\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n																					<tr>\n																						<td class=\"border-radius\" align=\"center\" bgcolor=\"#FFCD08\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;-webkit-border-radius: 5px;-moz-border-radius: 5px;border-radius: 5px;\">\n																							<a href=\"https://ithemes.com/security/#plugin-pricing\" target=\"_blank\" class=\"border-radius\" style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #2E280E;font-family: Helvetica;font-size: 30px;line-height: 100%;text-align: center;text-decoration: none;background-color: #FFCD08;border: 1px solid #FFCD08;display: inline-block;font-weight: bold;padding-top: 20px;padding-right: 30px;padding-bottom: 20px;padding-left: 30px;-webkit-border-radius: 5px;-moz-border-radius: 5px;border-radius: 5px;\">گرفتن نسخه پولی افزونه</a>\n																						</td>\n																					</tr>\n																				</table>\n																			</td>\n																		</tr>\n																	</table>\n																	<p class=\"why-pro\" style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;font-family: Helvetica;font-size: 16px;line-height: 150%;margin-top: 20px;margin-right: 0;margin-bottom: 20px;margin-left: 0;padding: 0;text-align: center;color: #999999;font-style: italic;\">چرا به پولی مهاجرت کنیم؟<a href=\"https://ithemes.com/security/why-go-pro/\">بررسی نسخه رایگان و پولی.</a></p>\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n<tr>\n	<td class=\"footer-heading\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n		<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n			<tr>\n				<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n					<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n						<tr>\n							<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n											<h2 style=\"color: #002030;font-family: Helvetica;font-size: 26px;font-weight: bold;line-height: 150%;margin: 0;padding: 0;text-align: center;\">منابع امنیت</h2>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n					</table>\n				</td>\n			</tr>\n		</table>\n	</td>\n</tr>\n<tr>\n	<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n		<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n			<tr>\n				<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n					<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n						<tr>\n							<td class=\"section-padding\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n								<table class=\"container\" align=\"left\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"260\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n											<img class=\"preserve-ratio\" src=\"http://localhost/hamyarlearn/wp-content/plugins/better-wp-security/core/img/mail/article_icon.png\" style=\"max-width: 61px;border: 0;outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;height: auto;\" width=\"61\" alt=\"\" align=\"center\">\n											<br>\n											<h4 style=\"color: #202020;font-family: Helvetica;font-size: 20px;font-weight: bold;line-height: 150%;margin: 0;padding: 0;text-align: center;\">\n												<a href=\"https://ithemes.com/category/wordpress-security/\" target=\"_blank\" style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #0084CB;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;text-decoration: none;\">مقالات</a>\n											</h4>\n											<br>\n											<p style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;font-family: Helvetica;font-size: 16px;line-height: 150%;margin-top: 10px;margin-right: 0;margin-bottom: 10px;margin-left: 0;padding: 0;text-align: center;\">بخوانید آخرین اخبار امنیتی وردپرس،نکات و بروزرسانی‌ها در <a href=\"https://ithemes.com/category/wordpress-security/\">iThemes Blog</a>.</p>\n										</td>\n									</tr>\n								</table>\n								<table class=\"container\" align=\"right\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"260\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td class=\"container-cell container-cell-bottom\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n											<img class=\"preserve-ratio\" src=\"http://localhost/hamyarlearn/wp-content/plugins/better-wp-security/core/img/mail/video_icon.png\" style=\"max-width: 61px;border: 0;outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;height: auto;\" width=\"61\" alt=\"\" align=\"center\">\n											<br>\n											<h4 style=\"color: #202020;font-family: Helvetica;font-size: 20px;font-weight: bold;line-height: 150%;margin: 0;padding: 0;text-align: center;\">\n												<a href=\"https://ithemes.com/tutorial/category/ithemes-security/\" target=\"_blank\" style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #0084CB;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;text-decoration: none;\">آموزش‌ها</a>\n											</h4>\n											<br>\n											<p style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;font-family: Helvetica;font-size: 16px;line-height: 150%;margin-top: 10px;margin-right: 0;margin-bottom: 10px;margin-left: 0;padding: 0;text-align: center;\">استفاده از ویژگی های امنیتی iThemes با <a href=\"https://ithemes.com/tutorial/category/ithemes-security/\">آموزش رایگان iThemes Security</a>.</p>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n					</table>\n				</td>\n			</tr>\n		</table>\n	</td>\n</tr>\n<tr>\n	<td class=\"divider\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n		<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n			<tr>\n				<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n					<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"450\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n						<tr>\n							<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"450\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n								<table class=\"divider-border\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;border-top-width: 1px;border-top-style: solid;border-top-color: #E8E8E8;\">\n									<tr>\n										<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 1px;text-align: center;padding-bottom: 20px;width: 450px;\">\n											&nbsp;\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n					</table>\n				</td>\n			</tr>\n		</table>\n	</td>\n</tr>\n<tr>\n	<td class=\"footer-heading\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n		<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n			<tr>\n				<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n					<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n						<tr>\n							<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n											<h2 style=\"color: #002030;font-family: Helvetica;font-size: 26px;font-weight: bold;line-height: 150%;margin: 0;padding: 0;text-align: center;\">کمک و پشتیبانی</h2>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n					</table>\n				</td>\n			</tr>\n		</table>\n	</td>\n</tr>\n<tr>\n	<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n		<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n			<tr>\n				<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n					<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n						<tr>\n							<td class=\"section-padding\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n								<table class=\"container\" align=\"left\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"260\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n											<img class=\"preserve-ratio\" src=\"http://localhost/hamyarlearn/wp-content/plugins/better-wp-security/core/img/mail/documentation_icon.png\" style=\"max-width: 62px;border: 0;outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;height: auto;\" width=\"62\" alt=\"\" align=\"center\">\n											<br>\n											<h4 style=\"color: #202020;font-family: Helvetica;font-size: 20px;font-weight: bold;line-height: 150%;margin: 0;padding: 0;text-align: center;\">\n												<a href=\"http://ithemes.com/codex/page/IThemes_Security\" target=\"_blank\" style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #0084CB;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;text-decoration: none;\">مستندات</a>\n											</h4>\n											<br>\n											<p style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;font-family: Helvetica;font-size: 16px;line-height: 150%;margin-top: 10px;margin-right: 0;margin-bottom: 10px;margin-left: 0;padding: 0;text-align: center;\">بخوانید مستندات و سوالات و پاسخ های افزونه را در <a href=\"http://ithemes.com/codex/page/IThemes_Security\">the Codex</a>.</p>\n										</td>\n									</tr>\n								</table>\n								<table class=\"container\" align=\"right\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"260\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td class=\"container-cell container-cell-bottom\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n											<img class=\"preserve-ratio\" src=\"http://localhost/hamyarlearn/wp-content/plugins/better-wp-security/core/img/mail/support_icon.png\" style=\"max-width: 62px;border: 0;outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;height: auto;\" width=\"62\" alt=\"\" align=\"center\">\n											<br>\n											<h4 style=\"color: #202020;font-family: Helvetica;font-size: 20px;font-weight: bold;line-height: 150%;margin: 0;padding: 0;text-align: center;\">\n												<a href=\"https://members.ithemes.com/panel/helpdesk.php\" target=\"_blank\" style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #0084CB;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;text-decoration: none;\">پشتیبانی</a>\n												<span class=\"pro-flag\" style=\"background-color: #FFCC00;color: #000000;font-size: 10px;display: inline-block;padding: 3px;line-height: 1;position: relative;bottom: 10px;text-transform: uppercase;\">پیشرفته</span>\n											</h4>\n											<br>\n											<p style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;font-family: Helvetica;font-size: 16px;line-height: 150%;margin-top: 10px;margin-right: 0;margin-bottom: 10px;margin-left: 0;padding: 0;text-align: center;\">مشتریان نسخه پولی می توانند با بخش <a href=\"https://members.ithemes.com/panel/helpdesk.php\">iThemes Helpdesk</a> برای کمک تماس بگیرند.تیم پشتیبانی ما در روزهای دوشنبه - جمعه ساعت 8 صبح-5بعدظهر پاسخگو است.</p>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n					</table>\n				</td>\n			</tr>\n		</table>\n	</td>\n</tr>\n<tr>\n	<td id=\"security-guide\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n		<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n			<tr>\n				<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n					<table id=\"security-guide-container\" class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;border: 1px solid #CDCECE;background-color: #D3E8E9;\">\n						<tr>\n							<td class=\"section-padding\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n								<table class=\"container\" align=\"left\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"104\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td class=\"section-padding-bottom\" align=\"left\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-bottom: 20px;\">\n											<img class=\"preserve-ratio\" src=\"http://localhost/hamyarlearn/wp-content/plugins/better-wp-security/core/img/mail/wp_security_book.png\" style=\"max-width: 84px;border: 0;outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;height: auto;\" width=\"84\" alt=\"\" align=\"center\">\n										</td>\n									</tr>\n								</table>\n								<table class=\"container\" align=\"right\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"454\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #6C6C6C;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: left;padding-bottom: 20px;\">\n											<h4 style=\"color: #6C6C6C;font-family: Helvetica;font-size: 18px;font-weight: bold;line-height: 150%;margin: 0;padding: 0;text-align: left;padding-bottom: 10px;\">راهنمای رایگان امنیت وردپرس</h4>\n											یادگیری نکات ابتدایی امنیتی وردپرس - شامل سه نوع امنیت برای سایت شما و 4 تمرین عالی برای اینکه سایت شما را امن نگاه دارد مشاهده کنید بخش <a href=\"https://ithemes.com/publishing/wordpress-security/\">free guide</a>.\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n					</table>\n				</td>\n			</tr>\n		</table>\n	</td>\n</tr>\n<tr>\n	<td id=\"footer-source-details\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n		<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n			<tr>\n				<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n					<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n						<tr>\n							<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 200%;text-align: center;padding-bottom: 0;padding-top: 60px;\">\n											<img class=\"preserve-ratio\" src=\"http://localhost/hamyarlearn/wp-content/plugins/better-wp-security/core/img/mail/footer_logo.png\" style=\"max-width: 50px;border: 0;outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;height: auto;\" width=\"50\" alt=\"\" align=\"center\"><br>\n											<br>\n											<span style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #666f72;font-family: Helvetica;font-size: 11px;line-height: 200%;text-align: center;text-decoration: none;font-weight: bold;\">\n												این ایمیل توسط افزونه iThemes Security ایجاد شده است.<br>برای لغو اشتراک از این بروزرسانی ها،مشاهده کنید <a href=\"http://localhost/hamyarlearn/wp-admin/admin.php?page=itsec\" style=\"color: #0084CB\">برگه تنظیمات</a> در فهرست افزونه امنیتی.\n											</span>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n					</table>\n				</td>\n			</tr>\n		</table>\n	</td>\n</tr>					</table>\n				</td>\n			</tr>\n		</table>\n	</center>\n</body>\n\n</html>\n\";s:7:\"headers\";a:0:{}s:11:\"attachments\";a:0:{}s:24:\"phpmailer_exception_code\";i:0;}}}}", "error", "2020-11-07 19:55:42", "2020-11-07 19:53:55", "108153528", "108600312", "http://localhost/hamyarlearn/wp-admin/", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("50", "0", "brute_force", "invalid-login::user-2", "a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:12:\"wp-login.php\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:261:\"<strong>خطا</strong>: رمز عبوری که برای نام کاربری <strong>hamyarlearn</strong> وارد شده درست نیست. <a href=\"http://localhost/hamyarlearn/my-account/lost-password/\">رمز عبورتان را گم کرده‌اید؟</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:11:\"hamyarlearn\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:24:{s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:9:\"HTTP_HOST\";s:9:\"localhost\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:14:\"CONTENT_LENGTH\";s:3:\"140\";s:18:\"HTTP_CACHE_CONTROL\";s:9:\"max-age=0\";s:11:\"HTTP_ORIGIN\";s:16:\"http://localhost\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:8:\"HTTP_DNT\";s:1:\"1\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.183 Safari/537.36\";s:11:\"HTTP_ACCEPT\";s:135:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9\";s:19:\"HTTP_SEC_FETCH_SITE\";s:11:\"same-origin\";s:19:\"HTTP_SEC_FETCH_MODE\";s:8:\"navigate\";s:19:\"HTTP_SEC_FETCH_USER\";s:2:\"?1\";s:19:\"HTTP_SEC_FETCH_DEST\";s:8:\"document\";s:12:\"HTTP_REFERER\";s:113:\"http://localhost/hamyarlearn/wp-login.php?redirect_to=http%3A%2F%2Flocalhost%2Fhamyarlearn%2Fwp-admin%2F&reauth=1\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:65:\"en-US,en;q=0.9,my-ZG;q=0.8,my;q=0.7,fa-IR;q=0.6,fa;q=0.5,es;q=0.4\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"SCRIPT_FILENAME\";s:39:\"C:/laragon/www/hamyarlearn/wp-login.php\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:18:\"REQUEST_TIME_FLOAT\";d:1604778960.883;s:12:\"REQUEST_TIME\";i:1604778960;}}", "notice", "2020-11-07 19:56:04", "2020-11-07 19:56:01", "96429968", "96499240", "http://localhost/hamyarlearn/wp-login.php", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("51", "0", "brute_force", "invalid-login::user-2", "a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:12:\"wp-login.php\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:261:\"<strong>خطا</strong>: رمز عبوری که برای نام کاربری <strong>hamyarlearn</strong> وارد شده درست نیست. <a href=\"http://localhost/hamyarlearn/my-account/lost-password/\">رمز عبورتان را گم کرده‌اید؟</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:11:\"hamyarlearn\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:24:{s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:9:\"HTTP_HOST\";s:9:\"localhost\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:14:\"CONTENT_LENGTH\";s:3:\"132\";s:18:\"HTTP_CACHE_CONTROL\";s:9:\"max-age=0\";s:11:\"HTTP_ORIGIN\";s:16:\"http://localhost\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:8:\"HTTP_DNT\";s:1:\"1\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.183 Safari/537.36\";s:11:\"HTTP_ACCEPT\";s:135:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9\";s:19:\"HTTP_SEC_FETCH_SITE\";s:11:\"same-origin\";s:19:\"HTTP_SEC_FETCH_MODE\";s:8:\"navigate\";s:19:\"HTTP_SEC_FETCH_USER\";s:2:\"?1\";s:19:\"HTTP_SEC_FETCH_DEST\";s:8:\"document\";s:12:\"HTTP_REFERER\";s:41:\"http://localhost/hamyarlearn/wp-login.php\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:65:\"en-US,en;q=0.9,my-ZG;q=0.8,my;q=0.7,fa-IR;q=0.6,fa;q=0.5,es;q=0.4\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"SCRIPT_FILENAME\";s:39:\"C:/laragon/www/hamyarlearn/wp-login.php\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:18:\"REQUEST_TIME_FLOAT\";d:1604778992.916;s:12:\"REQUEST_TIME\";i:1604778992;}}", "notice", "2020-11-07 19:56:35", "2020-11-07 19:56:33", "96432752", "96502024", "http://localhost/hamyarlearn/wp-login.php", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("52", "0", "brute_force", "invalid-login::user-2", "a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:12:\"wp-login.php\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:261:\"<strong>خطا</strong>: رمز عبوری که برای نام کاربری <strong>hamyarlearn</strong> وارد شده درست نیست. <a href=\"http://localhost/hamyarlearn/my-account/lost-password/\">رمز عبورتان را گم کرده‌اید؟</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:11:\"hamyarlearn\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:24:{s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:9:\"HTTP_HOST\";s:9:\"localhost\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:14:\"CONTENT_LENGTH\";s:3:\"138\";s:18:\"HTTP_CACHE_CONTROL\";s:9:\"max-age=0\";s:11:\"HTTP_ORIGIN\";s:16:\"http://localhost\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:8:\"HTTP_DNT\";s:1:\"1\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.183 Safari/537.36\";s:11:\"HTTP_ACCEPT\";s:135:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9\";s:19:\"HTTP_SEC_FETCH_SITE\";s:11:\"same-origin\";s:19:\"HTTP_SEC_FETCH_MODE\";s:8:\"navigate\";s:19:\"HTTP_SEC_FETCH_USER\";s:2:\"?1\";s:19:\"HTTP_SEC_FETCH_DEST\";s:8:\"document\";s:12:\"HTTP_REFERER\";s:41:\"http://localhost/hamyarlearn/wp-login.php\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:65:\"en-US,en;q=0.9,my-ZG;q=0.8,my;q=0.7,fa-IR;q=0.6,fa;q=0.5,es;q=0.4\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"SCRIPT_FILENAME\";s:39:\"C:/laragon/www/hamyarlearn/wp-login.php\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:18:\"REQUEST_TIME_FLOAT\";d:1604779023.484;s:12:\"REQUEST_TIME\";i:1604779023;}}", "notice", "2020-11-07 19:57:05", "2020-11-07 19:57:03", "96432752", "96502024", "http://localhost/hamyarlearn/wp-login.php", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("53", "0", "brute_force", "invalid-login::user-2", "a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:12:\"wp-login.php\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:261:\"<strong>خطا</strong>: رمز عبوری که برای نام کاربری <strong>hamyarlearn</strong> وارد شده درست نیست. <a href=\"http://localhost/hamyarlearn/my-account/lost-password/\">رمز عبورتان را گم کرده‌اید؟</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:11:\"hamyarlearn\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:24:{s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:9:\"HTTP_HOST\";s:9:\"localhost\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:14:\"CONTENT_LENGTH\";s:3:\"142\";s:18:\"HTTP_CACHE_CONTROL\";s:9:\"max-age=0\";s:11:\"HTTP_ORIGIN\";s:16:\"http://localhost\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:8:\"HTTP_DNT\";s:1:\"1\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.183 Safari/537.36\";s:11:\"HTTP_ACCEPT\";s:135:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9\";s:19:\"HTTP_SEC_FETCH_SITE\";s:11:\"same-origin\";s:19:\"HTTP_SEC_FETCH_MODE\";s:8:\"navigate\";s:19:\"HTTP_SEC_FETCH_USER\";s:2:\"?1\";s:19:\"HTTP_SEC_FETCH_DEST\";s:8:\"document\";s:12:\"HTTP_REFERER\";s:41:\"http://localhost/hamyarlearn/wp-login.php\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:65:\"en-US,en;q=0.9,my-ZG;q=0.8,my;q=0.7,fa-IR;q=0.6,fa;q=0.5,es;q=0.4\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"SCRIPT_FILENAME\";s:39:\"C:/laragon/www/hamyarlearn/wp-login.php\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:18:\"REQUEST_TIME_FLOAT\";d:1604779071.166;s:12:\"REQUEST_TIME\";i:1604779071;}}", "notice", "2020-11-07 19:57:53", "2020-11-07 19:57:51", "96722320", "96791592", "http://localhost/hamyarlearn/wp-login.php", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("54", "0", "brute_force", "invalid-login::user-2", "a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:12:\"wp-login.php\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:261:\"<strong>خطا</strong>: رمز عبوری که برای نام کاربری <strong>hamyarlearn</strong> وارد شده درست نیست. <a href=\"http://localhost/hamyarlearn/my-account/lost-password/\">رمز عبورتان را گم کرده‌اید؟</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:11:\"hamyarlearn\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:24:{s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:9:\"HTTP_HOST\";s:9:\"localhost\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:14:\"CONTENT_LENGTH\";s:3:\"142\";s:18:\"HTTP_CACHE_CONTROL\";s:9:\"max-age=0\";s:11:\"HTTP_ORIGIN\";s:16:\"http://localhost\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:8:\"HTTP_DNT\";s:1:\"1\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.183 Safari/537.36\";s:11:\"HTTP_ACCEPT\";s:135:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9\";s:19:\"HTTP_SEC_FETCH_SITE\";s:11:\"same-origin\";s:19:\"HTTP_SEC_FETCH_MODE\";s:8:\"navigate\";s:19:\"HTTP_SEC_FETCH_USER\";s:2:\"?1\";s:19:\"HTTP_SEC_FETCH_DEST\";s:8:\"document\";s:12:\"HTTP_REFERER\";s:41:\"http://localhost/hamyarlearn/wp-login.php\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:65:\"en-US,en;q=0.9,my-ZG;q=0.8,my;q=0.7,fa-IR;q=0.6,fa;q=0.5,es;q=0.4\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"SCRIPT_FILENAME\";s:39:\"C:/laragon/www/hamyarlearn/wp-login.php\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:18:\"REQUEST_TIME_FLOAT\";d:1604779086.458;s:12:\"REQUEST_TIME\";i:1604779086;}}", "notice", "2020-11-07 19:58:08", "2020-11-07 19:58:06", "96432256", "96501528", "http://localhost/hamyarlearn/wp-login.php", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("55", "0", "lockout", "whitelisted-host-triggered-host-lockout", "a:14:{s:6:\"module\";s:11:\"brute_force\";s:4:\"host\";s:3:\"::1\";s:7:\"user_id\";b:0;s:8:\"username\";b:0;s:14:\"module_details\";a:6:{s:4:\"type\";s:11:\"brute_force\";s:6:\"reason\";s:53:\"تعداد زیادی تلاش بد برای ورود\";s:5:\"label\";s:22:\"حملات Brute Force\";s:4:\"host\";i:5;s:4:\"user\";i:10;s:6:\"period\";i:5;}s:11:\"whitelisted\";b:1;s:11:\"blacklisted\";b:0;s:12:\"lockout_type\";s:11:\"brute_force\";s:13:\"lockout_start\";s:19:\"2020-11-07 23:28:06\";s:17:\"lockout_start_gmt\";s:19:\"2020-11-07 19:58:06\";s:15:\"lockout_context\";s:401:\"O:40:\"iThemesSecurity\\Lib\\Lockout\\Host_Context\":5:{s:46:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0host\";s:3:\"::1\";s:55:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0login_user_id\";i:2;s:56:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0login_username\";N;s:62:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0user_limit_triggered\";b:0;s:51:\"\0iThemesSecurity\\Lib\\Lockout\\Context\0lockout_module\";s:11:\"brute_force\";}\";s:14:\"lockout_expire\";s:19:\"1970-01-01 00:00:01\";s:18:\"lockout_expire_gmt\";s:19:\"1970-01-01 00:00:01\";s:12:\"lockout_host\";s:3:\"::1\";}", "notice", "2020-11-07 19:58:08", "2020-11-07 19:58:06", "96479040", "96505048", "http://localhost/hamyarlearn/wp-login.php", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("56", "0", "brute_force", "invalid-login::user-2", "a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:12:\"wp-login.php\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:261:\"<strong>خطا</strong>: رمز عبوری که برای نام کاربری <strong>hamyarlearn</strong> وارد شده درست نیست. <a href=\"http://localhost/hamyarlearn/my-account/lost-password/\">رمز عبورتان را گم کرده‌اید؟</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:11:\"hamyarlearn\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:24:{s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:9:\"HTTP_HOST\";s:9:\"localhost\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:14:\"CONTENT_LENGTH\";s:3:\"142\";s:18:\"HTTP_CACHE_CONTROL\";s:9:\"max-age=0\";s:11:\"HTTP_ORIGIN\";s:16:\"http://localhost\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:8:\"HTTP_DNT\";s:1:\"1\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.183 Safari/537.36\";s:11:\"HTTP_ACCEPT\";s:135:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9\";s:19:\"HTTP_SEC_FETCH_SITE\";s:11:\"same-origin\";s:19:\"HTTP_SEC_FETCH_MODE\";s:8:\"navigate\";s:19:\"HTTP_SEC_FETCH_USER\";s:2:\"?1\";s:19:\"HTTP_SEC_FETCH_DEST\";s:8:\"document\";s:12:\"HTTP_REFERER\";s:41:\"http://localhost/hamyarlearn/wp-login.php\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:65:\"en-US,en;q=0.9,my-ZG;q=0.8,my;q=0.7,fa-IR;q=0.6,fa;q=0.5,es;q=0.4\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"SCRIPT_FILENAME\";s:39:\"C:/laragon/www/hamyarlearn/wp-login.php\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:18:\"REQUEST_TIME_FLOAT\";d:1604779102.933;s:12:\"REQUEST_TIME\";i:1604779102;}}", "notice", "2020-11-07 19:58:25", "2020-11-07 19:58:23", "96723016", "96792288", "http://localhost/hamyarlearn/wp-login.php", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("57", "0", "lockout", "whitelisted-host-triggered-host-lockout", "a:14:{s:6:\"module\";s:11:\"brute_force\";s:4:\"host\";s:3:\"::1\";s:7:\"user_id\";b:0;s:8:\"username\";b:0;s:14:\"module_details\";a:6:{s:4:\"type\";s:11:\"brute_force\";s:6:\"reason\";s:53:\"تعداد زیادی تلاش بد برای ورود\";s:5:\"label\";s:22:\"حملات Brute Force\";s:4:\"host\";i:5;s:4:\"user\";i:10;s:6:\"period\";i:5;}s:11:\"whitelisted\";b:1;s:11:\"blacklisted\";b:0;s:12:\"lockout_type\";s:11:\"brute_force\";s:13:\"lockout_start\";s:19:\"2020-11-07 23:28:23\";s:17:\"lockout_start_gmt\";s:19:\"2020-11-07 19:58:23\";s:15:\"lockout_context\";s:401:\"O:40:\"iThemesSecurity\\Lib\\Lockout\\Host_Context\":5:{s:46:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0host\";s:3:\"::1\";s:55:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0login_user_id\";i:2;s:56:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0login_username\";N;s:62:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0user_limit_triggered\";b:0;s:51:\"\0iThemesSecurity\\Lib\\Lockout\\Context\0lockout_module\";s:11:\"brute_force\";}\";s:14:\"lockout_expire\";s:19:\"1970-01-01 00:00:01\";s:18:\"lockout_expire_gmt\";s:19:\"1970-01-01 00:00:01\";s:12:\"lockout_host\";s:3:\"::1\";}", "notice", "2020-11-07 19:58:25", "2020-11-07 19:58:23", "96769800", "96795808", "http://localhost/hamyarlearn/wp-login.php", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("58", "0", "brute_force", "invalid-login::user-2", "a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:12:\"wp-login.php\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:261:\"<strong>خطا</strong>: رمز عبوری که برای نام کاربری <strong>hamyarlearn</strong> وارد شده درست نیست. <a href=\"http://localhost/hamyarlearn/my-account/lost-password/\">رمز عبورتان را گم کرده‌اید؟</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:11:\"hamyarlearn\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:24:{s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:9:\"HTTP_HOST\";s:9:\"localhost\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:14:\"CONTENT_LENGTH\";s:3:\"138\";s:18:\"HTTP_CACHE_CONTROL\";s:9:\"max-age=0\";s:11:\"HTTP_ORIGIN\";s:16:\"http://localhost\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:8:\"HTTP_DNT\";s:1:\"1\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.183 Safari/537.36\";s:11:\"HTTP_ACCEPT\";s:135:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9\";s:19:\"HTTP_SEC_FETCH_SITE\";s:11:\"same-origin\";s:19:\"HTTP_SEC_FETCH_MODE\";s:8:\"navigate\";s:19:\"HTTP_SEC_FETCH_USER\";s:2:\"?1\";s:19:\"HTTP_SEC_FETCH_DEST\";s:8:\"document\";s:12:\"HTTP_REFERER\";s:41:\"http://localhost/hamyarlearn/wp-login.php\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:65:\"en-US,en;q=0.9,my-ZG;q=0.8,my;q=0.7,fa-IR;q=0.6,fa;q=0.5,es;q=0.4\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"SCRIPT_FILENAME\";s:39:\"C:/laragon/www/hamyarlearn/wp-login.php\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:18:\"REQUEST_TIME_FLOAT\";d:1604779120.567;s:12:\"REQUEST_TIME\";i:1604779120;}}", "notice", "2020-11-07 19:58:42", "2020-11-07 19:58:40", "96432240", "96501512", "http://localhost/hamyarlearn/wp-login.php", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("59", "0", "lockout", "whitelisted-host-triggered-host-lockout", "a:14:{s:6:\"module\";s:11:\"brute_force\";s:4:\"host\";s:3:\"::1\";s:7:\"user_id\";b:0;s:8:\"username\";b:0;s:14:\"module_details\";a:6:{s:4:\"type\";s:11:\"brute_force\";s:6:\"reason\";s:53:\"تعداد زیادی تلاش بد برای ورود\";s:5:\"label\";s:22:\"حملات Brute Force\";s:4:\"host\";i:5;s:4:\"user\";i:10;s:6:\"period\";i:5;}s:11:\"whitelisted\";b:1;s:11:\"blacklisted\";b:0;s:12:\"lockout_type\";s:11:\"brute_force\";s:13:\"lockout_start\";s:19:\"2020-11-07 23:28:40\";s:17:\"lockout_start_gmt\";s:19:\"2020-11-07 19:58:40\";s:15:\"lockout_context\";s:401:\"O:40:\"iThemesSecurity\\Lib\\Lockout\\Host_Context\":5:{s:46:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0host\";s:3:\"::1\";s:55:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0login_user_id\";i:2;s:56:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0login_username\";N;s:62:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0user_limit_triggered\";b:0;s:51:\"\0iThemesSecurity\\Lib\\Lockout\\Context\0lockout_module\";s:11:\"brute_force\";}\";s:14:\"lockout_expire\";s:19:\"1970-01-01 00:00:01\";s:18:\"lockout_expire_gmt\";s:19:\"1970-01-01 00:00:01\";s:12:\"lockout_host\";s:3:\"::1\";}", "notice", "2020-11-07 19:58:42", "2020-11-07 19:58:40", "96479024", "96505032", "http://localhost/hamyarlearn/wp-login.php", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("60", "0", "brute_force", "invalid-login::user-2", "a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:12:\"wp-login.php\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:261:\"<strong>خطا</strong>: رمز عبوری که برای نام کاربری <strong>hamyarlearn</strong> وارد شده درست نیست. <a href=\"http://localhost/hamyarlearn/my-account/lost-password/\">رمز عبورتان را گم کرده‌اید؟</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:11:\"hamyarlearn\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:24:{s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:9:\"HTTP_HOST\";s:9:\"localhost\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:14:\"CONTENT_LENGTH\";s:3:\"138\";s:18:\"HTTP_CACHE_CONTROL\";s:9:\"max-age=0\";s:11:\"HTTP_ORIGIN\";s:16:\"http://localhost\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:8:\"HTTP_DNT\";s:1:\"1\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.183 Safari/537.36\";s:11:\"HTTP_ACCEPT\";s:135:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9\";s:19:\"HTTP_SEC_FETCH_SITE\";s:11:\"same-origin\";s:19:\"HTTP_SEC_FETCH_MODE\";s:8:\"navigate\";s:19:\"HTTP_SEC_FETCH_USER\";s:2:\"?1\";s:19:\"HTTP_SEC_FETCH_DEST\";s:8:\"document\";s:12:\"HTTP_REFERER\";s:41:\"http://localhost/hamyarlearn/wp-login.php\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:65:\"en-US,en;q=0.9,my-ZG;q=0.8,my;q=0.7,fa-IR;q=0.6,fa;q=0.5,es;q=0.4\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"SCRIPT_FILENAME\";s:39:\"C:/laragon/www/hamyarlearn/wp-login.php\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:18:\"REQUEST_TIME_FLOAT\";d:1604779138.848;s:12:\"REQUEST_TIME\";i:1604779138;}}", "notice", "2020-11-07 19:59:01", "2020-11-07 19:58:59", "96723000", "96792272", "http://localhost/hamyarlearn/wp-login.php", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("61", "0", "lockout", "whitelisted-host-triggered-host-lockout", "a:14:{s:6:\"module\";s:11:\"brute_force\";s:4:\"host\";s:3:\"::1\";s:7:\"user_id\";b:0;s:8:\"username\";b:0;s:14:\"module_details\";a:6:{s:4:\"type\";s:11:\"brute_force\";s:6:\"reason\";s:53:\"تعداد زیادی تلاش بد برای ورود\";s:5:\"label\";s:22:\"حملات Brute Force\";s:4:\"host\";i:5;s:4:\"user\";i:10;s:6:\"period\";i:5;}s:11:\"whitelisted\";b:1;s:11:\"blacklisted\";b:0;s:12:\"lockout_type\";s:11:\"brute_force\";s:13:\"lockout_start\";s:19:\"2020-11-07 23:28:59\";s:17:\"lockout_start_gmt\";s:19:\"2020-11-07 19:58:59\";s:15:\"lockout_context\";s:401:\"O:40:\"iThemesSecurity\\Lib\\Lockout\\Host_Context\":5:{s:46:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0host\";s:3:\"::1\";s:55:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0login_user_id\";i:2;s:56:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0login_username\";N;s:62:\"\0iThemesSecurity\\Lib\\Lockout\\Host_Context\0user_limit_triggered\";b:0;s:51:\"\0iThemesSecurity\\Lib\\Lockout\\Context\0lockout_module\";s:11:\"brute_force\";}\";s:14:\"lockout_expire\";s:19:\"1970-01-01 00:00:01\";s:18:\"lockout_expire_gmt\";s:19:\"1970-01-01 00:00:01\";s:12:\"lockout_host\";s:3:\"::1\";}", "notice", "2020-11-07 19:59:01", "2020-11-07 19:58:59", "96769784", "96795792", "http://localhost/hamyarlearn/wp-login.php", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("62", "0", "notification_center", "send_scheduled", "a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}", "debug", "2020-11-10 13:10:46", "2020-11-10 13:10:39", "76755992", "77624888", "wp-cron", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("63", "0", "notification_center", "send::digest", "a:2:{s:10:\"recipients\";a:1:{i:0;s:22:\"shayanfp@shayanweb.com\";}s:7:\"subject\";s:58:\"[localhost/hamyarlearn] خلاصه امنیت روزانه\";}", "debug", "2020-11-10 13:10:47", "2020-11-10 13:10:39", "77217664", "77624888", "wp-cron", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("64", "0", "notification_center", "send_failed::digest", "a:1:{s:5:\"error\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:14:\"wp_mail_failed\";a:1:{i:0;s:45:\"Invalid address:  (From): wordpress@localhost\";}}s:10:\"error_data\";a:1:{s:14:\"wp_mail_failed\";a:6:{s:2:\"to\";a:1:{i:0;s:22:\"shayanfp@shayanweb.com\";}s:7:\"subject\";s:58:\"[localhost/hamyarlearn] خلاصه امنیت روزانه\";s:7:\"message\";s:61022:\"\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"fa-IR\">\n\n<head>\n	<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n	<title>خلاصه امنیت روزانه</title>\n	<meta name=\"viewport\" content=\"width=device-width\">\n\n	<style type=\"text/css\">\n		/* From: https://litmus.com/community/learning/13-foundations-email-coding-101 */\n\n		/* GENERAL STYLE RESETS */\n		body,#body-table,#body-cell{height:100%!important;width:100%!important;margin:0;padding:0;}\n		img,aimg{border:0;outline:none;text-decoration:none;}\n		.imageFix{display:block;}\n		table,td{border-collapse:collapse;border-spacing:0;}\n\n		/* CLIENT-SPECIFIC RESETS */\n		.ReadMsgBody{width:100%;}\n		.ExternalClass{width:100%;}\n		.ExternalClass,.ExternalClass p,.ExternalClass span,.ExternalClass font,.ExternalClass td,.ExternalClass div{line-height:100%;}\n		table,td{mso-table-lspace:0pt;mso-table-rspace:0pt;}\n		img{-ms-interpolation-mode:bicubic;}\n		body,table,td,p,a,li,blockquote{-ms-text-size-adjust:100%;-webkit-text-size-adjust:100%;}\n\n\n		h1,h2,h3,h4,h5,h6{color:#202020;font-family:Helvetica;font-size:20px;font-weight:bold;line-height:150%;margin:0;padding:0;text-align:center;}\n		p{font-family:Helvetica;font-size:16px;line-height:150%;margin-top:10px;margin-right:0;margin-bottom:10px;margin-left:0;padding:0;text-align:center;}\n		a{color:#0084CB;font-family:Helvetica;font-size:16px;line-height:150%;text-align:center;text-decoration:none;}\n		img{height:auto;}\n\n		body,#body-table{background-color:#FFFFFF;}\n		#body-cell{padding-bottom:20px;}\n		.section-padding{padding-top:20px;padding-right:20px;padding-left:20px;}\n		.section-padding-bottom{padding-bottom:20px;}\n		.container-cell{color:#808080;font-family:Helvetica;font-size:16px;line-height:150%;text-align:center;padding-bottom:20px;}\n		#top-banner{background-color:#FFCE08;}\n		#top-banner .container-cell{color:#413F39;font-size:13px;}\n		#top-logo .container-cell{padding-top:20px;}\n		#title-container h1{font-size:34px;}\n		.info-box{padding-top:20px;padding-bottom:20px;}\n		.info-box .container{border:1px solid #CDCECE;background-color:#F2F2F2;}\n		.info-box .section-padding{padding-top:40px;padding-right:40px;padding-left:40px;}\n		.info-box .container-cell{padding-bottom:40px;}\n		.info-box .info-icon{width:33px;height:23px;vertical-align:middle;}\n		.section-heading .container-cell{padding-bottom:0;}\n		.section-heading h4{color:#0084CB;font-size:16px;}\n		.section-heading h4 img{padding-top:2px;padding-right:5px;vertical-align:top;}\n		.lockouts-summary .container.left-column{margin-right:60px;}\n		.lockouts-summary h4{color:#ACAAAA;font-size:16px;font-weight:normal;}\n		.lockouts-summary p{color:#505050;font-size:30px;font-weight:bold;}\n		.table{border:1px solid #cdcece;color: #808080;font-family:Helvetica;font-size:14px;}\n		.table th,.table td{border:1px solid #cdcece;padding:10px;}\n		.table th{text-align:left;font-weight:bold;padding:5px 10px;}\n		.table .row-label{font-style:italic;}\n		.table a,.table b{font-size:14px;}\n		.large-text h4{color:#505050;margin-bottom:10px;}\n		.details-box-container{padding-top:20px;padding-bottom:20px;}\n		.details-box{background-color:#E4EEF7;border:1px solid #CDCECE;}\n		.details-box .container-cell{color:#6A6A6A;}\n		.divider .divider-border{border-top-width:1px;border-top-style:solid;border-top-color:#E8E8E8;}\n		.divider .container-cell{line-height:1px;padding-bottom:20px;width:450px;}\n		.module-button .border-radius{-webkit-border-radius:5px;-moz-border-radius:5px;border-radius:5px;}\n		.module-button a{background-color:#FFCD08;border:1px solid #FFCD08;color:#2E280E;display:inline-block;font-size:18px;font-weight:bold;line-height:100%;padding-top:20px;padding-right:30px;padding-bottom:20px;padding-left:30px;}\n		.pro-callout{padding-top:20px;}\n		.pro-callout-background{background-color:#0B1A23;}\n		.pro-callout .section-padding{padding-top:40px;}\n		.pro-callout .two-factor{color:#FFFFFF;margin-top:20px;margin-bottom:20px;}\n		.pro-callout .module-button a{font-size:30px;}\n		.pro-callout .why-pro{color:#999999;font-style:italic;margin-top:20px;margin-bottom:20px;}\n		.footer-heading h2{color:#002030;font-size:26px;}\n		.pro-flag{background-color:#FFCC00;color:#000000;font-size:10px;display:inline-block;padding:3px;line-height:1;position:relative;bottom:10px;text-transform:uppercase;}\n		#security-guide-container{border:1px solid #CDCECE;background-color:#D3E8E9;}\n		#security-guide .container-cell{color:#6C6C6C;text-align:left;}\n		#security-guide h4{color:#6C6C6C;font-size:18px;padding-bottom:10px;text-align:left;}\n		#security-guide a{font-weight:bold;}\n		#footer-source-details .container-cell{line-height:200%;padding-top:60px;padding-bottom:0;}\n		#footer-source-details a{font-size:11px;font-weight:bold;line-height:200%;}\n		.template-container {max-width: 600px !important;}\n\n		@media only screen and (max-width:600px){\n			body{width:100% !important;min-width:100% !important;}\n			#body-cell{padding:10px !important;}\n			#main-container, .container{width:100% !important;}\n			.preserve-ratio{height:auto !important;width:100% !important;}\n			.container-cell-bottom{padding-top:20px !important;}\n			.lockouts-summary .container{width:auto !important;}\n		}\n\n		@media only screen and (max-width:450px){\n			.divider .container-cell{width:auto !important;}\n		}\n	</style>\n</head>\n\n<body style=\"margin: 0;padding: 0;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;background-color: #FFFFFF;height: 100%!important;width: 100%!important;\">\n	<center>\n		<table id=\"body-table\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" height=\"100%\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;margin: 0;padding: 0;background-color: #FFFFFF;height: 100%!important;width: 100%!important;\">\n			<tr>\n				<td id=\"body-cell\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;margin: 0;padding: 0;padding-bottom: 20px;height: 100%!important;width: 100%!important;\">\n					<table id=\"main-container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n						<tr>\n							<td id=\"top-banner\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;background-color: #FFCE08;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n												<tr>\n													<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n														<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #413F39;font-family: Helvetica;font-size: 13px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n																	خلاصه امنیت روزانه شما برای <b>۲۰ آبان ۱۳۹۹</b>\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n						<tr>\n							<td id=\"top-logo\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n												<tr>\n													<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n														<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;padding-top: 20px;\">\n																	<img class=\"preserve-ratio\" src=\"http://localhost/hamyarlearn/wp-content/plugins/better-wp-security/core/img/mail/logo.png\" style=\"max-width: 300px;border: 0;outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;height: auto;\" alt=\"\" align=\"center\">\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n						<tr>\n							<td id=\"title-container\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n												<tr>\n													<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n														<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n																	<h1 style=\"color: #202020;font-family: Helvetica;font-size: 34px;font-weight: bold;line-height: 150%;margin: 0;padding: 0;text-align: center;\">خلاصه امنیت روزانه</h1>\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n						<tr>\n							<td class=\"info-box\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-bottom: 20px;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;border: 1px solid #CDCECE;background-color: #F2F2F2;\">\n												<tr>\n													<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 40px;padding-right: 40px;padding-left: 40px;\">\n														<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 40px;\">\n																	<img class=\"info-icon\" src=\"http://localhost/hamyarlearn/wp-content/plugins/better-wp-security/core/img/mail/info_icon.png\" alt=\"\" align=\"center\" width=\"33\" height=\"23\" style=\"border: 0;outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;height: 23px;width: 33px;vertical-align: middle;\">\n																	در زیر خلاصه ای از فعالیت مرتبط با امنیت در سایت شما است: <b>localhost/hamyarlearn</b>\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n						<tr>\n							<td class=\"section-heading\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n												<tr>\n													<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n														<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 0;\">\n																	<h4 style=\"color: #0084CB;font-family: Helvetica;font-size: 16px;font-weight: bold;line-height: 150%;margin: 0;padding: 0;text-align: center;\">\n																		<img src=\"http://localhost/hamyarlearn/wp-content/plugins/better-wp-security/core/img/mail/icon_lock.png\" alt=\"\" align=\"center\" style=\"border: 0;outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;height: auto;padding-top: 2px;padding-right: 5px;vertical-align: top;\">\n																		قفل کردن\n																	</h4>\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n						<tr>\n							<td class=\"lockouts-summary\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n												<tr>\n													<td class=\"section-padding\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n														<table class=\"container left-column\" align=\"left\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;margin-right: 60px;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n																	<h4 style=\"color: #ACAAAA;font-family: Helvetica;font-size: 16px;font-weight: normal;line-height: 150%;margin: 0;padding: 0;text-align: center;\">کاربران</h4>\n																	<p style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;font-family: Helvetica;font-size: 30px;line-height: 150%;margin-top: 10px;margin-right: 0;margin-bottom: 10px;margin-left: 0;padding: 0;text-align: center;color: #505050;font-weight: bold;\">0</p>\n																</td>\n															</tr>\n														</table>\n														<table class=\"container right-column\" align=\"right\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n																	<h4 style=\"color: #ACAAAA;font-family: Helvetica;font-size: 16px;font-weight: normal;line-height: 150%;margin: 0;padding: 0;text-align: center;\">هاست‌ها</h4>\n																	<p style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;font-family: Helvetica;font-size: 30px;line-height: 150%;margin-top: 10px;margin-right: 0;margin-bottom: 10px;margin-left: 0;padding: 0;text-align: center;color: #505050;font-weight: bold;\">5</p>\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n						<tr>\n							<td class=\"details-box-container\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-bottom: 20px;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"details-box container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;background-color: #E4EEF7;border: 1px solid #CDCECE;\">\n												<tr>\n													<td class=\"section-padding\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n														<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #6A6A6A;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n																	برای جزئیات بیشتر،  <a href=\"http://localhost/hamyarlearn/wp-admin/admin.php?page=itsec-logs\"><b> گزارشات امینیتی را ببینید</b></a>\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n						<tr>\n							<td class=\"divider\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"450\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n												<tr>\n													<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"450\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n														<table class=\"divider-border\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;border-top-width: 1px;border-top-style: solid;border-top-color: #E8E8E8;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 1px;text-align: center;padding-bottom: 20px;width: 450px;\">\n																	&nbsp;\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n						<tr>\n							<td class=\"large-text\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n												<tr>\n													<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n														<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n																	<h4 style=\"color: #505050;font-family: Helvetica;font-size: 20px;font-weight: bold;line-height: 150%;margin: 0;padding: 0;text-align: center;margin-bottom: 10px;\">آیا سایت شما به همان اندازه که می تواند امن است؟</h4>\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n						<tr>\n							<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n												<tr>\n													<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n														<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n																	اطمینان حاصل کنید که سایت شما با استفاده از بررسی امنیتی، از تنظیمات و ویژگی های توصیه شده استفاده می کند.\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n<tr>\n	<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n		<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n			<tr>\n				<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n					<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n						<tr>\n							<td class=\"section-padding section-padding-bottom\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;padding-bottom: 20px;\">\n								<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"module-button\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n												<tr>\n													<td class=\"border-radius\" align=\"center\" bgcolor=\"#FFCD08\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;-webkit-border-radius: 5px;-moz-border-radius: 5px;border-radius: 5px;\">\n														<a class=\"border-radius\" href=\"http://localhost/hamyarlearn/wp-admin/admin.php?page=itsec&module=security-check\" target=\"_blank\" style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #2E280E;font-family: Helvetica;font-size: 18px;line-height: 100%;text-align: center;text-decoration: none;background-color: #FFCD08;border: 1px solid #FFCD08;display: inline-block;font-weight: bold;padding-top: 20px;padding-right: 30px;padding-bottom: 20px;padding-left: 30px;-webkit-border-radius: 5px;-moz-border-radius: 5px;border-radius: 5px;\">بررسی امنیت ✓</a>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n					</table>\n				</td>\n			</tr>\n		</table>\n	</td>\n</tr>\n						<tr>\n							<td class=\"pro-callout\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;\">\n								<table class=\"pro-callout-background\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;background-color: #0B1A23;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" class=\"container\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n												<tr>\n													<td align=\"center\" valign=\"top\" width=\"600\" class=\"section-padding\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 40px;padding-right: 20px;padding-left: 20px;\">\n														<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n															<tr>\n																<td valign=\"top\" class=\"container-cell\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n																	<img class=\"preserve-ratio\" src=\"http://localhost/hamyarlearn/wp-content/plugins/better-wp-security/core/img/mail/pro_logo_no_text.png\" style=\"max-width: 100px;border: 0;outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;height: auto;\" width=\"100\" alt=\"\" align=\"center\">\n																	<p class=\"two-factor\" style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;font-family: Helvetica;font-size: 16px;line-height: 150%;margin-top: 20px;margin-right: 0;margin-bottom: 20px;margin-left: 0;padding: 0;text-align: center;color: #FFFFFF;\">Want two-factor authentication, scheduled site scanning, ticketed support and more?</p>\n																	<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n																		<tr>\n																			<td style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n																				<table class=\"module-button\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n																					<tr>\n																						<td class=\"border-radius\" align=\"center\" bgcolor=\"#FFCD08\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;-webkit-border-radius: 5px;-moz-border-radius: 5px;border-radius: 5px;\">\n																							<a href=\"https://ithemes.com/security/#plugin-pricing\" target=\"_blank\" class=\"border-radius\" style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #2E280E;font-family: Helvetica;font-size: 30px;line-height: 100%;text-align: center;text-decoration: none;background-color: #FFCD08;border: 1px solid #FFCD08;display: inline-block;font-weight: bold;padding-top: 20px;padding-right: 30px;padding-bottom: 20px;padding-left: 30px;-webkit-border-radius: 5px;-moz-border-radius: 5px;border-radius: 5px;\">گرفتن نسخه پولی افزونه</a>\n																						</td>\n																					</tr>\n																				</table>\n																			</td>\n																		</tr>\n																	</table>\n																	<p class=\"why-pro\" style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;font-family: Helvetica;font-size: 16px;line-height: 150%;margin-top: 20px;margin-right: 0;margin-bottom: 20px;margin-left: 0;padding: 0;text-align: center;color: #999999;font-style: italic;\">چرا به پولی مهاجرت کنیم؟<a href=\"https://ithemes.com/security/why-go-pro/\">بررسی نسخه رایگان و پولی.</a></p>\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n<tr>\n	<td class=\"footer-heading\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n		<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n			<tr>\n				<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n					<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n						<tr>\n							<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n											<h2 style=\"color: #002030;font-family: Helvetica;font-size: 26px;font-weight: bold;line-height: 150%;margin: 0;padding: 0;text-align: center;\">منابع امنیت</h2>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n					</table>\n				</td>\n			</tr>\n		</table>\n	</td>\n</tr>\n<tr>\n	<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n		<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n			<tr>\n				<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n					<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n						<tr>\n							<td class=\"section-padding\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n								<table class=\"container\" align=\"left\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"260\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n											<img class=\"preserve-ratio\" src=\"http://localhost/hamyarlearn/wp-content/plugins/better-wp-security/core/img/mail/article_icon.png\" style=\"max-width: 61px;border: 0;outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;height: auto;\" width=\"61\" alt=\"\" align=\"center\">\n											<br>\n											<h4 style=\"color: #202020;font-family: Helvetica;font-size: 20px;font-weight: bold;line-height: 150%;margin: 0;padding: 0;text-align: center;\">\n												<a href=\"https://ithemes.com/category/wordpress-security/\" target=\"_blank\" style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #0084CB;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;text-decoration: none;\">مقالات</a>\n											</h4>\n											<br>\n											<p style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;font-family: Helvetica;font-size: 16px;line-height: 150%;margin-top: 10px;margin-right: 0;margin-bottom: 10px;margin-left: 0;padding: 0;text-align: center;\">بخوانید آخرین اخبار امنیتی وردپرس،نکات و بروزرسانی‌ها در <a href=\"https://ithemes.com/category/wordpress-security/\">iThemes Blog</a>.</p>\n										</td>\n									</tr>\n								</table>\n								<table class=\"container\" align=\"right\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"260\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td class=\"container-cell container-cell-bottom\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n											<img class=\"preserve-ratio\" src=\"http://localhost/hamyarlearn/wp-content/plugins/better-wp-security/core/img/mail/video_icon.png\" style=\"max-width: 61px;border: 0;outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;height: auto;\" width=\"61\" alt=\"\" align=\"center\">\n											<br>\n											<h4 style=\"color: #202020;font-family: Helvetica;font-size: 20px;font-weight: bold;line-height: 150%;margin: 0;padding: 0;text-align: center;\">\n												<a href=\"https://ithemes.com/tutorial/category/ithemes-security/\" target=\"_blank\" style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #0084CB;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;text-decoration: none;\">آموزش‌ها</a>\n											</h4>\n											<br>\n											<p style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;font-family: Helvetica;font-size: 16px;line-height: 150%;margin-top: 10px;margin-right: 0;margin-bottom: 10px;margin-left: 0;padding: 0;text-align: center;\">استفاده از ویژگی های امنیتی iThemes با <a href=\"https://ithemes.com/tutorial/category/ithemes-security/\">آموزش رایگان iThemes Security</a>.</p>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n					</table>\n				</td>\n			</tr>\n		</table>\n	</td>\n</tr>\n<tr>\n	<td class=\"divider\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n		<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n			<tr>\n				<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n					<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"450\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n						<tr>\n							<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"450\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n								<table class=\"divider-border\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;border-top-width: 1px;border-top-style: solid;border-top-color: #E8E8E8;\">\n									<tr>\n										<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 1px;text-align: center;padding-bottom: 20px;width: 450px;\">\n											&nbsp;\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n					</table>\n				</td>\n			</tr>\n		</table>\n	</td>\n</tr>\n<tr>\n	<td class=\"footer-heading\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n		<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n			<tr>\n				<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n					<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n						<tr>\n							<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n											<h2 style=\"color: #002030;font-family: Helvetica;font-size: 26px;font-weight: bold;line-height: 150%;margin: 0;padding: 0;text-align: center;\">کمک و پشتیبانی</h2>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n					</table>\n				</td>\n			</tr>\n		</table>\n	</td>\n</tr>\n<tr>\n	<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n		<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n			<tr>\n				<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n					<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n						<tr>\n							<td class=\"section-padding\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n								<table class=\"container\" align=\"left\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"260\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n											<img class=\"preserve-ratio\" src=\"http://localhost/hamyarlearn/wp-content/plugins/better-wp-security/core/img/mail/documentation_icon.png\" style=\"max-width: 62px;border: 0;outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;height: auto;\" width=\"62\" alt=\"\" align=\"center\">\n											<br>\n											<h4 style=\"color: #202020;font-family: Helvetica;font-size: 20px;font-weight: bold;line-height: 150%;margin: 0;padding: 0;text-align: center;\">\n												<a href=\"http://ithemes.com/codex/page/IThemes_Security\" target=\"_blank\" style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #0084CB;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;text-decoration: none;\">مستندات</a>\n											</h4>\n											<br>\n											<p style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;font-family: Helvetica;font-size: 16px;line-height: 150%;margin-top: 10px;margin-right: 0;margin-bottom: 10px;margin-left: 0;padding: 0;text-align: center;\">بخوانید مستندات و سوالات و پاسخ های افزونه را در <a href=\"http://ithemes.com/codex/page/IThemes_Security\">the Codex</a>.</p>\n										</td>\n									</tr>\n								</table>\n								<table class=\"container\" align=\"right\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"260\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td class=\"container-cell container-cell-bottom\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n											<img class=\"preserve-ratio\" src=\"http://localhost/hamyarlearn/wp-content/plugins/better-wp-security/core/img/mail/support_icon.png\" style=\"max-width: 62px;border: 0;outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;height: auto;\" width=\"62\" alt=\"\" align=\"center\">\n											<br>\n											<h4 style=\"color: #202020;font-family: Helvetica;font-size: 20px;font-weight: bold;line-height: 150%;margin: 0;padding: 0;text-align: center;\">\n												<a href=\"https://members.ithemes.com/panel/helpdesk.php\" target=\"_blank\" style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #0084CB;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;text-decoration: none;\">پشتیبانی</a>\n												<span class=\"pro-flag\" style=\"background-color: #FFCC00;color: #000000;font-size: 10px;display: inline-block;padding: 3px;line-height: 1;position: relative;bottom: 10px;text-transform: uppercase;\">پیشرفته</span>\n											</h4>\n											<br>\n											<p style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;font-family: Helvetica;font-size: 16px;line-height: 150%;margin-top: 10px;margin-right: 0;margin-bottom: 10px;margin-left: 0;padding: 0;text-align: center;\">مشتریان نسخه پولی می توانند با بخش <a href=\"https://members.ithemes.com/panel/helpdesk.php\">iThemes Helpdesk</a> برای کمک تماس بگیرند.تیم پشتیبانی ما در روزهای دوشنبه - جمعه ساعت 8 صبح-5بعدظهر پاسخگو است.</p>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n					</table>\n				</td>\n			</tr>\n		</table>\n	</td>\n</tr>\n<tr>\n	<td id=\"security-guide\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n		<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n			<tr>\n				<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n					<table id=\"security-guide-container\" class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;border: 1px solid #CDCECE;background-color: #D3E8E9;\">\n						<tr>\n							<td class=\"section-padding\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n								<table class=\"container\" align=\"left\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"104\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td class=\"section-padding-bottom\" align=\"left\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-bottom: 20px;\">\n											<img class=\"preserve-ratio\" src=\"http://localhost/hamyarlearn/wp-content/plugins/better-wp-security/core/img/mail/wp_security_book.png\" style=\"max-width: 84px;border: 0;outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;height: auto;\" width=\"84\" alt=\"\" align=\"center\">\n										</td>\n									</tr>\n								</table>\n								<table class=\"container\" align=\"right\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"454\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #6C6C6C;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: left;padding-bottom: 20px;\">\n											<h4 style=\"color: #6C6C6C;font-family: Helvetica;font-size: 18px;font-weight: bold;line-height: 150%;margin: 0;padding: 0;text-align: left;padding-bottom: 10px;\">راهنمای رایگان امنیت وردپرس</h4>\n											یادگیری نکات ابتدایی امنیتی وردپرس - شامل سه نوع امنیت برای سایت شما و 4 تمرین عالی برای اینکه سایت شما را امن نگاه دارد مشاهده کنید بخش <a href=\"https://ithemes.com/publishing/wordpress-security/\">free guide</a>.\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n					</table>\n				</td>\n			</tr>\n		</table>\n	</td>\n</tr>\n<tr>\n	<td id=\"footer-source-details\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n		<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n			<tr>\n				<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n					<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n						<tr>\n							<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 200%;text-align: center;padding-bottom: 0;padding-top: 60px;\">\n											<img class=\"preserve-ratio\" src=\"http://localhost/hamyarlearn/wp-content/plugins/better-wp-security/core/img/mail/footer_logo.png\" style=\"max-width: 50px;border: 0;outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;height: auto;\" width=\"50\" alt=\"\" align=\"center\"><br>\n											<br>\n											<span style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #666f72;font-family: Helvetica;font-size: 11px;line-height: 200%;text-align: center;text-decoration: none;font-weight: bold;\">\n												این ایمیل توسط افزونه iThemes Security ایجاد شده است.<br>برای لغو اشتراک از این بروزرسانی ها،مشاهده کنید <a href=\"http://localhost/hamyarlearn/wp-admin/admin.php?page=itsec\" style=\"color: #0084CB\">برگه تنظیمات</a> در فهرست افزونه امنیتی.\n											</span>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n					</table>\n				</td>\n			</tr>\n		</table>\n	</td>\n</tr>					</table>\n				</td>\n			</tr>\n		</table>\n	</center>\n</body>\n\n</html>\n\";s:7:\"headers\";a:0:{}s:11:\"attachments\";a:0:{}s:24:\"phpmailer_exception_code\";i:0;}}}}", "error", "2020-11-10 13:10:47", "2020-11-10 13:10:39", "77889296", "78271192", "wp-cron", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("65", "0", "notification_center", "send_scheduled", "a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}", "debug", "2020-12-01 16:33:25", "2020-12-01 16:33:18", "76650128", "77649776", "wp-cron", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("66", "0", "notification_center", "send::digest", "a:2:{s:10:\"recipients\";a:1:{i:0;s:22:\"shayanfp@shayanweb.com\";}s:7:\"subject\";s:58:\"[localhost/hamyarlearn] خلاصه امنیت روزانه\";}", "debug", "2020-12-01 16:33:26", "2020-12-01 16:33:18", "77112512", "77649776", "wp-cron", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("67", "0", "notification_center", "send_failed::digest", "a:1:{s:5:\"error\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:14:\"wp_mail_failed\";a:1:{i:0;s:45:\"Invalid address:  (From): wordpress@localhost\";}}s:10:\"error_data\";a:1:{s:14:\"wp_mail_failed\";a:6:{s:2:\"to\";a:1:{i:0;s:22:\"shayanfp@shayanweb.com\";}s:7:\"subject\";s:58:\"[localhost/hamyarlearn] خلاصه امنیت روزانه\";s:7:\"message\";s:61020:\"\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"fa-IR\">\n\n<head>\n	<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n	<title>خلاصه امنیت روزانه</title>\n	<meta name=\"viewport\" content=\"width=device-width\">\n\n	<style type=\"text/css\">\n		/* From: https://litmus.com/community/learning/13-foundations-email-coding-101 */\n\n		/* GENERAL STYLE RESETS */\n		body,#body-table,#body-cell{height:100%!important;width:100%!important;margin:0;padding:0;}\n		img,aimg{border:0;outline:none;text-decoration:none;}\n		.imageFix{display:block;}\n		table,td{border-collapse:collapse;border-spacing:0;}\n\n		/* CLIENT-SPECIFIC RESETS */\n		.ReadMsgBody{width:100%;}\n		.ExternalClass{width:100%;}\n		.ExternalClass,.ExternalClass p,.ExternalClass span,.ExternalClass font,.ExternalClass td,.ExternalClass div{line-height:100%;}\n		table,td{mso-table-lspace:0pt;mso-table-rspace:0pt;}\n		img{-ms-interpolation-mode:bicubic;}\n		body,table,td,p,a,li,blockquote{-ms-text-size-adjust:100%;-webkit-text-size-adjust:100%;}\n\n\n		h1,h2,h3,h4,h5,h6{color:#202020;font-family:Helvetica;font-size:20px;font-weight:bold;line-height:150%;margin:0;padding:0;text-align:center;}\n		p{font-family:Helvetica;font-size:16px;line-height:150%;margin-top:10px;margin-right:0;margin-bottom:10px;margin-left:0;padding:0;text-align:center;}\n		a{color:#0084CB;font-family:Helvetica;font-size:16px;line-height:150%;text-align:center;text-decoration:none;}\n		img{height:auto;}\n\n		body,#body-table{background-color:#FFFFFF;}\n		#body-cell{padding-bottom:20px;}\n		.section-padding{padding-top:20px;padding-right:20px;padding-left:20px;}\n		.section-padding-bottom{padding-bottom:20px;}\n		.container-cell{color:#808080;font-family:Helvetica;font-size:16px;line-height:150%;text-align:center;padding-bottom:20px;}\n		#top-banner{background-color:#FFCE08;}\n		#top-banner .container-cell{color:#413F39;font-size:13px;}\n		#top-logo .container-cell{padding-top:20px;}\n		#title-container h1{font-size:34px;}\n		.info-box{padding-top:20px;padding-bottom:20px;}\n		.info-box .container{border:1px solid #CDCECE;background-color:#F2F2F2;}\n		.info-box .section-padding{padding-top:40px;padding-right:40px;padding-left:40px;}\n		.info-box .container-cell{padding-bottom:40px;}\n		.info-box .info-icon{width:33px;height:23px;vertical-align:middle;}\n		.section-heading .container-cell{padding-bottom:0;}\n		.section-heading h4{color:#0084CB;font-size:16px;}\n		.section-heading h4 img{padding-top:2px;padding-right:5px;vertical-align:top;}\n		.lockouts-summary .container.left-column{margin-right:60px;}\n		.lockouts-summary h4{color:#ACAAAA;font-size:16px;font-weight:normal;}\n		.lockouts-summary p{color:#505050;font-size:30px;font-weight:bold;}\n		.table{border:1px solid #cdcece;color: #808080;font-family:Helvetica;font-size:14px;}\n		.table th,.table td{border:1px solid #cdcece;padding:10px;}\n		.table th{text-align:left;font-weight:bold;padding:5px 10px;}\n		.table .row-label{font-style:italic;}\n		.table a,.table b{font-size:14px;}\n		.large-text h4{color:#505050;margin-bottom:10px;}\n		.details-box-container{padding-top:20px;padding-bottom:20px;}\n		.details-box{background-color:#E4EEF7;border:1px solid #CDCECE;}\n		.details-box .container-cell{color:#6A6A6A;}\n		.divider .divider-border{border-top-width:1px;border-top-style:solid;border-top-color:#E8E8E8;}\n		.divider .container-cell{line-height:1px;padding-bottom:20px;width:450px;}\n		.module-button .border-radius{-webkit-border-radius:5px;-moz-border-radius:5px;border-radius:5px;}\n		.module-button a{background-color:#FFCD08;border:1px solid #FFCD08;color:#2E280E;display:inline-block;font-size:18px;font-weight:bold;line-height:100%;padding-top:20px;padding-right:30px;padding-bottom:20px;padding-left:30px;}\n		.pro-callout{padding-top:20px;}\n		.pro-callout-background{background-color:#0B1A23;}\n		.pro-callout .section-padding{padding-top:40px;}\n		.pro-callout .two-factor{color:#FFFFFF;margin-top:20px;margin-bottom:20px;}\n		.pro-callout .module-button a{font-size:30px;}\n		.pro-callout .why-pro{color:#999999;font-style:italic;margin-top:20px;margin-bottom:20px;}\n		.footer-heading h2{color:#002030;font-size:26px;}\n		.pro-flag{background-color:#FFCC00;color:#000000;font-size:10px;display:inline-block;padding:3px;line-height:1;position:relative;bottom:10px;text-transform:uppercase;}\n		#security-guide-container{border:1px solid #CDCECE;background-color:#D3E8E9;}\n		#security-guide .container-cell{color:#6C6C6C;text-align:left;}\n		#security-guide h4{color:#6C6C6C;font-size:18px;padding-bottom:10px;text-align:left;}\n		#security-guide a{font-weight:bold;}\n		#footer-source-details .container-cell{line-height:200%;padding-top:60px;padding-bottom:0;}\n		#footer-source-details a{font-size:11px;font-weight:bold;line-height:200%;}\n		.template-container {max-width: 600px !important;}\n\n		@media only screen and (max-width:600px){\n			body{width:100% !important;min-width:100% !important;}\n			#body-cell{padding:10px !important;}\n			#main-container, .container{width:100% !important;}\n			.preserve-ratio{height:auto !important;width:100% !important;}\n			.container-cell-bottom{padding-top:20px !important;}\n			.lockouts-summary .container{width:auto !important;}\n		}\n\n		@media only screen and (max-width:450px){\n			.divider .container-cell{width:auto !important;}\n		}\n	</style>\n</head>\n\n<body style=\"margin: 0;padding: 0;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;background-color: #FFFFFF;height: 100%!important;width: 100%!important;\">\n	<center>\n		<table id=\"body-table\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" height=\"100%\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;margin: 0;padding: 0;background-color: #FFFFFF;height: 100%!important;width: 100%!important;\">\n			<tr>\n				<td id=\"body-cell\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;margin: 0;padding: 0;padding-bottom: 20px;height: 100%!important;width: 100%!important;\">\n					<table id=\"main-container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n						<tr>\n							<td id=\"top-banner\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;background-color: #FFCE08;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n												<tr>\n													<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n														<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #413F39;font-family: Helvetica;font-size: 13px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n																	خلاصه امنیت روزانه شما برای <b>۱۱ آذر ۱۳۹۹</b>\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n						<tr>\n							<td id=\"top-logo\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n												<tr>\n													<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n														<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;padding-top: 20px;\">\n																	<img class=\"preserve-ratio\" src=\"http://localhost/hamyarlearn/wp-content/plugins/better-wp-security/core/img/mail/logo.png\" style=\"max-width: 300px;border: 0;outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;height: auto;\" alt=\"\" align=\"center\">\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n						<tr>\n							<td id=\"title-container\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n												<tr>\n													<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n														<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n																	<h1 style=\"color: #202020;font-family: Helvetica;font-size: 34px;font-weight: bold;line-height: 150%;margin: 0;padding: 0;text-align: center;\">خلاصه امنیت روزانه</h1>\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n						<tr>\n							<td class=\"info-box\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-bottom: 20px;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;border: 1px solid #CDCECE;background-color: #F2F2F2;\">\n												<tr>\n													<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 40px;padding-right: 40px;padding-left: 40px;\">\n														<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 40px;\">\n																	<img class=\"info-icon\" src=\"http://localhost/hamyarlearn/wp-content/plugins/better-wp-security/core/img/mail/info_icon.png\" alt=\"\" align=\"center\" width=\"33\" height=\"23\" style=\"border: 0;outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;height: 23px;width: 33px;vertical-align: middle;\">\n																	در زیر خلاصه ای از فعالیت مرتبط با امنیت در سایت شما است: <b>localhost/hamyarlearn</b>\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n						<tr>\n							<td class=\"section-heading\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n												<tr>\n													<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n														<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 0;\">\n																	<h4 style=\"color: #0084CB;font-family: Helvetica;font-size: 16px;font-weight: bold;line-height: 150%;margin: 0;padding: 0;text-align: center;\">\n																		<img src=\"http://localhost/hamyarlearn/wp-content/plugins/better-wp-security/core/img/mail/icon_lock.png\" alt=\"\" align=\"center\" style=\"border: 0;outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;height: auto;padding-top: 2px;padding-right: 5px;vertical-align: top;\">\n																		قفل کردن\n																	</h4>\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n						<tr>\n							<td class=\"lockouts-summary\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n												<tr>\n													<td class=\"section-padding\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n														<table class=\"container left-column\" align=\"left\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;margin-right: 60px;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n																	<h4 style=\"color: #ACAAAA;font-family: Helvetica;font-size: 16px;font-weight: normal;line-height: 150%;margin: 0;padding: 0;text-align: center;\">کاربران</h4>\n																	<p style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;font-family: Helvetica;font-size: 30px;line-height: 150%;margin-top: 10px;margin-right: 0;margin-bottom: 10px;margin-left: 0;padding: 0;text-align: center;color: #505050;font-weight: bold;\">0</p>\n																</td>\n															</tr>\n														</table>\n														<table class=\"container right-column\" align=\"right\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n																	<h4 style=\"color: #ACAAAA;font-family: Helvetica;font-size: 16px;font-weight: normal;line-height: 150%;margin: 0;padding: 0;text-align: center;\">هاست‌ها</h4>\n																	<p style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;font-family: Helvetica;font-size: 30px;line-height: 150%;margin-top: 10px;margin-right: 0;margin-bottom: 10px;margin-left: 0;padding: 0;text-align: center;color: #505050;font-weight: bold;\">5</p>\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n						<tr>\n							<td class=\"details-box-container\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-bottom: 20px;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"details-box container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;background-color: #E4EEF7;border: 1px solid #CDCECE;\">\n												<tr>\n													<td class=\"section-padding\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n														<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #6A6A6A;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n																	برای جزئیات بیشتر،  <a href=\"http://localhost/hamyarlearn/wp-admin/admin.php?page=itsec-logs\"><b> گزارشات امینیتی را ببینید</b></a>\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n						<tr>\n							<td class=\"divider\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"450\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n												<tr>\n													<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"450\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n														<table class=\"divider-border\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;border-top-width: 1px;border-top-style: solid;border-top-color: #E8E8E8;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 1px;text-align: center;padding-bottom: 20px;width: 450px;\">\n																	&nbsp;\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n						<tr>\n							<td class=\"large-text\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n												<tr>\n													<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n														<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n																	<h4 style=\"color: #505050;font-family: Helvetica;font-size: 20px;font-weight: bold;line-height: 150%;margin: 0;padding: 0;text-align: center;margin-bottom: 10px;\">آیا سایت شما به همان اندازه که می تواند امن است؟</h4>\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n						<tr>\n							<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n												<tr>\n													<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n														<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n															<tr>\n																<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n																	اطمینان حاصل کنید که سایت شما با استفاده از بررسی امنیتی، از تنظیمات و ویژگی های توصیه شده استفاده می کند.\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n<tr>\n	<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n		<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n			<tr>\n				<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n					<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n						<tr>\n							<td class=\"section-padding section-padding-bottom\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;padding-bottom: 20px;\">\n								<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table class=\"module-button\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n												<tr>\n													<td class=\"border-radius\" align=\"center\" bgcolor=\"#FFCD08\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;-webkit-border-radius: 5px;-moz-border-radius: 5px;border-radius: 5px;\">\n														<a class=\"border-radius\" href=\"http://localhost/hamyarlearn/wp-admin/admin.php?page=itsec&module=security-check\" target=\"_blank\" style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #2E280E;font-family: Helvetica;font-size: 18px;line-height: 100%;text-align: center;text-decoration: none;background-color: #FFCD08;border: 1px solid #FFCD08;display: inline-block;font-weight: bold;padding-top: 20px;padding-right: 30px;padding-bottom: 20px;padding-left: 30px;-webkit-border-radius: 5px;-moz-border-radius: 5px;border-radius: 5px;\">بررسی امنیت ✓</a>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n					</table>\n				</td>\n			</tr>\n		</table>\n	</td>\n</tr>\n						<tr>\n							<td class=\"pro-callout\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;\">\n								<table class=\"pro-callout-background\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;background-color: #0B1A23;\">\n									<tr>\n										<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n											<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" class=\"container\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n												<tr>\n													<td align=\"center\" valign=\"top\" width=\"600\" class=\"section-padding\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 40px;padding-right: 20px;padding-left: 20px;\">\n														<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n															<tr>\n																<td valign=\"top\" class=\"container-cell\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n																	<img class=\"preserve-ratio\" src=\"http://localhost/hamyarlearn/wp-content/plugins/better-wp-security/core/img/mail/pro_logo_no_text.png\" style=\"max-width: 100px;border: 0;outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;height: auto;\" width=\"100\" alt=\"\" align=\"center\">\n																	<p class=\"two-factor\" style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;font-family: Helvetica;font-size: 16px;line-height: 150%;margin-top: 20px;margin-right: 0;margin-bottom: 20px;margin-left: 0;padding: 0;text-align: center;color: #FFFFFF;\">Want two-factor authentication, scheduled site scanning, ticketed support and more?</p>\n																	<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n																		<tr>\n																			<td style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n																				<table class=\"module-button\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n																					<tr>\n																						<td class=\"border-radius\" align=\"center\" bgcolor=\"#FFCD08\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;-webkit-border-radius: 5px;-moz-border-radius: 5px;border-radius: 5px;\">\n																							<a href=\"https://ithemes.com/security/#plugin-pricing\" target=\"_blank\" class=\"border-radius\" style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #2E280E;font-family: Helvetica;font-size: 30px;line-height: 100%;text-align: center;text-decoration: none;background-color: #FFCD08;border: 1px solid #FFCD08;display: inline-block;font-weight: bold;padding-top: 20px;padding-right: 30px;padding-bottom: 20px;padding-left: 30px;-webkit-border-radius: 5px;-moz-border-radius: 5px;border-radius: 5px;\">گرفتن نسخه پولی افزونه</a>\n																						</td>\n																					</tr>\n																				</table>\n																			</td>\n																		</tr>\n																	</table>\n																	<p class=\"why-pro\" style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;font-family: Helvetica;font-size: 16px;line-height: 150%;margin-top: 20px;margin-right: 0;margin-bottom: 20px;margin-left: 0;padding: 0;text-align: center;color: #999999;font-style: italic;\">چرا به پولی مهاجرت کنیم؟<a href=\"https://ithemes.com/security/why-go-pro/\">بررسی نسخه رایگان و پولی.</a></p>\n																</td>\n															</tr>\n														</table>\n													</td>\n												</tr>\n											</table>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n<tr>\n	<td class=\"footer-heading\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n		<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n			<tr>\n				<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n					<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n						<tr>\n							<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n											<h2 style=\"color: #002030;font-family: Helvetica;font-size: 26px;font-weight: bold;line-height: 150%;margin: 0;padding: 0;text-align: center;\">منابع امنیت</h2>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n					</table>\n				</td>\n			</tr>\n		</table>\n	</td>\n</tr>\n<tr>\n	<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n		<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n			<tr>\n				<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n					<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n						<tr>\n							<td class=\"section-padding\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n								<table class=\"container\" align=\"left\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"260\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n											<img class=\"preserve-ratio\" src=\"http://localhost/hamyarlearn/wp-content/plugins/better-wp-security/core/img/mail/article_icon.png\" style=\"max-width: 61px;border: 0;outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;height: auto;\" width=\"61\" alt=\"\" align=\"center\">\n											<br>\n											<h4 style=\"color: #202020;font-family: Helvetica;font-size: 20px;font-weight: bold;line-height: 150%;margin: 0;padding: 0;text-align: center;\">\n												<a href=\"https://ithemes.com/category/wordpress-security/\" target=\"_blank\" style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #0084CB;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;text-decoration: none;\">مقالات</a>\n											</h4>\n											<br>\n											<p style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;font-family: Helvetica;font-size: 16px;line-height: 150%;margin-top: 10px;margin-right: 0;margin-bottom: 10px;margin-left: 0;padding: 0;text-align: center;\">بخوانید آخرین اخبار امنیتی وردپرس،نکات و بروزرسانی‌ها در <a href=\"https://ithemes.com/category/wordpress-security/\">iThemes Blog</a>.</p>\n										</td>\n									</tr>\n								</table>\n								<table class=\"container\" align=\"right\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"260\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td class=\"container-cell container-cell-bottom\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n											<img class=\"preserve-ratio\" src=\"http://localhost/hamyarlearn/wp-content/plugins/better-wp-security/core/img/mail/video_icon.png\" style=\"max-width: 61px;border: 0;outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;height: auto;\" width=\"61\" alt=\"\" align=\"center\">\n											<br>\n											<h4 style=\"color: #202020;font-family: Helvetica;font-size: 20px;font-weight: bold;line-height: 150%;margin: 0;padding: 0;text-align: center;\">\n												<a href=\"https://ithemes.com/tutorial/category/ithemes-security/\" target=\"_blank\" style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #0084CB;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;text-decoration: none;\">آموزش‌ها</a>\n											</h4>\n											<br>\n											<p style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;font-family: Helvetica;font-size: 16px;line-height: 150%;margin-top: 10px;margin-right: 0;margin-bottom: 10px;margin-left: 0;padding: 0;text-align: center;\">استفاده از ویژگی های امنیتی iThemes با <a href=\"https://ithemes.com/tutorial/category/ithemes-security/\">آموزش رایگان iThemes Security</a>.</p>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n					</table>\n				</td>\n			</tr>\n		</table>\n	</td>\n</tr>\n<tr>\n	<td class=\"divider\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n		<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n			<tr>\n				<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n					<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"450\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n						<tr>\n							<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"450\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n								<table class=\"divider-border\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;border-top-width: 1px;border-top-style: solid;border-top-color: #E8E8E8;\">\n									<tr>\n										<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 1px;text-align: center;padding-bottom: 20px;width: 450px;\">\n											&nbsp;\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n					</table>\n				</td>\n			</tr>\n		</table>\n	</td>\n</tr>\n<tr>\n	<td class=\"footer-heading\" align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n		<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n			<tr>\n				<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n					<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n						<tr>\n							<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n											<h2 style=\"color: #002030;font-family: Helvetica;font-size: 26px;font-weight: bold;line-height: 150%;margin: 0;padding: 0;text-align: center;\">کمک و پشتیبانی</h2>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n					</table>\n				</td>\n			</tr>\n		</table>\n	</td>\n</tr>\n<tr>\n	<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n		<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n			<tr>\n				<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n					<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n						<tr>\n							<td class=\"section-padding\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n								<table class=\"container\" align=\"left\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"260\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n											<img class=\"preserve-ratio\" src=\"http://localhost/hamyarlearn/wp-content/plugins/better-wp-security/core/img/mail/documentation_icon.png\" style=\"max-width: 62px;border: 0;outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;height: auto;\" width=\"62\" alt=\"\" align=\"center\">\n											<br>\n											<h4 style=\"color: #202020;font-family: Helvetica;font-size: 20px;font-weight: bold;line-height: 150%;margin: 0;padding: 0;text-align: center;\">\n												<a href=\"http://ithemes.com/codex/page/IThemes_Security\" target=\"_blank\" style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #0084CB;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;text-decoration: none;\">مستندات</a>\n											</h4>\n											<br>\n											<p style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;font-family: Helvetica;font-size: 16px;line-height: 150%;margin-top: 10px;margin-right: 0;margin-bottom: 10px;margin-left: 0;padding: 0;text-align: center;\">بخوانید مستندات و سوالات و پاسخ های افزونه را در <a href=\"http://ithemes.com/codex/page/IThemes_Security\">the Codex</a>.</p>\n										</td>\n									</tr>\n								</table>\n								<table class=\"container\" align=\"right\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"260\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td class=\"container-cell container-cell-bottom\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;padding-bottom: 20px;\">\n											<img class=\"preserve-ratio\" src=\"http://localhost/hamyarlearn/wp-content/plugins/better-wp-security/core/img/mail/support_icon.png\" style=\"max-width: 62px;border: 0;outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;height: auto;\" width=\"62\" alt=\"\" align=\"center\">\n											<br>\n											<h4 style=\"color: #202020;font-family: Helvetica;font-size: 20px;font-weight: bold;line-height: 150%;margin: 0;padding: 0;text-align: center;\">\n												<a href=\"https://members.ithemes.com/panel/helpdesk.php\" target=\"_blank\" style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #0084CB;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: center;text-decoration: none;\">پشتیبانی</a>\n												<span class=\"pro-flag\" style=\"background-color: #FFCC00;color: #000000;font-size: 10px;display: inline-block;padding: 3px;line-height: 1;position: relative;bottom: 10px;text-transform: uppercase;\">پیشرفته</span>\n											</h4>\n											<br>\n											<p style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;font-family: Helvetica;font-size: 16px;line-height: 150%;margin-top: 10px;margin-right: 0;margin-bottom: 10px;margin-left: 0;padding: 0;text-align: center;\">مشتریان نسخه پولی می توانند با بخش <a href=\"https://members.ithemes.com/panel/helpdesk.php\">iThemes Helpdesk</a> برای کمک تماس بگیرند.تیم پشتیبانی ما در روزهای دوشنبه - جمعه ساعت 8 صبح-5بعدظهر پاسخگو است.</p>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n					</table>\n				</td>\n			</tr>\n		</table>\n	</td>\n</tr>\n<tr>\n	<td id=\"security-guide\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n		<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n			<tr>\n				<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n					<table id=\"security-guide-container\" class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;border: 1px solid #CDCECE;background-color: #D3E8E9;\">\n						<tr>\n							<td class=\"section-padding\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n								<table class=\"container\" align=\"left\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"104\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td class=\"section-padding-bottom\" align=\"left\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-bottom: 20px;\">\n											<img class=\"preserve-ratio\" src=\"http://localhost/hamyarlearn/wp-content/plugins/better-wp-security/core/img/mail/wp_security_book.png\" style=\"max-width: 84px;border: 0;outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;height: auto;\" width=\"84\" alt=\"\" align=\"center\">\n										</td>\n									</tr>\n								</table>\n								<table class=\"container\" align=\"right\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"454\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #6C6C6C;font-family: Helvetica;font-size: 16px;line-height: 150%;text-align: left;padding-bottom: 20px;\">\n											<h4 style=\"color: #6C6C6C;font-family: Helvetica;font-size: 18px;font-weight: bold;line-height: 150%;margin: 0;padding: 0;text-align: left;padding-bottom: 10px;\">راهنمای رایگان امنیت وردپرس</h4>\n											یادگیری نکات ابتدایی امنیتی وردپرس - شامل سه نوع امنیت برای سایت شما و 4 تمرین عالی برای اینکه سایت شما را امن نگاه دارد مشاهده کنید بخش <a href=\"https://ithemes.com/publishing/wordpress-security/\">free guide</a>.\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n					</table>\n				</td>\n			</tr>\n		</table>\n	</td>\n</tr>\n<tr>\n	<td id=\"footer-source-details\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n		<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n			<tr>\n				<td align=\"center\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n					<table class=\"container\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n						<tr>\n							<td class=\"section-padding\" align=\"center\" valign=\"top\" width=\"600\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;padding-top: 20px;padding-right: 20px;padding-left: 20px;\">\n								<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;\">\n									<tr>\n										<td class=\"container-cell\" valign=\"top\" style=\"border-collapse: collapse;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #808080;font-family: Helvetica;font-size: 16px;line-height: 200%;text-align: center;padding-bottom: 0;padding-top: 60px;\">\n											<img class=\"preserve-ratio\" src=\"http://localhost/hamyarlearn/wp-content/plugins/better-wp-security/core/img/mail/footer_logo.png\" style=\"max-width: 50px;border: 0;outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;height: auto;\" width=\"50\" alt=\"\" align=\"center\"><br>\n											<br>\n											<span style=\"-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%;color: #666f72;font-family: Helvetica;font-size: 11px;line-height: 200%;text-align: center;text-decoration: none;font-weight: bold;\">\n												این ایمیل توسط افزونه iThemes Security ایجاد شده است.<br>برای لغو اشتراک از این بروزرسانی ها،مشاهده کنید <a href=\"http://localhost/hamyarlearn/wp-admin/admin.php?page=itsec\" style=\"color: #0084CB\">برگه تنظیمات</a> در فهرست افزونه امنیتی.\n											</span>\n										</td>\n									</tr>\n								</table>\n							</td>\n						</tr>\n					</table>\n				</td>\n			</tr>\n		</table>\n	</td>\n</tr>					</table>\n				</td>\n			</tr>\n		</table>\n	</center>\n</body>\n\n</html>\n\";s:7:\"headers\";a:0:{}s:11:\"attachments\";a:0:{}s:24:\"phpmailer_exception_code\";i:0;}}}}", "error", "2020-12-01 16:33:26", "2020-12-01 16:33:18", "77718608", "78166040", "wp-cron", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("68", "0", "brute_force", "invalid-login::username-hmlupdate", "a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:12:\"wp-login.php\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:16:\"invalid_username\";a:1:{i:0;s:137:\"نام کاربری ناشناس. دوباره بررسی نمایید یا از آدرس ایمیل خود استفاده نمایید. \";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:9:\"hmlupdate\";s:7:\"user_id\";i:0;s:6:\"SERVER\";a:24:{s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:9:\"HTTP_HOST\";s:9:\"localhost\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:14:\"CONTENT_LENGTH\";s:3:\"143\";s:18:\"HTTP_CACHE_CONTROL\";s:9:\"max-age=0\";s:11:\"HTTP_ORIGIN\";s:16:\"http://localhost\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:8:\"HTTP_DNT\";s:1:\"1\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36\";s:11:\"HTTP_ACCEPT\";s:135:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9\";s:19:\"HTTP_SEC_FETCH_SITE\";s:11:\"same-origin\";s:19:\"HTTP_SEC_FETCH_MODE\";s:8:\"navigate\";s:19:\"HTTP_SEC_FETCH_USER\";s:2:\"?1\";s:19:\"HTTP_SEC_FETCH_DEST\";s:8:\"document\";s:12:\"HTTP_REFERER\";s:40:\"http://localhost/hamyarlearn/my-account/\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:65:\"en-US,en;q=0.9,my-ZG;q=0.8,my;q=0.7,fa-IR;q=0.6,fa;q=0.5,es;q=0.4\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"SCRIPT_FILENAME\";s:36:\"C:/laragon/www/hamyarlearn/index.php\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:18:\"REQUEST_TIME_FLOAT\";d:1606840474.196;s:12:\"REQUEST_TIME\";i:1606840474;}}", "notice", "2020-12-01 16:34:37", "2020-12-01 16:34:34", "78544608", "78899552", "http://localhost/hamyarlearn/my-account/", "1", "0", "::1");
INSERT INTO `hm_itsec_logs` VALUES("69", "0", "brute_force", "invalid-login::user-2", "a:5:{s:7:\"details\";a:2:{s:6:\"source\";s:12:\"wp-login.php\";s:20:\"authentication_types\";a:1:{i:0;s:21:\"username_and_password\";}}s:4:\"user\";O:8:\"WP_Error\":2:{s:6:\"errors\";a:1:{s:18:\"incorrect_password\";a:1:{i:0;s:261:\"<strong>خطا</strong>: رمز عبوری که برای نام کاربری <strong>hamyarlearn</strong> وارد شده درست نیست. <a href=\"http://localhost/hamyarlearn/my-account/lost-password/\">رمز عبورتان را گم کرده‌اید؟</a>\";}}s:10:\"error_data\";a:0:{}}s:8:\"username\";s:11:\"hamyarlearn\";s:7:\"user_id\";i:2;s:6:\"SERVER\";a:24:{s:18:\"HTTP_AUTHORIZATION\";s:0:\"\";s:9:\"HTTP_HOST\";s:9:\"localhost\";s:15:\"HTTP_CONNECTION\";s:10:\"keep-alive\";s:14:\"CONTENT_LENGTH\";s:3:\"153\";s:18:\"HTTP_CACHE_CONTROL\";s:9:\"max-age=0\";s:11:\"HTTP_ORIGIN\";s:16:\"http://localhost\";s:30:\"HTTP_UPGRADE_INSECURE_REQUESTS\";s:1:\"1\";s:8:\"HTTP_DNT\";s:1:\"1\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:15:\"HTTP_USER_AGENT\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36\";s:11:\"HTTP_ACCEPT\";s:135:\"text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9\";s:19:\"HTTP_SEC_FETCH_SITE\";s:11:\"same-origin\";s:19:\"HTTP_SEC_FETCH_MODE\";s:8:\"navigate\";s:19:\"HTTP_SEC_FETCH_USER\";s:2:\"?1\";s:19:\"HTTP_SEC_FETCH_DEST\";s:8:\"document\";s:12:\"HTTP_REFERER\";s:40:\"http://localhost/hamyarlearn/my-account/\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip, deflate, br\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:65:\"en-US,en;q=0.9,my-ZG;q=0.8,my;q=0.7,fa-IR;q=0.6,fa;q=0.5,es;q=0.4\";s:14:\"REQUEST_SCHEME\";s:4:\"http\";s:15:\"SCRIPT_FILENAME\";s:36:\"C:/laragon/www/hamyarlearn/index.php\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.1\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:18:\"REQUEST_TIME_FLOAT\";d:1606908445.49;s:12:\"REQUEST_TIME\";i:1606908445;}}", "notice", "2020-12-02 11:27:27", "2020-12-02 11:27:26", "81509928", "84773104", "http://localhost/hamyarlearn/my-account/", "1", "0", "::1");

/* INSERT TABLE DATA: hm_itsec_temp */
INSERT INTO `hm_itsec_temp` VALUES("1", "brute_force", "2020-07-10 22:00:10", "2020-07-10 17:30:10", "::1", NULL, NULL);
INSERT INTO `hm_itsec_temp` VALUES("2", "brute_force", "2020-07-10 22:00:10", "2020-07-10 17:30:10", NULL, NULL, "admin");
INSERT INTO `hm_itsec_temp` VALUES("3", "brute_force", "2020-07-11 19:58:21", "2020-07-11 15:28:21", "::1", NULL, NULL);
INSERT INTO `hm_itsec_temp` VALUES("4", "brute_force", "2020-07-11 19:58:21", "2020-07-11 15:28:21", NULL, NULL, "admin");
INSERT INTO `hm_itsec_temp` VALUES("5", "brute_force", "2020-07-14 13:51:06", "2020-07-14 09:21:06", "::1", NULL, NULL);
INSERT INTO `hm_itsec_temp` VALUES("6", "brute_force", "2020-07-14 13:51:06", "2020-07-14 09:21:06", NULL, NULL, "hamyarthemes");
INSERT INTO `hm_itsec_temp` VALUES("7", "brute_force", "2020-09-05 21:35:35", "2020-09-05 17:05:35", "::1", NULL, NULL);
INSERT INTO `hm_itsec_temp` VALUES("8", "brute_force", "2020-09-05 21:35:35", "2020-09-05 17:05:35", NULL, NULL, "shayanfp");
INSERT INTO `hm_itsec_temp` VALUES("9", "brute_force", "2020-09-05 21:38:43", "2020-09-05 17:08:43", "::1", NULL, NULL);
INSERT INTO `hm_itsec_temp` VALUES("10", "brute_force", "2020-09-05 21:38:43", "2020-09-05 17:08:43", NULL, NULL, "shayanfp");
INSERT INTO `hm_itsec_temp` VALUES("11", "brute_force", "2020-09-05 21:55:43", "2020-09-05 17:25:43", "::1", NULL, NULL);
INSERT INTO `hm_itsec_temp` VALUES("12", "brute_force", "2020-09-05 21:55:43", "2020-09-05 17:25:43", NULL, "2", "hamyarlearn");
INSERT INTO `hm_itsec_temp` VALUES("13", "brute_force", "2020-09-05 21:55:51", "2020-09-05 17:25:51", "::1", NULL, NULL);
INSERT INTO `hm_itsec_temp` VALUES("14", "brute_force", "2020-09-05 21:55:51", "2020-09-05 17:25:51", NULL, "2", "hamyarlearn");
INSERT INTO `hm_itsec_temp` VALUES("15", "brute_force", "2020-09-09 18:28:27", "2020-09-09 13:58:27", "::1", NULL, NULL);
INSERT INTO `hm_itsec_temp` VALUES("16", "brute_force", "2020-09-09 18:28:27", "2020-09-09 13:58:27", NULL, "2", "hamyarlearn");
INSERT INTO `hm_itsec_temp` VALUES("17", "brute_force", "2020-09-09 18:30:37", "2020-09-09 14:00:37", "::1", NULL, NULL);
INSERT INTO `hm_itsec_temp` VALUES("18", "brute_force", "2020-09-09 18:30:37", "2020-09-09 14:00:37", NULL, "2", "hamyarlearn");
INSERT INTO `hm_itsec_temp` VALUES("19", "brute_force", "2020-09-09 18:30:45", "2020-09-09 14:00:45", "::1", NULL, NULL);
INSERT INTO `hm_itsec_temp` VALUES("20", "brute_force", "2020-09-09 18:30:45", "2020-09-09 14:00:45", NULL, "2", "hamyarlearn");
INSERT INTO `hm_itsec_temp` VALUES("21", "brute_force", "2020-10-25 16:23:36", "2020-10-25 12:53:36", "::1", NULL, NULL);
INSERT INTO `hm_itsec_temp` VALUES("22", "brute_force", "2020-10-25 16:23:36", "2020-10-25 12:53:36", NULL, "2", "hamyarlearn");
INSERT INTO `hm_itsec_temp` VALUES("23", "brute_force", "2020-10-25 16:23:43", "2020-10-25 12:53:43", "::1", NULL, NULL);
INSERT INTO `hm_itsec_temp` VALUES("24", "brute_force", "2020-10-25 16:23:43", "2020-10-25 12:53:43", NULL, NULL, "shayanfp");
INSERT INTO `hm_itsec_temp` VALUES("25", "brute_force", "2020-10-25 16:23:52", "2020-10-25 12:53:52", "::1", NULL, NULL);
INSERT INTO `hm_itsec_temp` VALUES("26", "brute_force", "2020-10-25 16:23:52", "2020-10-25 12:53:52", NULL, "2", "hamyarlearn");
INSERT INTO `hm_itsec_temp` VALUES("27", "brute_force", "2020-10-25 16:24:05", "2020-10-25 12:54:05", "::1", NULL, NULL);
INSERT INTO `hm_itsec_temp` VALUES("28", "brute_force", "2020-10-25 16:24:05", "2020-10-25 12:54:05", NULL, "2", "hamyarlearn");
INSERT INTO `hm_itsec_temp` VALUES("29", "brute_force", "2020-10-25 16:24:12", "2020-10-25 12:54:12", "::1", NULL, NULL);
INSERT INTO `hm_itsec_temp` VALUES("30", "brute_force", "2020-10-25 16:24:12", "2020-10-25 12:54:12", NULL, "2", "hamyarlearn");
INSERT INTO `hm_itsec_temp` VALUES("31", "brute_force", "2020-11-01 20:52:25", "2020-11-01 17:22:25", "::1", NULL, NULL);
INSERT INTO `hm_itsec_temp` VALUES("32", "brute_force", "2020-11-01 20:52:25", "2020-11-01 17:22:25", NULL, "2", "hamyarlearn");
INSERT INTO `hm_itsec_temp` VALUES("33", "brute_force", "2020-11-01 20:52:36", "2020-11-01 17:22:36", "::1", NULL, NULL);
INSERT INTO `hm_itsec_temp` VALUES("34", "brute_force", "2020-11-01 20:52:36", "2020-11-01 17:22:36", NULL, "2", "hamyarlearn");
INSERT INTO `hm_itsec_temp` VALUES("35", "brute_force", "2020-11-01 20:53:37", "2020-11-01 17:23:37", "::1", NULL, NULL);
INSERT INTO `hm_itsec_temp` VALUES("36", "brute_force", "2020-11-01 20:53:37", "2020-11-01 17:23:37", NULL, "2", "hamyarlearn");
INSERT INTO `hm_itsec_temp` VALUES("37", "brute_force", "2020-11-07 23:26:01", "2020-11-07 19:56:01", "::1", NULL, NULL);
INSERT INTO `hm_itsec_temp` VALUES("38", "brute_force", "2020-11-07 23:26:01", "2020-11-07 19:56:01", NULL, "2", "hamyarlearn");
INSERT INTO `hm_itsec_temp` VALUES("39", "brute_force", "2020-11-07 23:26:33", "2020-11-07 19:56:33", "::1", NULL, NULL);
INSERT INTO `hm_itsec_temp` VALUES("40", "brute_force", "2020-11-07 23:26:33", "2020-11-07 19:56:33", NULL, "2", "hamyarlearn");
INSERT INTO `hm_itsec_temp` VALUES("41", "brute_force", "2020-11-07 23:27:03", "2020-11-07 19:57:03", "::1", NULL, NULL);
INSERT INTO `hm_itsec_temp` VALUES("42", "brute_force", "2020-11-07 23:27:03", "2020-11-07 19:57:03", NULL, "2", "hamyarlearn");
INSERT INTO `hm_itsec_temp` VALUES("43", "brute_force", "2020-11-07 23:27:51", "2020-11-07 19:57:51", "::1", NULL, NULL);
INSERT INTO `hm_itsec_temp` VALUES("44", "brute_force", "2020-11-07 23:27:51", "2020-11-07 19:57:51", NULL, "2", "hamyarlearn");
INSERT INTO `hm_itsec_temp` VALUES("45", "brute_force", "2020-11-07 23:28:06", "2020-11-07 19:58:06", "::1", NULL, NULL);
INSERT INTO `hm_itsec_temp` VALUES("46", "brute_force", "2020-11-07 23:28:06", "2020-11-07 19:58:06", NULL, "2", "hamyarlearn");
INSERT INTO `hm_itsec_temp` VALUES("47", "brute_force", "2020-11-07 23:28:23", "2020-11-07 19:58:23", "::1", NULL, NULL);
INSERT INTO `hm_itsec_temp` VALUES("48", "brute_force", "2020-11-07 23:28:23", "2020-11-07 19:58:23", NULL, "2", "hamyarlearn");
INSERT INTO `hm_itsec_temp` VALUES("49", "brute_force", "2020-11-07 23:28:40", "2020-11-07 19:58:40", "::1", NULL, NULL);
INSERT INTO `hm_itsec_temp` VALUES("50", "brute_force", "2020-11-07 23:28:40", "2020-11-07 19:58:40", NULL, "2", "hamyarlearn");
INSERT INTO `hm_itsec_temp` VALUES("51", "brute_force", "2020-11-07 23:28:59", "2020-11-07 19:58:59", "::1", NULL, NULL);
INSERT INTO `hm_itsec_temp` VALUES("52", "brute_force", "2020-11-07 23:28:59", "2020-11-07 19:58:59", NULL, "2", "hamyarlearn");
INSERT INTO `hm_itsec_temp` VALUES("53", "brute_force", "2020-12-01 20:04:34", "2020-12-01 16:34:34", "::1", NULL, NULL);
INSERT INTO `hm_itsec_temp` VALUES("54", "brute_force", "2020-12-01 20:04:34", "2020-12-01 16:34:34", NULL, NULL, "hmlupdate");
INSERT INTO `hm_itsec_temp` VALUES("55", "brute_force", "2020-12-02 14:57:26", "2020-12-02 11:27:26", "::1", NULL, NULL);
INSERT INTO `hm_itsec_temp` VALUES("56", "brute_force", "2020-12-02 14:57:26", "2020-12-02 11:27:26", NULL, "2", "hamyarlearn");

/* INSERT TABLE DATA: hm_itsec_user_groups */
INSERT INTO `hm_itsec_user_groups` VALUES("016b6b7f-c721-4a9a-94ba-df6a3558fbc1", "Subscriber Users", "", "subscriber", "", "", "2020-07-10 10:07:54");
INSERT INTO `hm_itsec_user_groups` VALUES("02d6aff0-5e9b-49d3-97d4-7320f1ddd48a", "Editor Users", "", "editor", "", "", "2020-07-10 10:07:06");
INSERT INTO `hm_itsec_user_groups` VALUES("089f25aa-01a4-44c8-9b09-08278aee53c5", "Subscriber Users", "", "subscriber", "", "", "2020-07-10 10:07:06");
INSERT INTO `hm_itsec_user_groups` VALUES("1766f5f1-ff17-43eb-b356-35581ae4f376", "Editor Users", "", "editor", "", "", "2020-07-10 10:07:54");
INSERT INTO `hm_itsec_user_groups` VALUES("1825a743-d1ce-483c-bc4e-a57e5bcaa092", "Subscriber Users", "", "subscriber", "", "", "2020-07-10 10:07:10");
INSERT INTO `hm_itsec_user_groups` VALUES("18611a12-1767-41af-8adc-46af39150eaf", "Contributor Users", "", "contributor", "", "", "2020-07-10 10:07:59");
INSERT INTO `hm_itsec_user_groups` VALUES("18990f9d-411f-42d2-bce8-783151a8e130", "Author Users", "", "author", "", "", "2020-07-10 10:07:14");
INSERT INTO `hm_itsec_user_groups` VALUES("1e8c1a50-fe27-4da2-b665-d56150ab13aa", "Administrator Users", "", "administrator", "", "", "2020-07-10 10:07:53");
INSERT INTO `hm_itsec_user_groups` VALUES("2d7ad722-a285-4576-846c-1392be0f3352", "Author Users", "", "author", "", "", "2020-07-10 10:07:40");
INSERT INTO `hm_itsec_user_groups` VALUES("2df40b38-ac60-4a37-9892-f9c587571c17", "Subscriber Users", "", "subscriber", "", "", "2020-07-10 10:07:40");
INSERT INTO `hm_itsec_user_groups` VALUES("2f3db0d3-65c0-45e5-a35d-eff99d94cb7e", "Author Users", "", "author", "", "", "2020-07-10 10:07:06");
INSERT INTO `hm_itsec_user_groups` VALUES("3887fe56-cd96-41ba-87af-f3cc7a81ab22", "Author Users", "", "author", "", "", "2020-07-10 10:07:59");
INSERT INTO `hm_itsec_user_groups` VALUES("3da3c2b7-fb74-4b30-b2cb-3a0067d2410a", "Author Users", "", "author", "", "", "2020-07-10 10:07:54");
INSERT INTO `hm_itsec_user_groups` VALUES("3f0f2e1d-1411-4fe2-8248-40ca3754ff45", "Editor Users", "", "editor", "", "", "2020-07-10 10:07:40");
INSERT INTO `hm_itsec_user_groups` VALUES("444bc5c6-ff8c-4b45-ac0f-b058e349ed08", "Author Users", "", "author", "", "", "2020-07-10 10:07:09");
INSERT INTO `hm_itsec_user_groups` VALUES("469373cf-21ee-484e-a6a8-c340a740f11f", "Administrator Users", "", "administrator", "", "", "2020-07-10 10:07:59");
INSERT INTO `hm_itsec_user_groups` VALUES("59239bb3-dcf0-4726-a19f-ff8ed1ca7296", "Contributor Users", "", "contributor", "", "", "2020-07-10 10:07:10");
INSERT INTO `hm_itsec_user_groups` VALUES("5bb5657a-88d0-43b8-9463-edf74bc07000", "Administrator Users", "", "administrator", "", "", "2020-07-10 10:07:40");
INSERT INTO `hm_itsec_user_groups` VALUES("63ac32e2-da4a-4a0d-9048-ea8bbbb16d99", "Editor Users", "", "editor", "", "", "2020-07-10 10:07:59");
INSERT INTO `hm_itsec_user_groups` VALUES("65ba90a2-684c-4c50-a21b-6716c3ef2aa8", "Contributor Users", "", "contributor", "", "", "2020-07-10 10:07:14");
INSERT INTO `hm_itsec_user_groups` VALUES("6771873e-7eea-437a-b270-6c3058cc1f89", "Administrator Users", "", "administrator", "", "", "2020-07-10 10:07:14");
INSERT INTO `hm_itsec_user_groups` VALUES("7210b7e2-2ff4-48cb-a8a5-1f854a1efeb0", "Subscriber Users", "", "subscriber", "", "", "2020-07-10 10:07:59");
INSERT INTO `hm_itsec_user_groups` VALUES("7f9afd51-6887-4233-aac8-c016b62d6919", "Subscriber Users", "", "subscriber", "", "", "2020-07-10 10:07:14");
INSERT INTO `hm_itsec_user_groups` VALUES("a1da201f-a3ea-4455-907a-9a56797663ee", "Editor Users", "", "editor", "", "", "2020-07-10 10:07:09");
INSERT INTO `hm_itsec_user_groups` VALUES("aa706560-0014-4298-ad3b-55344f587f34", "Administrator Users", "", "administrator", "", "", "2020-07-10 10:07:06");
INSERT INTO `hm_itsec_user_groups` VALUES("acb22c0a-69da-4978-a21e-04e4a01b62f7", "Contributor Users", "", "contributor", "", "", "2020-07-10 10:07:06");
INSERT INTO `hm_itsec_user_groups` VALUES("af2897cf-07d8-4064-9321-c4f459e2ec32", "Administrator Users", "", "administrator", "", "", "2020-07-10 10:07:09");
INSERT INTO `hm_itsec_user_groups` VALUES("cd677f81-f7f1-49cd-a15b-7f169d076586", "Contributor Users", "", "contributor", "", "", "2020-07-10 10:07:40");
INSERT INTO `hm_itsec_user_groups` VALUES("de1f08ab-af12-4e5e-949b-4d91617d32ec", "Contributor Users", "", "contributor", "", "", "2020-07-10 10:07:54");
INSERT INTO `hm_itsec_user_groups` VALUES("ee331c74-160c-46db-a527-70361796d7f0", "Editor Users", "", "editor", "", "", "2020-07-10 10:07:14");

/* INSERT TABLE DATA: hm_learndash_user_activity */
INSERT INTO `hm_learndash_user_activity` VALUES("1", "2", "835", "835", "course", "0", "1604253119", NULL, "1604253119");
INSERT INTO `hm_learndash_user_activity` VALUES("2", "2", "839", "835", "lesson", "0", "1604253119", NULL, "1604253119");
INSERT INTO `hm_learndash_user_activity` VALUES("3", "2", "843", "835", "topic", "0", "1604253127", NULL, "1604253127");
INSERT INTO `hm_learndash_user_activity` VALUES("4", "2", "845", "835", "topic", "0", "1604253133", NULL, "1604253133");

/* INSERT TABLE DATA: hm_learndash_user_activity_meta */
INSERT INTO `hm_learndash_user_activity_meta` VALUES("1", "1", "steps_total", "5");
INSERT INTO `hm_learndash_user_activity_meta` VALUES("2", "1", "steps_completed", "0");
INSERT INTO `hm_learndash_user_activity_meta` VALUES("3", "1", "steps_last_id", "839");
INSERT INTO `hm_learndash_user_activity_meta` VALUES("4", "2", "steps_total", "5");
INSERT INTO `hm_learndash_user_activity_meta` VALUES("5", "2", "steps_completed", "0");
INSERT INTO `hm_learndash_user_activity_meta` VALUES("6", "3", "steps_total", "5");
INSERT INTO `hm_learndash_user_activity_meta` VALUES("7", "3", "steps_completed", "0");
INSERT INTO `hm_learndash_user_activity_meta` VALUES("8", "4", "steps_total", "5");
INSERT INTO `hm_learndash_user_activity_meta` VALUES("9", "4", "steps_completed", "0");

/* INSERT TABLE DATA: hm_learnpress_sessions */
INSERT INTO `hm_learnpress_sessions` VALUES("30", "19b135b49ddb5275ba7184ca9ec7f975", "a:3:{s:13:\"guest_user_id\";i:1599659915;s:4:\"cart\";s:6:\"a:0:{}\";s:19:\"user_just_logged_in\";s:3:\"yes\";}", "1599828664");

/* INSERT TABLE DATA: hm_options */
INSERT INTO `hm_options` VALUES("1", "siteurl", "http://localhost/hamyarlearn", "yes");
INSERT INTO `hm_options` VALUES("2", "home", "http://localhost/hamyarlearn", "yes");
INSERT INTO `hm_options` VALUES("3", "blogname", "همیار لرن", "yes");
INSERT INTO `hm_options` VALUES("4", "blogdescription", "یادگیری مهارت‌های جدید", "yes");
INSERT INTO `hm_options` VALUES("5", "users_can_register", "1", "yes");
INSERT INTO `hm_options` VALUES("6", "admin_email", "info@email.com", "yes");
INSERT INTO `hm_options` VALUES("7", "start_of_week", "6", "yes");
INSERT INTO `hm_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `hm_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `hm_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `hm_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `hm_options` VALUES("12", "posts_per_rss", "15", "yes");
INSERT INTO `hm_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `hm_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `hm_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `hm_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `hm_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `hm_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `hm_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `hm_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `hm_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `hm_options` VALUES("22", "posts_per_page", "9", "yes");
INSERT INTO `hm_options` VALUES("23", "date_format", "j F Y", "yes");
INSERT INTO `hm_options` VALUES("24", "time_format", "H:i", "yes");
INSERT INTO `hm_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `hm_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `hm_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `hm_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `hm_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `hm_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `hm_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `hm_options` VALUES("33", "active_plugins", "a:14:{i:0;s:57:\"acf-content-analysis-for-yoast-seo/yoast-acf-analysis.php\";i:1;s:30:\"advanced-custom-fields/acf.php\";i:2;s:41:\"better-wp-security/better-wp-security.php\";i:3;s:36:\"contact-form-7/wp-contact-form-7.php\";i:4;s:25:\"duplicator/duplicator.php\";i:5;s:23:\"elementor/elementor.php\";i:7;s:39:\"persian-elementor/persian-elementor.php\";i:8;s:43:\"persian-woocommerce/woocommerce-persian.php\";i:10;s:56:\"woo-checkout-field-editor-pro/checkout-form-designer.php\";i:11;s:27:\"woocommerce/woocommerce.php\";i:12;s:24:\"wordpress-seo/wp-seo.php\";i:13;s:29:\"wp-parsidate/wp-parsidate.php\";i:14;s:23:\"wp-smushit/wp-smush.php\";i:15;s:46:\"zarinpal-woocommerce-payment-gateway/index.php\";}", "yes");
INSERT INTO `hm_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `hm_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `hm_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `hm_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `hm_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `hm_options` VALUES("39", "recently_edited", "", "no");
INSERT INTO `hm_options` VALUES("40", "template", "hamyarlearn", "yes");
INSERT INTO `hm_options` VALUES("41", "stylesheet", "hamyarlearn-child", "yes");
INSERT INTO `hm_options` VALUES("44", "comment_registration", "0", "yes");
INSERT INTO `hm_options` VALUES("45", "html_type", "text/html", "yes");
INSERT INTO `hm_options` VALUES("46", "use_trackback", "0", "yes");
INSERT INTO `hm_options` VALUES("47", "default_role", "subscriber", "yes");
INSERT INTO `hm_options` VALUES("48", "db_version", "48748", "yes");
INSERT INTO `hm_options` VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `hm_options` VALUES("50", "upload_path", "", "yes");
INSERT INTO `hm_options` VALUES("51", "blog_public", "1", "yes");
INSERT INTO `hm_options` VALUES("52", "default_link_category", "2", "yes");
INSERT INTO `hm_options` VALUES("53", "show_on_front", "page", "yes");
INSERT INTO `hm_options` VALUES("54", "tag_base", "", "yes");
INSERT INTO `hm_options` VALUES("55", "show_avatars", "1", "yes");
INSERT INTO `hm_options` VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO `hm_options` VALUES("57", "upload_url_path", "", "yes");
INSERT INTO `hm_options` VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO `hm_options` VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO `hm_options` VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO `hm_options` VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO `hm_options` VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO `hm_options` VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO `hm_options` VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO `hm_options` VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO `hm_options` VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO `hm_options` VALUES("67", "image_default_size", "", "yes");
INSERT INTO `hm_options` VALUES("68", "image_default_align", "", "yes");
INSERT INTO `hm_options` VALUES("69", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `hm_options` VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO `hm_options` VALUES("71", "thread_comments", "1", "yes");
INSERT INTO `hm_options` VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO `hm_options` VALUES("73", "page_comments", "0", "yes");
INSERT INTO `hm_options` VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO `hm_options` VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO `hm_options` VALUES("76", "comment_order", "asc", "yes");
INSERT INTO `hm_options` VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `hm_options` VALUES("78", "widget_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `hm_options` VALUES("79", "widget_text", "a:3:{i:1;a:0:{}i:2;a:4:{s:5:\"title\";s:15:\"متن تستی\";s:4:\"text\";s:339:\"من متنم را در این جا مینویسم!\r\n<ul>\r\n 	<li>یک لیست</li>\r\n 	<li>دو لیست</li>\r\n 	<li>تو در تو!!</li>\r\n</ul>\r\nمن <strong>بولدم</strong> من <strong>ایتالیکم</strong> من <a href=\"#\">لینکم</a>\r\n<ol>\r\n 	<li>سلام 1</li>\r\n 	<li>سلام 2</li>\r\n 	<li>سلام تست 3</li>\r\n</ol>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `hm_options` VALUES("80", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `hm_options` VALUES("81", "uninstall_plugins", "a:2:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:41:\"better-wp-security/better-wp-security.php\";a:2:{i:0;s:10:\"ITSEC_Core\";i:1;s:16:\"handle_uninstall\";}}", "no");
INSERT INTO `hm_options` VALUES("82", "timezone_string", "Asia/Tehran", "yes");
INSERT INTO `hm_options` VALUES("83", "page_for_posts", "6", "yes");
INSERT INTO `hm_options` VALUES("84", "page_on_front", "277", "yes");
INSERT INTO `hm_options` VALUES("85", "default_post_format", "0", "yes");
INSERT INTO `hm_options` VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO `hm_options` VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `hm_options` VALUES("88", "site_icon", "36", "yes");
INSERT INTO `hm_options` VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO `hm_options` VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO `hm_options` VALUES("91", "wp_page_for_privacy_policy", "", "yes");
INSERT INTO `hm_options` VALUES("92", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `hm_options` VALUES("93", "admin_email_lifespan", "1609927156", "yes");
INSERT INTO `hm_options` VALUES("94", "initial_db_version", "47018", "yes");
INSERT INTO `hm_options` VALUES("95", "hm_user_roles", "a:11:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:199:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:14:\"wpProQuiz_show\";b:1;s:18:\"wpProQuiz_add_quiz\";b:1;s:19:\"wpProQuiz_edit_quiz\";b:1;s:21:\"wpProQuiz_delete_quiz\";b:1;s:25:\"wpProQuiz_show_statistics\";b:1;s:26:\"wpProQuiz_reset_statistics\";b:1;s:16:\"wpProQuiz_import\";b:1;s:16:\"wpProQuiz_export\";b:1;s:25:\"wpProQuiz_change_settings\";b:1;s:22:\"wpProQuiz_toplist_edit\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:11:\"read_course\";b:1;s:15:\"publish_courses\";b:1;s:12:\"edit_courses\";b:1;s:19:\"edit_others_courses\";b:1;s:14:\"delete_courses\";b:1;s:21:\"delete_others_courses\";b:1;s:20:\"read_private_courses\";b:1;s:20:\"edit_private_courses\";b:1;s:22:\"delete_private_courses\";b:1;s:13:\"delete_course\";b:1;s:22:\"edit_published_courses\";b:1;s:24:\"delete_published_courses\";b:1;s:12:\"enroll_users\";b:1;s:17:\"delete_lp_courses\";b:1;s:27:\"delete_published_lp_courses\";b:1;s:15:\"edit_lp_courses\";b:1;s:25:\"edit_published_lp_courses\";b:1;s:18:\"publish_lp_courses\";b:1;s:25:\"delete_private_lp_courses\";b:1;s:23:\"edit_private_lp_courses\";b:1;s:24:\"delete_others_lp_courses\";b:1;s:22:\"edit_others_lp_courses\";b:1;s:17:\"delete_lp_lessons\";b:1;s:27:\"delete_published_lp_lessons\";b:1;s:15:\"edit_lp_lessons\";b:1;s:25:\"edit_published_lp_lessons\";b:1;s:18:\"publish_lp_lessons\";b:1;s:25:\"delete_private_lp_lessons\";b:1;s:23:\"edit_private_lp_lessons\";b:1;s:24:\"delete_others_lp_lessons\";b:1;s:22:\"edit_others_lp_lessons\";b:1;s:16:\"delete_lp_orders\";b:1;s:26:\"delete_published_lp_orders\";b:1;s:14:\"edit_lp_orders\";b:1;s:24:\"edit_published_lp_orders\";b:1;s:17:\"publish_lp_orders\";b:1;s:24:\"delete_private_lp_orders\";b:1;s:22:\"edit_private_lp_orders\";b:1;s:23:\"delete_others_lp_orders\";b:1;s:21:\"edit_others_lp_orders\";b:1;s:10:\"read_group\";b:1;s:14:\"publish_groups\";b:1;s:11:\"edit_groups\";b:1;s:18:\"edit_others_groups\";b:1;s:13:\"delete_groups\";b:1;s:20:\"delete_others_groups\";b:1;s:19:\"read_private_groups\";b:1;s:12:\"delete_group\";b:1;s:21:\"edit_published_groups\";b:1;s:23:\"delete_published_groups\";b:1;s:11:\"edit_essays\";b:1;s:18:\"edit_others_essays\";b:1;s:14:\"publish_essays\";b:1;s:11:\"read_essays\";b:1;s:19:\"read_private_essays\";b:1;s:13:\"delete_essays\";b:1;s:21:\"edit_published_essays\";b:1;s:20:\"delete_others_essays\";b:1;s:23:\"delete_published_essays\";b:1;s:15:\"edit_assignment\";b:1;s:16:\"edit_assignments\";b:1;s:23:\"edit_others_assignments\";b:1;s:19:\"publish_assignments\";b:1;s:15:\"read_assignment\";b:1;s:24:\"read_private_assignments\";b:1;s:17:\"delete_assignment\";b:1;s:26:\"edit_published_assignments\";b:1;s:25:\"delete_others_assignments\";b:1;s:28:\"delete_published_assignments\";b:1;s:20:\"wpseo_manage_options\";b:1;s:10:\"edit_group\";b:1;s:29:\"manage_terms_group_categories\";b:1;s:27:\"edit_terms_group_categories\";b:1;s:29:\"delete_terms_group_categories\";b:1;s:29:\"assign_terms_group_categories\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:35:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:12:\"group_leader\";a:2:{s:4:\"name\";s:12:\"Group Leader\";s:12:\"capabilities\";a:20:{s:4:\"read\";b:1;s:12:\"group_leader\";b:1;s:11:\"edit_essays\";b:1;s:18:\"edit_others_essays\";b:1;s:14:\"publish_essays\";b:1;s:11:\"read_essays\";b:1;s:19:\"read_private_essays\";b:1;s:13:\"delete_essays\";b:1;s:21:\"edit_published_essays\";b:1;s:20:\"delete_others_essays\";b:1;s:23:\"delete_published_essays\";b:1;s:15:\"read_assignment\";b:1;s:16:\"edit_assignments\";b:1;s:23:\"edit_others_assignments\";b:1;s:26:\"edit_published_assignments\";b:1;s:25:\"delete_others_assignments\";b:1;s:28:\"delete_published_assignments\";b:1;s:25:\"wpProQuiz_show_statistics\";b:1;s:7:\"level_1\";b:0;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:92:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}s:10:\"lp_teacher\";a:2:{s:4:\"name\";s:13:\"LP Instructor\";s:12:\"capabilities\";a:13:{s:27:\"delete_published_lp_courses\";b:1;s:25:\"edit_published_lp_courses\";b:1;s:15:\"edit_lp_courses\";b:1;s:17:\"delete_lp_courses\";b:1;s:15:\"unfiltered_html\";b:1;s:27:\"delete_published_lp_lessons\";b:1;s:25:\"edit_published_lp_lessons\";b:1;s:15:\"edit_lp_lessons\";b:1;s:17:\"delete_lp_lessons\";b:1;s:18:\"publish_lp_lessons\";b:1;s:12:\"upload_files\";b:1;s:4:\"read\";b:1;s:10:\"edit_posts\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}}", "yes");
INSERT INTO `hm_options` VALUES("96", "fresh_site", "0", "yes");
INSERT INTO `hm_options` VALUES("97", "WPLANG", "fa_IR", "yes");
INSERT INTO `hm_options` VALUES("98", "widget_search", "a:3:{i:2;a:1:{s:5:\"title\";s:0:\"\";}i:3;a:1:{s:5:\"title\";s:10:\"جستجو\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `hm_options` VALUES("99", "widget_recent-posts", "a:3:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}i:3;a:3:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;s:9:\"show_date\";b:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `hm_options` VALUES("100", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `hm_options` VALUES("101", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `hm_options` VALUES("102", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `hm_options` VALUES("103", "sidebars_widgets", "a:4:{s:19:\"wp_inactive_widgets\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:14:\"sidebar_single\";a:6:{i:0;s:8:\"search-3\";i:1;s:6:\"text-2\";i:2;s:14:\"recent-posts-3\";i:3;s:28:\"woocommerce_product_search-2\";i:4;s:22:\"woocommerce_products-2\";i:5;s:25:\"woocommerce_widget_cart-2\";}s:17:\"footer_left_namad\";a:1:{i:0;s:13:\"custom_html-2\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `hm_options` VALUES("104", "cron", "a:26:{i:1606920620;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1606921160;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1606921188;a:1:{s:32:\"woocommerce_cancel_unpaid_orders\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1606921670;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1606921690;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1606924781;a:1:{s:24:\"woocommerce_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1606935581;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1606942800;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1606946361;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1606946863;a:1:{s:25:\"ZhUpClient_update_checker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1606950682;a:1:{s:15:\"itsec_cron_test\";a:1:{s:32:\"1e07b8ed719818454b4d49b88ce2647e\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1606950682;}}}}i:1606952627;a:1:{s:28:\"learn_press_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1606982722;a:3:{s:13:\"wpseo-reindex\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"wpseo_permalink_structure_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:20:\"wpseo_home_url_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1606984741;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1606989560;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1606989570;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1606989572;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1606989681;a:1:{s:27:\"hamyarlearn_daily_validator\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1606990069;a:1:{s:19:\"wpseo-reindex-links\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1606990072;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1607000391;a:2:{s:33:\"woocommerce_cleanup_personal_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1607005116;a:1:{s:23:\"isa_add_every_nice_time\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:15:\"every_nice_time\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1607076458;a:1:{s:16:\"wpseo_ryte_fetch\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1607162360;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1608210041;a:1:{s:25:\"woocommerce_geoip_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"fifteendays\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1296000;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `hm_options` VALUES("105", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `hm_options` VALUES("106", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `hm_options` VALUES("107", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `hm_options` VALUES("108", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `hm_options` VALUES("109", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `hm_options` VALUES("110", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `hm_options` VALUES("111", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `hm_options` VALUES("112", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `hm_options` VALUES("113", "widget_custom_html", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:7:\"content\";s:63:\"مکان نماد اعتماد پرداخت و ساماندهی\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `hm_options` VALUES("115", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `hm_options` VALUES("117", "theme_mods_twentytwenty", "a:4:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1600083951;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:9:\"sidebar-2\";a:1:{i:0;s:13:\"custom_html-2\";}}}s:16:\"background_color\";s:3:\"fff\";s:18:\"nav_menu_locations\";a:2:{s:7:\"primary\";i:22;s:6:\"footer\";i:23;}}", "yes");
INSERT INTO `hm_options` VALUES("142", "recently_activated", "a:0:{}", "yes");
INSERT INTO `hm_options` VALUES("143", "current_theme", "همیار لرن چایلد", "yes");
INSERT INTO `hm_options` VALUES("144", "theme_mods_hamyarlearn-child", "a:5:{i:0;b:0;s:18:\"nav_menu_locations\";a:3:{s:9:\"main-menu\";i:22;s:11:\"footer-menu\";i:23;s:11:\"mobile-menu\";i:22;}s:18:\"custom_css_post_id\";i:-1;s:19:\"ot_set_google_fonts\";a:0:{}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1600083953;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:17:\"footer_left_namad\";a:1:{i:0;s:13:\"custom_html-2\";}}}}", "yes");
INSERT INTO `hm_options` VALUES("145", "theme_switched", "", "yes");
INSERT INTO `hm_options` VALUES("146", "option_tree_settings", "a:3:{s:15:\"contextual_help\";a:2:{s:7:\"content\";a:2:{i:0;a:3:{s:2:\"id\";s:10:\"how_to_use\";s:5:\"title\";s:53:\"نحوه‌ی اعمال تغییرات در قالب\";s:7:\"content\";s:546:\"برای تنظیم کردن قالب در هر زمان، تنها کافیست به این بخش بیایید و تغییرات تان را اعمال کنید.&lt;br&gt;\r\nمثلا برای تنظیم لوگویتان، باید در بخش تنظیمات اصلی، روی دکمه‌ی + کلیک کنید و تصویر را در سایز خواسته شده، آپلود کنید و قرار دهید.&lt;br&gt;\r\nپس از اعمال کلی تنظیمات، روی دکمه‌ی &quot;ذخیره‌ی تغییرات&quot; کلیک کنید.\";}i:1;a:3:{s:2:\"id\";s:12:\"how_to_start\";s:5:\"title\";s:35:\"شروع کار با تنظیمات\";s:7:\"content\";s:562:\"برای شروع استفاده از تنظیمات قالب همیار لرن، در صورتی که از بسته‌ی نصب آسان استفاده نکردید، باید یکبار تمام گزینه‌های ON/OFF در تنظیمات را Off و مجددا On کنید و سپس از آنها استفاده کنید. نکته‌ی مهم: در صورت انتشار بروزرسانی جدید برای قالب، باید مواردی که اضافه شدند را بررسی کنید و یکبار آنها را نیز Off و مجددا On کنید.\";}}s:7:\"sidebar\";s:189:\"&lt;p style=&quot;text-align:center&quot;&gt;\r\nراهنمای تنظیمات قالب&lt;br&gt;مجموعه‌ی وردپرس با شایان&lt;br&gt;قالب همیار لرن\r\n&lt;/p&gt;\";}s:8:\"sections\";a:18:{i:0;a:2:{s:2:\"id\";s:16:\"general_settings\";s:5:\"title\";s:23:\"تنظیمات اصلی\";}i:1;a:2:{s:2:\"id\";s:14:\"color_settings\";s:5:\"title\";s:28:\"تنظیمات رنگ‌ها\";}i:2;a:2:{s:2:\"id\";s:20:\"shtemplates_settings\";s:5:\"title\";s:76:\"تنظیمات متمایز ساز همیار لرن!! &quot;جدید!&quot;\";}i:3;a:2:{s:2:\"id\";s:15:\"slider_settings\";s:5:\"title\";s:29:\"تنظیمات اسلایدر\";}i:4;a:2:{s:2:\"id\";s:13:\"links_sttings\";s:5:\"title\";s:15:\"لینک‌ها\";}i:5;a:2:{s:2:\"id\";s:17:\"bookarea_settings\";s:5:\"title\";s:58:\"باکس دانلود کتاب در صفحه‌ی اصلی\";}i:6;a:2:{s:2:\"id\";s:10:\"count_home\";s:5:\"title\";s:31:\"آمار صفحه‌ی اصلی\";}i:7;a:2:{s:2:\"id\";s:20:\"course_page_settings\";s:5:\"title\";s:48:\"تنظیمات صفحه‌ی دوره/محصول\";}i:8;a:2:{s:2:\"id\";s:13:\"post_settings\";s:5:\"title\";s:39:\"تنظیمات صفحه‌ی مقاله\";}i:9;a:2:{s:2:\"id\";s:11:\"menu_notice\";s:5:\"title\";s:47:\"تنظیمات اعلان منوی موبایل\";}i:10;a:2:{s:2:\"id\";s:15:\"fast_reg_mobile\";s:5:\"title\";s:89:\"تنظیمات دکمه‌ی ثبت‌نام سریع موبایل در صفحه دوره\";}i:11;a:2:{s:2:\"id\";s:12:\"css_settings\";s:5:\"title\";s:18:\"css اختصاصی\";}i:12;a:2:{s:2:\"id\";s:10:\"advice_box\";s:5:\"title\";s:27:\"درخواست مشاوره\";}i:13;a:2:{s:2:\"id\";s:11:\"advice_form\";s:5:\"title\";s:34:\"فرم درخواست مشاوره\";}i:14;a:2:{s:2:\"id\";s:15:\"footer_settings\";s:5:\"title\";s:8:\"فوتر\";}i:15;a:2:{s:2:\"id\";s:16:\"scoials_settings\";s:5:\"title\";s:47:\"تنظیمات شبکه‌های اجتماعی\";}i:16;a:2:{s:2:\"id\";s:14:\"count_products\";s:5:\"title\";s:25:\"تعداد محصولات\";}i:17;a:2:{s:2:\"id\";s:17:\"footer_wwsh_codes\";s:5:\"title\";s:19:\"کدهای فوتر\";}}s:8:\"settings\";a:109:{i:0;a:14:{s:2:\"id\";s:8:\"sitefont\";s:5:\"label\";s:73:\"دوست دارید فونت سایت شما، چه فونتی باشد؟\";s:4:\"desc\";s:171:\"در نسخه‌ی جدید قالب همیار لرن، می‌توانید فونت‌های مورد نظر خود را برای سایت تان انتخاب کنید!!\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"select\";s:7:\"section\";s:16:\"general_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";s:7:\"choices\";a:6:{i:0;a:3:{s:5:\"value\";s:7:\"shabnam\";s:5:\"label\";s:17:\"فونت شبنم\";s:3:\"src\";s:0:\"\";}i:1;a:3:{s:5:\"value\";s:5:\"tanha\";s:5:\"label\";s:17:\"فونت تنها\";s:3:\"src\";s:0:\"\";}i:2;a:3:{s:5:\"value\";s:5:\"samim\";s:5:\"label\";s:17:\"فونت صمیم\";s:3:\"src\";s:0:\"\";}i:3;a:3:{s:5:\"value\";s:5:\"sahel\";s:5:\"label\";s:17:\"فونت ساحل\";s:3:\"src\";s:0:\"\";}i:4;a:3:{s:5:\"value\";s:5:\"nahid\";s:5:\"label\";s:19:\"فونت ناهید\";s:3:\"src\";s:0:\"\";}i:5;a:3:{s:5:\"value\";s:6:\"gandom\";s:5:\"label\";s:17:\"فونت گندم\";s:3:\"src\";s:0:\"\";}}}i:1;a:13:{s:2:\"id\";s:8:\"darkmode\";s:5:\"label\";s:15:\"دارک مود\";s:4:\"desc\";s:195:\"سایت شما بصورت دارک مود و حالت تاریک در می‌آید.&lt;br&gt;\r\n				با on و off می‌توانید این حالت را فعال یا غیرفعال کنید.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"on-off\";s:7:\"section\";s:16:\"general_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:2;a:13:{s:2:\"id\";s:8:\"sitelogo\";s:5:\"label\";s:19:\"لوگوی سایت\";s:4:\"desc\";s:135:\"لوگوی سایت تان را قرار دهید. سایز لوگو:&lt;br&gt;\r\nعرض: 61 پیکسل&lt;br&gt;\r\nطول: 61 پیکسل\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"upload\";s:7:\"section\";s:16:\"general_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:3;a:13:{s:2:\"id\";s:14:\"sitefooterlogo\";s:5:\"label\";s:19:\"لوگوی فوتر\";s:4:\"desc\";s:135:\"یک لوگوی سفید رنگ قرار دهید. سایز لوگو:&lt;br&gt;\r\nعرض: 61 پیکسل&lt;br&gt;\r\nطول: 61 پیکسل\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"upload\";s:7:\"section\";s:16:\"general_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:4;a:13:{s:2:\"id\";s:14:\"site404pageimg\";s:5:\"label\";s:14:\"تصویر 404\";s:4:\"desc\";s:46:\"تصویر برای صفحه‌ی 404 سایت\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"upload\";s:7:\"section\";s:16:\"general_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:5;a:13:{s:2:\"id\";s:21:\"hm_designed_scrollbar\";s:5:\"label\";s:75:\"اسکرول بار همیار لرن یا حالت عادی مرورگر؟\";s:4:\"desc\";s:776:\"(منظور از اسکرول بار، نوار کناری\r\n			در مرورگر هست که با کمک آن صفحه را جابجا می‌کنید)&lt;br&gt;\r\n			می‌خواهید اسکرول بار صفحات سایت تان حالت عادی مرورگر که در اکثر سایت‌ها وجود دارد باشد\r\n			یا اختصاصی همیار لرن (که به رنگ قالب شما هست)&lt;br&gt;\r\n			توجه داشته باشید که این قابلیت در مرورگر فایرفاکس فعال نیست و صرفا برای کروم و یکسری مرورگر دیگر هست.&lt;br&gt;\r\n			برای فعال کردن همیار لرن، روی on و برای غیرفعال کردن (حالت عادی مرورگر) روی off قرار دهید.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"on-off\";s:7:\"section\";s:16:\"general_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:6;a:13:{s:2:\"id\";s:20:\"sticky_header_on_off\";s:5:\"label\";s:45:\"فعالسازی هدر چسبان (sticky)؟\";s:4:\"desc\";s:153:\"در هدر چسبان، هدر بصورت ثابت در بالای سایت می‌ماند و با اسکرول هم همان‌جا قرار دارد.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"on-off\";s:7:\"section\";s:16:\"general_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:7;a:13:{s:2:\"id\";s:13:\"tooman_enable\";s:5:\"label\";s:93:\"فعالسازی کد واحد پولی تومان برای افزونه‌ی لرن‌پرس\";s:4:\"desc\";s:1071:\"&lt;strong&gt;توصیه‌ی ما: فعال باشد.&lt;/strong&gt;&lt;br&gt; برای فعالسازی، یکبار غیرفعال کنید و سپس on کنید.&lt;br&gt;\r\n				اگر غیرفعال کردید، از افزونه‌ی زرین‌پال لرن‌پرس در سایت خود زرین‌پال، به جای فایل افزونه اصلاح شده در پکیج قالب دانلود شده استفاده کنید&lt;br&gt;\r\n				در صورتی هم که فعال کردید، حتما افزونه‌ی زرین‌پال اصلاح‌شده (برای واحد پولی تومان) را روی سایت‌تان نصب کنید.\r\n				این افزونه، در پکیج فایل قالب دانلود شده، موجود است و باید نصب و فعال کنید.&lt;br&gt;\r\n				در صورتی هم که کلا افزونه‌ی لرن‌پرس را نصب و فعال نکرده‌اید و به آن نیازی هم ندارید، این افزونه را پاک کنید. این تنظیم هم در این صورت، کاری نمی‌کند.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"on-off\";s:7:\"section\";s:16:\"general_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:8;a:13:{s:2:\"id\";s:25:\"enable_user_register_date\";s:5:\"label\";s:87:\"فعالسازی نمایش تاریخ عضویت کاربر در بخش کاربران\";s:4:\"desc\";s:377:\"با این تنظیم، در پیشخوان وردپرس &gt; کاربران، یک ستون جدید با عنوان\r\n				 تاریخ عضویت کاربر\r\n				 اضافه می‌شود.&lt;br&gt;\r\n				 &lt;strong style=&quot;color:red&quot;&gt;\r\n				 نکته‌ی مهم: این تاریخ بصورت میلادی نمایش داده خواهد شد.\r\n				 &lt;/strong&gt;\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"on-off\";s:7:\"section\";s:16:\"general_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:9;a:13:{s:2:\"id\";s:25:\"enable_mobile_menu_search\";s:5:\"label\";s:64:\"فعال بودن باکس جستجو در منوی موبایل\";s:4:\"desc\";s:123:\"با فعالسازی این تنظیم، در منوی موبایل سایت باکس جستجو اضافه می‌شود.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"on-off\";s:7:\"section\";s:16:\"general_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:10;a:13:{s:2:\"id\";s:23:\"author_learndash_enable\";s:5:\"label\";s:107:\"فعال بودن نویسنده (مدرس اصلی) دوره در پایین دوره برای لرن دش\";s:4:\"desc\";s:566:\"قالب همیار لرن، یک باکس نویسنده به پایین صفحه‌ی دوره‌ی لرن دش اضافه می‌کند.&lt;br&gt;\r\n				همان طور که می‌دانید، نصب افزونه لرن دش برای قالب همیار لرن، ضروری نیست و فقط در صورت نیاز است و قالب همیار لرن هم با آن سازگار است.\r\n				اگر نصب دارید، این تنظیم برای شما کار می‌کند و در صورتی که نصب نیست، این تنظیم کلا کار نمیکند!\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"on-off\";s:7:\"section\";s:16:\"general_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:11;a:13:{s:2:\"id\";s:9:\"left_sidr\";s:5:\"label\";s:73:\"فعالسازی باز شدن منوی موبایل از سمت راست\";s:4:\"desc\";s:485:\"به طور پیش فرض منوی موبایل از سمت چپ باز می‌شود.&lt;br&gt;\r\n				با فعال کردن این تنظیم، منوی موبایل از سمت راست باز می‌شود.\r\n				توصیه‌ی ما، این است که از همان سمت چپ باز شود. ولی در صورتی که حتما می‌خواهید از سمت درخواست\r\n				 باز شود، مشکلی نیست و میتوانید این تنظیم را فعال کنید.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"on-off\";s:7:\"section\";s:16:\"general_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:12;a:14:{s:2:\"id\";s:17:\"type_of_bg_header\";s:5:\"label\";s:76:\"نوع بک گراند بالای صفحات سایت را مشخص کنید\";s:4:\"desc\";s:865:\"دموی نوع اول: &lt;a href=&quot;https://cdn.zhaket.com/resources/5dca2013eaec37000920809f/5e2c016d80ce3b009d22a50d.png&quot; target=&quot;_blank&quot;&gt;روی من کلیک کن!&lt;/a&gt;&lt;br&gt;\r\n				دموی نوع دوم: &lt;a href=&quot;https://cdn.zhaket.com/resources/5dca2013eaec37000920809f/5e2c016ef0805900a0755e2b.png&quot; target=&quot;_blank&quot;&gt;روی من کلیک کن!&lt;/a&gt;&lt;br&gt;\r\n				دموی نوع سوم: &lt;a href=&quot;https://cdn.zhaket.com/resources/5dca2013eaec37000920809f/5e2c016e68cea800ad0844c7.png&quot; target=&quot;_blank&quot;&gt;روی من کلیک کن!&lt;/a&gt;&lt;br&gt;\r\n				دموی بدون بک گراند: &lt;a href=&quot;https://cdn.zhaket.com/resources/5dca2013eaec37000920809f/5e2c016f7d86e800af76eda8.png&quot; target=&quot;_blank&quot;&gt;روی من کلیک کن!&lt;/a&gt;&lt;br&gt;\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"select\";s:7:\"section\";s:20:\"shtemplates_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";s:7:\"choices\";a:4:{i:0;a:3:{s:5:\"value\";s:8:\"bg_first\";s:5:\"label\";s:13:\"نوع اول\";s:3:\"src\";s:0:\"\";}i:1;a:3:{s:5:\"value\";s:9:\"bg_second\";s:5:\"label\";s:13:\"نوع دوم\";s:3:\"src\";s:0:\"\";}i:2;a:3:{s:5:\"value\";s:8:\"bg_third\";s:5:\"label\";s:13:\"نوع سوم\";s:3:\"src\";s:0:\"\";}i:3;a:3:{s:5:\"value\";s:5:\"bg_no\";s:5:\"label\";s:24:\"بدون بک گراند\";s:3:\"src\";s:0:\"\";}}}i:13;a:14:{s:2:\"id\";s:22:\"default_template_posts\";s:5:\"label\";s:54:\"قالب پیش فرض صفحه‌ی نوشته‌ها\";s:4:\"desc\";s:347:\"شما می‌توانید برای هر نوشته هم، این مورد را تنظیم کنید. برای این کار، روی ویرایش نوشته کلیک کنید.\r\n				 سپس در سایدبار سمت چپ آن، از بخش ویژگی‌های نوشته &gt; قالب، روی گزینه‌ی مد نظر خود کلیک کنید.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"select\";s:7:\"section\";s:20:\"shtemplates_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";s:7:\"choices\";a:3:{i:0;a:3:{s:5:\"value\";s:6:\"noside\";s:5:\"label\";s:24:\"بدون ساید بار\";s:3:\"src\";s:0:\"\";}i:1;a:3:{s:5:\"value\";s:5:\"sidel\";s:5:\"label\";s:19:\"سایدبار چپ\";s:3:\"src\";s:0:\"\";}i:2;a:3:{s:5:\"value\";s:5:\"sider\";s:5:\"label\";s:23:\"سایدبار راست\";s:3:\"src\";s:0:\"\";}}}i:14;a:13:{s:2:\"id\";s:11:\"back_slider\";s:5:\"label\";s:61:\"تصویر بک گراند اسلایدر بالای سایت\";s:4:\"desc\";s:102:\"می‌توانید تصویری را انتخاب کنید تا در آن‌جا قرار بگیرد.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"upload\";s:7:\"section\";s:15:\"slider_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:15;a:14:{s:2:\"id\";s:14:\"position_bgimg\";s:5:\"label\";s:30:\"مکان نمایش تصویر\";s:4:\"desc\";s:90:\"تصویر بک گراند، در راست، چپ یا وسط نمایش داده شود؟\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"select\";s:7:\"section\";s:15:\"slider_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";s:7:\"choices\";a:3:{i:0;a:3:{s:5:\"value\";s:8:\"bg_right\";s:5:\"label\";s:8:\"راست\";s:3:\"src\";s:0:\"\";}i:1;a:3:{s:5:\"value\";s:9:\"bg_center\";s:5:\"label\";s:6:\"وسط\";s:3:\"src\";s:0:\"\";}i:2;a:3:{s:5:\"value\";s:7:\"bg_left\";s:5:\"label\";s:4:\"چپ\";s:3:\"src\";s:0:\"\";}}}i:16;a:13:{s:2:\"id\";s:15:\"slider_defult_h\";s:5:\"label\";s:42:\"متن اصلی سمت چپ اسلایدر\";s:4:\"desc\";s:81:\"به جای &quot;بیش از 1000 وبمستر&quot; در صفحه‌ی اصلی\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:15:\"slider_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:17;a:13:{s:2:\"id\";s:18:\"slider_defult_span\";s:5:\"label\";s:42:\"متن فرعی سمت چپ اسلایدر\";s:4:\"desc\";s:93:\"به جای &quot;و کسب و کار آنلاین موفق&quot; در صفحه‌ی اصلی\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:15:\"slider_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:18;a:13:{s:2:\"id\";s:16:\"slider_right_one\";s:5:\"label\";s:46:\"متن اصلی سمت راست اسلایدر\";s:4:\"desc\";s:83:\"به جای &quot;اینجا شروع آینده موفق شغلی شماست&quot;\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:15:\"slider_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:19;a:13:{s:2:\"id\";s:16:\"slider_right_two\";s:5:\"label\";s:46:\"متن فرعی سمت راست اسلایدر\";s:4:\"desc\";s:104:\"به جای &quot;کسب و کار اینترنتی خودتان را راه اندازی کنید&quot;\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:15:\"slider_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:20;a:13:{s:2:\"id\";s:14:\"slider_right_a\";s:5:\"label\";s:47:\"متن دکمه در اسلایدر سمت چپ\";s:4:\"desc\";s:68:\"به جای &quot;آموزش کسب و کار اینترنتی&quot;\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:15:\"slider_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:21;a:13:{s:2:\"id\";s:18:\"slider_button_link\";s:5:\"label\";s:37:\"لینک دکمه‌ی اسلایدر\";s:4:\"desc\";s:204:\"لینک دکمه‌ی اسلایدر سمت چپ را وارد کنید.\r\n&lt;br&gt;می‌توانید لینک یک برگه، لینک یکی از محصولات برتر و... را قرار دهید.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:15:\"slider_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:22;a:13:{s:2:\"id\";s:9:\"blog_link\";s:5:\"label\";s:45:\"لینک برگه‌ی &quot;وبلاگ&quot;\";s:4:\"desc\";s:224:\"لینک برگه‌ی وبلاگ را وارد کنید. (فقط نامک آدرس (یعنی بدون آدرس سایت شما))\r\n&lt;br&gt;مثلا: (فقط به این صورت باشد- بدون آدرس)&lt;br&gt;\r\nblog\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:13:\"links_sttings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:23;a:13:{s:2:\"id\";s:9:\"shop_link\";s:5:\"label\";s:132:\"لینک برگه‌ی &quot;فروشگاه&quot; یا در واقع همان &quot;همه‌ی دوره‌های آموزشی&quot;\";s:4:\"desc\";s:170:\"لینک برگه‌ی فروشگاه را وارد کنید. (فقط نامک آدرس (یعنی بدون آدرس سایت شما))\r\n&lt;br&gt;مثلا:&lt;br&gt;\r\nshop\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:13:\"links_sttings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:24;a:13:{s:2:\"id\";s:15:\"remove_bookarea\";s:5:\"label\";s:88:\"عدم نمایش باکس &quot;دانلود کتاب&quot; در صفحه‌ی اصلی\";s:4:\"desc\";s:171:\"با انتخاب &quot;ON&quot; نمایش داده می‌شود و &lt;br&gt;\r\nبا انتخاب &quot;OFF&quot; نمایش داده &lt;b&gt;نمی‌شود.&lt;/b&gt;\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"on-off\";s:7:\"section\";s:17:\"bookarea_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:25;a:13:{s:2:\"id\";s:6:\"book_p\";s:5:\"label\";s:52:\"به جای &quot;روایتی واقعی از&quot;\";s:4:\"desc\";s:0:\"\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:17:\"bookarea_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:26;a:13:{s:2:\"id\";s:7:\"book_h3\";s:5:\"label\";s:85:\"به جای &quot;ساختن کارخانه‌ی پولسازی در ایران&quot;\";s:4:\"desc\";s:0:\"\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:17:\"bookarea_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:27;a:13:{s:2:\"id\";s:9:\"book_span\";s:5:\"label\";s:78:\"به جای &quot;همین الان رایگان دانلود کنید!!&quot;\";s:4:\"desc\";s:0:\"\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:17:\"bookarea_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:28;a:13:{s:2:\"id\";s:15:\"book_button_txt\";s:5:\"label\";s:54:\"متن دکمه‌ی &quot;دانلود کتاب&quot;\";s:4:\"desc\";s:0:\"\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:17:\"bookarea_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:29;a:13:{s:2:\"id\";s:16:\"book_button_link\";s:5:\"label\";s:17:\"لینک دکمه\";s:4:\"desc\";s:0:\"\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:17:\"bookarea_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:30;a:13:{s:2:\"id\";s:8:\"book_img\";s:5:\"label\";s:19:\"تصویر کتاب\";s:4:\"desc\";s:113:\"تصویر سمت چپ از کتاب&lt;br&gt;\r\nسایز مناسب: ارتفاع: 350 در عرض:200 پیکسل\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"upload\";s:7:\"section\";s:17:\"bookarea_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:31;a:13:{s:2:\"id\";s:7:\"infos_p\";s:5:\"label\";s:59:\"به جای &quot;آمار و ارقام نشانگر&quot;\";s:4:\"desc\";s:0:\"\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:10:\"count_home\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:32;a:13:{s:2:\"id\";s:8:\"infos_h4\";s:5:\"label\";s:60:\"به جای &quot;موفقیت دانشجویان ما&quot;\";s:4:\"desc\";s:0:\"\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:10:\"count_home\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:33;a:13:{s:2:\"id\";s:10:\"infos_span\";s:5:\"label\";s:37:\"به جای &quot;می باشد&quot;\";s:4:\"desc\";s:0:\"\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:10:\"count_home\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:34;a:13:{s:2:\"id\";s:13:\"count_courses\";s:5:\"label\";s:41:\"تعداد دوره‌های آموزشی\";s:4:\"desc\";s:0:\"\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:10:\"count_home\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:35;a:13:{s:2:\"id\";s:13:\"infos_courses\";s:5:\"label\";s:45:\"متن &quot;دوره‌ی آموزشی&quot;\";s:4:\"desc\";s:0:\"\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:10:\"count_home\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:36;a:13:{s:2:\"id\";s:14:\"count_hamyaris\";s:5:\"label\";s:31:\"تعداد همیارجویان\";s:4:\"desc\";s:0:\"\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:10:\"count_home\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:37;a:13:{s:2:\"id\";s:14:\"infos_hamyaris\";s:5:\"label\";s:33:\"متن &quot;همیارجو&quot;\";s:4:\"desc\";s:0:\"\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:10:\"count_home\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:38;a:13:{s:2:\"id\";s:11:\"count_hours\";s:5:\"label\";s:32:\"تعداد ساعات آموزش\";s:4:\"desc\";s:0:\"\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:10:\"count_home\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:39;a:13:{s:2:\"id\";s:11:\"infos_hours\";s:5:\"label\";s:38:\"متن &quot;ساعت آموزش&quot;\";s:4:\"desc\";s:0:\"\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:10:\"count_home\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:40;a:13:{s:2:\"id\";s:13:\"count_oksells\";s:5:\"label\";s:38:\"تعداد فارغ التحصیلان\";s:4:\"desc\";s:0:\"\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:10:\"count_home\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:41;a:13:{s:2:\"id\";s:13:\"infos_oksells\";s:5:\"label\";s:42:\"متن &quot;فارغ التحصیل&quot;\";s:4:\"desc\";s:0:\"\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:10:\"count_home\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:42;a:13:{s:2:\"id\";s:19:\"remove_course_intro\";s:5:\"label\";s:72:\"حذف باکس &quot;معرفی دوره&quot; از تمام صفحات\";s:4:\"desc\";s:450:\"اگر روی ON قرار دهید، نمایش داده می‌شود (اگر در تنظیمات ویرایش محصول این باکس را تنظیم کنید که نمایش دهد ولی در تنظیمات اینجا در تمام صفحات غیرفعال باشد، نمایش نمی‌دهد) و&lt;br&gt;\r\nدر صورتی که روی &lt;b&gt;OFF&lt;/b&gt; قرار دهید، در تمام صفحات نمایش داده نمی‌شود.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"on-off\";s:7:\"section\";s:20:\"course_page_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:43;a:13:{s:2:\"id\";s:17:\"text_course_intro\";s:5:\"label\";s:33:\"متن بخش معرفی دوره\";s:4:\"desc\";s:89:\"این بخش را خالی بگذارید تا متن پیش فرض قرار بگیرد.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:20:\"course_page_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:44;a:13:{s:2:\"id\";s:21:\"remove_course_lessons\";s:5:\"label\";s:94:\"حذف باکس &quot;سرفصل‌های دوره&quot; از تمام صفحات (جدید!!)\";s:4:\"desc\";s:450:\"اگر روی ON قرار دهید، نمایش داده می‌شود (اگر در تنظیمات ویرایش محصول این باکس را تنظیم کنید که نمایش دهد ولی در تنظیمات اینجا در تمام صفحات غیرفعال باشد، نمایش نمی‌دهد) و&lt;br&gt;\r\nدر صورتی که روی &lt;b&gt;OFF&lt;/b&gt; قرار دهید، در تمام صفحات نمایش داده نمی‌شود.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"on-off\";s:7:\"section\";s:20:\"course_page_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:45;a:13:{s:2:\"id\";s:19:\"text_course_lessons\";s:5:\"label\";s:42:\"متن بخش سرفصل‌های دوره\";s:4:\"desc\";s:89:\"این بخش را خالی بگذارید تا متن پیش فرض قرار بگیرد.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:20:\"course_page_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:46;a:13:{s:2:\"id\";s:25:\"remove_course_requirement\";s:5:\"label\";s:76:\"حذف باکس &quot;مخاطبین دوره&quot; از تمام صفحات\";s:4:\"desc\";s:450:\"اگر روی ON قرار دهید، نمایش داده می‌شود (اگر در تنظیمات ویرایش محصول این باکس را تنظیم کنید که نمایش دهد ولی در تنظیمات اینجا در تمام صفحات غیرفعال باشد، نمایش نمی‌دهد) و&lt;br&gt;\r\nدر صورتی که روی &lt;b&gt;OFF&lt;/b&gt; قرار دهید، در تمام صفحات نمایش داده نمی‌شود.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"on-off\";s:7:\"section\";s:20:\"course_page_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:47;a:13:{s:2:\"id\";s:23:\"text_course_requirement\";s:5:\"label\";s:37:\"متن بخش مخاطبین دوره\";s:4:\"desc\";s:89:\"این بخش را خالی بگذارید تا متن پیش فرض قرار بگیرد.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:20:\"course_page_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:48;a:13:{s:2:\"id\";s:22:\"remove_course_teachers\";s:5:\"label\";s:70:\"حذف باکس &quot;مدرس دوره&quot; از تمام صفحات\";s:4:\"desc\";s:450:\"اگر روی ON قرار دهید، نمایش داده می‌شود (اگر در تنظیمات ویرایش محصول این باکس را تنظیم کنید که نمایش دهد ولی در تنظیمات اینجا در تمام صفحات غیرفعال باشد، نمایش نمی‌دهد) و&lt;br&gt;\r\nدر صورتی که روی &lt;b&gt;OFF&lt;/b&gt; قرار دهید، در تمام صفحات نمایش داده نمی‌شود.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"on-off\";s:7:\"section\";s:20:\"course_page_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:49;a:13:{s:2:\"id\";s:20:\"text_course_teachers\";s:5:\"label\";s:31:\"متن بخش مدرس دوره\";s:4:\"desc\";s:89:\"این بخش را خالی بگذارید تا متن پیش فرض قرار بگیرد.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:20:\"course_page_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:50;a:13:{s:2:\"id\";s:17:\"remove_course_faq\";s:5:\"label\";s:92:\"حذف باکس &quot;سوالات متداول&quot; از تمام صفحات (جدید!!!)\";s:4:\"desc\";s:913:\"&lt;span style=&quot;color:#F50057&quot;&gt;این المان جدید اضافه شده است. اگر این بخش را فعال کنید، حتما باید المنتور پرو را نصب کرده باشید.&lt;/span&gt;&lt;br&gt;\r\n				&lt;span style=&quot;color:#FFD000; background:#000;&quot;&gt;در صورتی که تمایل به استفاده از این المان دارید، یک بار off و مجدد on کنید.&lt;/span&gt;&lt;br&gt;\r\n				اگر روی ON قرار دهید، نمایش داده می‌شود (اگر در تنظیمات ویرایش محصول این باکس را تنظیم کنید که نمایش دهد ولی در تنظیمات اینجا در تمام صفحات غیرفعال باشد، نمایش نمی‌دهد) و&lt;br&gt;\r\nدر صورتی که روی &lt;b&gt;OFF&lt;/b&gt; قرار دهید، در تمام صفحات نمایش داده نمی‌شود.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"on-off\";s:7:\"section\";s:20:\"course_page_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:51;a:13:{s:2:\"id\";s:15:\"text_course_faq\";s:5:\"label\";s:52:\"متن بخش سوالات متداول (جدید!!)\";s:4:\"desc\";s:89:\"این بخش را خالی بگذارید تا متن پیش فرض قرار بگیرد.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:20:\"course_page_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:52;a:13:{s:2:\"id\";s:20:\"remove_course_advice\";s:5:\"label\";s:80:\"حذف باکس &quot;درخواست مشاوره&quot; از تمام صفحات\";s:4:\"desc\";s:450:\"اگر روی ON قرار دهید، نمایش داده می‌شود (اگر در تنظیمات ویرایش محصول این باکس را تنظیم کنید که نمایش دهد ولی در تنظیمات اینجا در تمام صفحات غیرفعال باشد، نمایش نمی‌دهد) و&lt;br&gt;\r\nدر صورتی که روی &lt;b&gt;OFF&lt;/b&gt; قرار دهید، در تمام صفحات نمایش داده نمی‌شود.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"on-off\";s:7:\"section\";s:20:\"course_page_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:53;a:13:{s:2:\"id\";s:18:\"text_course_advice\";s:5:\"label\";s:41:\"متن بخش درخواست مشاوره\";s:4:\"desc\";s:89:\"این بخش را خالی بگذارید تا متن پیش فرض قرار بگیرد.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:20:\"course_page_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:54;a:13:{s:2:\"id\";s:25:\"text_button_course_advice\";s:5:\"label\";s:48:\"متن دکمه‌ی درخواست مشاوره\";s:4:\"desc\";s:89:\"این بخش را خالی بگذارید تا متن پیش فرض قرار بگیرد.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:20:\"course_page_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:55;a:13:{s:2:\"id\";s:22:\"remove_course_register\";s:5:\"label\";s:80:\"حذف باکس &quot;ثبت نام در دوره&quot; از تمام صفحات\";s:4:\"desc\";s:450:\"اگر روی ON قرار دهید، نمایش داده می‌شود (اگر در تنظیمات ویرایش محصول این باکس را تنظیم کنید که نمایش دهد ولی در تنظیمات اینجا در تمام صفحات غیرفعال باشد، نمایش نمی‌دهد) و&lt;br&gt;\r\nدر صورتی که روی &lt;b&gt;OFF&lt;/b&gt; قرار دهید، در تمام صفحات نمایش داده نمی‌شود.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"on-off\";s:7:\"section\";s:20:\"course_page_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:56;a:13:{s:2:\"id\";s:20:\"text_course_register\";s:5:\"label\";s:41:\"متن بخش ثبت نام در دوره\";s:4:\"desc\";s:89:\"این بخش را خالی بگذارید تا متن پیش فرض قرار بگیرد.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:20:\"course_page_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:57;a:13:{s:2:\"id\";s:27:\"text_button_course_register\";s:5:\"label\";s:49:\"متن دکمه‌ی اطلاعات ثبت نام\";s:4:\"desc\";s:89:\"این بخش را خالی بگذارید تا متن پیش فرض قرار بگیرد.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:20:\"course_page_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:58;a:13:{s:2:\"id\";s:15:\"remove_comments\";s:5:\"label\";s:83:\"حذف باکس &quot;نظرات/دیدگاه‌ها&quot; از تمام صفحات\";s:4:\"desc\";s:450:\"اگر روی ON قرار دهید، نمایش داده می‌شود (اگر در تنظیمات ویرایش محصول این باکس را تنظیم کنید که نمایش دهد ولی در تنظیمات اینجا در تمام صفحات غیرفعال باشد، نمایش نمی‌دهد) و&lt;br&gt;\r\nدر صورتی که روی &lt;b&gt;OFF&lt;/b&gt; قرار دهید، در تمام صفحات نمایش داده نمی‌شود.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"on-off\";s:7:\"section\";s:20:\"course_page_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:59;a:13:{s:2:\"id\";s:13:\"text_comments\";s:5:\"label\";s:33:\"متن بخش دیدگاه‌ها\";s:4:\"desc\";s:89:\"این بخش را خالی بگذارید تا متن پیش فرض قرار بگیرد.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:20:\"course_page_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:60;a:13:{s:2:\"id\";s:22:\"remove_article_excerpt\";s:5:\"label\";s:70:\"عدم نمایش &quot;خلاصه&quot; در صفحه‌ی مقاله\";s:4:\"desc\";s:56:\"برای عدم نمایش روی OFF قرار دهید.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"on-off\";s:7:\"section\";s:13:\"post_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:61;a:13:{s:2:\"id\";s:18:\"remove_article_img\";s:5:\"label\";s:90:\"عدم نمایش &quot;تصویر شاخص نوشته&quot; در صفحه‌ی مقاله\";s:4:\"desc\";s:56:\"برای عدم نمایش روی OFF قرار دهید.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"on-off\";s:7:\"section\";s:13:\"post_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:62;a:13:{s:2:\"id\";s:21:\"remove_article_advice\";s:5:\"label\";s:96:\"عدم نمایش &quot;باکس درخواست مشاوره&quot; در صفحه‌ی مقاله\";s:4:\"desc\";s:56:\"برای عدم نمایش روی OFF قرار دهید.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"on-off\";s:7:\"section\";s:13:\"post_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:63;a:13:{s:2:\"id\";s:16:\"first_color_wwsh\";s:5:\"label\";s:24:\"رنگ اصلی قالب\";s:4:\"desc\";s:108:\"رنگ پیش فرض این قالب: &quot;قرمز&quot; - رنگ خودتان را انتخاب کنید.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:19:\"colorpicker-opacity\";s:7:\"section\";s:14:\"color_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:64;a:13:{s:2:\"id\";s:22:\"hover_first_color_wwsh\";s:5:\"label\";s:33:\"هاور رنگ اصلی قالب\";s:4:\"desc\";s:203:\"رنگ هاور یعنی &quot;وقتی موس روی هر المانی (بخشی از سایت، مثل دکمه و...) می‌رود، بک گراند یا رنگ متن آن چه رنگی شود&quot;\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:19:\"colorpicker-opacity\";s:7:\"section\";s:14:\"color_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:65;a:13:{s:2:\"id\";s:17:\"second_color_wwsh\";s:5:\"label\";s:13:\"رنگ دوم\";s:4:\"desc\";s:187:\"رنگ پیش فرض دوم این قالب: &quot;آبی&quot; - رنگ دوم خود را انتخاب کنید. این رنگ برای دکمه ها و... استفاده می‌شود.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:19:\"colorpicker-opacity\";s:7:\"section\";s:14:\"color_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:66;a:13:{s:2:\"id\";s:23:\"hover_second_color_wwsh\";s:5:\"label\";s:22:\"هاور رنگ دوم\";s:4:\"desc\";s:0:\"\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:19:\"colorpicker-opacity\";s:7:\"section\";s:14:\"color_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:67;a:13:{s:2:\"id\";s:21:\"inside_fff_000_second\";s:5:\"label\";s:40:\"رنگ داخلی برای رنگ سوم\";s:4:\"desc\";s:596:\"رنگ سوم، بیشتر برای رنگ بک‌گراند دکمه ها به کار می‌رود.&lt;br&gt;\r\n				 اگر رنگ سوم، تیره است باید رنگ داخلی اش سفید باشد (متن درون دکمه با رنگ بک گراند &quot;رنگ سوم&quot;) و اگر روشن است، باید رنگ داخلی اش سیاه باشد.&lt;br&gt;&lt;br&gt;\r\n				  اگر روی ON قرار دهید، رنگ داخلی &lt;b&gt;سیاه&lt;/b&gt; خواهد بود و در صورتی که روی OFF باشد، &lt;b&gt;سفید&lt;/b&gt; انتخاب می‌شود.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"on-off\";s:7:\"section\";s:14:\"color_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:68;a:13:{s:2:\"id\";s:16:\"third_color_wwsh\";s:5:\"label\";s:13:\"رنگ سوم\";s:4:\"desc\";s:194:\"رنگ پیش فرض سوم این قالب: &quot;زرد&quot; - رنگ سوم خود را انتخاب کنید. این رنگ برای دکمه‌ی هدر و... استفاده می‌شود.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:19:\"colorpicker-opacity\";s:7:\"section\";s:14:\"color_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:69;a:13:{s:2:\"id\";s:22:\"hover_third_color_wwsh\";s:5:\"label\";s:22:\"هاور رنگ سوم\";s:4:\"desc\";s:0:\"\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:19:\"colorpicker-opacity\";s:7:\"section\";s:14:\"color_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:70;a:13:{s:2:\"id\";s:18:\"footer_first_color\";s:5:\"label\";s:22:\"رنگ اول فوتر\";s:4:\"desc\";s:92:\"رنگ اول فوتر را انتخاب کنید. (فوتر دارای دو رنگ است.)\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:19:\"colorpicker-opacity\";s:7:\"section\";s:14:\"color_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:71;a:13:{s:2:\"id\";s:19:\"footer_second_color\";s:5:\"label\";s:22:\"رنگ دوم فوتر\";s:4:\"desc\";s:92:\"رنگ دوم فوتر را انتخاب کنید. (فوتر دارای دو رنگ است.)\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:19:\"colorpicker-opacity\";s:7:\"section\";s:14:\"color_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:72;a:13:{s:2:\"id\";s:17:\"header-back-color\";s:5:\"label\";s:43:\"رنگ بک گراند هدر (جدید!!!)\";s:4:\"desc\";s:153:\"رنگ بک گراند هدر را انتخاب کنید. (توصیه می‌شود همان رنگ سفید باشد که حالت پیش فرض هست)\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:19:\"colorpicker-opacity\";s:7:\"section\";s:14:\"color_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:73;a:13:{s:2:\"id\";s:25:\"enable_mobile_menu_notice\";s:5:\"label\";s:49:\"فعالسازی اعلان منوی موبایل\";s:4:\"desc\";s:215:\"در منوی بازشونده در موبایل، گزینه‌ای تبلیغاتی اضافه می‌شود. مثلا تبلیغ دوره‌ی شما یا جشنواره و تخفیف ویژه در آن هفته!\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"on-off\";s:7:\"section\";s:11:\"menu_notice\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:74;a:13:{s:2:\"id\";s:11:\"notic_title\";s:5:\"label\";s:45:\"عنوان/توضیحات اصلی اعلان\";s:4:\"desc\";s:119:\"در بخش بالایی و به‌عنوان متن اصلی و توضیح اصلی نمایش داده می‌شود.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:11:\"menu_notice\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:75;a:13:{s:2:\"id\";s:13:\"notic_btn_txt\";s:5:\"label\";s:31:\"متن دکمه‌ی اعلان\";s:4:\"desc\";s:179:\"عنوان دکمه‌ی دعوت به اقدام (call to action) برای باز شدن اعلان. (مثلا لینک صفحه‌ی دوره‌ی شما یا غیره باشد)\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:11:\"menu_notice\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:76;a:13:{s:2:\"id\";s:14:\"notic_btn_link\";s:5:\"label\";s:33:\"لینک دکمه‌ی اعلان\";s:4:\"desc\";s:147:\"در اینجا هم لینک آن دکمه را وارد کنید. (لینکی که با کلیک روی دکمه، وارد آن می‌شوند)\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:11:\"menu_notice\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:77;a:13:{s:2:\"id\";s:22:\"enable_mobile_fast_reg\";s:5:\"label\";s:83:\"فعالسازی دکمه‌ی ثبت‌نام سریع در صفحه‌ی دوره\";s:4:\"desc\";s:331:\"\r\n				با فعال بودن این تنظیم، در پایین تمام صفحات دوره در سایت شما، دکمه‌ای اضافه می‌شود که کاربر با\r\n				 کلیک روی آن، می‌توانید سریعا به باکس اطلاعات ثبت‌نام در همان صفحه منتقل شود.\r\n				\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"on-off\";s:7:\"section\";s:15:\"fast_reg_mobile\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:78;a:13:{s:2:\"id\";s:23:\"mobile_fast_reg_btn_txt\";s:5:\"label\";s:22:\"متن این دکمه\";s:4:\"desc\";s:95:\"متن برای این دکمه.<br>\r\n				مثلا: همین الان ثبت‌نام کنید!\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:15:\"fast_reg_mobile\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:79;a:13:{s:2:\"id\";s:8:\"your_css\";s:5:\"label\";s:18:\"CSS اختصاصی\";s:4:\"desc\";s:162:\"برای اضافه کردن CSS دلخواه و اختصاصی خودتان، لطفا &lt;strong&gt;تنها&lt;/strong&gt; از اینجا اقدام کنید.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:15:\"textarea-simple\";s:7:\"section\";s:12:\"css_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:80;a:13:{s:2:\"id\";s:10:\"top_form_p\";s:5:\"label\";s:24:\"متن بالای فرم\";s:4:\"desc\";s:337:\"متن قبل از فرم.&lt;br&gt;\r\nبه جای متن &quot;شما این فرصت را دارید، با تکمیل فرم زیر، قبل از انتخاب دوره آموزشی مناسب خود، از مشاوره رایگان کارشناسان آموزشی مجموعه همیار آکادمی استفاده نمائید.&quot;\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:15:\"textarea-simple\";s:7:\"section\";s:10:\"advice_box\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:81;a:13:{s:2:\"id\";s:14:\"first_advice_h\";s:5:\"label\";s:65:\"متن اول به جای &quot;مشاوران آموزشی&quot;\";s:4:\"desc\";s:70:\"به جای &quot;مشاوران آموزشی&quot; در باکس چپ\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:10:\"advice_box\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:82;a:13:{s:2:\"id\";s:15:\"second_advice_h\";s:5:\"label\";s:55:\"متن دوم به جای &quot;همیار لرن&quot;\";s:4:\"desc\";s:60:\"به جای &quot;همیار لرن&quot; در باکس چپ\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:10:\"advice_box\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:83;a:13:{s:2:\"id\";s:14:\"third_advice_p\";s:5:\"label\";s:70:\"متن سوم به جای &quot;پاسخگوی شما هستند&quot;\";s:4:\"desc\";s:75:\"به جای &quot;پاسخگوی شما هستند&quot; در باکس چپ\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:10:\"advice_box\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:84;a:13:{s:2:\"id\";s:23:\"background_style_advice\";s:5:\"label\";s:47:\"بک گراند (پس زمینه) باکس چپ\";s:4:\"desc\";s:208:\"تصویر بک گراند را انتخاب کنید.\r\n&lt;br&gt;تصویر بک گراند پیش فرض:&lt;br&gt;\r\nآدرس سایت شما +&lt;br&gt;\r\nwp-content/themes/hamyarlearn/img/lightbox_back.jpg\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"upload\";s:7:\"section\";s:10:\"advice_box\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:85;a:13:{s:2:\"id\";s:18:\"show_number_advice\";s:5:\"label\";s:48:\"شماره تماس نمایش داده شود؟\";s:4:\"desc\";s:122:\"با انتخاب ON ، نمایش داده می‌شود و با انتخاب OFF ، نمایش داده نمی‌شود.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"on-off\";s:7:\"section\";s:10:\"advice_box\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:86;a:13:{s:2:\"id\";s:18:\"call_number_advice\";s:5:\"label\";s:20:\"شماره تماس:\";s:4:\"desc\";s:50:\"شماره تماس تان را وارد کنید.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:10:\"advice_box\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:87;a:13:{s:2:\"id\";s:17:\"phone_link_advice\";s:5:\"label\";s:28:\"لینک شماره تماس\";s:4:\"desc\";s:412:\"اگر برای مثال شماره تماس شما 02123456 باشد، باید در این بخش به عنوان لینک این عبارت را وارد کنید:&lt;br&gt;\r\ntel://+98 2123456&lt;br&gt;\r\nعبارت بالا را کپی کنید و با شماره‌ خودتان جایگزین کنید. (در واقع باید بدون صفر در اول شماره، شماره تان را بنویسید.)\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:10:\"advice_box\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:88;a:13:{s:2:\"id\";s:20:\"show_telegram_advice\";s:5:\"label\";s:41:\"تلگرام نمایش داده شود؟\";s:4:\"desc\";s:122:\"با انتخاب ON ، نمایش داده می‌شود و با انتخاب OFF ، نمایش داده نمی‌شود.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"on-off\";s:7:\"section\";s:10:\"advice_box\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:89;a:13:{s:2:\"id\";s:18:\"telegram_id_advice\";s:5:\"label\";s:13:\"تلگرام:\";s:4:\"desc\";s:189:\"ID تلگرام تان را وارد کنید.&lt;br&gt;\r\nمثال: t.me/shayanwebcom&lt;br&gt;\r\nنکته: در ابتدا http:// یا https:// را وارد &lt;b&gt;نکنید.&lt;/b&gt;\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:10:\"advice_box\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:90;a:14:{s:2:\"id\";s:9:\"form_saaz\";s:5:\"label\";s:58:\"از چه فرم سازی استفاده می‌کنید؟\";s:4:\"desc\";s:1240:\"فرم ساز خود را برای فرم درخواست مشاوره انتخاب کنید.&lt;br&gt;\r\nدر صورتی که گرویتی فرمز را انتخاب کردید: &lt;a href=&quot;#setting_advice_gravityforms&quot;&gt;من را کلیک کن!!&lt;/a&gt;&lt;br&gt;\r\nدر صورتی که فرم ساز 7 را انتخاب کردید: &lt;a href=&quot;#setting_advice_contactform7&quot;&gt;من را کلیک کن!!&lt;/a&gt;&lt;br&gt;\r\nدر صورتی که سایر را انتخاب کردید: &lt;a href=&quot;#advice_others&quot;&gt;من را کلیک کن!!&lt;/a&gt;&lt;br&gt;\r\n&lt;br&gt;&lt;br&gt; توصیه‌ی ما این است که تا جایی که ممکن است، از گرویتی فرمز استفاده کنید چون قالب ما، سازگاری بیشتری با آن دارد و خودتان نیز بسیار راحتتر هستید. اما در غیر این صورت، از فرم ساز7 استفاده کنید که رایگان است . در صورتی که هیچ کدام از این دو فرم‌ساز برای شما قابل استفاده نبود، نهایتا مجبور به استفاده از سایر فرم سازها هستید که باید به شما شورتکد بدهند.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"select\";s:7:\"section\";s:11:\"advice_form\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";s:7:\"choices\";a:3:{i:0;a:3:{s:5:\"value\";s:23:\"selected_gravity_advice\";s:5:\"label\";s:37:\"گرویتی فرمز (Gravity Forms)\";s:3:\"src\";s:0:\"\";}i:1;a:3:{s:5:\"value\";s:21:\"selected_form7_advice\";s:5:\"label\";s:32:\"فرم ساز 7 (Contact Form 7)\";s:3:\"src\";s:0:\"\";}i:2;a:3:{s:5:\"value\";s:22:\"selected_others_advice\";s:5:\"label\";s:31:\"سایر فرم‌سازها...\";s:3:\"src\";s:0:\"\";}}}i:91;a:13:{s:2:\"id\";s:19:\"advice_gravityforms\";s:5:\"label\";s:46:\"ID فرم گرویتی فرمز (GravityForms)\";s:4:\"desc\";s:989:\"&lt;div style=&quot;line-height:25px&quot;&gt;\r\nID فرم گرویتی فرمز.&lt;br&gt;این آی دی را که به صورت عدد است، می‌توانید در باکس قرمز رنگ، هنگام ساختن فرم ببینید. (در بخش بالا نوشته. مثلا:\r\n&lt;span style=&quot;background:#D4662C;color:#fff;padding:3px&quot;&gt;ID:4&lt;/span&gt; )\r\n&lt;/div&gt;\r\n&lt;br&gt;\r\n&lt;br&gt;\r\nلینک‌های کاربردی:\r\n&lt;br&gt;\r\n&lt;a href=&quot;https://zhaket.com/product/gravity-forms-farsi/&quot; target=&quot;_blank&quot;&gt;دریافت گرویتی فرمز&lt;/a&gt;\r\n&lt;br&gt;\r\n&lt;a href=&quot;https://shayanweb.com/soon&quot; target=&quot;_blank&quot;&gt;فایل درون ریز گرویتی فرمز (فرم نمونه که با درون ریزی کردن این فرم در گرویتی فرمز و وارد کردن آی دی آن در این بخش، فرم را با ظاهری مناسب نمایش می‌دهد)&lt;/a&gt;\r\n&lt;br&gt;\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:11:\"advice_form\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:92;a:13:{s:2:\"id\";s:19:\"advice_contactform7\";s:5:\"label\";s:44:\"ID فرم فرم‌ساز 7 (Contact Form 7)\";s:4:\"desc\";s:607:\"ID فرم فرم‌ساز 7.&lt;br&gt;این آی دی را که به صورت عدد است، می‌توانید در لیست فرم‌های فرم‌ساز7، در بخش &quot;کدکوتاه&quot; به این صورت نوشته:\r\n&lt;br&gt;&lt;br&gt;\r\n&lt;span style=&quot;direction:ltr;background:#333;padding:5px;border-radius:5px;color:#fff&quot;&gt;\r\n[contact-form-7 id=&quot;150&quot; title=&quot;name&quot;]\r\n&lt;/span&gt;&lt;br&gt;&lt;br&gt;\r\nکه در این کد، نوشته‌ی id=&quot;number&quot; وجود دارد. باید number آی دی را بنویسید. (در این فیلد)\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:11:\"advice_form\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:93;a:13:{s:2:\"id\";s:13:\"advice_others\";s:5:\"label\";s:43:\"شورت کد سایر فرم ساز‌ها\";s:4:\"desc\";s:868:\"اگر از گرویتی فرمز یا فرم ساز7 استفاده نمی‌کنید (که پیشنهاد ما این است که حتما از این دو مورد استفاده کنید)، می‌توانید از فرم‌سازهای دیگر نیز استفاده کنید، ولی ممکن است مشکلاتی در استایل داشته باشند و فاصله‌های اضافه و... داشته باشند.\r\n&lt;br&gt;\r\nبه هر حال، در صورتی که از دیگر فرم ساز ها استفاده می‌کنید، شورتکدی که به شما می‌دهد را وارد کنید. تنها راه نمایش، استفاده از این شورتکد ها است و در صورتی که فرم‌ساز مدنظر شما شورتکد (ShortCode) نمی‌دهد، راهی برای نمایش آن در این بخش وجود ندارد.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:11:\"advice_form\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:94;a:13:{s:2:\"id\";s:22:\"remove_address_footbox\";s:5:\"label\";s:21:\"نمایش آدرس؟\";s:4:\"desc\";s:122:\"با انتخاب ON ، نمایش داده می‌شود و با انتخاب OFF ، نمایش داده نمی‌شود.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"on-off\";s:7:\"section\";s:15:\"footer_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:95;a:13:{s:2:\"id\";s:15:\"address_footbox\";s:5:\"label\";s:9:\"آدرس:\";s:4:\"desc\";s:218:\"آدرس تان را وارد کنید.\r\n&lt;br&gt;\r\nمثلا: تهران، پاسداران، بوستان دوم، خیابان گیلان غربی، بن بست مریم، پلاک ۲، طبقه اول، واحد ۱\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:15:\"footer_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:96;a:13:{s:2:\"id\";s:20:\"remove_phone_footbox\";s:5:\"label\";s:32:\"نمایش شماره تماس؟\";s:4:\"desc\";s:122:\"با انتخاب ON ، نمایش داده می‌شود و با انتخاب OFF ، نمایش داده نمی‌شود.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"on-off\";s:7:\"section\";s:15:\"footer_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:97;a:13:{s:2:\"id\";s:13:\"phone_footbox\";s:5:\"label\";s:20:\"شماره تماس:\";s:4:\"desc\";s:97:\"شماره تماس تان را وارد کنید.\r\n&lt;br&gt;\r\nمثلا:\r\n۰۲۱۷۴۵۵۳۰۰۰\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:15:\"footer_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:98;a:13:{s:2:\"id\";s:18:\"link_phone_footbox\";s:5:\"label\";s:37:\"لینک شماره تماس فوتر\";s:4:\"desc\";s:412:\"اگر برای مثال شماره تماس شما 02123456 باشد، باید در این بخش به عنوان لینک این عبارت را وارد کنید:&lt;br&gt;\r\ntel://+98 2123456&lt;br&gt;\r\nعبارت بالا را کپی کنید و با شماره‌ خودتان جایگزین کنید. (در واقع باید بدون صفر در اول شماره، شماره تان را بنویسید.)\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:15:\"footer_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:99;a:13:{s:2:\"id\";s:15:\"youtube_scoials\";s:5:\"label\";s:21:\"لینک یوتیوب\";s:4:\"desc\";s:114:\"در صورت خالی گذاشتن این بخش، آیکون یوتیوب نمایش داده نخواهد شد.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:16:\"scoials_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:100;a:13:{s:2:\"id\";s:11:\"rss_scoials\";s:5:\"label\";s:12:\"لینک rss\";s:4:\"desc\";s:105:\"در صورت خالی گذاشتن این بخش، آیکون rss نمایش داده نخواهد شد.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:16:\"scoials_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:101;a:13:{s:2:\"id\";s:16:\"telegram_scoials\";s:5:\"label\";s:21:\"لینک تلگرام\";s:4:\"desc\";s:114:\"در صورت خالی گذاشتن این بخش، آیکون تلگرام نمایش داده نخواهد شد.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:16:\"scoials_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:102;a:13:{s:2:\"id\";s:13:\"insta_scoials\";s:5:\"label\";s:29:\"لینک اینستاگرام\";s:4:\"desc\";s:122:\"در صورت خالی گذاشتن این بخش، آیکون اینستاگرام نمایش داده نخواهد شد.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:16:\"scoials_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:103;a:13:{s:2:\"id\";s:14:\"google_scoials\";s:5:\"label\";s:18:\"لینک گوگل+\";s:4:\"desc\";s:111:\"در صورت خالی گذاشتن این بخش، آیکون گوگل+ نمایش داده نخواهد شد.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:16:\"scoials_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:104;a:13:{s:2:\"id\";s:12:\"twit_scoials\";s:5:\"label\";s:21:\"لینک توئیتر\";s:4:\"desc\";s:114:\"در صورت خالی گذاشتن این بخش، آیکون توئیتر نمایش داده نخواهد شد.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:16:\"scoials_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:105;a:13:{s:2:\"id\";s:12:\"face_scoials\";s:5:\"label\";s:21:\"لینک فیسبوک\";s:4:\"desc\";s:114:\"در صورت خالی گذاشتن این بخش، آیکون فیسبوک نمایش داده نخواهد شد.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:7:\"section\";s:16:\"scoials_settings\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:106;a:13:{s:2:\"id\";s:22:\"count_products_in_home\";s:5:\"label\";s:53:\"تعداد محصولات در صفحه‌ی اصلی\";s:4:\"desc\";s:83:\"چه تعداد محصول در صفحه‌ی اصلی نمایش داده شود؟\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:14:\"numeric-slider\";s:7:\"section\";s:14:\"count_products\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:107;a:13:{s:2:\"id\";s:29:\"count_products_in_archivepros\";s:5:\"label\";s:69:\"تعداد محصولات در هر صفحه از آرشیو دوره\";s:4:\"desc\";s:168:\"تعداد محصولات در هر صفحه از آرشیو دوره (شامل صفحه‌ی همه‌ی دوره‌ها، آرشیو دسته بندی دوره و...)\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:14:\"numeric-slider\";s:7:\"section\";s:14:\"count_products\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}i:108;a:13:{s:2:\"id\";s:17:\"footer_codes_wwsh\";s:5:\"label\";s:52:\"کدهای خود را اینجا وارد کنید.\";s:4:\"desc\";s:420:\"کدهای خود را در اینجا وارد کنید. (کدهای گوگل آنالیتیکس و...)&lt;br&gt;\r\nهمچنین برای کدهای &lt;b&gt;جاوا اسکریپت&lt;/b&gt; هم می‌توانید از این بخش استفاده کنید. (با باز کردن تگ html برای جاوا اسکریپت، یعنی تگ script - فراموش نکنید که حتما این تگ را ببندید.)\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:15:\"textarea-simple\";s:7:\"section\";s:17:\"footer_wwsh_codes\";s:4:\"rows\";s:0:\"\";s:9:\"post_type\";s:0:\"\";s:8:\"taxonomy\";s:0:\"\";s:12:\"min_max_step\";s:0:\"\";s:5:\"class\";s:0:\"\";s:9:\"condition\";s:0:\"\";s:8:\"operator\";s:3:\"and\";}}}", "yes");
INSERT INTO `hm_options` VALUES("148", "shwebhmcode", "6cdd3ba615a173659a650ea7581a2ef4", "yes");
INSERT INTO `hm_options` VALUES("150", "ot_media_post_ID", "5", "yes");
INSERT INTO `hm_options` VALUES("154", "wpcf7", "a:2:{s:7:\"version\";s:3:\"5.3\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1594375572;s:7:\"version\";s:3:\"5.2\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}", "yes");
INSERT INTO `hm_options` VALUES("155", "duplicator_settings", "a:17:{s:7:\"version\";s:6:\"1.3.40\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";s:1:\"0\";s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";s:1:\"0\";s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";s:1:\"2\";s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:6;}", "yes");
INSERT INTO `hm_options` VALUES("157", "duplicator_version_plugin", "1.3.40", "yes");
INSERT INTO `hm_options` VALUES("176", "itsec-storage", "a:4:{s:6:\"global\";a:35:{s:15:\"lockout_message\";s:5:\"error\";s:20:\"user_lockout_message\";s:64:\"You have been locked out due to too many invalid login attempts.\";s:25:\"community_lockout_message\";s:77:\"Your IP address has been flagged as a threat by the iThemes Security network.\";s:9:\"blacklist\";b:1;s:15:\"blacklist_count\";i:3;s:16:\"blacklist_period\";i:7;s:14:\"lockout_period\";i:15;s:18:\"lockout_white_list\";a:0:{}s:12:\"log_rotation\";i:60;s:17:\"file_log_rotation\";i:180;s:8:\"log_type\";s:8:\"database\";s:12:\"log_location\";s:67:\"C:/laragon/www/hamyarlearn/wp-content/uploads/ithemes-security/logs\";s:8:\"log_info\";s:0:\"\";s:14:\"allow_tracking\";b:0;s:11:\"write_files\";b:1;s:10:\"nginx_file\";s:37:\"C:/laragon/www/hamyarlearn/nginx.conf\";s:24:\"infinitewp_compatibility\";b:0;s:11:\"did_upgrade\";b:0;s:9:\"lock_file\";b:0;s:5:\"proxy\";s:9:\"automatic\";s:12:\"proxy_header\";s:20:\"HTTP_X_FORWARDED_FOR\";s:14:\"hide_admin_bar\";b:0;s:16:\"show_error_codes\";b:0;s:19:\"show_security_check\";b:0;s:5:\"build\";i:4121;s:13:\"initial_build\";i:4118;s:20:\"activation_timestamp\";i:1594375572;s:11:\"cron_status\";i:1;s:8:\"use_cron\";b:1;s:14:\"cron_test_time\";i:1606950682;s:19:\"enable_grade_report\";b:0;s:10:\"server_ips\";a:0:{}s:13:\"feature_flags\";a:0:{}s:12:\"manage_group\";a:0:{}s:24:\"licensed_hostname_prompt\";b:0;}s:11:\"user-groups\";a:1:{s:14:\"default_groups\";a:5:{s:13:\"administrator\";s:36:\"1e8c1a50-fe27-4da2-b665-d56150ab13aa\";s:6:\"editor\";s:36:\"1766f5f1-ff17-43eb-b356-35581ae4f376\";s:6:\"author\";s:36:\"3da3c2b7-fb74-4b30-b2cb-3a0067d2410a\";s:11:\"contributor\";s:36:\"de1f08ab-af12-4e5e-949b-4d91617d32ec\";s:10:\"subscriber\";s:36:\"016b6b7f-c721-4a9a-94ba-df6a3558fbc1\";}}s:19:\"notification-center\";a:8:{s:9:\"last_sent\";a:1:{s:6:\"digest\";i:1603630397;}s:9:\"resend_at\";a:1:{s:6:\"digest\";i:1606861998;}s:4:\"data\";a:1:{s:6:\"digest\";a:0:{}}s:15:\"last_mail_error\";s:45:\"Invalid address:  (From): wordpress@localhost\";s:13:\"notifications\";a:3:{s:6:\"digest\";a:5:{s:8:\"schedule\";s:5:\"daily\";s:7:\"enabled\";b:1;s:9:\"user_list\";a:1:{i:0;s:18:\"role:administrator\";}s:14:\"recipient_type\";s:7:\"default\";s:7:\"subject\";N;}s:7:\"lockout\";a:4:{s:7:\"enabled\";b:1;s:9:\"user_list\";a:1:{i:0;s:18:\"role:administrator\";}s:14:\"recipient_type\";s:7:\"default\";s:7:\"subject\";N;}s:6:\"backup\";a:2:{s:10:\"email_list\";a:1:{i:0;s:14:\"info@email.com\";}s:7:\"subject\";N;}}s:12:\"admin_emails\";a:0:{}s:10:\"from_email\";s:0:\"\";s:18:\"default_recipients\";a:1:{s:9:\"user_list\";a:1:{i:0;s:18:\"role:administrator\";}}}s:16:\"wordpress-tweaks\";a:13:{s:18:\"wlwmanifest_header\";b:0;s:14:\"edituri_header\";b:0;s:12:\"comment_spam\";b:0;s:11:\"file_editor\";b:1;s:14:\"disable_xmlrpc\";i:0;s:22:\"allow_xmlrpc_multiauth\";b:0;s:8:\"rest_api\";s:14:\"default-access\";s:12:\"login_errors\";b:0;s:21:\"force_unique_nicename\";b:0;s:27:\"disable_unused_author_pages\";b:0;s:16:\"block_tabnapping\";b:0;s:21:\"valid_user_login_type\";s:4:\"both\";s:26:\"patch_thumb_file_traversal\";b:1;}}", "yes");
INSERT INTO `hm_options` VALUES("177", "learndash_data_settings", "a:12:{s:10:\"db_version\";s:3:\"2.5\";s:15:\"version_history\";a:3:{i:1604252137;s:7:\"3.2.3.5\";i:1594375576;s:5:\"3.1.8\";i:0;s:3:\"new\";}s:13:\"prior_version\";s:5:\"3.1.8\";s:15:\"current_version\";s:7:\"3.2.3.5\";s:23:\"rename-wpproquiz-tables\";a:2:{s:8:\"prefixes\";a:2:{s:7:\"current\";s:10:\"learndash_\";s:3:\"alt\";s:3:\"wp_\";}s:12:\"show_upgrade\";b:0;}s:17:\"user-meta-courses\";a:3:{s:8:\"last_run\";i:1594375578;s:7:\"user_id\";i:1;s:7:\"version\";s:3:\"2.5\";}s:17:\"user-meta-quizzes\";a:3:{s:8:\"last_run\";i:1594375578;s:7:\"user_id\";i:1;s:7:\"version\";s:3:\"2.5\";}s:27:\"course-access-lists-convert\";a:3:{s:8:\"last_run\";i:1594375578;s:7:\"user_id\";i:1;s:7:\"version\";s:3:\"2.5\";}s:18:\"pro-quiz-questions\";a:3:{s:8:\"last_run\";i:1604252139;s:7:\"user_id\";i:2;s:7:\"version\";s:3:\"2.5\";}s:22:\"translations_installed\";i:1604252144;s:15:\"gl_role_created\";i:1604252144;s:10:\"is_upgrade\";b:0;}", "yes");
INSERT INTO `hm_options` VALUES("179", "wpProQuiz_dbVersion", "22", "yes");
INSERT INTO `hm_options` VALUES("180", "wpProQuiz_version", "0.28", "yes");
INSERT INTO `hm_options` VALUES("181", "learn_press_logout_redirect_page_id", "", "yes");
INSERT INTO `hm_options` VALUES("182", "learn_press_currency", "IRR", "yes");
INSERT INTO `hm_options` VALUES("183", "learn_press_currency_pos", "right_with_space", "yes");
INSERT INTO `hm_options` VALUES("184", "learn_press_thousands_separator", ",", "yes");
INSERT INTO `hm_options` VALUES("185", "learn_press_decimals_separator", ".", "yes");
INSERT INTO `hm_options` VALUES("186", "learn_press_number_of_decimals", "0", "yes");
INSERT INTO `hm_options` VALUES("187", "learn_press_required_review", "yes", "yes");
INSERT INTO `hm_options` VALUES("188", "learn_press_enable_edit_published", "yes", "yes");
INSERT INTO `hm_options` VALUES("189", "learn_press_courses_page_id", "21", "yes");
INSERT INTO `hm_options` VALUES("190", "learn_press_archive_course_limit", "10", "yes");
INSERT INTO `hm_options` VALUES("191", "learn_press_course_category_base", "course-category", "yes");
INSERT INTO `hm_options` VALUES("192", "learn_press_course_tag_base", "course-tag", "yes");
INSERT INTO `hm_options` VALUES("193", "learn_press_course_base", "", "yes");
INSERT INTO `hm_options` VALUES("194", "learn_press_lesson_slug", "lessons", "yes");
INSERT INTO `hm_options` VALUES("195", "learn_press_quiz_slug", "quizzes", "yes");
INSERT INTO `hm_options` VALUES("196", "learn_press_enrolled_students_number", "quizzes", "yes");
INSERT INTO `hm_options` VALUES("197", "learn_press_archive_course_thumbnail", "yes", "yes");
INSERT INTO `hm_options` VALUES("198", "learn_press_course_thumbnail_image_size", "a:3:{i:0;i:400;i:1;i:250;i:2;s:3:\"yes\";}", "yes");
INSERT INTO `hm_options` VALUES("199", "learn_press_become_a_teacher_page_id", "23", "yes");
INSERT INTO `hm_options` VALUES("200", "learn_press_instructor_registration", "no", "yes");
INSERT INTO `hm_options` VALUES("201", "learn_press_profile_page_id", "22", "yes");
INSERT INTO `hm_options` VALUES("202", "learn_press_admin_bar_link", "yes", "yes");
INSERT INTO `hm_options` VALUES("203", "learn_press_admin_bar_link_text", "", "yes");
INSERT INTO `hm_options` VALUES("204", "learn_press_admin_bar_link_target", "yes", "yes");
INSERT INTO `hm_options` VALUES("205", "learn_press_profile_courses_limit", "10", "yes");
INSERT INTO `hm_options` VALUES("206", "learn_press_enable_login_profile", "no", "yes");
INSERT INTO `hm_options` VALUES("207", "learn_press_enable_register_profile", "no", "yes");
INSERT INTO `hm_options` VALUES("208", "learn_press_profile_endpoints", "a:9:{s:17:\"profile-dashboard\";s:9:\"dashboard\";s:15:\"profile-courses\";s:7:\"courses\";s:15:\"profile-quizzes\";s:7:\"quizzes\";s:14:\"profile-orders\";s:6:\"orders\";s:21:\"profile-order-details\";s:13:\"order-details\";s:16:\"profile-settings\";s:8:\"settings\";s:26:\"settings-basic-information\";s:17:\"basic-information\";s:15:\"settings-avatar\";s:6:\"avatar\";s:24:\"settings-change-password\";s:15:\"change-password\";}", "yes");
INSERT INTO `hm_options` VALUES("209", "learn_press_profile_avatar", "yes", "yes");
INSERT INTO `hm_options` VALUES("210", "learn_press_profile_picture_thumbnail_size", "a:2:{s:5:\"width\";i:200;s:6:\"height\";i:200;}", "yes");
INSERT INTO `hm_options` VALUES("211", "learn_press_profile_publicity", "a:3:{s:9:\"dashboard\";s:3:\"yes\";s:7:\"courses\";s:2:\"no\";s:7:\"quizzes\";s:2:\"no\";}", "yes");
INSERT INTO `hm_options` VALUES("212", "learn_press_checkout_page_id", "20", "yes");
INSERT INTO `hm_options` VALUES("213", "learn_press_auto_enroll", "yes", "yes");
INSERT INTO `hm_options` VALUES("214", "learn_press_guest_checkout", "no", "yes");
INSERT INTO `hm_options` VALUES("215", "learn_press_enable_login_checkout", "yes", "yes");
INSERT INTO `hm_options` VALUES("216", "learn_press_enable_registration_checkout", "yes", "yes");
INSERT INTO `hm_options` VALUES("217", "learn_press_term_conditions_page_id", "", "yes");
INSERT INTO `hm_options` VALUES("218", "learn_press_checkout_endpoints", "a:1:{s:17:\"lp_order_received\";s:17:\"lp-order-received\";}", "yes");
INSERT INTO `hm_options` VALUES("219", "learn_press_payment_order", "", "yes");
INSERT INTO `hm_options` VALUES("220", "learn_press_emails_general", "a:7:{s:9:\"from_name\";s:17:\"همیار لرن\";s:10:\"from_email\";s:14:\"info@email.com\";s:21:\"send_email_background\";s:2:\"no\";s:21:\"default_email_content\";s:5:\"plain\";s:12:\"header_image\";s:0:\"\";s:11:\"footer_text\";s:15:\"لرن‌پرس\";s:11:\"list_emails\";s:0:\"\";}", "yes");
INSERT INTO `hm_options` VALUES("228", "wp-smush-settings", "a:21:{s:4:\"auto\";b:1;s:5:\"lossy\";b:0;s:10:\"strip_exif\";b:1;s:6:\"resize\";b:0;s:9:\"detection\";b:0;s:8:\"original\";b:0;s:6:\"backup\";b:0;s:10:\"png_to_jpg\";b:0;s:7:\"nextgen\";b:0;s:2:\"s3\";b:0;s:9:\"gutenberg\";b:0;s:10:\"js_builder\";b:0;s:3:\"cdn\";b:0;s:11:\"auto_resize\";b:0;s:4:\"webp\";b:1;s:5:\"usage\";b:0;s:17:\"accessible_colors\";b:0;s:9:\"keep_data\";b:1;s:9:\"lazy_load\";b:0;s:17:\"background_images\";b:1;s:16:\"rest_api_support\";b:0;}", "yes");
INSERT INTO `hm_options` VALUES("229", "wp-smush-install-type", "existing", "no");
INSERT INTO `hm_options` VALUES("230", "wp-smush-version", "3.7.3", "no");
INSERT INTO `hm_options` VALUES("233", "action_scheduler_hybrid_store_demarkation", "15", "yes");
INSERT INTO `hm_options` VALUES("234", "schema-ActionScheduler_StoreSchema", "3.0.1594375585", "yes");
INSERT INTO `hm_options` VALUES("235", "schema-ActionScheduler_LoggerSchema", "2.0.1594375585", "yes");
INSERT INTO `hm_options` VALUES("238", "woocommerce_schema_version", "430", "yes");
INSERT INTO `hm_options` VALUES("239", "woocommerce_store_address", "اصفهان", "yes");
INSERT INTO `hm_options` VALUES("240", "woocommerce_store_address_2", "اصفهان", "yes");
INSERT INTO `hm_options` VALUES("241", "woocommerce_store_city", "اصفهان", "yes");
INSERT INTO `hm_options` VALUES("242", "woocommerce_default_country", "IR:ESF", "yes");
INSERT INTO `hm_options` VALUES("243", "woocommerce_store_postcode", "اصفهان", "yes");
INSERT INTO `hm_options` VALUES("244", "woocommerce_allowed_countries", "all", "yes");
INSERT INTO `hm_options` VALUES("245", "woocommerce_all_except_countries", "a:0:{}", "yes");
INSERT INTO `hm_options` VALUES("246", "woocommerce_specific_allowed_countries", "a:0:{}", "yes");
INSERT INTO `hm_options` VALUES("247", "woocommerce_ship_to_countries", "", "yes");
INSERT INTO `hm_options` VALUES("248", "woocommerce_specific_ship_to_countries", "a:0:{}", "yes");
INSERT INTO `hm_options` VALUES("249", "woocommerce_default_customer_address", "base", "yes");
INSERT INTO `hm_options` VALUES("250", "woocommerce_calc_taxes", "no", "yes");
INSERT INTO `hm_options` VALUES("251", "woocommerce_enable_coupons", "yes", "yes");
INSERT INTO `hm_options` VALUES("252", "woocommerce_calc_discounts_sequentially", "no", "no");
INSERT INTO `hm_options` VALUES("253", "woocommerce_currency", "IRT", "yes");
INSERT INTO `hm_options` VALUES("254", "woocommerce_currency_pos", "right_space", "yes");
INSERT INTO `hm_options` VALUES("255", "woocommerce_price_thousand_sep", ",", "yes");
INSERT INTO `hm_options` VALUES("256", "woocommerce_price_decimal_sep", ".", "yes");
INSERT INTO `hm_options` VALUES("257", "woocommerce_price_num_decimals", "0", "yes");
INSERT INTO `hm_options` VALUES("258", "woocommerce_shop_page_id", "16", "yes");
INSERT INTO `hm_options` VALUES("259", "woocommerce_cart_redirect_after_add", "yes", "yes");
INSERT INTO `hm_options` VALUES("260", "woocommerce_enable_ajax_add_to_cart", "no", "yes");
INSERT INTO `hm_options` VALUES("261", "woocommerce_placeholder_image", "717", "yes");
INSERT INTO `hm_options` VALUES("262", "woocommerce_weight_unit", "kg", "yes");
INSERT INTO `hm_options` VALUES("263", "woocommerce_dimension_unit", "cm", "yes");
INSERT INTO `hm_options` VALUES("264", "woocommerce_enable_reviews", "yes", "yes");
INSERT INTO `hm_options` VALUES("265", "woocommerce_review_rating_verification_label", "yes", "no");
INSERT INTO `hm_options` VALUES("266", "woocommerce_review_rating_verification_required", "no", "no");
INSERT INTO `hm_options` VALUES("267", "woocommerce_enable_review_rating", "yes", "yes");
INSERT INTO `hm_options` VALUES("268", "woocommerce_review_rating_required", "no", "no");
INSERT INTO `hm_options` VALUES("269", "woocommerce_manage_stock", "yes", "yes");
INSERT INTO `hm_options` VALUES("270", "woocommerce_hold_stock_minutes", "60", "no");
INSERT INTO `hm_options` VALUES("271", "woocommerce_notify_low_stock", "yes", "no");
INSERT INTO `hm_options` VALUES("272", "woocommerce_notify_no_stock", "yes", "no");
INSERT INTO `hm_options` VALUES("273", "woocommerce_stock_email_recipient", "info@email.com", "no");
INSERT INTO `hm_options` VALUES("274", "woocommerce_notify_low_stock_amount", "2", "no");
INSERT INTO `hm_options` VALUES("275", "woocommerce_notify_no_stock_amount", "0", "yes");
INSERT INTO `hm_options` VALUES("276", "woocommerce_hide_out_of_stock_items", "no", "yes");
INSERT INTO `hm_options` VALUES("277", "woocommerce_stock_format", "", "yes");
INSERT INTO `hm_options` VALUES("278", "woocommerce_file_download_method", "force", "no");
INSERT INTO `hm_options` VALUES("279", "woocommerce_downloads_require_login", "yes", "no");
INSERT INTO `hm_options` VALUES("280", "woocommerce_downloads_grant_access_after_payment", "yes", "no");
INSERT INTO `hm_options` VALUES("281", "woocommerce_downloads_add_hash_to_filename", "yes", "yes");
INSERT INTO `hm_options` VALUES("282", "woocommerce_prices_include_tax", "no", "yes");
INSERT INTO `hm_options` VALUES("283", "woocommerce_tax_based_on", "shipping", "yes");
INSERT INTO `hm_options` VALUES("284", "woocommerce_shipping_tax_class", "inherit", "yes");
INSERT INTO `hm_options` VALUES("285", "woocommerce_tax_round_at_subtotal", "no", "yes");
INSERT INTO `hm_options` VALUES("286", "woocommerce_tax_classes", "", "yes");
INSERT INTO `hm_options` VALUES("287", "woocommerce_tax_display_shop", "excl", "yes");
INSERT INTO `hm_options` VALUES("288", "woocommerce_tax_display_cart", "excl", "yes");
INSERT INTO `hm_options` VALUES("289", "woocommerce_price_display_suffix", "", "yes");
INSERT INTO `hm_options` VALUES("290", "woocommerce_tax_total_display", "itemized", "no");
INSERT INTO `hm_options` VALUES("291", "woocommerce_enable_shipping_calc", "yes", "no");
INSERT INTO `hm_options` VALUES("292", "woocommerce_shipping_cost_requires_address", "no", "yes");
INSERT INTO `hm_options` VALUES("293", "woocommerce_ship_to_destination", "billing", "no");
INSERT INTO `hm_options` VALUES("294", "woocommerce_shipping_debug_mode", "no", "yes");
INSERT INTO `hm_options` VALUES("295", "woocommerce_enable_guest_checkout", "yes", "no");
INSERT INTO `hm_options` VALUES("296", "woocommerce_enable_checkout_login_reminder", "yes", "no");
INSERT INTO `hm_options` VALUES("297", "woocommerce_enable_signup_and_login_from_checkout", "yes", "no");
INSERT INTO `hm_options` VALUES("298", "woocommerce_enable_myaccount_registration", "yes", "no");
INSERT INTO `hm_options` VALUES("299", "woocommerce_registration_generate_username", "yes", "no");
INSERT INTO `hm_options` VALUES("300", "woocommerce_registration_generate_password", "no", "no");
INSERT INTO `hm_options` VALUES("301", "woocommerce_erasure_request_removes_order_data", "no", "no");
INSERT INTO `hm_options` VALUES("302", "woocommerce_erasure_request_removes_download_data", "no", "no");
INSERT INTO `hm_options` VALUES("303", "woocommerce_allow_bulk_remove_personal_data", "no", "no");
INSERT INTO `hm_options` VALUES("304", "woocommerce_registration_privacy_policy_text", "اطلاعاتی که وارد می‌کنید، برای مواردی که در صفحه‌ی [privacy_policy] ذکر شده استفاده می‌شود.", "yes");
INSERT INTO `hm_options` VALUES("305", "woocommerce_checkout_privacy_policy_text", "اطلاعاتی که وارد می‌کنید، برای مواردی که در صفحه‌ی [privacy_policy] ذکر شده استفاده می‌شود.", "yes");
INSERT INTO `hm_options` VALUES("306", "woocommerce_delete_inactive_accounts", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `hm_options` VALUES("307", "woocommerce_trash_pending_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}", "no");
INSERT INTO `hm_options` VALUES("308", "woocommerce_trash_failed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}", "no");
INSERT INTO `hm_options` VALUES("309", "woocommerce_trash_cancelled_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}", "no");
INSERT INTO `hm_options` VALUES("310", "woocommerce_anonymize_completed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `hm_options` VALUES("311", "woocommerce_email_from_name", "همیار لرن", "no");
INSERT INTO `hm_options` VALUES("312", "woocommerce_email_from_address", "info@email.com", "no");
INSERT INTO `hm_options` VALUES("313", "woocommerce_email_header_image", "", "no");
INSERT INTO `hm_options` VALUES("314", "woocommerce_email_footer_text", "{site_title} &mdash; Built with {WooCommerce}", "no");
INSERT INTO `hm_options` VALUES("315", "woocommerce_email_base_color", "#96588a", "no");
INSERT INTO `hm_options` VALUES("316", "woocommerce_email_background_color", "#f7f7f7", "no");
INSERT INTO `hm_options` VALUES("317", "woocommerce_email_body_background_color", "#ffffff", "no");
INSERT INTO `hm_options` VALUES("318", "woocommerce_email_text_color", "#3c3c3c", "no");
INSERT INTO `hm_options` VALUES("319", "woocommerce_cart_page_id", "17", "no");
INSERT INTO `hm_options` VALUES("320", "woocommerce_checkout_page_id", "18", "no");
INSERT INTO `hm_options` VALUES("321", "woocommerce_myaccount_page_id", "19", "no");
INSERT INTO `hm_options` VALUES("322", "woocommerce_terms_page_id", "", "no");
INSERT INTO `hm_options` VALUES("323", "woocommerce_force_ssl_checkout", "no", "yes");
INSERT INTO `hm_options` VALUES("324", "woocommerce_unforce_ssl_checkout", "no", "yes");
INSERT INTO `hm_options` VALUES("325", "woocommerce_checkout_pay_endpoint", "order-pay", "yes");
INSERT INTO `hm_options` VALUES("326", "woocommerce_checkout_order_received_endpoint", "order-received", "yes");
INSERT INTO `hm_options` VALUES("327", "woocommerce_myaccount_add_payment_method_endpoint", "add-payment-method", "yes");
INSERT INTO `hm_options` VALUES("328", "woocommerce_myaccount_delete_payment_method_endpoint", "delete-payment-method", "yes");
INSERT INTO `hm_options` VALUES("329", "woocommerce_myaccount_set_default_payment_method_endpoint", "set-default-payment-method", "yes");
INSERT INTO `hm_options` VALUES("330", "woocommerce_myaccount_orders_endpoint", "orders", "yes");
INSERT INTO `hm_options` VALUES("331", "woocommerce_myaccount_view_order_endpoint", "view-order", "yes");
INSERT INTO `hm_options` VALUES("332", "woocommerce_myaccount_downloads_endpoint", "downloads", "yes");
INSERT INTO `hm_options` VALUES("333", "woocommerce_myaccount_edit_account_endpoint", "edit-account", "yes");
INSERT INTO `hm_options` VALUES("334", "woocommerce_myaccount_edit_address_endpoint", "edit-address", "yes");
INSERT INTO `hm_options` VALUES("335", "woocommerce_myaccount_payment_methods_endpoint", "payment-methods", "yes");
INSERT INTO `hm_options` VALUES("336", "woocommerce_myaccount_lost_password_endpoint", "lost-password", "yes");
INSERT INTO `hm_options` VALUES("337", "woocommerce_logout_endpoint", "customer-logout", "yes");
INSERT INTO `hm_options` VALUES("338", "woocommerce_api_enabled", "no", "yes");
INSERT INTO `hm_options` VALUES("339", "woocommerce_allow_tracking", "no", "no");
INSERT INTO `hm_options` VALUES("340", "woocommerce_show_marketplace_suggestions", "yes", "no");
INSERT INTO `hm_options` VALUES("341", "woocommerce_single_image_width", "600", "yes");
INSERT INTO `hm_options` VALUES("342", "woocommerce_thumbnail_image_width", "300", "yes");
INSERT INTO `hm_options` VALUES("343", "woocommerce_checkout_highlight_required_fields", "yes", "yes");
INSERT INTO `hm_options` VALUES("344", "woocommerce_demo_store", "no", "no");
INSERT INTO `hm_options` VALUES("345", "woocommerce_permalinks", "a:5:{s:12:\"product_base\";s:7:\"/course\";s:13:\"category_base\";s:16:\"product-category\";s:8:\"tag_base\";s:11:\"product-tag\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}", "yes");
INSERT INTO `hm_options` VALUES("346", "current_theme_supports_woocommerce", "yes", "yes");
INSERT INTO `hm_options` VALUES("347", "woocommerce_queue_flush_rewrite_rules", "no", "yes");
INSERT INTO `hm_options` VALUES("350", "default_product_cat", "20", "yes");
INSERT INTO `hm_options` VALUES("352", "elementor_version", "3.0.14", "yes");
INSERT INTO `hm_options` VALUES("354", "widget_akismet_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `hm_options` VALUES("355", "widget_lp-widget-featured-courses", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `hm_options` VALUES("356", "widget_lp-widget-popular-courses", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `hm_options` VALUES("357", "widget_lp-widget-recent-courses", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `hm_options` VALUES("358", "widget_lp-widget-course-progress", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `hm_options` VALUES("359", "widget_lp-widget-course-info", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `hm_options` VALUES("360", "widget_sfwd-lessons-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `hm_options` VALUES("361", "widget_sfwd-courses-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `hm_options` VALUES("362", "widget_sfwd-quiz-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `hm_options` VALUES("363", "widget_sfwd-transactions-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `hm_options` VALUES("364", "widget_sfwd-certificates-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `hm_options` VALUES("365", "widget_ldcourseprogress", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `hm_options` VALUES("366", "widget_ldcourseinfo", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `hm_options` VALUES("367", "widget_widget_ldcoursenavigation", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `hm_options` VALUES("368", "widget_lduserstatus", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `hm_options` VALUES("369", "learndash_settings_permalinks", "a:5:{s:7:\"courses\";s:10:\"ld-courses\";s:7:\"lessons\";s:10:\"ld-lessons\";s:6:\"topics\";s:8:\"ld-topic\";s:7:\"quizzes\";s:10:\"ld-quizzes\";s:11:\"nested_urls\";s:2:\"no\";}", "yes");
INSERT INTO `hm_options` VALUES("371", "wpProQuiz_addRawShortcode", "", "yes");
INSERT INTO `hm_options` VALUES("372", "wpProQuiz_jsLoadInHead", "", "yes");
INSERT INTO `hm_options` VALUES("373", "wpProQuiz_touchLibraryDeactivate", "", "yes");
INSERT INTO `hm_options` VALUES("374", "wpProQuiz_corsActivated", "", "yes");
INSERT INTO `hm_options` VALUES("378", "ld-translations", "a:2:{s:10:\"last_check\";i:1604779431;s:16:\"translation_sets\";a:1:{s:9:\"learndash\";a:21:{s:9:\"Arabic-58\";a:10:{s:2:\"id\";s:2:\"58\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:9:\"wp_locale\";s:2:\"ar\";s:9:\"all_count\";i:3480;s:13:\"current_count\";i:2491;s:18:\"untranslated_count\";i:989;s:18:\"percent_translated\";i:71;s:17:\"last_modified_gmt\";s:19:\"2020-09-11 12:40:43\";s:5:\"links\";a:2:{s:2:\"po\";s:118:\"https://translations.learndash.com/languages/projects/learndash/ar/ar/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:118:\"https://translations.learndash.com/languages/projects/learndash/ar/ar/export-translations/?ldlms-glotpress=1&format=mo\";}}s:18:\"Chinese (China)-49\";a:10:{s:2:\"id\";s:2:\"49\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:9:\"wp_locale\";s:5:\"zh_CN\";s:9:\"all_count\";i:3480;s:13:\"current_count\";i:1337;s:18:\"untranslated_count\";i:2143;s:18:\"percent_translated\";i:38;s:17:\"last_modified_gmt\";s:19:\"2018-11-19 14:35:30\";s:5:\"links\";a:2:{s:2:\"po\";s:124:\"https://translations.learndash.com/languages/projects/learndash/zh-cn/zh_cn/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:124:\"https://translations.learndash.com/languages/projects/learndash/zh-cn/zh_cn/export-translations/?ldlms-glotpress=1&format=mo\";}}s:9:\"Danish-16\";a:10:{s:2:\"id\";s:2:\"16\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:9:\"wp_locale\";s:5:\"da_DK\";s:9:\"all_count\";i:3480;s:13:\"current_count\";i:665;s:18:\"untranslated_count\";i:2815;s:18:\"percent_translated\";i:19;s:17:\"last_modified_gmt\";s:19:\"2018-01-15 21:42:17\";s:5:\"links\";a:2:{s:2:\"po\";s:121:\"https://translations.learndash.com/languages/projects/learndash/da/da_dk/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:121:\"https://translations.learndash.com/languages/projects/learndash/da/da_dk/export-translations/?ldlms-glotpress=1&format=mo\";}}s:8:\"Dutch-48\";a:10:{s:2:\"id\";s:2:\"48\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:9:\"wp_locale\";s:5:\"nl_NL\";s:9:\"all_count\";i:3480;s:13:\"current_count\";i:2381;s:18:\"untranslated_count\";i:1099;s:18:\"percent_translated\";i:68;s:17:\"last_modified_gmt\";s:19:\"2020-09-12 11:58:26\";s:5:\"links\";a:2:{s:2:\"po\";s:121:\"https://translations.learndash.com/languages/projects/learndash/nl/nl_nl/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:121:\"https://translations.learndash.com/languages/projects/learndash/nl/nl_nl/export-translations/?ldlms-glotpress=1&format=mo\";}}s:10:\"English-43\";a:10:{s:2:\"id\";s:2:\"43\";s:12:\"english_name\";s:7:\"English\";s:11:\"native_name\";s:7:\"English\";s:9:\"wp_locale\";s:5:\"en_US\";s:9:\"all_count\";i:3480;s:13:\"current_count\";i:0;s:18:\"untranslated_count\";i:3480;s:18:\"percent_translated\";i:0;s:17:\"last_modified_gmt\";N;s:5:\"links\";a:2:{s:2:\"po\";s:121:\"https://translations.learndash.com/languages/projects/learndash/en/en_us/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:121:\"https://translations.learndash.com/languages/projects/learndash/en/en_us/export-translations/?ldlms-glotpress=1&format=mo\";}}s:18:\"French (Canada)-14\";a:10:{s:2:\"id\";s:2:\"14\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:9:\"wp_locale\";s:5:\"fr_CA\";s:9:\"all_count\";i:3480;s:13:\"current_count\";i:908;s:18:\"untranslated_count\";i:2572;s:18:\"percent_translated\";i:26;s:17:\"last_modified_gmt\";s:19:\"2018-01-16 01:14:14\";s:5:\"links\";a:2:{s:2:\"po\";s:124:\"https://translations.learndash.com/languages/projects/learndash/fr-ca/fr_ca/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:124:\"https://translations.learndash.com/languages/projects/learndash/fr-ca/fr_ca/export-translations/?ldlms-glotpress=1&format=mo\";}}s:17:\"French (France)-1\";a:10:{s:2:\"id\";s:1:\"1\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:9:\"wp_locale\";s:5:\"fr_FR\";s:9:\"all_count\";i:3480;s:13:\"current_count\";i:2574;s:18:\"untranslated_count\";i:906;s:18:\"percent_translated\";i:73;s:17:\"last_modified_gmt\";s:19:\"2020-09-12 12:25:27\";s:5:\"links\";a:2:{s:2:\"po\";s:121:\"https://translations.learndash.com/languages/projects/learndash/fr/fr_fr/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:121:\"https://translations.learndash.com/languages/projects/learndash/fr/fr_fr/export-translations/?ldlms-glotpress=1&format=mo\";}}s:8:\"German-5\";a:10:{s:2:\"id\";s:1:\"5\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:9:\"wp_locale\";s:5:\"de_DE\";s:9:\"all_count\";i:3480;s:13:\"current_count\";i:626;s:18:\"untranslated_count\";i:2854;s:18:\"percent_translated\";i:17;s:17:\"last_modified_gmt\";s:19:\"2019-07-09 19:21:03\";s:5:\"links\";a:2:{s:2:\"po\";s:121:\"https://translations.learndash.com/languages/projects/learndash/de/de_de/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:121:\"https://translations.learndash.com/languages/projects/learndash/de/de_de/export-translations/?ldlms-glotpress=1&format=mo\";}}s:9:\"German-66\";a:10:{s:2:\"id\";s:2:\"66\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:9:\"wp_locale\";s:12:\"de_DE_formal\";s:9:\"all_count\";i:3480;s:13:\"current_count\";i:910;s:18:\"untranslated_count\";i:2570;s:18:\"percent_translated\";i:26;s:17:\"last_modified_gmt\";s:19:\"2019-12-17 12:35:41\";s:5:\"links\";a:2:{s:2:\"po\";s:128:\"https://translations.learndash.com/languages/projects/learndash/de/de_de_formal/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:128:\"https://translations.learndash.com/languages/projects/learndash/de/de_de_formal/export-translations/?ldlms-glotpress=1&format=mo\";}}s:9:\"Hebrew-18\";a:10:{s:2:\"id\";s:2:\"18\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:9:\"wp_locale\";s:5:\"he_IL\";s:9:\"all_count\";i:3480;s:13:\"current_count\";i:2254;s:18:\"untranslated_count\";i:1226;s:18:\"percent_translated\";i:64;s:17:\"last_modified_gmt\";s:19:\"2019-07-29 16:46:55\";s:5:\"links\";a:2:{s:2:\"po\";s:121:\"https://translations.learndash.com/languages/projects/learndash/he/he_il/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:121:\"https://translations.learndash.com/languages/projects/learndash/he/he_il/export-translations/?ldlms-glotpress=1&format=mo\";}}s:12:\"Hungarian-64\";a:10:{s:2:\"id\";s:2:\"64\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:9:\"wp_locale\";s:5:\"hu_HU\";s:9:\"all_count\";i:3480;s:13:\"current_count\";i:176;s:18:\"untranslated_count\";i:3304;s:18:\"percent_translated\";i:5;s:17:\"last_modified_gmt\";s:19:\"2019-11-19 20:42:29\";s:5:\"links\";a:2:{s:2:\"po\";s:121:\"https://translations.learndash.com/languages/projects/learndash/hu/hu_hu/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:121:\"https://translations.learndash.com/languages/projects/learndash/hu/hu_hu/export-translations/?ldlms-glotpress=1&format=mo\";}}s:9:\"Italian-7\";a:10:{s:2:\"id\";s:1:\"7\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:9:\"wp_locale\";s:5:\"it_IT\";s:9:\"all_count\";i:3480;s:13:\"current_count\";i:1552;s:18:\"untranslated_count\";i:1928;s:18:\"percent_translated\";i:44;s:17:\"last_modified_gmt\";s:19:\"2019-07-08 21:05:01\";s:5:\"links\";a:2:{s:2:\"po\";s:121:\"https://translations.learndash.com/languages/projects/learndash/it/it_it/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:121:\"https://translations.learndash.com/languages/projects/learndash/it/it_it/export-translations/?ldlms-glotpress=1&format=mo\";}}s:11:\"Japanese-68\";a:10:{s:2:\"id\";s:2:\"68\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:9:\"wp_locale\";s:2:\"ja\";s:9:\"all_count\";i:3480;s:13:\"current_count\";i:2384;s:18:\"untranslated_count\";i:1096;s:18:\"percent_translated\";i:68;s:17:\"last_modified_gmt\";s:19:\"2020-03-03 17:08:50\";s:5:\"links\";a:2:{s:2:\"po\";s:118:\"https://translations.learndash.com/languages/projects/learndash/ja/ja/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:118:\"https://translations.learndash.com/languages/projects/learndash/ja/ja/export-translations/?ldlms-glotpress=1&format=mo\";}}s:9:\"Polish-12\";a:10:{s:2:\"id\";s:2:\"12\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:9:\"wp_locale\";s:5:\"pl_PL\";s:9:\"all_count\";i:3480;s:13:\"current_count\";i:536;s:18:\"untranslated_count\";i:2944;s:18:\"percent_translated\";i:15;s:17:\"last_modified_gmt\";s:19:\"2019-07-09 19:22:17\";s:5:\"links\";a:2:{s:2:\"po\";s:121:\"https://translations.learndash.com/languages/projects/learndash/pl/pl_pl/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:121:\"https://translations.learndash.com/languages/projects/learndash/pl/pl_pl/export-translations/?ldlms-glotpress=1&format=mo\";}}s:22:\"Portuguese (Brazil)-20\";a:10:{s:2:\"id\";s:2:\"20\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:9:\"wp_locale\";s:5:\"pt_BR\";s:9:\"all_count\";i:3480;s:13:\"current_count\";i:333;s:18:\"untranslated_count\";i:3147;s:18:\"percent_translated\";i:9;s:17:\"last_modified_gmt\";s:19:\"2020-10-19 11:58:35\";s:5:\"links\";a:2:{s:2:\"po\";s:124:\"https://translations.learndash.com/languages/projects/learndash/pt-br/pt_br/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:124:\"https://translations.learndash.com/languages/projects/learndash/pt-br/pt_br/export-translations/?ldlms-glotpress=1&format=mo\";}}s:24:\"Portuguese (Portugal)-80\";a:10:{s:2:\"id\";s:2:\"80\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:9:\"wp_locale\";s:5:\"pt_PT\";s:9:\"all_count\";i:3480;s:13:\"current_count\";i:117;s:18:\"untranslated_count\";i:3363;s:18:\"percent_translated\";i:3;s:17:\"last_modified_gmt\";s:19:\"2020-05-19 18:27:58\";s:5:\"links\";a:2:{s:2:\"po\";s:121:\"https://translations.learndash.com/languages/projects/learndash/pt/pt_pr/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:121:\"https://translations.learndash.com/languages/projects/learndash/pt/pt_pr/export-translations/?ldlms-glotpress=1&format=mo\";}}s:10:\"Russian-22\";a:10:{s:2:\"id\";s:2:\"22\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:9:\"wp_locale\";s:5:\"ru_RU\";s:9:\"all_count\";i:3480;s:13:\"current_count\";i:1516;s:18:\"untranslated_count\";i:1964;s:18:\"percent_translated\";i:43;s:17:\"last_modified_gmt\";s:19:\"2020-04-16 21:05:24\";s:5:\"links\";a:2:{s:2:\"po\";s:121:\"https://translations.learndash.com/languages/projects/learndash/ru/ru_ru/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:121:\"https://translations.learndash.com/languages/projects/learndash/ru/ru_ru/export-translations/?ldlms-glotpress=1&format=mo\";}}s:10:\"Serbian-72\";a:10:{s:2:\"id\";s:2:\"72\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:9:\"wp_locale\";s:5:\"sr_RS\";s:9:\"all_count\";i:3480;s:13:\"current_count\";i:2551;s:18:\"untranslated_count\";i:929;s:18:\"percent_translated\";i:73;s:17:\"last_modified_gmt\";s:19:\"2020-04-07 19:52:56\";s:5:\"links\";a:2:{s:2:\"po\";s:121:\"https://translations.learndash.com/languages/projects/learndash/sr/sr_me/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:121:\"https://translations.learndash.com/languages/projects/learndash/sr/sr_me/export-translations/?ldlms-glotpress=1&format=mo\";}}s:10:\"Serbian-74\";a:10:{s:2:\"id\";s:2:\"74\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:9:\"wp_locale\";s:5:\"sr_RS\";s:9:\"all_count\";i:3480;s:13:\"current_count\";i:2551;s:18:\"untranslated_count\";i:929;s:18:\"percent_translated\";i:73;s:17:\"last_modified_gmt\";s:19:\"2020-04-21 17:38:40\";s:5:\"links\";a:2:{s:2:\"po\";s:121:\"https://translations.learndash.com/languages/projects/learndash/sr/me_me/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:121:\"https://translations.learndash.com/languages/projects/learndash/sr/me_me/export-translations/?ldlms-glotpress=1&format=mo\";}}s:17:\"Spanish (Spain)-3\";a:10:{s:2:\"id\";s:1:\"3\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:9:\"wp_locale\";s:5:\"es_ES\";s:9:\"all_count\";i:3480;s:13:\"current_count\";i:1751;s:18:\"untranslated_count\";i:1729;s:18:\"percent_translated\";i:50;s:17:\"last_modified_gmt\";s:19:\"2019-06-17 18:54:44\";s:5:\"links\";a:2:{s:2:\"po\";s:121:\"https://translations.learndash.com/languages/projects/learndash/es/es_es/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:121:\"https://translations.learndash.com/languages/projects/learndash/es/es_es/export-translations/?ldlms-glotpress=1&format=mo\";}}s:10:\"Swedish-24\";a:10:{s:2:\"id\";s:2:\"24\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:9:\"wp_locale\";s:5:\"sv_SE\";s:9:\"all_count\";i:3480;s:13:\"current_count\";i:2496;s:18:\"untranslated_count\";i:984;s:18:\"percent_translated\";i:71;s:17:\"last_modified_gmt\";s:19:\"2019-12-12 15:38:04\";s:5:\"links\";a:2:{s:2:\"po\";s:121:\"https://translations.learndash.com/languages/projects/learndash/sv/sv_se/export-translations/?ldlms-glotpress=1&format=po\";s:2:\"mo\";s:121:\"https://translations.learndash.com/languages/projects/learndash/sv/sv_se/export-translations/?ldlms-glotpress=1&format=mo\";}}}}}", "yes");
INSERT INTO `hm_options` VALUES("380", "learndash_adv_quiz_migration_completed", "1", "yes");
INSERT INTO `hm_options` VALUES("382", "learndash_quiz_migration_completed", "1", "yes");
INSERT INTO `hm_options` VALUES("384", "learndash_generate_patent_course_and_lesson_ids_onetime", "no", "yes");
INSERT INTO `hm_options` VALUES("385", "wdev-frash", "a:3:{s:7:\"plugins\";a:1:{s:23:\"wp-smushit/wp-smush.php\";i:1594375640;}s:5:\"queue\";a:0:{}s:4:\"done\";a:2:{i:0;a:6:{s:6:\"plugin\";s:23:\"wp-smushit/wp-smush.php\";s:4:\"type\";s:5:\"email\";s:7:\"show_at\";i:1594375640;s:5:\"state\";s:6:\"ignore\";s:4:\"hash\";s:32:\"fc50097023d0d34c5a66f6cddcf77694\";s:10:\"handled_at\";i:1594376109;}i:1;a:6:{s:6:\"plugin\";s:23:\"wp-smushit/wp-smush.php\";s:4:\"type\";s:4:\"rate\";s:7:\"show_at\";i:1594980440;s:5:\"state\";s:6:\"ignore\";s:4:\"hash\";s:32:\"fc50097023d0d34c5a66f6cddcf77694\";s:10:\"handled_at\";i:1599199113;}}}", "no");
INSERT INTO `hm_options` VALUES("386", "wpmudev_recommended_plugins_registered", "a:1:{s:23:\"wp-smushit/wp-smush.php\";a:1:{s:13:\"registered_at\";i:1594375640;}}", "no");
INSERT INTO `hm_options` VALUES("391", "learn_press_check_tables", "yes", "yes");
INSERT INTO `hm_options` VALUES("408", "learndash-repositories", "a:5:{s:10:\"last_check\";i:1604253752;s:12:\"repositories\";a:18:{s:21:\"learndash-core-readme\";O:8:\"stdClass\":3:{s:4:\"slug\";s:21:\"learndash-core-readme\";s:7:\"version\";s:7:\"3.2.3.6\";s:10:\"updated_on\";s:19:\"2020-10-27 00:00:00\";}s:21:\"learndash-woocommerce\";O:8:\"stdClass\":3:{s:4:\"slug\";s:21:\"learndash-woocommerce\";s:7:\"version\";s:5:\"1.9.0\";s:10:\"updated_on\";s:19:\"2020-10-22 00:00:00\";}s:16:\"learndash-stripe\";O:8:\"stdClass\":3:{s:4:\"slug\";s:16:\"learndash-stripe\";s:7:\"version\";s:5:\"1.7.0\";s:10:\"updated_on\";s:19:\"2020-10-22 00:00:00\";}s:25:\"learndash-propanel-readme\";O:8:\"stdClass\":3:{s:4:\"slug\";s:25:\"learndash-propanel-readme\";s:7:\"version\";s:5:\"2.1.4\";s:10:\"updated_on\";s:19:\"2020-10-15 00:00:00\";}s:19:\"learndash-elementor\";O:8:\"stdClass\":3:{s:4:\"slug\";s:19:\"learndash-elementor\";s:7:\"version\";s:5:\"1.0.2\";s:10:\"updated_on\";s:19:\"2020-09-17 00:00:00\";}s:23:\"learndash-notifications\";O:8:\"stdClass\":3:{s:4:\"slug\";s:23:\"learndash-notifications\";s:7:\"version\";s:5:\"1.4.1\";s:10:\"updated_on\";s:19:\"2020-08-07 00:00:00\";}s:21:\"learndash-memberpress\";O:8:\"stdClass\":3:{s:4:\"slug\";s:21:\"learndash-memberpress\";s:7:\"version\";s:5:\"2.1.1\";s:10:\"updated_on\";s:19:\"2020-05-08 00:00:00\";}s:25:\"learndash-paidmemberships\";O:8:\"stdClass\":3:{s:4:\"slug\";s:25:\"learndash-paidmemberships\";s:7:\"version\";s:5:\"1.2.0\";s:10:\"updated_on\";s:19:\"2020-05-07 00:00:00\";}s:21:\"learndash-course-grid\";O:8:\"stdClass\":3:{s:4:\"slug\";s:21:\"learndash-course-grid\";s:7:\"version\";s:5:\"1.6.0\";s:10:\"updated_on\";s:19:\"2020-04-17 00:00:00\";}s:15:\"ld-multilingual\";O:8:\"stdClass\":3:{s:4:\"slug\";s:15:\"ld-multilingual\";s:7:\"version\";s:3:\"1.0\";s:10:\"updated_on\";s:19:\"2020-04-14 00:00:00\";}s:16:\"learndash-zapier\";O:8:\"stdClass\":3:{s:4:\"slug\";s:16:\"learndash-zapier\";s:7:\"version\";s:5:\"2.1.0\";s:10:\"updated_on\";s:19:\"2020-03-20 00:00:00\";}s:17:\"learndash-bbpress\";O:8:\"stdClass\":3:{s:4:\"slug\";s:17:\"learndash-bbpress\";s:7:\"version\";s:5:\"2.1.1\";s:10:\"updated_on\";s:19:\"2019-11-05 00:00:00\";}s:13:\"learndash-edd\";O:8:\"stdClass\":3:{s:4:\"slug\";s:13:\"learndash-edd\";s:7:\"version\";s:5:\"1.2.0\";s:10:\"updated_on\";s:19:\"2019-10-18 00:00:00\";}s:23:\"learndash-gravity-forms\";O:8:\"stdClass\":3:{s:4:\"slug\";s:23:\"learndash-gravity-forms\";s:7:\"version\";s:5:\"2.1.1\";s:10:\"updated_on\";s:19:\"2019-09-26 00:00:00\";}s:30:\"learndash-restrict-content-pro\";O:8:\"stdClass\":3:{s:4:\"slug\";s:30:\"learndash-restrict-content-pro\";s:7:\"version\";s:5:\"1.1.0\";s:10:\"updated_on\";s:19:\"2019-07-11 00:00:00\";}s:19:\"learndash-2checkout\";O:8:\"stdClass\":3:{s:4:\"slug\";s:19:\"learndash-2checkout\";s:7:\"version\";s:5:\"1.1.0\";s:10:\"updated_on\";s:19:\"2019-05-02 00:00:00\";}s:24:\"learndash-event-espresso\";O:8:\"stdClass\":3:{s:4:\"slug\";s:24:\"learndash-event-espresso\";s:7:\"version\";s:5:\"1.1.0\";s:10:\"updated_on\";s:19:\"2019-04-24 00:00:00\";}s:17:\"learndash-samcart\";O:8:\"stdClass\":3:{s:4:\"slug\";s:17:\"learndash-samcart\";s:7:\"version\";s:3:\"1.0\";s:10:\"updated_on\";s:19:\"2018-01-17 00:00:00\";}}s:7:\"plugins\";a:18:{s:21:\"learndash-core-readme\";a:32:{s:4:\"name\";s:13:\"LearnDash LMS\";s:6:\"author\";s:45:\"<a href=\"https://learndash.com\">LearnDash</a>\";s:10:\"author_uri\";s:21:\"https://learndash.com\";s:10:\"plugin_uri\";s:21:\"https://learndash.com\";s:4:\"slug\";s:14:\"learndash-core\";s:4:\"tags\";a:0:{}s:17:\"requires_at_least\";s:3:\"5.0\";s:12:\"tested_up_to\";s:5:\"5.5.1\";s:12:\"requires_php\";s:3:\"7.0\";s:10:\"stable_tag\";s:7:\"3.2.3.6\";s:11:\"last_update\";s:10:\"2020-10-27\";s:17:\"short_description\";s:82:\"LearnDash LMS Plugin - Turn your WordPress site into a learning management system.\";s:12:\"is_truncated\";b:0;s:11:\"description\";a:3:{s:5:\"title\";s:11:\"Description\";s:11:\"content_raw\";s:411:\"Turn your WordPress site into a learning management system.\r\n\r\nEasily create & sell courses, deliver quizzes, award certificates, manage users, download reports, and so much more! By using LearnDash you have access to the latest e-learning industry trends for creating robust learning experiences.\r\n\r\nSee the [Features](https://www.learndash.com/wordpress-course-plugin-features/) page for more information.\r\n\r\n\";s:7:\"content\";s:437:\"<p>Turn your WordPress site into a learning management system.</p>\n<p>Easily create &amp; sell courses, deliver quizzes, award certificates, manage users, download reports, and so much more! By using LearnDash you have access to the latest e-learning industry trends for creating robust learning experiences.</p>\n<p>See the <a href=\"https://www.learndash.com/wordpress-course-plugin-features/\">Features</a> page for more information.</p>\";}s:12:\"installation\";a:3:{s:5:\"title\";s:12:\"Installation\";s:11:\"content_raw\";s:494:\"If the auto-update is not working, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. \r\n\r\n1. Deactivate and delete your current version of LearnDash LMS.\r\n2. Download the latest version of LearnDash from our [support site](https://support.learndash.com/articles/my-downloads/).\r\n3. Upload the zipped file via PLUGINS > ADD NEW, or to wp-content/plugins.\r\n4. Activate the LearnDash LMS plugin via the PLUGINS menu.\r\n\r\n\";s:7:\"content\";s:540:\"<p>If the auto-update is not working, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of LearnDash LMS.</li>\n<li>Download the latest version of LearnDash from our <a href=\"https://support.learndash.com/articles/my-downloads/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the LearnDash LMS plugin via the PLUGINS menu.</li>\n</ol>\";}s:9:\"changelog\";a:3:{s:5:\"title\";s:9:\"Changelog\";s:11:\"content_raw\";s:2464:\"= 3.2.3.6 =\r\n\r\n* Fixed LD Menu Items on new install \r\n* Fixed Fatal Error when group leader tries filtering in the WordPress admin\r\n\r\n= 3.2.3.5 =\r\n\r\n* Fixed Matrix sorting not respecting order in the builder\r\n* Fixed Final quizzes always being associated with the first lesson in a course\r\n* Fixed Quiz with prerequisites not able to be started by non-admins\r\n* Fixed Translations causing URL redirects\r\n* Fixed Button spacing on quiz legacy templates\r\n* Fixed Syntax error on quiz cookie code\r\n\r\n= 3.2.3.4 =\r\n\r\n* Fixed Quiz prerequisites not saving\r\n* Fixed typo in includes/course/ld-course-progress.php causing lesson quiz redirect to be negatively impacted\r\n* Fixed Restrict Quiz Retake not respecting number of retries\r\n* Fixed Section titles so they can be edited after creation\r\n* Fixed assignment/essay course/lesson filtering not working\r\n* Fixed [ld_course_list] shortcode Number of courses per page not applying\r\n* Fixed LD30 Registration: users not being auto enrolled after registering for Free Course\r\n* Fixed quiz statistics activation through actions row link or Actions menu\r\n* Fixed Assignment approve link not updating status\r\n* Fixed Incorrect/Correct Message box still visible for Essay Type question\r\n* Fixed submitted Essays so they can be updated\r\n* Fixed Quiz Statistics page 2 showing entries from page 1\r\n* Fixed LearnDash Quiz Settings (legacy) metabox showing on Quiz Settings tab\r\n\r\n= 3.2.3.3 = \r\n\r\n* Fixed issue with quiz leaderboard preventing quiz from starting\r\n\r\n= 3.2.3 =\r\n\r\n* Updated Focus mode CSS improvements for more consistent styling\r\n* Updated Color coding for quiz summary table\r\n* Updated `[learndash_login]` shortcode now works in Focus Mode lessons topics and quizzes\r\n* Added autoplay mute parameter for browsers blocking video autoplay;\r\n* Added the ability to protect posts and pages from one global setting rather than per page and post\r\n* Added Admin notice if other LMS plugins are activated that may conflict\r\n\r\n* Fixed Courses being marked complete when not all steps are being complete\r\n* Fixed graded Essay points reverting to `0`\r\n* Fixed no mark complete button at top when using timer\r\n* Fixed Course with only a final quiz not updating course progress\r\n* Fixed Group leader bypass not working\r\n* Fixed Group permalinks\r\n* Fixed missing translations on some strings\r\n* Fixed Expand all button on Groups page causing JS error\r\n\r\n\r\nView our full changelog [here](https://www.learndash.com/changelog/).\r\n\r\n\";s:7:\"content\";s:2768:\"<h4>3.2.3.6</h4>\n<ul>\n<li>Fixed LD Menu Items on new install </li>\n<li>\n<p>Fixed Fatal Error when group leader tries filtering in the WordPress admin</p>\n<h4>3.2.3.5</h4>\n</li>\n<li>Fixed Matrix sorting not respecting order in the builder</li>\n<li>Fixed Final quizzes always being associated with the first lesson in a course</li>\n<li>Fixed Quiz with prerequisites not able to be started by non-admins</li>\n<li>Fixed Translations causing URL redirects</li>\n<li>Fixed Button spacing on quiz legacy templates</li>\n<li>\n<p>Fixed Syntax error on quiz cookie code</p>\n<h4>3.2.3.4</h4>\n</li>\n<li>Fixed Quiz prerequisites not saving</li>\n<li>Fixed typo in includes/course/ld-course-progress.php causing lesson quiz redirect to be negatively impacted</li>\n<li>Fixed Restrict Quiz Retake not respecting number of retries</li>\n<li>Fixed Section titles so they can be edited after creation</li>\n<li>Fixed assignment/essay course/lesson filtering not working</li>\n<li>Fixed [ld_course_list] shortcode Number of courses per page not applying</li>\n<li>Fixed LD30 Registration: users not being auto enrolled after registering for Free Course</li>\n<li>Fixed quiz statistics activation through actions row link or Actions menu</li>\n<li>Fixed Assignment approve link not updating status</li>\n<li>Fixed Incorrect/Correct Message box still visible for Essay Type question</li>\n<li>Fixed submitted Essays so they can be updated</li>\n<li>Fixed Quiz Statistics page 2 showing entries from page 1</li>\n<li>\n<p>Fixed LearnDash Quiz Settings (legacy) metabox showing on Quiz Settings tab</p>\n<h4>3.2.3.3</h4> \n</li>\n<li>\n<p>Fixed issue with quiz leaderboard preventing quiz from starting</p>\n<h4>3.2.3</h4>\n</li>\n<li>Updated Focus mode CSS improvements for more consistent styling</li>\n<li>Updated Color coding for quiz summary table</li>\n<li>Updated <code>[learndash_login]</code> shortcode now works in Focus Mode lessons topics and quizzes</li>\n<li>Added autoplay mute parameter for browsers blocking video autoplay;</li>\n<li>Added the ability to protect posts and pages from one global setting rather than per page and post</li>\n<li>\n<p>Added Admin notice if other LMS plugins are activated that may conflict</p>\n</li>\n<li>Fixed Courses being marked complete when not all steps are being complete</li>\n<li>Fixed graded Essay points reverting to <code>0</code></li>\n<li>Fixed no mark complete button at top when using timer</li>\n<li>Fixed Course with only a final quiz not updating course progress</li>\n<li>Fixed Group leader bypass not working</li>\n<li>Fixed Group permalinks</li>\n<li>Fixed missing translations on some strings</li>\n<li>Fixed Expand all button on Groups page causing JS error</li>\n</ul>\n<p>View our full changelog <a href=\"https://www.learndash.com/changelog/\">here</a>.</p>\";}s:14:\"upgrade_notice\";a:3:{s:5:\"title\";s:14:\"Upgrade Notice\";s:11:\"content_raw\";s:69:\"= 3.1.3 = \r\nImportant security update: please update immediately.\r\n\r\n\";s:7:\"content\";a:1:{s:5:\"3.1.3\";s:60:\"<p>Important security update: please update immediately.</p>\";}}s:3:\"faq\";a:3:{s:5:\"title\";s:3:\"FAQ\";s:11:\"content_raw\";s:1146:\"= Do I need to update? =\r\n\r\nIt is always recommended to update. However given the nature of WordPress and the option to have many other plugins installed, custom code, etc. it is possible that a conflict would arise. This is why we always recommend testing the update on a development environment first. \r\n\r\n= Why am I getting an error notice when trying to update? =\r\n\r\nIf you are getting an error while trying to update your version of LearnDash LMS, verify that your license is still valid. \r\n\r\nBoth your license key and email address should be entered via LEARNDASH LMS > SETTINGS > LMS LICENSE. You should then see a \"Your license is valid\" message appear. \r\n\r\nIf not, you can find your correct information via our [Support Site](https://support.learndash.com/articles/my-downloads/).\r\n\r\nIf your license has expired, you can purchase a new one [here](https://www.learndash.com/pricing-and-purchase/).\r\n\r\n= What will happen to my customizations when updating? =\r\n\r\nAs long as the customizations were not done directly in the core LearnDash plugin files, there should be no problem. We provide many template files and hooks for this purpose.\r\n\";s:7:\"content\";s:0:\"\";}s:12:\"contributors\";a:0:{}s:8:\"sections\";a:3:{s:11:\"description\";s:437:\"<p>Turn your WordPress site into a learning management system.</p>\n<p>Easily create &amp; sell courses, deliver quizzes, award certificates, manage users, download reports, and so much more! By using LearnDash you have access to the latest e-learning industry trends for creating robust learning experiences.</p>\n<p>See the <a href=\"https://www.learndash.com/wordpress-course-plugin-features/\">Features</a> page for more information.</p>\";s:12:\"installation\";s:540:\"<p>If the auto-update is not working, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of LearnDash LMS.</li>\n<li>Download the latest version of LearnDash from our <a href=\"https://support.learndash.com/articles/my-downloads/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the LearnDash LMS plugin via the PLUGINS menu.</li>\n</ol>\";s:9:\"changelog\";s:2768:\"<h4>3.2.3.6</h4>\n<ul>\n<li>Fixed LD Menu Items on new install </li>\n<li>\n<p>Fixed Fatal Error when group leader tries filtering in the WordPress admin</p>\n<h4>3.2.3.5</h4>\n</li>\n<li>Fixed Matrix sorting not respecting order in the builder</li>\n<li>Fixed Final quizzes always being associated with the first lesson in a course</li>\n<li>Fixed Quiz with prerequisites not able to be started by non-admins</li>\n<li>Fixed Translations causing URL redirects</li>\n<li>Fixed Button spacing on quiz legacy templates</li>\n<li>\n<p>Fixed Syntax error on quiz cookie code</p>\n<h4>3.2.3.4</h4>\n</li>\n<li>Fixed Quiz prerequisites not saving</li>\n<li>Fixed typo in includes/course/ld-course-progress.php causing lesson quiz redirect to be negatively impacted</li>\n<li>Fixed Restrict Quiz Retake not respecting number of retries</li>\n<li>Fixed Section titles so they can be edited after creation</li>\n<li>Fixed assignment/essay course/lesson filtering not working</li>\n<li>Fixed [ld_course_list] shortcode Number of courses per page not applying</li>\n<li>Fixed LD30 Registration: users not being auto enrolled after registering for Free Course</li>\n<li>Fixed quiz statistics activation through actions row link or Actions menu</li>\n<li>Fixed Assignment approve link not updating status</li>\n<li>Fixed Incorrect/Correct Message box still visible for Essay Type question</li>\n<li>Fixed submitted Essays so they can be updated</li>\n<li>Fixed Quiz Statistics page 2 showing entries from page 1</li>\n<li>\n<p>Fixed LearnDash Quiz Settings (legacy) metabox showing on Quiz Settings tab</p>\n<h4>3.2.3.3</h4> \n</li>\n<li>\n<p>Fixed issue with quiz leaderboard preventing quiz from starting</p>\n<h4>3.2.3</h4>\n</li>\n<li>Updated Focus mode CSS improvements for more consistent styling</li>\n<li>Updated Color coding for quiz summary table</li>\n<li>Updated <code>[learndash_login]</code> shortcode now works in Focus Mode lessons topics and quizzes</li>\n<li>Added autoplay mute parameter for browsers blocking video autoplay;</li>\n<li>Added the ability to protect posts and pages from one global setting rather than per page and post</li>\n<li>\n<p>Added Admin notice if other LMS plugins are activated that may conflict</p>\n</li>\n<li>Fixed Courses being marked complete when not all steps are being complete</li>\n<li>Fixed graded Essay points reverting to <code>0</code></li>\n<li>Fixed no mark complete button at top when using timer</li>\n<li>Fixed Course with only a final quiz not updating course progress</li>\n<li>Fixed Group leader bypass not working</li>\n<li>Fixed Group permalinks</li>\n<li>Fixed missing translations on some strings</li>\n<li>Fixed Expand all button on Groups page causing JS error</li>\n</ul>\n<p>View our full changelog <a href=\"https://www.learndash.com/changelog/\">here</a>.</p>\";}s:4:\"file\";s:96:\"C:\\laragon\\www\\hamyarlearn/wp-content/uploads/learndash/add-ons/learndash-core-readme_readme.txt\";s:10:\"last_check\";i:1604252209;s:8:\"external\";b:1;s:7:\"bb_slug\";s:21:\"learndash-core-readme\";s:8:\"homepage\";s:21:\"https://learndash.com\";s:12:\"last_updated\";s:19:\"2020-10-27 00:00:00\";s:7:\"version\";s:7:\"3.2.3.6\";s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:5:\"5.5.1\";s:5:\"icons\";a:3:{s:2:\"1x\";s:100:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-core_256x256.jpg\";s:2:\"2x\";s:100:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-core_256x256.jpg\";s:7:\"default\";s:100:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-core_256x256.jpg\";}s:7:\"banners\";a:3:{s:3:\"low\";s:99:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-core_banner.jpg\";s:4:\"high\";s:99:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-core_banner.jpg\";s:7:\"default\";s:99:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-core_banner.jpg\";}s:11:\"show-add-on\";s:2:\"no\";}s:21:\"learndash-woocommerce\";a:31:{s:4:\"name\";s:25:\"WooCommerce for LearnDash\";s:6:\"author\";s:45:\"<a href=\"https://learndash.com\">LearnDash</a>\";s:10:\"author_uri\";s:21:\"https://learndash.com\";s:10:\"plugin_uri\";s:41:\"https://learndash.com/add-on/woocommerce/\";s:20:\"ld_requires_at_least\";s:3:\"3.0\";s:4:\"slug\";s:21:\"learndash-woocommerce\";s:4:\"tags\";a:3:{i:0;s:11:\"integration\";i:1;s:11:\"woocommerce\";i:2;s:0:\"\";}s:17:\"requires_at_least\";s:3:\"5.0\";s:12:\"tested_up_to\";s:3:\"5.5\";s:12:\"requires_php\";s:3:\"7.0\";s:10:\"stable_tag\";s:5:\"1.9.0\";s:17:\"short_description\";s:41:\"Integrate LearnDash LMS with WooCommerce.\";s:12:\"is_truncated\";b:0;s:11:\"description\";a:3:{s:5:\"title\";s:11:\"Description\";s:11:\"content_raw\";s:592:\"Integrate LearnDash LMS with WooCommerce.\r\n\r\nWooCommerce is the most popular shopping cart software for WordPress. Most WordPress themes are compatible with WooCommerce. This add-on allows you to sell your LearnDash created courses with the WooCommerce shopping cart.\r\n\r\n= Integration Features = \r\n\r\n* Easily map courses to products\r\n* Associate one, or multiple courses to a single product\r\n* Automatic course access removal\r\n* Works with any payment gateway\r\n* Works with WooCommerce Subscription\r\n\r\nSee the [Add-on](https://learndash.com/add-on/woocommerce/) page for more information.\r\n\r\n\";s:7:\"content\";s:655:\"<p>Integrate LearnDash LMS with WooCommerce.</p>\n<p>WooCommerce is the most popular shopping cart software for WordPress. Most WordPress themes are compatible with WooCommerce. This add-on allows you to sell your LearnDash created courses with the WooCommerce shopping cart.</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Easily map courses to products</li>\n<li>Associate one, or multiple courses to a single product</li>\n<li>Automatic course access removal</li>\n<li>Works with any payment gateway</li>\n<li>Works with WooCommerce Subscription</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/woocommerce/\">Add-on</a> page for more information.</p>\";}s:12:\"installation\";a:3:{s:5:\"title\";s:12:\"Installation\";s:11:\"content_raw\";s:601:\"If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS > SETTINGS > LMS LICENSE. \r\n\r\nAlternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. \r\n\r\n1. Deactivate and delete your current version of the add-on.\r\n1. Download the latest version of the add-on from our [support site](https://support.learndash.com/article-categories/free/).\r\n1. Upload the zipped file via PLUGINS > ADD NEW, or to wp-content/plugins.\r\n1. Activate the add-on plugin via the PLUGINS menu.\r\n\r\n\";s:7:\"content\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";}s:9:\"changelog\";a:3:{s:5:\"title\";s:9:\"Changelog\";s:11:\"content_raw\";s:825:\"= 1.9.0 =\r\n* Added dependencies check\r\n* Added WPML multi language course selector support\r\n* Added background course enrollment warning above course selector field\r\n* Added WC subscription switching feature support\r\n* Updated allow retroactive tool to process course enrollment directly instead of storing the queue in DB\r\n* Updated remove old code that process retroactive tool using cron\r\n* Updated change learndash_woocommerce_silent_course_enrollment_queue option to be non autoload to improve performance\r\n* Updated Use custom label if set\r\n* Fixed renewal process unenroll and reenroll users to courses\r\n* Fixed PHP notice error because of deprecated class property\r\n* Fixed retroactive tool reset enrollment date to the tool run date\r\n\r\nView the full changelog [here](https://www.learndash.com/add-on/woocommerce/).\r\n\";s:7:\"content\";s:920:\"<h4>1.9.0</h4>\n<ul>\n<li>Added dependencies check</li>\n<li>Added WPML multi language course selector support</li>\n<li>Added background course enrollment warning above course selector field</li>\n<li>Added WC subscription switching feature support</li>\n<li>Updated allow retroactive tool to process course enrollment directly instead of storing the queue in DB</li>\n<li>Updated remove old code that process retroactive tool using cron</li>\n<li>Updated change learndash_woocommerce_silent_course_enrollment_queue option to be non autoload to improve performance</li>\n<li>Updated Use custom label if set</li>\n<li>Fixed renewal process unenroll and reenroll users to courses</li>\n<li>Fixed PHP notice error because of deprecated class property</li>\n<li>Fixed retroactive tool reset enrollment date to the tool run date</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/woocommerce/\">here</a>.</p>\";}s:12:\"contributors\";a:0:{}s:8:\"sections\";a:3:{s:11:\"description\";s:655:\"<p>Integrate LearnDash LMS with WooCommerce.</p>\n<p>WooCommerce is the most popular shopping cart software for WordPress. Most WordPress themes are compatible with WooCommerce. This add-on allows you to sell your LearnDash created courses with the WooCommerce shopping cart.</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Easily map courses to products</li>\n<li>Associate one, or multiple courses to a single product</li>\n<li>Automatic course access removal</li>\n<li>Works with any payment gateway</li>\n<li>Works with WooCommerce Subscription</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/woocommerce/\">Add-on</a> page for more information.</p>\";s:12:\"installation\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";s:9:\"changelog\";s:920:\"<h4>1.9.0</h4>\n<ul>\n<li>Added dependencies check</li>\n<li>Added WPML multi language course selector support</li>\n<li>Added background course enrollment warning above course selector field</li>\n<li>Added WC subscription switching feature support</li>\n<li>Updated allow retroactive tool to process course enrollment directly instead of storing the queue in DB</li>\n<li>Updated remove old code that process retroactive tool using cron</li>\n<li>Updated change learndash_woocommerce_silent_course_enrollment_queue option to be non autoload to improve performance</li>\n<li>Updated Use custom label if set</li>\n<li>Fixed renewal process unenroll and reenroll users to courses</li>\n<li>Fixed PHP notice error because of deprecated class property</li>\n<li>Fixed retroactive tool reset enrollment date to the tool run date</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/woocommerce/\">here</a>.</p>\";}s:4:\"file\";s:96:\"C:\\laragon\\www\\hamyarlearn/wp-content/uploads/learndash/add-ons/learndash-woocommerce_readme.txt\";s:10:\"last_check\";i:1604252209;s:8:\"external\";b:1;s:7:\"bb_slug\";s:21:\"learndash-woocommerce\";s:8:\"homepage\";s:41:\"https://learndash.com/add-on/woocommerce/\";s:12:\"last_updated\";s:19:\"2020-10-22 00:00:00\";s:7:\"version\";s:5:\"1.9.0\";s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:3:\"5.5\";s:5:\"icons\";a:3:{s:2:\"1x\";s:107:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-woocommerce_256x256.jpg\";s:2:\"2x\";s:107:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-woocommerce_256x256.jpg\";s:7:\"default\";s:107:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-woocommerce_256x256.jpg\";}s:7:\"banners\";a:3:{s:3:\"low\";s:106:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-woocommerce_banner.jpg\";s:4:\"high\";s:106:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-woocommerce_banner.jpg\";s:7:\"default\";s:106:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-woocommerce_banner.jpg\";}s:7:\"wp_slug\";s:47:\"learndash-woocommerce/learndash_woocommerce.php\";s:13:\"plugin_status\";a:4:{s:6:\"status\";s:7:\"install\";s:7:\"version\";s:5:\"1.9.0\";s:4:\"file\";b:0;s:3:\"url\";s:215:\"http://localhost/hamyarlearn/wp-admin/update.php?action=install-plugin&amp;plugin=learndash-woocommerce&amp;_wpnonce=346ddeb6ae&ld-return-addons=/hamyarlearn/wp-admin/admin.php?page=wpseo_tools&start-indexation=true\";}}s:16:\"learndash-stripe\";a:30:{s:4:\"name\";s:20:\"Stripe for LearnDash\";s:6:\"author\";s:45:\"<a href=\"https://learndash.com\">LearnDash</a>\";s:10:\"author_uri\";s:21:\"https://learndash.com\";s:10:\"plugin_uri\";s:36:\"https://learndash.com/add-on/stripe/\";s:20:\"ld_requires_at_least\";s:3:\"3.0\";s:4:\"slug\";s:16:\"learndash-stripe\";s:4:\"tags\";a:3:{i:0;s:11:\"integration\";i:1;s:15:\"payment gateway\";i:2;s:6:\"stripe\";}s:17:\"requires_at_least\";s:3:\"5.0\";s:12:\"tested_up_to\";s:3:\"5.5\";s:12:\"requires_php\";s:3:\"7.0\";s:10:\"stable_tag\";s:5:\"1.7.0\";s:17:\"short_description\";s:36:\"Integrate LearnDash LMS with Stripe.\";s:12:\"is_truncated\";b:0;s:11:\"description\";a:3:{s:5:\"title\";s:11:\"Description\";s:11:\"content_raw\";s:538:\"Integrate LearnDash LMS with Stripe.\r\n\r\nLearnDash comes with the ability to accept payment for courses by leveraging PayPal. Using this add-on, you can quickly and easily accept payments using the Stripe payment gateway. Use it with PayPal, or just use Stripe - the choice is yours!\r\n\r\n= Integration Features = \r\n\r\n* Accept payments using Stripe\r\n* Automatic user creation and enrollment\r\n* Compatible with built-in PayPal option\r\n* Lightbox overlay\r\n\r\nSee the [Add-on](https://learndash.com/add-on/stripe/) page for more information.\r\n\r\n\";s:7:\"content\";s:595:\"<p>Integrate LearnDash LMS with Stripe.</p>\n<p>LearnDash comes with the ability to accept payment for courses by leveraging PayPal. Using this add-on, you can quickly and easily accept payments using the Stripe payment gateway. Use it with PayPal, or just use Stripe - the choice is yours!</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Accept payments using Stripe</li>\n<li>Automatic user creation and enrollment</li>\n<li>Compatible with built-in PayPal option</li>\n<li>Lightbox overlay</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/stripe/\">Add-on</a> page for more information.</p>\";}s:12:\"installation\";a:3:{s:5:\"title\";s:12:\"Installation\";s:11:\"content_raw\";s:601:\"If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS > SETTINGS > LMS LICENSE. \r\n\r\nAlternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. \r\n\r\n1. Deactivate and delete your current version of the add-on.\r\n1. Download the latest version of the add-on from our [support site](https://support.learndash.com/article-categories/free/).\r\n1. Upload the zipped file via PLUGINS > ADD NEW, or to wp-content/plugins.\r\n1. Activate the add-on plugin via the PLUGINS menu.\r\n\r\n\";s:7:\"content\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";}s:9:\"changelog\";a:3:{s:5:\"title\";s:9:\"Changelog\";s:11:\"content_raw\";s:503:\"= 1.7.0 =\r\n* Added dependencies check\r\n* Added allow_promotion_codes arg in Stripe session creation API\r\n* Updated add \'customer\' arg in Stripe session API so that Stripe only create 1 customer object for each WP user\r\n* Fixed token used more than once error on legacy checkout\r\n* Fixed fatal error due to uncaught Stripe API Exception\r\n* Fixed Stripe JS is loaded multiple times if there\'s multiple payment button on a page\r\n\r\nView the full changelog [here](https://www.learndash.com/add-on/stripe/).\r\n\";s:7:\"content\";s:568:\"<h4>1.7.0</h4>\n<ul>\n<li>Added dependencies check</li>\n<li>Added allow_promotion_codes arg in Stripe session creation API</li>\n<li>Updated add \'customer\' arg in Stripe session API so that Stripe only create 1 customer object for each WP user</li>\n<li>Fixed token used more than once error on legacy checkout</li>\n<li>Fixed fatal error due to uncaught Stripe API Exception</li>\n<li>Fixed Stripe JS is loaded multiple times if there\'s multiple payment button on a page</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/stripe/\">here</a>.</p>\";}s:12:\"contributors\";a:0:{}s:8:\"sections\";a:3:{s:11:\"description\";s:595:\"<p>Integrate LearnDash LMS with Stripe.</p>\n<p>LearnDash comes with the ability to accept payment for courses by leveraging PayPal. Using this add-on, you can quickly and easily accept payments using the Stripe payment gateway. Use it with PayPal, or just use Stripe - the choice is yours!</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Accept payments using Stripe</li>\n<li>Automatic user creation and enrollment</li>\n<li>Compatible with built-in PayPal option</li>\n<li>Lightbox overlay</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/stripe/\">Add-on</a> page for more information.</p>\";s:12:\"installation\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";s:9:\"changelog\";s:568:\"<h4>1.7.0</h4>\n<ul>\n<li>Added dependencies check</li>\n<li>Added allow_promotion_codes arg in Stripe session creation API</li>\n<li>Updated add \'customer\' arg in Stripe session API so that Stripe only create 1 customer object for each WP user</li>\n<li>Fixed token used more than once error on legacy checkout</li>\n<li>Fixed fatal error due to uncaught Stripe API Exception</li>\n<li>Fixed Stripe JS is loaded multiple times if there\'s multiple payment button on a page</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/stripe/\">here</a>.</p>\";}s:4:\"file\";s:91:\"C:\\laragon\\www\\hamyarlearn/wp-content/uploads/learndash/add-ons/learndash-stripe_readme.txt\";s:10:\"last_check\";i:1604252209;s:8:\"external\";b:1;s:7:\"bb_slug\";s:16:\"learndash-stripe\";s:8:\"homepage\";s:36:\"https://learndash.com/add-on/stripe/\";s:12:\"last_updated\";s:19:\"2020-10-22 00:00:00\";s:7:\"version\";s:5:\"1.7.0\";s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:3:\"5.5\";s:5:\"icons\";a:3:{s:2:\"1x\";s:102:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-stripe_256x256.jpg\";s:2:\"2x\";s:102:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-stripe_256x256.jpg\";s:7:\"default\";s:102:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-stripe_256x256.jpg\";}s:7:\"banners\";a:3:{s:3:\"low\";s:101:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-stripe_banner.jpg\";s:4:\"high\";s:101:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-stripe_banner.jpg\";s:7:\"default\";s:101:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-stripe_banner.jpg\";}s:13:\"plugin_status\";a:4:{s:6:\"status\";s:7:\"install\";s:7:\"version\";s:5:\"1.7.0\";s:4:\"file\";b:0;s:3:\"url\";s:210:\"http://localhost/hamyarlearn/wp-admin/update.php?action=install-plugin&amp;plugin=learndash-stripe&amp;_wpnonce=5cb2f74ccc&ld-return-addons=/hamyarlearn/wp-admin/admin.php?page=wpseo_tools&start-indexation=true\";}}s:25:\"learndash-propanel-readme\";a:32:{s:4:\"name\";s:21:\"ProPanel by LearnDash\";s:6:\"author\";s:45:\"<a href=\"https://learndash.com\">LearnDash</a>\";s:10:\"author_uri\";s:21:\"https://learndash.com\";s:10:\"plugin_uri\";s:44:\"https://learndash.com/propanel-by-learndash/\";s:20:\"ld_requires_at_least\";s:5:\"2.4.0\";s:4:\"slug\";s:18:\"learndash-propanel\";s:17:\"requires_at_least\";s:3:\"5.0\";s:12:\"tested_up_to\";s:5:\"5.5.1\";s:12:\"requires_php\";s:3:\"7.0\";s:10:\"stable_tag\";s:5:\"2.1.4\";s:11:\"last_update\";s:10:\"2020-10-15\";s:17:\"short_description\";s:51:\"Easily manage and view your LearnDash LMS activity.\";s:12:\"is_truncated\";b:0;s:11:\"description\";a:3:{s:5:\"title\";s:11:\"Description\";s:11:\"content_raw\";s:372:\"Easily manage and view your LearnDash LMS activity.\r\n\r\nProPanel enhances your LearnDash admin experience by consolidating reporting and assignment management, giving you the ability to send course specific communications, and showing real-time activity of your courses!\r\n\r\nSee the [Features](https://www.learndash.com/propanel-by-learndash/) page for more information.\r\n\r\n\";s:7:\"content\";s:394:\"<p>Easily manage and view your LearnDash LMS activity.</p>\n<p>ProPanel enhances your LearnDash admin experience by consolidating reporting and assignment management, giving you the ability to send course specific communications, and showing real-time activity of your courses!</p>\n<p>See the <a href=\"https://www.learndash.com/propanel-by-learndash/\">Features</a> page for more information.</p>\";}s:12:\"installation\";a:3:{s:5:\"title\";s:12:\"Installation\";s:11:\"content_raw\";s:483:\"If the auto-update is not working, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. \r\n\r\n1. Deactivate and delete your current version of ProPanel.\r\n1. Download the latest version of ProPanel from our [support site](https://support.learndash.com/articles/my-downloads/).\r\n1. Upload the zipped file via PLUGINS > ADD NEW, or to wp-content/plugins.\r\n1. Activate the ProPanel plugin via the PLUGINS menu.\r\n\r\n\";s:7:\"content\";s:529:\"<p>If the auto-update is not working, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of ProPanel.</li>\n<li>Download the latest version of ProPanel from our <a href=\"https://support.learndash.com/articles/my-downloads/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the ProPanel plugin via the PLUGINS menu.</li>\n</ol>\";}s:9:\"changelog\";a:3:{s:5:\"title\";s:9:\"Changelog\";s:11:\"content_raw\";s:558:\"= 2.1.4 = \r\n\r\n* Added Filter by dates\r\n* Added RTL support\r\n* Fixed ProPanel Reporting widget not updating\r\n* Fixed Users results stats not showing in dashboard\r\n* Fixed 403 errors \r\n* Fixed ProPanel translation issues\r\n* Fixed Issue with LearnDash shortcodes when ProPanel is activated\r\n* Fixed Error on quiz statistics loading on front-end from ProPanel activity widget\r\n\r\n= 2.1.3.1 =\r\n\r\n* Updated license and update calls to use SSL for secure connections.\r\n\r\nView our full changelog [here](https://support.learndash.com/articles/propanel-changelog/).\r\n\r\n\";s:7:\"content\";s:646:\"<h4>2.1.4</h4> \n<ul>\n<li>Added Filter by dates</li>\n<li>Added RTL support</li>\n<li>Fixed ProPanel Reporting widget not updating</li>\n<li>Fixed Users results stats not showing in dashboard</li>\n<li>Fixed 403 errors </li>\n<li>Fixed ProPanel translation issues</li>\n<li>Fixed Issue with LearnDash shortcodes when ProPanel is activated</li>\n<li>\n<p>Fixed Error on quiz statistics loading on front-end from ProPanel activity widget</p>\n<h4>2.1.3.1</h4>\n</li>\n<li>Updated license and update calls to use SSL for secure connections.</li>\n</ul>\n<p>View our full changelog <a href=\"https://support.learndash.com/articles/propanel-changelog/\">here</a>.</p>\";}s:3:\"faq\";a:3:{s:5:\"title\";s:3:\"FAQ\";s:11:\"content_raw\";s:931:\"= Do I need to update? =\r\n\r\nIt is always recommended to update. However given the nature of WordPress and the option to have many other plugins installed, custom code, etc. it is possible that a conflict would arise. This is why we always recommend testing the update on a development environment first. \r\n\r\n= Why am I getting an error notice when trying to update? =\r\n\r\nIf you are getting an error while trying to update your version of LearnDash LMS, verify that your license is still valid. \r\n\r\nBoth your license key and email address should be entered via LEARNDASH LMS > SETTINGS > PROPANEL LICENSE.\r\n\r\nIf you see an invalid license message, you can find your correct information via our [Support Site](https://support.learndash.com/articles/my-downloads/).\r\n\r\nIf your license has expired, you can purchase a new one [here](https://www.learndash.com/pricing-and-purchase/). ProPanel is part of both the Plus and Pro package.\r\n\";s:7:\"content\";s:0:\"\";}s:4:\"tags\";a:0:{}s:12:\"contributors\";a:0:{}s:8:\"sections\";a:3:{s:11:\"description\";s:394:\"<p>Easily manage and view your LearnDash LMS activity.</p>\n<p>ProPanel enhances your LearnDash admin experience by consolidating reporting and assignment management, giving you the ability to send course specific communications, and showing real-time activity of your courses!</p>\n<p>See the <a href=\"https://www.learndash.com/propanel-by-learndash/\">Features</a> page for more information.</p>\";s:12:\"installation\";s:529:\"<p>If the auto-update is not working, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of ProPanel.</li>\n<li>Download the latest version of ProPanel from our <a href=\"https://support.learndash.com/articles/my-downloads/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the ProPanel plugin via the PLUGINS menu.</li>\n</ol>\";s:9:\"changelog\";s:646:\"<h4>2.1.4</h4> \n<ul>\n<li>Added Filter by dates</li>\n<li>Added RTL support</li>\n<li>Fixed ProPanel Reporting widget not updating</li>\n<li>Fixed Users results stats not showing in dashboard</li>\n<li>Fixed 403 errors </li>\n<li>Fixed ProPanel translation issues</li>\n<li>Fixed Issue with LearnDash shortcodes when ProPanel is activated</li>\n<li>\n<p>Fixed Error on quiz statistics loading on front-end from ProPanel activity widget</p>\n<h4>2.1.3.1</h4>\n</li>\n<li>Updated license and update calls to use SSL for secure connections.</li>\n</ul>\n<p>View our full changelog <a href=\"https://support.learndash.com/articles/propanel-changelog/\">here</a>.</p>\";}s:4:\"file\";s:100:\"C:\\laragon\\www\\hamyarlearn/wp-content/uploads/learndash/add-ons/learndash-propanel-readme_readme.txt\";s:10:\"last_check\";i:1604252209;s:8:\"external\";b:1;s:7:\"bb_slug\";s:25:\"learndash-propanel-readme\";s:8:\"homepage\";s:44:\"https://learndash.com/propanel-by-learndash/\";s:12:\"last_updated\";s:19:\"2020-10-15 00:00:00\";s:7:\"version\";s:5:\"2.1.4\";s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:5:\"5.5.1\";s:5:\"icons\";a:3:{s:2:\"1x\";s:104:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-propanel_256x256.jpg\";s:2:\"2x\";s:104:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-propanel_256x256.jpg\";s:7:\"default\";s:104:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-propanel_256x256.jpg\";}s:7:\"banners\";a:3:{s:3:\"low\";s:103:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-propanel_banner.jpg\";s:4:\"high\";s:103:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-propanel_banner.jpg\";s:7:\"default\";s:103:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-propanel_banner.jpg\";}s:11:\"show-add-on\";s:2:\"no\";}s:19:\"learndash-elementor\";a:29:{s:4:\"name\";s:23:\"Elementor for LearnDash\";s:6:\"author\";s:45:\"<a href=\"https://learndash.com\">LearnDash</a>\";s:10:\"author_uri\";s:21:\"https://learndash.com\";s:10:\"plugin_uri\";s:22:\"https://learndash.com/\";s:4:\"slug\";s:19:\"learndash-elementor\";s:17:\"requires_at_least\";s:3:\"5.0\";s:12:\"tested_up_to\";s:3:\"5.4\";s:12:\"requires_php\";s:3:\"7.0\";s:10:\"stable_tag\";s:5:\"1.0.2\";s:17:\"short_description\";s:75:\"LearnDash LMS add-on to add support native Elementor templates and widgets.\";s:12:\"is_truncated\";b:0;s:11:\"description\";a:3:{s:5:\"title\";s:11:\"Description\";s:11:\"content_raw\";s:227:\"Integrate LearnDash LMS with Elementor. \r\n\r\n= Integration Features = \r\n\r\n* Native Elementor templates and widgets\r\n\r\nSee the [Add-on](https://www.learndash.com/support/docs/add-ons/compatibility/) page for more information.\r\n\r\n\";s:7:\"content\";s:262:\"<p>Integrate LearnDash LMS with Elementor. </p>\n<h4>Integration Features</h4> \n<ul>\n<li>Native Elementor templates and widgets</li>\n</ul>\n<p>See the <a href=\"https://www.learndash.com/support/docs/add-ons/compatibility/\">Add-on</a> page for more information.</p>\";}s:12:\"installation\";a:3:{s:5:\"title\";s:12:\"Installation\";s:11:\"content_raw\";s:601:\"If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS > SETTINGS > LMS LICENSE. \r\n\r\nAlternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. \r\n\r\n1. Deactivate and delete your current version of the add-on.\r\n1. Download the latest version of the add-on from our [support site](https://support.learndash.com/article-categories/free/).\r\n1. Upload the zipped file via PLUGINS > ADD NEW, or to wp-content/plugins.\r\n1. Activate the add-on plugin via the PLUGINS menu.\r\n\r\n\";s:7:\"content\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";}s:9:\"changelog\";a:3:{s:5:\"title\";s:9:\"Changelog\";s:11:\"content_raw\";s:421:\"= 1.0.2 =\r\n\r\n* Fixed conflict with other premium Elementor add-on plugins\r\n\r\n= 1.0.1 =\r\n* Updated Assignment widget output within Lesson and Topic templates\r\n* Updated issue with duplicate output via `post_content` widget\r\n* Updated style settings on some widgets\r\n* Added support for Course Grid settings in some widgets\r\n\r\nView the full changelog [here](https://www.learndash.com/support/docs/add-ons/compatibility/).\r\n\";s:7:\"content\";s:491:\"<h4>1.0.2</h4>\n<ul>\n<li>Fixed conflict with other premium Elementor add-on plugins\n<h4>1.0.1</h4></li>\n<li>Updated Assignment widget output within Lesson and Topic templates</li>\n<li>Updated issue with duplicate output via <code>post_content</code> widget</li>\n<li>Updated style settings on some widgets</li>\n<li>Added support for Course Grid settings in some widgets</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/support/docs/add-ons/compatibility/\">here</a>.</p>\";}s:4:\"tags\";a:0:{}s:12:\"contributors\";a:0:{}s:8:\"sections\";a:3:{s:11:\"description\";s:262:\"<p>Integrate LearnDash LMS with Elementor. </p>\n<h4>Integration Features</h4> \n<ul>\n<li>Native Elementor templates and widgets</li>\n</ul>\n<p>See the <a href=\"https://www.learndash.com/support/docs/add-ons/compatibility/\">Add-on</a> page for more information.</p>\";s:12:\"installation\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";s:9:\"changelog\";s:491:\"<h4>1.0.2</h4>\n<ul>\n<li>Fixed conflict with other premium Elementor add-on plugins\n<h4>1.0.1</h4></li>\n<li>Updated Assignment widget output within Lesson and Topic templates</li>\n<li>Updated issue with duplicate output via <code>post_content</code> widget</li>\n<li>Updated style settings on some widgets</li>\n<li>Added support for Course Grid settings in some widgets</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/support/docs/add-ons/compatibility/\">here</a>.</p>\";}s:4:\"file\";s:94:\"C:\\laragon\\www\\hamyarlearn/wp-content/uploads/learndash/add-ons/learndash-elementor_readme.txt\";s:10:\"last_check\";i:1604252209;s:8:\"external\";b:1;s:7:\"bb_slug\";s:19:\"learndash-elementor\";s:8:\"homepage\";s:22:\"https://learndash.com/\";s:12:\"last_updated\";s:19:\"2020-09-17 00:00:00\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:3:\"5.4\";s:5:\"icons\";a:3:{s:2:\"1x\";s:103:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_256x256.jpg\";s:2:\"2x\";s:103:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_256x256.jpg\";s:7:\"default\";s:103:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_256x256.jpg\";}s:7:\"banners\";a:3:{s:3:\"low\";s:102:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_banner.jpg\";s:4:\"high\";s:102:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_banner.jpg\";s:7:\"default\";s:102:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_banner.jpg\";}s:13:\"plugin_status\";a:4:{s:6:\"status\";s:7:\"install\";s:7:\"version\";s:5:\"1.0.2\";s:4:\"file\";b:0;s:3:\"url\";s:213:\"http://localhost/hamyarlearn/wp-admin/update.php?action=install-plugin&amp;plugin=learndash-elementor&amp;_wpnonce=3e14c77a0d&ld-return-addons=/hamyarlearn/wp-admin/admin.php?page=wpseo_tools&start-indexation=true\";}}s:23:\"learndash-notifications\";a:30:{s:4:\"name\";s:23:\"LearnDash Notifications\";s:6:\"author\";s:45:\"<a href=\"https://learndash.com\">LearnDash</a>\";s:10:\"author_uri\";s:21:\"https://learndash.com\";s:10:\"plugin_uri\";s:53:\"https://learndash.com/add-on/learndash-notifications/\";s:20:\"ld_requires_at_least\";s:3:\"3.0\";s:4:\"slug\";s:23:\"learndash-notifications\";s:4:\"tags\";a:2:{i:0;s:13:\"notifications\";i:1;s:6:\"emails\";}s:17:\"requires_at_least\";s:3:\"5.0\";s:12:\"tested_up_to\";s:3:\"5.4\";s:12:\"requires_php\";s:3:\"7.0\";s:10:\"stable_tag\";s:5:\"1.4.1\";s:17:\"short_description\";s:52:\"Send email notifications based on LearnDash actions.\";s:12:\"is_truncated\";b:0;s:11:\"description\";a:3:{s:5:\"title\";s:11:\"Description\";s:11:\"content_raw\";s:625:\"Send email notifications based on LearnDash actions.\r\n\r\nThis add-on enables a new level of learner engagement within your LearnDash courses. Configure various notifications to be sent out automatically based on what learners do (and do not do) in a course.\r\n\r\nThis is a perfect tool for bolstering learner engagement, encouragement, promotions, and cross-selling.\r\n\r\n= Add-on Features = \r\n\r\n* Automatically Send Notifications\r\n* 13 Available Triggers\r\n* 34 Dynamic Shortcodes\r\n* Delay Notifications\r\n* Choose Recipients\r\n\r\nSee the [Add-on](https://learndash.com/add-on/learndash-notifications/) page for more information.\r\n\r\n\";s:7:\"content\";s:692:\"<p>Send email notifications based on LearnDash actions.</p>\n<p>This add-on enables a new level of learner engagement within your LearnDash courses. Configure various notifications to be sent out automatically based on what learners do (and do not do) in a course.</p>\n<p>This is a perfect tool for bolstering learner engagement, encouragement, promotions, and cross-selling.</p>\n<h4>Add-on Features</h4> \n<ul>\n<li>Automatically Send Notifications</li>\n<li>13 Available Triggers</li>\n<li>34 Dynamic Shortcodes</li>\n<li>Delay Notifications</li>\n<li>Choose Recipients</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/learndash-notifications/\">Add-on</a> page for more information.</p>\";}s:12:\"installation\";a:3:{s:5:\"title\";s:12:\"Installation\";s:11:\"content_raw\";s:601:\"If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS > SETTINGS > LMS LICENSE. \r\n\r\nAlternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. \r\n\r\n1. Deactivate and delete your current version of the add-on.\r\n1. Download the latest version of the add-on from our [support site](https://support.learndash.com/article-categories/free/).\r\n1. Upload the zipped file via PLUGINS > ADD NEW, or to wp-content/plugins.\r\n1. Activate the add-on plugin via the PLUGINS menu.\r\n\r\n\";s:7:\"content\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";}s:9:\"changelog\";a:3:{s:5:\"title\";s:9:\"Changelog\";s:11:\"content_raw\";s:748:\"= 1.4.1 =\r\n* Updated delay field unchangeable for edit to prevent issue with delayed emails\r\n* Updated use of global delete function instead of create new queries in delete functions\r\n* Updated remove `learndash_notifications_delete_delayed_emails_when_unenrolled` hooked function because it already exists in `includes/database.php`\r\n* Updated use of `learndash_get_users_for_course()` to pull course users instead of access list meta only\r\n* Fixed lesson available notification not queueing multiple notifications in DB if there are more than 1 notifications posts\r\n* Fixed regex pattern for searching notifications by shortcode data key value pair\r\n\r\n\r\nView the full changelog [here](https://www.learndash.com/add-on/learndash-notifications/).\r\n\";s:7:\"content\";s:844:\"<h4>1.4.1</h4>\n<ul>\n<li>Updated delay field unchangeable for edit to prevent issue with delayed emails</li>\n<li>Updated use of global delete function instead of create new queries in delete functions</li>\n<li>Updated remove <code>learndash_notifications_delete_delayed_emails_when_unenrolled</code> hooked function because it already exists in <code>includes/database.php</code></li>\n<li>Updated use of <code>learndash_get_users_for_course()</code> to pull course users instead of access list meta only</li>\n<li>Fixed lesson available notification not queueing multiple notifications in DB if there are more than 1 notifications posts</li>\n<li>Fixed regex pattern for searching notifications by shortcode data key value pair</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/learndash-notifications/\">here</a>.</p>\";}s:12:\"contributors\";a:0:{}s:8:\"sections\";a:3:{s:11:\"description\";s:692:\"<p>Send email notifications based on LearnDash actions.</p>\n<p>This add-on enables a new level of learner engagement within your LearnDash courses. Configure various notifications to be sent out automatically based on what learners do (and do not do) in a course.</p>\n<p>This is a perfect tool for bolstering learner engagement, encouragement, promotions, and cross-selling.</p>\n<h4>Add-on Features</h4> \n<ul>\n<li>Automatically Send Notifications</li>\n<li>13 Available Triggers</li>\n<li>34 Dynamic Shortcodes</li>\n<li>Delay Notifications</li>\n<li>Choose Recipients</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/learndash-notifications/\">Add-on</a> page for more information.</p>\";s:12:\"installation\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";s:9:\"changelog\";s:844:\"<h4>1.4.1</h4>\n<ul>\n<li>Updated delay field unchangeable for edit to prevent issue with delayed emails</li>\n<li>Updated use of global delete function instead of create new queries in delete functions</li>\n<li>Updated remove <code>learndash_notifications_delete_delayed_emails_when_unenrolled</code> hooked function because it already exists in <code>includes/database.php</code></li>\n<li>Updated use of <code>learndash_get_users_for_course()</code> to pull course users instead of access list meta only</li>\n<li>Fixed lesson available notification not queueing multiple notifications in DB if there are more than 1 notifications posts</li>\n<li>Fixed regex pattern for searching notifications by shortcode data key value pair</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/learndash-notifications/\">here</a>.</p>\";}s:4:\"file\";s:98:\"C:\\laragon\\www\\hamyarlearn/wp-content/uploads/learndash/add-ons/learndash-notifications_readme.txt\";s:10:\"last_check\";i:1604252209;s:8:\"external\";b:1;s:7:\"bb_slug\";s:23:\"learndash-notifications\";s:8:\"homepage\";s:53:\"https://learndash.com/add-on/learndash-notifications/\";s:12:\"last_updated\";s:19:\"2020-08-07 00:00:00\";s:7:\"version\";s:5:\"1.4.1\";s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:3:\"5.4\";s:5:\"icons\";a:3:{s:2:\"1x\";s:109:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-notifications_256x256.jpg\";s:2:\"2x\";s:109:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-notifications_256x256.jpg\";s:7:\"default\";s:109:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-notifications_256x256.jpg\";}s:7:\"banners\";a:3:{s:3:\"low\";s:108:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-notifications_banner.jpg\";s:4:\"high\";s:108:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-notifications_banner.jpg\";s:7:\"default\";s:108:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-notifications_banner.jpg\";}s:13:\"plugin_status\";a:4:{s:6:\"status\";s:7:\"install\";s:7:\"version\";s:5:\"1.4.1\";s:4:\"file\";b:0;s:3:\"url\";s:217:\"http://localhost/hamyarlearn/wp-admin/update.php?action=install-plugin&amp;plugin=learndash-notifications&amp;_wpnonce=b8b2245e9a&ld-return-addons=/hamyarlearn/wp-admin/admin.php?page=wpseo_tools&start-indexation=true\";}}s:21:\"learndash-memberpress\";a:30:{s:4:\"name\";s:25:\"MemberPress for LearnDash\";s:6:\"author\";s:45:\"<a href=\"https://learndash.com\">LearnDash</a>\";s:10:\"author_uri\";s:21:\"https://learndash.com\";s:10:\"plugin_uri\";s:41:\"https://learndash.com/add-on/memberpress/\";s:20:\"ld_requires_at_least\";s:3:\"2.5\";s:4:\"slug\";s:21:\"learndash-memberpress\";s:4:\"tags\";a:4:{i:0;s:11:\"integration\";i:1;s:10:\"membership\";i:2;s:11:\"memberpress\";i:3;s:0:\"\";}s:17:\"requires_at_least\";s:3:\"5.0\";s:12:\"tested_up_to\";s:3:\"5.4\";s:12:\"requires_php\";s:3:\"7.0\";s:10:\"stable_tag\";s:3:\"2.1\";s:17:\"short_description\";s:41:\"Integrate LearnDash LMS with MemberPress.\";s:12:\"is_truncated\";b:0;s:11:\"description\";a:3:{s:5:\"title\";s:11:\"Description\";s:11:\"content_raw\";s:673:\"Integrate LearnDash LMS with MemberPress.\r\n\r\nMemberPress is a premium WordPress membership plugin that excels in memberships, grouping, coupons, reminders, reports, and more.\r\n\r\nWith this integration you can create membership levels in MemberPress and associate the access levels to LearnDash courses. Customers are then auto-enrolled into courses after signing-up for membership.\r\n\r\n= Integration Features = \r\n\r\n* Associate membership levels to one or more courses\r\n* Automatic removal upon membership cancellation\r\n* Create trial membership levels with various payment gateways\r\n\r\nSee the [Add-on](https://learndash.com/add-on/memberpress/) page for more information.\r\n\r\n\";s:7:\"content\";s:728:\"<p>Integrate LearnDash LMS with MemberPress.</p>\n<p>MemberPress is a premium WordPress membership plugin that excels in memberships, grouping, coupons, reminders, reports, and more.</p>\n<p>With this integration you can create membership levels in MemberPress and associate the access levels to LearnDash courses. Customers are then auto-enrolled into courses after signing-up for membership.</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Associate membership levels to one or more courses</li>\n<li>Automatic removal upon membership cancellation</li>\n<li>Create trial membership levels with various payment gateways</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/memberpress/\">Add-on</a> page for more information.</p>\";}s:12:\"installation\";a:3:{s:5:\"title\";s:12:\"Installation\";s:11:\"content_raw\";s:601:\"If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS > SETTINGS > LMS LICENSE. \r\n\r\nAlternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. \r\n\r\n1. Deactivate and delete your current version of the add-on.\r\n1. Download the latest version of the add-on from our [support site](https://support.learndash.com/article-categories/free/).\r\n1. Upload the zipped file via PLUGINS > ADD NEW, or to wp-content/plugins.\r\n1. Activate the add-on plugin via the PLUGINS menu.\r\n\r\n\";s:7:\"content\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";}s:9:\"changelog\";a:3:{s:5:\"title\";s:9:\"Changelog\";s:11:\"content_raw\";s:381:\"= 2.1.1 =\r\n* Updated process course queue update 1 at a time\r\n* Updated make sure the returned membership associated courses value is unique\r\n* Fixed cron update course access run in batch for transactions and subscriptions to prevent timeout error\r\n* Fixed missing cron schedules filter parameter\r\n\r\nView the full changelog [here](https://www.learndash.com/add-on/memberpress/).\r\n\";s:7:\"content\";s:434:\"<h4>2.1.1</h4>\n<ul>\n<li>Updated process course queue update 1 at a time</li>\n<li>Updated make sure the returned membership associated courses value is unique</li>\n<li>Fixed cron update course access run in batch for transactions and subscriptions to prevent timeout error</li>\n<li>Fixed missing cron schedules filter parameter</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/memberpress/\">here</a>.</p>\";}s:12:\"contributors\";a:0:{}s:8:\"sections\";a:3:{s:11:\"description\";s:728:\"<p>Integrate LearnDash LMS with MemberPress.</p>\n<p>MemberPress is a premium WordPress membership plugin that excels in memberships, grouping, coupons, reminders, reports, and more.</p>\n<p>With this integration you can create membership levels in MemberPress and associate the access levels to LearnDash courses. Customers are then auto-enrolled into courses after signing-up for membership.</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Associate membership levels to one or more courses</li>\n<li>Automatic removal upon membership cancellation</li>\n<li>Create trial membership levels with various payment gateways</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/memberpress/\">Add-on</a> page for more information.</p>\";s:12:\"installation\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";s:9:\"changelog\";s:434:\"<h4>2.1.1</h4>\n<ul>\n<li>Updated process course queue update 1 at a time</li>\n<li>Updated make sure the returned membership associated courses value is unique</li>\n<li>Fixed cron update course access run in batch for transactions and subscriptions to prevent timeout error</li>\n<li>Fixed missing cron schedules filter parameter</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/memberpress/\">here</a>.</p>\";}s:4:\"file\";s:96:\"C:/laragon/www/hamyarlearn/wp-content/uploads/learndash/add-ons/learndash-memberpress_readme.txt\";s:10:\"last_check\";i:1594375649;s:8:\"external\";b:1;s:7:\"bb_slug\";s:21:\"learndash-memberpress\";s:8:\"homepage\";s:41:\"https://learndash.com/add-on/memberpress/\";s:12:\"last_updated\";s:19:\"2020-05-08 00:00:00\";s:7:\"version\";s:3:\"2.1\";s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:3:\"5.4\";s:5:\"icons\";a:3:{s:2:\"1x\";s:107:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-memberpress_256x256.jpg\";s:2:\"2x\";s:107:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-memberpress_256x256.jpg\";s:7:\"default\";s:107:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-memberpress_256x256.jpg\";}s:7:\"banners\";a:3:{s:3:\"low\";s:106:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-memberpress_banner.jpg\";s:4:\"high\";s:106:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-memberpress_banner.jpg\";s:7:\"default\";s:106:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-memberpress_banner.jpg\";}s:13:\"plugin_status\";a:4:{s:6:\"status\";s:7:\"install\";s:7:\"version\";s:3:\"2.1\";s:4:\"file\";b:0;s:3:\"url\";s:215:\"http://localhost/hamyarlearn/wp-admin/update.php?action=install-plugin&amp;plugin=learndash-memberpress&amp;_wpnonce=24f1aab536&ld-return-addons=/hamyarlearn/wp-admin/admin.php?page=wpseo_tools&start-indexation=true\";}}s:25:\"learndash-paidmemberships\";a:30:{s:4:\"name\";s:32:\"PaidMembershipsPro for LearnDash\";s:6:\"author\";s:45:\"<a href=\"https://learndash.com\">LearnDash</a>\";s:10:\"author_uri\";s:21:\"https://learndash.com\";s:10:\"plugin_uri\";s:48:\"https://learndash.com/add-on/paidmembershipspro/\";s:20:\"ld_requires_at_least\";s:3:\"3.0\";s:4:\"slug\";s:25:\"learndash-paidmemberships\";s:4:\"tags\";a:4:{i:0;s:11:\"integration\";i:1;s:10:\"membership\";i:2;s:20:\"paid memberships pro\";i:3;s:0:\"\";}s:17:\"requires_at_least\";s:3:\"5.0\";s:12:\"tested_up_to\";s:3:\"5.4\";s:12:\"requires_php\";s:3:\"7.0\";s:10:\"stable_tag\";s:5:\"1.2.0\";s:17:\"short_description\";s:50:\"Integrate LearnDash LMS with Paid Memberships Pro.\";s:12:\"is_truncated\";b:0;s:11:\"description\";a:3:{s:5:\"title\";s:11:\"Description\";s:11:\"content_raw\";s:712:\"Integrate LearnDash LMS with Paid Memberships Pro.\r\n\r\nPaidMemberships Pro is one of the most popular free membership plugins available for WordPress with robust user statistics and reporting of membership levels. \r\n\r\nWith this integration, you can create membership level access and associate the access levels to LearnDash courses. Customers are auto-enrolled into courses after signing-up for membership.\r\n\r\n= Integration Features = \r\n\r\n* Associate membership levels to one or more courses\r\n* Auto-expire membership levels after X amount of time\r\n* Create trial membership levels with various payment gateways\r\n\r\nSee the [Add-on](https://learndash.com/add-on/paidmembershipspro/) page for more information.\r\n\r\n\";s:7:\"content\";s:767:\"<p>Integrate LearnDash LMS with Paid Memberships Pro.</p>\n<p>PaidMemberships Pro is one of the most popular free membership plugins available for WordPress with robust user statistics and reporting of membership levels. </p>\n<p>With this integration, you can create membership level access and associate the access levels to LearnDash courses. Customers are auto-enrolled into courses after signing-up for membership.</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Associate membership levels to one or more courses</li>\n<li>Auto-expire membership levels after X amount of time</li>\n<li>Create trial membership levels with various payment gateways</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/paidmembershipspro/\">Add-on</a> page for more information.</p>\";}s:12:\"installation\";a:3:{s:5:\"title\";s:12:\"Installation\";s:11:\"content_raw\";s:601:\"If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS > SETTINGS > LMS LICENSE. \r\n\r\nAlternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. \r\n\r\n1. Deactivate and delete your current version of the add-on.\r\n1. Download the latest version of the add-on from our [support site](https://support.learndash.com/article-categories/free/).\r\n1. Upload the zipped file via PLUGINS > ADD NEW, or to wp-content/plugins.\r\n1. Activate the add-on plugin via the PLUGINS menu.\r\n\r\n\";s:7:\"content\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";}s:9:\"changelog\";a:3:{s:5:\"title\";s:9:\"Changelog\";s:11:\"content_raw\";s:358:\"= 1.2.0 =\r\n* Added LD integration PMP submenu page and add retroactive tool button\r\n* Added retroactive tool\r\n* Added disable PMP protection for courses page\r\n* Updated improve metabox saving function to require membership option\r\n* Fixed undefined index error notice\r\n\r\nView the full changelog [here](https://www.learndash.com/add-on/paidmembershipspro/).\r\n\";s:7:\"content\";s:417:\"<h4>1.2.0</h4>\n<ul>\n<li>Added LD integration PMP submenu page and add retroactive tool button</li>\n<li>Added retroactive tool</li>\n<li>Added disable PMP protection for courses page</li>\n<li>Updated improve metabox saving function to require membership option</li>\n<li>Fixed undefined index error notice</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/paidmembershipspro/\">here</a>.</p>\";}s:12:\"contributors\";a:0:{}s:8:\"sections\";a:3:{s:11:\"description\";s:767:\"<p>Integrate LearnDash LMS with Paid Memberships Pro.</p>\n<p>PaidMemberships Pro is one of the most popular free membership plugins available for WordPress with robust user statistics and reporting of membership levels. </p>\n<p>With this integration, you can create membership level access and associate the access levels to LearnDash courses. Customers are auto-enrolled into courses after signing-up for membership.</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Associate membership levels to one or more courses</li>\n<li>Auto-expire membership levels after X amount of time</li>\n<li>Create trial membership levels with various payment gateways</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/paidmembershipspro/\">Add-on</a> page for more information.</p>\";s:12:\"installation\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";s:9:\"changelog\";s:417:\"<h4>1.2.0</h4>\n<ul>\n<li>Added LD integration PMP submenu page and add retroactive tool button</li>\n<li>Added retroactive tool</li>\n<li>Added disable PMP protection for courses page</li>\n<li>Updated improve metabox saving function to require membership option</li>\n<li>Fixed undefined index error notice</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/paidmembershipspro/\">here</a>.</p>\";}s:4:\"file\";s:100:\"C:/laragon/www/hamyarlearn/wp-content/uploads/learndash/add-ons/learndash-paidmemberships_readme.txt\";s:10:\"last_check\";i:1594375649;s:8:\"external\";b:1;s:7:\"bb_slug\";s:25:\"learndash-paidmemberships\";s:8:\"homepage\";s:48:\"https://learndash.com/add-on/paidmembershipspro/\";s:12:\"last_updated\";s:19:\"2020-05-07 00:00:00\";s:7:\"version\";s:5:\"1.2.0\";s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:3:\"5.4\";s:5:\"icons\";a:3:{s:2:\"1x\";s:111:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-paidmemberships_256x256.jpg\";s:2:\"2x\";s:111:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-paidmemberships_256x256.jpg\";s:7:\"default\";s:111:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-paidmemberships_256x256.jpg\";}s:7:\"banners\";a:3:{s:3:\"low\";s:110:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-paidmemberships_banner.jpg\";s:4:\"high\";s:110:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-paidmemberships_banner.jpg\";s:7:\"default\";s:110:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-paidmemberships_banner.jpg\";}s:13:\"plugin_status\";a:4:{s:6:\"status\";s:7:\"install\";s:7:\"version\";s:5:\"1.2.0\";s:4:\"file\";b:0;s:3:\"url\";s:219:\"http://localhost/hamyarlearn/wp-admin/update.php?action=install-plugin&amp;plugin=learndash-paidmemberships&amp;_wpnonce=53e34b09ca&ld-return-addons=/hamyarlearn/wp-admin/admin.php?page=wpseo_tools&start-indexation=true\";}}s:21:\"learndash-course-grid\";a:30:{s:4:\"name\";s:21:\"LearnDash Course Grid\";s:6:\"author\";s:45:\"<a href=\"https://learndash.com\">LearnDash</a>\";s:10:\"author_uri\";s:21:\"https://learndash.com\";s:10:\"plugin_uri\";s:41:\"https://learndash.com/add-on/course-grid/\";s:20:\"ld_requires_at_least\";s:3:\"3.0\";s:4:\"slug\";s:21:\"learndash-course-grid\";s:4:\"tags\";a:3:{i:0;s:4:\"grid\";i:1;s:4:\"view\";i:2;s:7:\"display\";}s:17:\"requires_at_least\";s:3:\"5.0\";s:12:\"tested_up_to\";s:3:\"5.4\";s:12:\"requires_php\";s:3:\"7.0\";s:10:\"stable_tag\";s:5:\"1.6.0\";s:17:\"short_description\";s:79:\"Transform the course list created with shortcode [ld_course_list] to grid view.\";s:12:\"is_truncated\";b:0;s:11:\"description\";a:3:{s:5:\"title\";s:11:\"Description\";s:11:\"content_raw\";s:604:\"The Course Grid add-on gives you the ability to create a responsive course library that can be inserted on any page or post of your site. This is a perfect feature if you have a variety of course offerings and want to give users the ability to filter through them by category.\r\n\r\n= Add-on Features = \r\n\r\n* Responsive grid layout of courses\r\n* Filtering by category\r\n* Display course featured image and short description\r\n* Featured video support\r\n* Dynamic course price listing\r\n* Dynamic course status listing\r\n\r\nSee the [Add-on](https://learndash.com/add-on/course-grid/) page for more information.\r\n\r\n\";s:7:\"content\";s:669:\"<p>The Course Grid add-on gives you the ability to create a responsive course library that can be inserted on any page or post of your site. This is a perfect feature if you have a variety of course offerings and want to give users the ability to filter through them by category.</p>\n<h4>Add-on Features</h4> \n<ul>\n<li>Responsive grid layout of courses</li>\n<li>Filtering by category</li>\n<li>Display course featured image and short description</li>\n<li>Featured video support</li>\n<li>Dynamic course price listing</li>\n<li>Dynamic course status listing</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/course-grid/\">Add-on</a> page for more information.</p>\";}s:12:\"installation\";a:3:{s:5:\"title\";s:12:\"Installation\";s:11:\"content_raw\";s:601:\"If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS > SETTINGS > LMS LICENSE. \r\n\r\nAlternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. \r\n\r\n1. Deactivate and delete your current version of the add-on.\r\n1. Download the latest version of the add-on from our [support site](https://support.learndash.com/article-categories/free/).\r\n1. Upload the zipped file via PLUGINS > ADD NEW, or to wp-content/plugins.\r\n1. Activate the add-on plugin via the PLUGINS menu.\r\n\r\n\";s:7:\"content\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";}s:9:\"changelog\";a:3:{s:5:\"title\";s:9:\"Changelog\";s:11:\"content_raw\";s:817:\"= 1.6.0 =\r\n\r\n* Added hook to filter course grid html output\r\n* Added docblock for html output filter\r\n* Added class container class names and its filter hook\r\n* Updated ribbon text escaping to wp_kses_post instead of esc_attr\r\n* Updated load grid resources on LD courses archive page\r\n* Updated plugin name and description\r\n* Updated LD get course price helper function to allow users filter the values\r\n* Updated to remove #ld_course_list wrapper on course grid shortcode to prevent conflicts with page builder plugins\r\n* Fixed thumbnail course URL redirects to bare URL instead of nested URL\r\n* Fixed short description unable to be set to empty because legacy value is not saved when saving new value\r\n* Fixed undefined index error\r\n\r\nView the full changelog [here](https://www.learndash.com/add-on/course-grid/).\r\n\";s:7:\"content\";s:910:\"<h4>1.6.0</h4>\n<ul>\n<li>Added hook to filter course grid html output</li>\n<li>Added docblock for html output filter</li>\n<li>Added class container class names and its filter hook</li>\n<li>Updated ribbon text escaping to wp_kses_post instead of esc_attr</li>\n<li>Updated load grid resources on LD courses archive page</li>\n<li>Updated plugin name and description</li>\n<li>Updated LD get course price helper function to allow users filter the values</li>\n<li>Updated to remove #ld_course_list wrapper on course grid shortcode to prevent conflicts with page builder plugins</li>\n<li>Fixed thumbnail course URL redirects to bare URL instead of nested URL</li>\n<li>Fixed short description unable to be set to empty because legacy value is not saved when saving new value</li>\n<li>Fixed undefined index error</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/course-grid/\">here</a>.</p>\";}s:12:\"contributors\";a:0:{}s:8:\"sections\";a:3:{s:11:\"description\";s:669:\"<p>The Course Grid add-on gives you the ability to create a responsive course library that can be inserted on any page or post of your site. This is a perfect feature if you have a variety of course offerings and want to give users the ability to filter through them by category.</p>\n<h4>Add-on Features</h4> \n<ul>\n<li>Responsive grid layout of courses</li>\n<li>Filtering by category</li>\n<li>Display course featured image and short description</li>\n<li>Featured video support</li>\n<li>Dynamic course price listing</li>\n<li>Dynamic course status listing</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/course-grid/\">Add-on</a> page for more information.</p>\";s:12:\"installation\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";s:9:\"changelog\";s:910:\"<h4>1.6.0</h4>\n<ul>\n<li>Added hook to filter course grid html output</li>\n<li>Added docblock for html output filter</li>\n<li>Added class container class names and its filter hook</li>\n<li>Updated ribbon text escaping to wp_kses_post instead of esc_attr</li>\n<li>Updated load grid resources on LD courses archive page</li>\n<li>Updated plugin name and description</li>\n<li>Updated LD get course price helper function to allow users filter the values</li>\n<li>Updated to remove #ld_course_list wrapper on course grid shortcode to prevent conflicts with page builder plugins</li>\n<li>Fixed thumbnail course URL redirects to bare URL instead of nested URL</li>\n<li>Fixed short description unable to be set to empty because legacy value is not saved when saving new value</li>\n<li>Fixed undefined index error</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/course-grid/\">here</a>.</p>\";}s:4:\"file\";s:96:\"C:/laragon/www/hamyarlearn/wp-content/uploads/learndash/add-ons/learndash-course-grid_readme.txt\";s:10:\"last_check\";i:1594375649;s:8:\"external\";b:1;s:7:\"bb_slug\";s:21:\"learndash-course-grid\";s:8:\"homepage\";s:41:\"https://learndash.com/add-on/course-grid/\";s:12:\"last_updated\";s:19:\"2020-04-17 00:00:00\";s:7:\"version\";s:5:\"1.6.0\";s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:3:\"5.4\";s:5:\"icons\";a:3:{s:2:\"1x\";s:107:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-course-grid_256x256.jpg\";s:2:\"2x\";s:107:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-course-grid_256x256.jpg\";s:7:\"default\";s:107:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-course-grid_256x256.jpg\";}s:7:\"banners\";a:3:{s:3:\"low\";s:106:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-course-grid_banner.jpg\";s:4:\"high\";s:106:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-course-grid_banner.jpg\";s:7:\"default\";s:106:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-course-grid_banner.jpg\";}s:13:\"plugin_status\";a:4:{s:6:\"status\";s:7:\"install\";s:7:\"version\";s:5:\"1.6.0\";s:4:\"file\";b:0;s:3:\"url\";s:215:\"http://localhost/hamyarlearn/wp-admin/update.php?action=install-plugin&amp;plugin=learndash-course-grid&amp;_wpnonce=4a93ba6150&ld-return-addons=/hamyarlearn/wp-admin/admin.php?page=wpseo_tools&start-indexation=true\";}}s:15:\"ld-multilingual\";a:29:{s:4:\"name\";s:34:\"LearnDash Multilingual Integration\";s:6:\"author\";s:45:\"<a href=\"https://learndash.com\">LearnDash</a>\";s:10:\"author_uri\";s:21:\"https://learndash.com\";s:10:\"plugin_uri\";s:22:\"https://learndash.com/\";s:4:\"slug\";s:15:\"ld-multilingual\";s:4:\"tags\";a:4:{i:0;s:11:\"integration\";i:1;s:12:\"translations\";i:2;s:4:\"wpml\";i:3;s:8:\"polylang\";}s:17:\"requires_at_least\";s:3:\"5.0\";s:12:\"tested_up_to\";s:3:\"5.4\";s:12:\"requires_php\";s:3:\"7.0\";s:10:\"stable_tag\";s:5:\"1.0.0\";s:17:\"short_description\";s:57:\"Adds Multilingual support with WPML and Polylang plugins.\";s:12:\"is_truncated\";b:0;s:11:\"description\";a:3:{s:5:\"title\";s:11:\"Description\";s:11:\"content_raw\";s:261:\"Integrate LearnDash LMS with WPML and Polylang. \r\n\r\n= Integration Features = \r\n\r\n* Compatibility with course and quiz builder\r\n* Translatable URLs \r\n\r\nSee the [Add-on](https://www.learndash.com/support/docs/add-ons/compatibility/) page for more information.\r\n\r\n\";s:7:\"content\";s:302:\"<p>Integrate LearnDash LMS with WPML and Polylang. </p>\n<h4>Integration Features</h4> \n<ul>\n<li>Compatibility with course and quiz builder</li>\n<li>Translatable URLs </li>\n</ul>\n<p>See the <a href=\"https://www.learndash.com/support/docs/add-ons/compatibility/\">Add-on</a> page for more information.</p>\";}s:12:\"installation\";a:3:{s:5:\"title\";s:12:\"Installation\";s:11:\"content_raw\";s:601:\"If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS > SETTINGS > LMS LICENSE. \r\n\r\nAlternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. \r\n\r\n1. Deactivate and delete your current version of the add-on.\r\n1. Download the latest version of the add-on from our [support site](https://support.learndash.com/article-categories/free/).\r\n1. Upload the zipped file via PLUGINS > ADD NEW, or to wp-content/plugins.\r\n1. Activate the add-on plugin via the PLUGINS menu.\r\n\r\n\";s:7:\"content\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";}s:9:\"changelog\";a:3:{s:5:\"title\";s:9:\"Changelog\";s:11:\"content_raw\";s:128:\"= 1.0.0 =\r\n* Initial release\r\n\r\nView the full changelog [here](https://www.learndash.com/support/docs/add-ons/compatibility/).\r\n\";s:7:\"content\";s:163:\"<h4>1.0.0</h4>\n<ul>\n<li>Initial release</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/support/docs/add-ons/compatibility/\">here</a>.</p>\";}s:12:\"contributors\";a:0:{}s:8:\"sections\";a:3:{s:11:\"description\";s:302:\"<p>Integrate LearnDash LMS with WPML and Polylang. </p>\n<h4>Integration Features</h4> \n<ul>\n<li>Compatibility with course and quiz builder</li>\n<li>Translatable URLs </li>\n</ul>\n<p>See the <a href=\"https://www.learndash.com/support/docs/add-ons/compatibility/\">Add-on</a> page for more information.</p>\";s:12:\"installation\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";s:9:\"changelog\";s:163:\"<h4>1.0.0</h4>\n<ul>\n<li>Initial release</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/support/docs/add-ons/compatibility/\">here</a>.</p>\";}s:4:\"file\";s:90:\"C:/laragon/www/hamyarlearn/wp-content/uploads/learndash/add-ons/ld-multilingual_readme.txt\";s:10:\"last_check\";i:1594375649;s:8:\"external\";b:1;s:7:\"bb_slug\";s:15:\"ld-multilingual\";s:8:\"homepage\";s:22:\"https://learndash.com/\";s:12:\"last_updated\";s:19:\"2020-04-14 00:00:00\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:3:\"5.4\";s:5:\"icons\";a:3:{s:2:\"1x\";s:103:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_256x256.jpg\";s:2:\"2x\";s:103:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_256x256.jpg\";s:7:\"default\";s:103:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_256x256.jpg\";}s:7:\"banners\";a:3:{s:3:\"low\";s:102:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_banner.jpg\";s:4:\"high\";s:102:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_banner.jpg\";s:7:\"default\";s:102:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-default_banner.jpg\";}s:13:\"plugin_status\";a:4:{s:6:\"status\";s:7:\"install\";s:7:\"version\";s:5:\"1.0.0\";s:4:\"file\";b:0;s:3:\"url\";s:209:\"http://localhost/hamyarlearn/wp-admin/update.php?action=install-plugin&amp;plugin=ld-multilingual&amp;_wpnonce=7880cb3aac&ld-return-addons=/hamyarlearn/wp-admin/admin.php?page=wpseo_tools&start-indexation=true\";}}s:16:\"learndash-zapier\";a:30:{s:4:\"name\";s:20:\"Zapier for LearnDash\";s:6:\"author\";s:45:\"<a href=\"https://learndash.com\">LearnDash</a>\";s:10:\"author_uri\";s:21:\"https://learndash.com\";s:10:\"plugin_uri\";s:48:\"https://learndash.com/add-on/zapier-integration/\";s:20:\"ld_requires_at_least\";s:3:\"3.0\";s:4:\"slug\";s:16:\"learndash-zapier\";s:4:\"tags\";a:3:{i:0;s:11:\"integration\";i:1;s:6:\"zapier\";i:2;s:0:\"\";}s:17:\"requires_at_least\";s:3:\"5.0\";s:12:\"tested_up_to\";s:3:\"5.4\";s:12:\"requires_php\";s:1:\"7\";s:10:\"stable_tag\";s:5:\"2.1.0\";s:17:\"short_description\";s:36:\"Integrate LearnDash LMS with Zapier.\";s:12:\"is_truncated\";b:0;s:11:\"description\";a:3:{s:5:\"title\";s:11:\"Description\";s:11:\"content_raw\";s:648:\"Integrate LearnDash LMS with Zapier.\r\n\r\n\r\nZapier is a service that makes it easy for you to connect two applications without the need to know code, currently with a library of over 300 applications. Zapier calls these connections Zaps, and this integration lets you create Zaps that include LearnDash activities.\r\n\r\n= Integration Features = \r\n\r\n* Perform actions in over 300 applications based on seven specific LearnDash activities\r\n* Supports both global and specific LearnDash activity\r\n* Easily connect LearnDash to the popular Zapier program without code\r\n\r\nSee the [Add-on](https://learndash.com/add-on/zapier/) page for more information.\r\n\r\n\";s:7:\"content\";s:697:\"<p>Integrate LearnDash LMS with Zapier.</p>\n<p>Zapier is a service that makes it easy for you to connect two applications without the need to know code, currently with a library of over 300 applications. Zapier calls these connections Zaps, and this integration lets you create Zaps that include LearnDash activities.</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Perform actions in over 300 applications based on seven specific LearnDash activities</li>\n<li>Supports both global and specific LearnDash activity</li>\n<li>Easily connect LearnDash to the popular Zapier program without code</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/zapier/\">Add-on</a> page for more information.</p>\";}s:12:\"installation\";a:3:{s:5:\"title\";s:12:\"Installation\";s:11:\"content_raw\";s:601:\"If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS > SETTINGS > LMS LICENSE. \r\n\r\nAlternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. \r\n\r\n1. Deactivate and delete your current version of the add-on.\r\n1. Download the latest version of the add-on from our [support site](https://support.learndash.com/article-categories/free/).\r\n1. Upload the zipped file via PLUGINS > ADD NEW, or to wp-content/plugins.\r\n1. Activate the add-on plugin via the PLUGINS menu.\r\n\r\n\";s:7:\"content\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";}s:9:\"changelog\";a:3:{s:5:\"title\";s:9:\"Changelog\";s:11:\"content_raw\";s:1012:\"= 2.1.0 =\r\n\r\n* Added first name and last name to user response\r\n* Added create user param to toggle course access function\r\n* Added create user param to get user and toggle group membership functions\r\n* Added `add_to_group` and `remove_from_group` actions handler and add toggle membership helper\r\n* Added `get_user helper` to automatically create user if it does not exist or return it if it exists\r\n* Updated to return the last quiz result sample from the last user to get the latest quiz result possible\r\n* Updated `get_trigger_sample` and `get_object_sample` to be more efficient\r\n* Updated `get_response()` parser method and update respective sections accordingly\r\n* Updated to make first and last name field not required\r\n* Updated `get_group_field` action handler and its helpers\r\n* Fixed add array wrapper for `get_sample` response because it is expected by Zapier\r\n* Fixed get sample method returns wrapped response in array\r\n\r\nView the full changelog [here](https://www.learndash.com/add-on/zapier/).\r\n\";s:7:\"content\";s:1199:\"<h4>2.1.0</h4>\n<ul>\n<li>Added first name and last name to user response</li>\n<li>Added create user param to toggle course access function</li>\n<li>Added create user param to get user and toggle group membership functions</li>\n<li>Added <code>add_to_group</code> and <code>remove_from_group</code> actions handler and add toggle membership helper</li>\n<li>Added <code>get_user helper</code> to automatically create user if it does not exist or return it if it exists</li>\n<li>Updated to return the last quiz result sample from the last user to get the latest quiz result possible</li>\n<li>Updated <code>get_trigger_sample</code> and <code>get_object_sample</code> to be more efficient</li>\n<li>Updated <code>get_response()</code> parser method and update respective sections accordingly</li>\n<li>Updated to make first and last name field not required</li>\n<li>Updated <code>get_group_field</code> action handler and its helpers</li>\n<li>Fixed add array wrapper for <code>get_sample</code> response because it is expected by Zapier</li>\n<li>Fixed get sample method returns wrapped response in array</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/zapier/\">here</a>.</p>\";}s:12:\"contributors\";a:0:{}s:8:\"sections\";a:3:{s:11:\"description\";s:697:\"<p>Integrate LearnDash LMS with Zapier.</p>\n<p>Zapier is a service that makes it easy for you to connect two applications without the need to know code, currently with a library of over 300 applications. Zapier calls these connections Zaps, and this integration lets you create Zaps that include LearnDash activities.</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Perform actions in over 300 applications based on seven specific LearnDash activities</li>\n<li>Supports both global and specific LearnDash activity</li>\n<li>Easily connect LearnDash to the popular Zapier program without code</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/zapier/\">Add-on</a> page for more information.</p>\";s:12:\"installation\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";s:9:\"changelog\";s:1199:\"<h4>2.1.0</h4>\n<ul>\n<li>Added first name and last name to user response</li>\n<li>Added create user param to toggle course access function</li>\n<li>Added create user param to get user and toggle group membership functions</li>\n<li>Added <code>add_to_group</code> and <code>remove_from_group</code> actions handler and add toggle membership helper</li>\n<li>Added <code>get_user helper</code> to automatically create user if it does not exist or return it if it exists</li>\n<li>Updated to return the last quiz result sample from the last user to get the latest quiz result possible</li>\n<li>Updated <code>get_trigger_sample</code> and <code>get_object_sample</code> to be more efficient</li>\n<li>Updated <code>get_response()</code> parser method and update respective sections accordingly</li>\n<li>Updated to make first and last name field not required</li>\n<li>Updated <code>get_group_field</code> action handler and its helpers</li>\n<li>Fixed add array wrapper for <code>get_sample</code> response because it is expected by Zapier</li>\n<li>Fixed get sample method returns wrapped response in array</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/zapier/\">here</a>.</p>\";}s:4:\"file\";s:91:\"C:/laragon/www/hamyarlearn/wp-content/uploads/learndash/add-ons/learndash-zapier_readme.txt\";s:10:\"last_check\";i:1594375649;s:8:\"external\";b:1;s:7:\"bb_slug\";s:16:\"learndash-zapier\";s:8:\"homepage\";s:48:\"https://learndash.com/add-on/zapier-integration/\";s:12:\"last_updated\";s:19:\"2020-03-20 00:00:00\";s:7:\"version\";s:5:\"2.1.0\";s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:3:\"5.4\";s:5:\"icons\";a:3:{s:2:\"1x\";s:102:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-zapier_256x256.jpg\";s:2:\"2x\";s:102:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-zapier_256x256.jpg\";s:7:\"default\";s:102:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-zapier_256x256.jpg\";}s:7:\"banners\";a:3:{s:3:\"low\";s:101:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-zapier_banner.jpg\";s:4:\"high\";s:101:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-zapier_banner.jpg\";s:7:\"default\";s:101:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-zapier_banner.jpg\";}s:13:\"plugin_status\";a:4:{s:6:\"status\";s:7:\"install\";s:7:\"version\";s:5:\"2.1.0\";s:4:\"file\";b:0;s:3:\"url\";s:210:\"http://localhost/hamyarlearn/wp-admin/update.php?action=install-plugin&amp;plugin=learndash-zapier&amp;_wpnonce=b25b1cd51f&ld-return-addons=/hamyarlearn/wp-admin/admin.php?page=wpseo_tools&start-indexation=true\";}}s:17:\"learndash-bbpress\";a:30:{s:4:\"name\";s:21:\"bbPress for LearnDash\";s:6:\"author\";s:45:\"<a href=\"https://learndash.com\">LearnDash</a>\";s:10:\"author_uri\";s:21:\"https://learndash.com\";s:10:\"plugin_uri\";s:37:\"https://learndash.com/add-on/bbpress/\";s:20:\"ld_requires_at_least\";s:5:\"2.5.0\";s:4:\"slug\";s:17:\"learndash-bbpress\";s:4:\"tags\";a:3:{i:0;s:7:\"bbpress\";i:1;s:6:\"forums\";i:2;s:12:\"integrations\";}s:17:\"requires_at_least\";s:3:\"4.9\";s:12:\"tested_up_to\";s:3:\"5.2\";s:12:\"requires_php\";s:3:\"7.0\";s:10:\"stable_tag\";s:5:\"2.1.1\";s:17:\"short_description\";s:37:\"Integrate LearnDash LMS with bbPress.\";s:12:\"is_truncated\";b:0;s:11:\"description\";a:3:{s:5:\"title\";s:11:\"Description\";s:11:\"content_raw\";s:589:\"Integrate LearnDash LMS with bbPress.\r\n\r\nbbPress is a forum plugin for WordPress with over 1.5 million downloads. This integration makes it easy for you to add forums to your courses. You can protect the forums so that only users who are enrolled into your courses are able to view content and to post new threads & topics.\r\n\r\n= Integration Features = \r\n\r\n* Automatic forum access\r\n* Public or private forums\r\n* Multi-forum support\r\n* Custom Access Denied messages\r\n* Dynamic associated forum widget\r\n\r\nSee the [Add-on](https://learndash.com/add-on/bbpress/) page for more information.\r\n\r\n\";s:7:\"content\";s:656:\"<p>Integrate LearnDash LMS with bbPress.</p>\n<p>bbPress is a forum plugin for WordPress with over 1.5 million downloads. This integration makes it easy for you to add forums to your courses. You can protect the forums so that only users who are enrolled into your courses are able to view content and to post new threads &amp; topics.</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Automatic forum access</li>\n<li>Public or private forums</li>\n<li>Multi-forum support</li>\n<li>Custom Access Denied messages</li>\n<li>Dynamic associated forum widget</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/bbpress/\">Add-on</a> page for more information.</p>\";}s:12:\"installation\";a:3:{s:5:\"title\";s:12:\"Installation\";s:11:\"content_raw\";s:601:\"If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS > SETTINGS > LMS LICENSE. \r\n\r\nAlternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. \r\n\r\n1. Deactivate and delete your current version of the add-on.\r\n1. Download the latest version of the add-on from our [support site](https://support.learndash.com/article-categories/free/).\r\n1. Upload the zipped file via PLUGINS > ADD NEW, or to wp-content/plugins.\r\n1. Activate the add-on plugin via the PLUGINS menu.\r\n\r\n\";s:7:\"content\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";}s:9:\"changelog\";a:3:{s:5:\"title\";s:9:\"Changelog\";s:11:\"content_raw\";s:408:\"= 2.1.1 =\r\n* Added course forum widget\r\n* Updated name and moved `functions.php` and `forum-widget.php`\r\n* Updated load translation function\r\n* Updated addon name to match the other addons\r\n* Fixed issue with forum link not working for non logged in users\r\n* Fixed course forums not displaying on bbp page other than forums page\r\n\r\nView the full changelog [here](https://www.learndash.com/add-on/bbpress/).\r\n\";s:7:\"content\";s:495:\"<h4>2.1.1</h4>\n<ul>\n<li>Added course forum widget</li>\n<li>Updated name and moved <code>functions.php</code> and <code>forum-widget.php</code></li>\n<li>Updated load translation function</li>\n<li>Updated addon name to match the other addons</li>\n<li>Fixed issue with forum link not working for non logged in users</li>\n<li>Fixed course forums not displaying on bbp page other than forums page</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/bbpress/\">here</a>.</p>\";}s:12:\"contributors\";a:0:{}s:8:\"sections\";a:3:{s:11:\"description\";s:656:\"<p>Integrate LearnDash LMS with bbPress.</p>\n<p>bbPress is a forum plugin for WordPress with over 1.5 million downloads. This integration makes it easy for you to add forums to your courses. You can protect the forums so that only users who are enrolled into your courses are able to view content and to post new threads &amp; topics.</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Automatic forum access</li>\n<li>Public or private forums</li>\n<li>Multi-forum support</li>\n<li>Custom Access Denied messages</li>\n<li>Dynamic associated forum widget</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/bbpress/\">Add-on</a> page for more information.</p>\";s:12:\"installation\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";s:9:\"changelog\";s:495:\"<h4>2.1.1</h4>\n<ul>\n<li>Added course forum widget</li>\n<li>Updated name and moved <code>functions.php</code> and <code>forum-widget.php</code></li>\n<li>Updated load translation function</li>\n<li>Updated addon name to match the other addons</li>\n<li>Fixed issue with forum link not working for non logged in users</li>\n<li>Fixed course forums not displaying on bbp page other than forums page</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/bbpress/\">here</a>.</p>\";}s:4:\"file\";s:92:\"C:/laragon/www/hamyarlearn/wp-content/uploads/learndash/add-ons/learndash-bbpress_readme.txt\";s:10:\"last_check\";i:1594375649;s:8:\"external\";b:1;s:7:\"bb_slug\";s:17:\"learndash-bbpress\";s:8:\"homepage\";s:37:\"https://learndash.com/add-on/bbpress/\";s:12:\"last_updated\";s:19:\"2019-11-05 00:00:00\";s:7:\"version\";s:5:\"2.1.1\";s:8:\"requires\";s:3:\"4.9\";s:6:\"tested\";s:3:\"5.2\";s:5:\"icons\";a:3:{s:2:\"1x\";s:103:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-bbpress_256x256.jpg\";s:2:\"2x\";s:103:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-bbpress_256x256.jpg\";s:7:\"default\";s:103:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-bbpress_256x256.jpg\";}s:7:\"banners\";a:3:{s:3:\"low\";s:102:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-bbpress_banner.jpg\";s:4:\"high\";s:102:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-bbpress_banner.jpg\";s:7:\"default\";s:102:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-bbpress_banner.jpg\";}s:13:\"plugin_status\";a:4:{s:6:\"status\";s:7:\"install\";s:7:\"version\";s:5:\"2.1.1\";s:4:\"file\";b:0;s:3:\"url\";s:211:\"http://localhost/hamyarlearn/wp-admin/update.php?action=install-plugin&amp;plugin=learndash-bbpress&amp;_wpnonce=293fa000ca&ld-return-addons=/hamyarlearn/wp-admin/admin.php?page=wpseo_tools&start-indexation=true\";}}s:13:\"learndash-edd\";a:30:{s:4:\"name\";s:17:\"EDD for LearnDash\";s:6:\"author\";s:45:\"<a href=\"https://learndash.com\">LearnDash</a>\";s:10:\"author_uri\";s:21:\"https://learndash.com\";s:10:\"plugin_uri\";s:52:\"https://learndash.com/add-on/easy-digital-downloads/\";s:20:\"ld_requires_at_least\";s:3:\"2.5\";s:4:\"slug\";s:13:\"learndash-edd\";s:4:\"tags\";a:4:{i:0;s:11:\"integration\";i:1;s:10:\"membership\";i:2;s:3:\"edd\";i:3;s:0:\"\";}s:17:\"requires_at_least\";s:3:\"4.9\";s:12:\"tested_up_to\";s:3:\"5.2\";s:12:\"requires_php\";s:3:\"7.0\";s:10:\"stable_tag\";s:5:\"1.2.0\";s:17:\"short_description\";s:53:\"Integrates LearnDash LMS with Easy Digital Downloads.\";s:12:\"is_truncated\";b:0;s:11:\"description\";a:3:{s:5:\"title\";s:11:\"Description\";s:11:\"content_raw\";s:520:\"Integrate LearnDash LMS with Easy Digital Downloads.\r\n\r\nEasy Digital Downloads is a popular shopping cart for WordPress with over 400,000 downloads. This integration makes it possible to sell LearnDash created courses using the Easy Digital Downloads shopping cart.\r\n\r\n= Integration Features = \r\n\r\n* Easy course mapping\r\n* Associate one, or multiple courses\r\n* Auto-User Enrollment\r\n* Works with any payment gateway\r\n\r\nSee the [Add-on](https://learndash.com/add-on/easy-digital-downloads/) page for more information.\r\n\r\n\";s:7:\"content\";s:577:\"<p>Integrate LearnDash LMS with Easy Digital Downloads.</p>\n<p>Easy Digital Downloads is a popular shopping cart for WordPress with over 400,000 downloads. This integration makes it possible to sell LearnDash created courses using the Easy Digital Downloads shopping cart.</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Easy course mapping</li>\n<li>Associate one, or multiple courses</li>\n<li>Auto-User Enrollment</li>\n<li>Works with any payment gateway</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/easy-digital-downloads/\">Add-on</a> page for more information.</p>\";}s:12:\"installation\";a:3:{s:5:\"title\";s:12:\"Installation\";s:11:\"content_raw\";s:601:\"If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS > SETTINGS > LMS LICENSE. \r\n\r\nAlternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. \r\n\r\n1. Deactivate and delete your current version of the add-on.\r\n1. Download the latest version of the add-on from our [support site](https://support.learndash.com/article-categories/free/).\r\n1. Upload the zipped file via PLUGINS > ADD NEW, or to wp-content/plugins.\r\n1. Activate the add-on plugin via the PLUGINS menu.\r\n\r\n\";s:7:\"content\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";}s:9:\"changelog\";a:3:{s:5:\"title\";s:9:\"Changelog\";s:11:\"content_raw\";s:277:\"= 1.2.0 =\r\n* Added a check on expired transaction status when removing course access\r\n* Fixed users not being unenrolled on payment status change\r\n* Fixed course unenrollment issue\r\n\r\n\r\nView the full changelog [here](https://www.learndash.com/add-on/easy-digital-downloads/).\r\n\";s:7:\"content\";s:322:\"<h4>1.2.0</h4>\n<ul>\n<li>Added a check on expired transaction status when removing course access</li>\n<li>Fixed users not being unenrolled on payment status change</li>\n<li>Fixed course unenrollment issue</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/easy-digital-downloads/\">here</a>.</p>\";}s:12:\"contributors\";a:0:{}s:8:\"sections\";a:3:{s:11:\"description\";s:577:\"<p>Integrate LearnDash LMS with Easy Digital Downloads.</p>\n<p>Easy Digital Downloads is a popular shopping cart for WordPress with over 400,000 downloads. This integration makes it possible to sell LearnDash created courses using the Easy Digital Downloads shopping cart.</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Easy course mapping</li>\n<li>Associate one, or multiple courses</li>\n<li>Auto-User Enrollment</li>\n<li>Works with any payment gateway</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/easy-digital-downloads/\">Add-on</a> page for more information.</p>\";s:12:\"installation\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";s:9:\"changelog\";s:322:\"<h4>1.2.0</h4>\n<ul>\n<li>Added a check on expired transaction status when removing course access</li>\n<li>Fixed users not being unenrolled on payment status change</li>\n<li>Fixed course unenrollment issue</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/easy-digital-downloads/\">here</a>.</p>\";}s:4:\"file\";s:88:\"C:/laragon/www/hamyarlearn/wp-content/uploads/learndash/add-ons/learndash-edd_readme.txt\";s:10:\"last_check\";i:1594375649;s:8:\"external\";b:1;s:7:\"bb_slug\";s:13:\"learndash-edd\";s:8:\"homepage\";s:52:\"https://learndash.com/add-on/easy-digital-downloads/\";s:12:\"last_updated\";s:19:\"2019-10-18 00:00:00\";s:7:\"version\";s:5:\"1.2.0\";s:8:\"requires\";s:3:\"4.9\";s:6:\"tested\";s:3:\"5.2\";s:5:\"icons\";a:3:{s:2:\"1x\";s:99:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-edd_256x256.jpg\";s:2:\"2x\";s:99:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-edd_256x256.jpg\";s:7:\"default\";s:99:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-edd_256x256.jpg\";}s:7:\"banners\";a:3:{s:3:\"low\";s:98:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-edd_banner.jpg\";s:4:\"high\";s:98:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-edd_banner.jpg\";s:7:\"default\";s:98:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-edd_banner.jpg\";}s:13:\"plugin_status\";a:4:{s:6:\"status\";s:7:\"install\";s:7:\"version\";s:5:\"1.2.0\";s:4:\"file\";b:0;s:3:\"url\";s:207:\"http://localhost/hamyarlearn/wp-admin/update.php?action=install-plugin&amp;plugin=learndash-edd&amp;_wpnonce=1e8004d3dd&ld-return-addons=/hamyarlearn/wp-admin/admin.php?page=wpseo_tools&start-indexation=true\";}}s:23:\"learndash-gravity-forms\";a:30:{s:4:\"name\";s:27:\"Gravity Forms for LearnDash\";s:6:\"author\";s:45:\"<a href=\"https://learndash.com\">LearnDash</a>\";s:10:\"author_uri\";s:21:\"https://learndash.com\";s:10:\"plugin_uri\";s:43:\"https://learndash.com/add-on/gravity-forms/\";s:20:\"ld_requires_at_least\";s:3:\"3.0\";s:4:\"slug\";s:23:\"learndash-gravity-forms\";s:4:\"tags\";a:2:{i:0;s:11:\"integration\";i:1;s:13:\"gravity forms\";}s:17:\"requires_at_least\";s:3:\"5.0\";s:12:\"tested_up_to\";s:3:\"5.2\";s:12:\"requires_php\";s:3:\"7.0\";s:10:\"stable_tag\";s:5:\"2.1.1\";s:17:\"short_description\";s:44:\"Integrates LearnDash LMS with Gravity Forms.\";s:12:\"is_truncated\";b:0;s:11:\"description\";a:3:{s:5:\"title\";s:11:\"Description\";s:11:\"content_raw\";s:621:\"Integrate LearnDash LMS with Gravity Forms.\r\n\r\nGravity Forms is hands-down the industry\'s best custom form development plugin.\r\n\r\nWith this integration, you can create a completely custom course registration form and associate your online courses to it so that when users register, they are auto-enrolled.\r\n\r\n= Integration Features = \r\n\r\n* Create a unique registration form\r\n* Automatically enrolls user\r\n* Accept payments using Gravity Forms add-ons\r\n\r\nNote: this integration requires a Developer License from Gravity Forms.\r\n\r\nSee the [Add-on](https://learndash.com/add-on/gravity-forms/) page for more information.\r\n\r\n\";s:7:\"content\";s:680:\"<p>Integrate LearnDash LMS with Gravity Forms.</p>\n<p>Gravity Forms is hands-down the industry\'s best custom form development plugin.</p>\n<p>With this integration, you can create a completely custom course registration form and associate your online courses to it so that when users register, they are auto-enrolled.</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Create a unique registration form</li>\n<li>Automatically enrolls user</li>\n<li>Accept payments using Gravity Forms add-ons</li>\n</ul>\n<p>Note: this integration requires a Developer License from Gravity Forms.</p>\n<p>See the <a href=\"https://learndash.com/add-on/gravity-forms/\">Add-on</a> page for more information.</p>\";}s:12:\"installation\";a:3:{s:5:\"title\";s:12:\"Installation\";s:11:\"content_raw\";s:601:\"If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS > SETTINGS > LMS LICENSE. \r\n\r\nAlternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. \r\n\r\n1. Deactivate and delete your current version of the add-on.\r\n1. Download the latest version of the add-on from our [support site](https://support.learndash.com/article-categories/free/).\r\n1. Upload the zipped file via PLUGINS > ADD NEW, or to wp-content/plugins.\r\n1. Activate the add-on plugin via the PLUGINS menu.\r\n\r\n\";s:7:\"content\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";}s:9:\"changelog\";a:3:{s:5:\"title\";s:9:\"Changelog\";s:11:\"content_raw\";s:399:\"= 2.1.1 =\r\n* Added payment refunded hooked function for paid form\r\n* Added payment completed hooked function for paid form\r\n* Added logic to bail course enrollment in user registration hook if the submitted form is a paid form\r\n* Added paid form setting field to mark a paid form on user registration feed setting\r\n\r\nView the full changelog [here](https://www.learndash.com/add-on/gravity-forms/).\r\n\";s:7:\"content\";s:452:\"<h4>2.1.1</h4>\n<ul>\n<li>Added payment refunded hooked function for paid form</li>\n<li>Added payment completed hooked function for paid form</li>\n<li>Added logic to bail course enrollment in user registration hook if the submitted form is a paid form</li>\n<li>Added paid form setting field to mark a paid form on user registration feed setting</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/gravity-forms/\">here</a>.</p>\";}s:12:\"contributors\";a:0:{}s:8:\"sections\";a:3:{s:11:\"description\";s:680:\"<p>Integrate LearnDash LMS with Gravity Forms.</p>\n<p>Gravity Forms is hands-down the industry\'s best custom form development plugin.</p>\n<p>With this integration, you can create a completely custom course registration form and associate your online courses to it so that when users register, they are auto-enrolled.</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Create a unique registration form</li>\n<li>Automatically enrolls user</li>\n<li>Accept payments using Gravity Forms add-ons</li>\n</ul>\n<p>Note: this integration requires a Developer License from Gravity Forms.</p>\n<p>See the <a href=\"https://learndash.com/add-on/gravity-forms/\">Add-on</a> page for more information.</p>\";s:12:\"installation\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";s:9:\"changelog\";s:452:\"<h4>2.1.1</h4>\n<ul>\n<li>Added payment refunded hooked function for paid form</li>\n<li>Added payment completed hooked function for paid form</li>\n<li>Added logic to bail course enrollment in user registration hook if the submitted form is a paid form</li>\n<li>Added paid form setting field to mark a paid form on user registration feed setting</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/gravity-forms/\">here</a>.</p>\";}s:4:\"file\";s:98:\"C:/laragon/www/hamyarlearn/wp-content/uploads/learndash/add-ons/learndash-gravity-forms_readme.txt\";s:10:\"last_check\";i:1594375649;s:8:\"external\";b:1;s:7:\"bb_slug\";s:23:\"learndash-gravity-forms\";s:8:\"homepage\";s:43:\"https://learndash.com/add-on/gravity-forms/\";s:12:\"last_updated\";s:19:\"2019-09-26 00:00:00\";s:7:\"version\";s:5:\"2.1.1\";s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:3:\"5.2\";s:5:\"icons\";a:3:{s:2:\"1x\";s:109:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-gravity-forms_256x256.jpg\";s:2:\"2x\";s:109:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-gravity-forms_256x256.jpg\";s:7:\"default\";s:109:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-gravity-forms_256x256.jpg\";}s:7:\"banners\";a:3:{s:3:\"low\";s:108:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-gravity-forms_banner.jpg\";s:4:\"high\";s:108:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-gravity-forms_banner.jpg\";s:7:\"default\";s:108:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-gravity-forms_banner.jpg\";}s:13:\"plugin_status\";a:4:{s:6:\"status\";s:7:\"install\";s:7:\"version\";s:5:\"2.1.1\";s:4:\"file\";b:0;s:3:\"url\";s:217:\"http://localhost/hamyarlearn/wp-admin/update.php?action=install-plugin&amp;plugin=learndash-gravity-forms&amp;_wpnonce=fa539e3f40&ld-return-addons=/hamyarlearn/wp-admin/admin.php?page=wpseo_tools&start-indexation=true\";}}s:30:\"learndash-restrict-content-pro\";a:29:{s:4:\"name\";s:34:\"Restrict Content Pro for LearnDash\";s:6:\"author\";s:45:\"<a href=\"https://learndash.com\">LearnDash</a>\";s:10:\"author_uri\";s:21:\"https://learndash.com\";s:10:\"plugin_uri\";s:0:\"\";s:20:\"ld_requires_at_least\";s:3:\"2.5\";s:4:\"slug\";s:30:\"learndash-restrict-content-pro\";s:4:\"tags\";a:4:{i:0;s:11:\"integration\";i:1;s:10:\"membership\";i:2;s:20:\"restrict content pro\";i:3;s:0:\"\";}s:17:\"requires_at_least\";s:3:\"4.9\";s:12:\"tested_up_to\";s:3:\"5.2\";s:12:\"requires_php\";s:3:\"7.0\";s:10:\"stable_tag\";s:5:\"1.1.0\";s:17:\"short_description\";s:50:\"Integrate LearnDash LMS with Restrict Content Pro.\";s:12:\"is_truncated\";b:0;s:11:\"description\";a:3:{s:5:\"title\";s:11:\"Description\";s:11:\"content_raw\";s:153:\"Integrate LearnDash LMS with Restrict Content Pro.\r\n\r\n= Integration Features = \r\n\r\nSee the [Add-on](https://learndash.com) page for more information.\r\n\r\n\";s:7:\"content\";s:173:\"<p>Integrate LearnDash LMS with Restrict Content Pro.</p>\n<h4>Integration Features</h4> \n<p>See the <a href=\"https://learndash.com\">Add-on</a> page for more information.</p>\";}s:12:\"installation\";a:3:{s:5:\"title\";s:12:\"Installation\";s:11:\"content_raw\";s:601:\"If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS > SETTINGS > LMS LICENSE. \r\n\r\nAlternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. \r\n\r\n1. Deactivate and delete your current version of the add-on.\r\n1. Download the latest version of the add-on from our [support site](https://support.learndash.com/article-categories/free/).\r\n1. Upload the zipped file via PLUGINS > ADD NEW, or to wp-content/plugins.\r\n1. Activate the add-on plugin via the PLUGINS menu.\r\n\r\n\";s:7:\"content\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";}s:9:\"changelog\";a:3:{s:5:\"title\";s:9:\"Changelog\";s:11:\"content_raw\";s:143:\"= 1.1.0 =\r\n\r\n* Added RCP 3.0 compatibility hook function\r\n* Fixed course association\r\n\r\nView the full changelog [here](https://learndash.com)\r\n\";s:7:\"content\";s:182:\"<h4>1.1.0</h4>\n<ul>\n<li>Added RCP 3.0 compatibility hook function</li>\n<li>Fixed course association</li>\n</ul>\n<p>View the full changelog <a href=\"https://learndash.com\">here</a></p>\";}s:12:\"contributors\";a:0:{}s:8:\"sections\";a:3:{s:11:\"description\";s:173:\"<p>Integrate LearnDash LMS with Restrict Content Pro.</p>\n<h4>Integration Features</h4> \n<p>See the <a href=\"https://learndash.com\">Add-on</a> page for more information.</p>\";s:12:\"installation\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";s:9:\"changelog\";s:182:\"<h4>1.1.0</h4>\n<ul>\n<li>Added RCP 3.0 compatibility hook function</li>\n<li>Fixed course association</li>\n</ul>\n<p>View the full changelog <a href=\"https://learndash.com\">here</a></p>\";}s:4:\"file\";s:105:\"C:/laragon/www/hamyarlearn/wp-content/uploads/learndash/add-ons/learndash-restrict-content-pro_readme.txt\";s:10:\"last_check\";i:1594375649;s:8:\"external\";b:1;s:7:\"bb_slug\";s:30:\"learndash-restrict-content-pro\";s:12:\"last_updated\";s:19:\"2019-07-11 00:00:00\";s:7:\"version\";s:5:\"1.1.0\";s:8:\"requires\";s:3:\"4.9\";s:6:\"tested\";s:3:\"5.2\";s:5:\"icons\";a:3:{s:2:\"1x\";s:116:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-restrict-content-pro_256x256.jpg\";s:2:\"2x\";s:116:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-restrict-content-pro_256x256.jpg\";s:7:\"default\";s:116:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-restrict-content-pro_256x256.jpg\";}s:7:\"banners\";a:3:{s:3:\"low\";s:115:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-restrict-content-pro_banner.jpg\";s:4:\"high\";s:115:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-restrict-content-pro_banner.jpg\";s:7:\"default\";s:115:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-restrict-content-pro_banner.jpg\";}s:13:\"plugin_status\";a:4:{s:6:\"status\";s:7:\"install\";s:7:\"version\";s:5:\"1.1.0\";s:4:\"file\";b:0;s:3:\"url\";s:224:\"http://localhost/hamyarlearn/wp-admin/update.php?action=install-plugin&amp;plugin=learndash-restrict-content-pro&amp;_wpnonce=ebda85dcb6&ld-return-addons=/hamyarlearn/wp-admin/admin.php?page=wpseo_tools&start-indexation=true\";}}s:19:\"learndash-2checkout\";a:30:{s:4:\"name\";s:23:\"2Checkout for LearnDash\";s:6:\"author\";s:45:\"<a href=\"https://learndash.com\">LearnDash</a>\";s:10:\"author_uri\";s:21:\"https://learndash.com\";s:10:\"plugin_uri\";s:39:\"https://learndash.com/add-on/2checkout/\";s:20:\"ld_requires_at_least\";s:5:\"2.5.0\";s:4:\"slug\";s:19:\"learndash-2checkout\";s:4:\"tags\";a:2:{i:0;s:15:\"payment gateway\";i:1;s:9:\"2checkout\";}s:17:\"requires_at_least\";s:3:\"4.9\";s:12:\"tested_up_to\";s:3:\"5.1\";s:12:\"requires_php\";s:3:\"7.0\";s:10:\"stable_tag\";s:5:\"1.1.0\";s:17:\"short_description\";s:51:\"Integrate 2checkout payment gateway with LearnDash.\";s:12:\"is_truncated\";b:0;s:11:\"description\";a:3:{s:5:\"title\";s:11:\"Description\";s:11:\"content_raw\";s:442:\"Integrate 2checkout payment gateway with LearnDash.\r\n\r\nUsing this add-on, you can quickly and easily accept payments using the 2CheckOut payment gateway. Use it with PayPal, or just use 2CheckOut the choice is yours!\r\n\r\n= Integration Features = \r\n\r\n* Use 2Checkout to sell courses\r\n* Automatically delivers username and password\r\n* Hassle-free set-up\r\n\r\nSee the [Add-on](https://learndash.com/add-on/2checkout/) page for more information.\r\n\r\n\";s:7:\"content\";s:493:\"<p>Integrate 2checkout payment gateway with LearnDash.</p>\n<p>Using this add-on, you can quickly and easily accept payments using the 2CheckOut payment gateway. Use it with PayPal, or just use 2CheckOut the choice is yours!</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Use 2Checkout to sell courses</li>\n<li>Automatically delivers username and password</li>\n<li>Hassle-free set-up</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/2checkout/\">Add-on</a> page for more information.</p>\";}s:12:\"installation\";a:3:{s:5:\"title\";s:12:\"Installation\";s:11:\"content_raw\";s:601:\"If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS > SETTINGS > LMS LICENSE. \r\n\r\nAlternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. \r\n\r\n1. Deactivate and delete your current version of the add-on.\r\n1. Download the latest version of the add-on from our [support site](https://support.learndash.com/article-categories/free/).\r\n1. Upload the zipped file via PLUGINS > ADD NEW, or to wp-content/plugins.\r\n1. Activate the add-on plugin via the PLUGINS menu.\r\n\r\n\";s:7:\"content\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";}s:9:\"changelog\";a:3:{s:5:\"title\";s:9:\"Changelog\";s:11:\"content_raw\";s:316:\"= 1.1.0 =\r\n* Added language directory and POT file\r\n* Updated setting field text and description\r\n* Updated disable attribute to readonly for 2checkout approved URL field\r\n* Updated to send new user notification to both user and admin\r\n\r\nView the full changelog [here](https://www.learndash.com/add-on/2checkout/).\r\n\";s:7:\"content\";s:369:\"<h4>1.1.0</h4>\n<ul>\n<li>Added language directory and POT file</li>\n<li>Updated setting field text and description</li>\n<li>Updated disable attribute to readonly for 2checkout approved URL field</li>\n<li>Updated to send new user notification to both user and admin</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/2checkout/\">here</a>.</p>\";}s:12:\"contributors\";a:0:{}s:8:\"sections\";a:3:{s:11:\"description\";s:493:\"<p>Integrate 2checkout payment gateway with LearnDash.</p>\n<p>Using this add-on, you can quickly and easily accept payments using the 2CheckOut payment gateway. Use it with PayPal, or just use 2CheckOut the choice is yours!</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Use 2Checkout to sell courses</li>\n<li>Automatically delivers username and password</li>\n<li>Hassle-free set-up</li>\n</ul>\n<p>See the <a href=\"https://learndash.com/add-on/2checkout/\">Add-on</a> page for more information.</p>\";s:12:\"installation\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";s:9:\"changelog\";s:369:\"<h4>1.1.0</h4>\n<ul>\n<li>Added language directory and POT file</li>\n<li>Updated setting field text and description</li>\n<li>Updated disable attribute to readonly for 2checkout approved URL field</li>\n<li>Updated to send new user notification to both user and admin</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/2checkout/\">here</a>.</p>\";}s:4:\"file\";s:94:\"C:/laragon/www/hamyarlearn/wp-content/uploads/learndash/add-ons/learndash-2checkout_readme.txt\";s:10:\"last_check\";i:1594375649;s:8:\"external\";b:1;s:7:\"bb_slug\";s:19:\"learndash-2checkout\";s:8:\"homepage\";s:39:\"https://learndash.com/add-on/2checkout/\";s:12:\"last_updated\";s:19:\"2019-05-02 00:00:00\";s:7:\"version\";s:5:\"1.1.0\";s:8:\"requires\";s:3:\"4.9\";s:6:\"tested\";s:3:\"5.1\";s:5:\"icons\";a:3:{s:2:\"1x\";s:105:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-2checkout_256x256.jpg\";s:2:\"2x\";s:105:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-2checkout_256x256.jpg\";s:7:\"default\";s:105:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-2checkout_256x256.jpg\";}s:7:\"banners\";a:3:{s:3:\"low\";s:104:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-2checkout_banner.jpg\";s:4:\"high\";s:104:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-2checkout_banner.jpg\";s:7:\"default\";s:104:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-2checkout_banner.jpg\";}s:13:\"plugin_status\";a:4:{s:6:\"status\";s:7:\"install\";s:7:\"version\";s:5:\"1.1.0\";s:4:\"file\";b:0;s:3:\"url\";s:213:\"http://localhost/hamyarlearn/wp-admin/update.php?action=install-plugin&amp;plugin=learndash-2checkout&amp;_wpnonce=4019edaa04&ld-return-addons=/hamyarlearn/wp-admin/admin.php?page=wpseo_tools&start-indexation=true\";}}s:24:\"learndash-event-espresso\";a:30:{s:4:\"name\";s:28:\"Event Espresso for LearnDash\";s:6:\"author\";s:45:\"<a href=\"https://learndash.com\">LearnDash</a>\";s:10:\"author_uri\";s:21:\"https://learndash.com\";s:10:\"plugin_uri\";s:44:\"https://learndash.com/add-on/event-espresso/\";s:20:\"ld_requires_at_least\";s:3:\"2.5\";s:4:\"slug\";s:24:\"learndash-event-espresso\";s:4:\"tags\";a:4:{i:0;s:11:\"integration\";i:1;s:5:\"event\";i:2;s:14:\"event espresso\";i:3;s:0:\"\";}s:17:\"requires_at_least\";s:3:\"4.9\";s:12:\"tested_up_to\";s:3:\"5.1\";s:12:\"requires_php\";s:3:\"7.0\";s:10:\"stable_tag\";s:5:\"1.1.0\";s:17:\"short_description\";s:44:\"Integrate LearnDash LMS with Event Espresso.\";s:12:\"is_truncated\";b:0;s:11:\"description\";a:3:{s:5:\"title\";s:11:\"Description\";s:11:\"content_raw\";s:693:\"Integrate LearnDash LMS with Event Espresso.\r\n\r\nEvent Espresso is the leading live event and ticket management solution for WordPress. With this integration, you can associate your online courses to live events so that when users register, they are auto-enrolled. Perfect for anyone offering live training, seminars, or classrooms.\r\n\r\n= Integration Features = \r\n\r\n* Easily map an event to a course\r\n* Associate one, or many, courses\r\n* Drip-feed course content leading up to an event\r\n* Works with any Event Espresso payment gateway\r\n\r\nNote: this integration requires Event Espresso v4 or higher.\r\n\r\nSee the [Add-on](https://learndash.com/add-on/event-espresso/) page for more information.\r\n\r\n\";s:7:\"content\";s:754:\"<p>Integrate LearnDash LMS with Event Espresso.</p>\n<p>Event Espresso is the leading live event and ticket management solution for WordPress. With this integration, you can associate your online courses to live events so that when users register, they are auto-enrolled. Perfect for anyone offering live training, seminars, or classrooms.</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Easily map an event to a course</li>\n<li>Associate one, or many, courses</li>\n<li>Drip-feed course content leading up to an event</li>\n<li>Works with any Event Espresso payment gateway</li>\n</ul>\n<p>Note: this integration requires Event Espresso v4 or higher.</p>\n<p>See the <a href=\"https://learndash.com/add-on/event-espresso/\">Add-on</a> page for more information.</p>\";}s:12:\"installation\";a:3:{s:5:\"title\";s:12:\"Installation\";s:11:\"content_raw\";s:601:\"If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS > SETTINGS > LMS LICENSE. \r\n\r\nAlternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. \r\n\r\n1. Deactivate and delete your current version of the add-on.\r\n1. Download the latest version of the add-on from our [support site](https://support.learndash.com/article-categories/free/).\r\n1. Upload the zipped file via PLUGINS > ADD NEW, or to wp-content/plugins.\r\n1. Activate the add-on plugin via the PLUGINS menu.\r\n\r\n\";s:7:\"content\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";}s:9:\"changelog\";a:3:{s:5:\"title\";s:9:\"Changelog\";s:11:\"content_raw\";s:156:\"= 1.1.0 =\r\n* Added language directory and POT file\r\n* Added constants\r\n\r\nView the full changelog [here](https://www.learndash.com/add-on/event-espresso/).\r\n\";s:7:\"content\";s:197:\"<h4>1.1.0</h4>\n<ul>\n<li>Added language directory and POT file</li>\n<li>Added constants</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/event-espresso/\">here</a>.</p>\";}s:12:\"contributors\";a:0:{}s:8:\"sections\";a:3:{s:11:\"description\";s:754:\"<p>Integrate LearnDash LMS with Event Espresso.</p>\n<p>Event Espresso is the leading live event and ticket management solution for WordPress. With this integration, you can associate your online courses to live events so that when users register, they are auto-enrolled. Perfect for anyone offering live training, seminars, or classrooms.</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Easily map an event to a course</li>\n<li>Associate one, or many, courses</li>\n<li>Drip-feed course content leading up to an event</li>\n<li>Works with any Event Espresso payment gateway</li>\n</ul>\n<p>Note: this integration requires Event Espresso v4 or higher.</p>\n<p>See the <a href=\"https://learndash.com/add-on/event-espresso/\">Add-on</a> page for more information.</p>\";s:12:\"installation\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";s:9:\"changelog\";s:197:\"<h4>1.1.0</h4>\n<ul>\n<li>Added language directory and POT file</li>\n<li>Added constants</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/event-espresso/\">here</a>.</p>\";}s:4:\"file\";s:99:\"C:/laragon/www/hamyarlearn/wp-content/uploads/learndash/add-ons/learndash-event-espresso_readme.txt\";s:10:\"last_check\";i:1594375649;s:8:\"external\";b:1;s:7:\"bb_slug\";s:24:\"learndash-event-espresso\";s:8:\"homepage\";s:44:\"https://learndash.com/add-on/event-espresso/\";s:12:\"last_updated\";s:19:\"2019-04-24 00:00:00\";s:7:\"version\";s:5:\"1.1.0\";s:8:\"requires\";s:3:\"4.9\";s:6:\"tested\";s:3:\"5.1\";s:5:\"icons\";a:3:{s:2:\"1x\";s:110:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-event-espresso_256x256.jpg\";s:2:\"2x\";s:110:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-event-espresso_256x256.jpg\";s:7:\"default\";s:110:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-event-espresso_256x256.jpg\";}s:7:\"banners\";a:3:{s:3:\"low\";s:109:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-event-espresso_banner.jpg\";s:4:\"high\";s:109:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-event-espresso_banner.jpg\";s:7:\"default\";s:109:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-event-espresso_banner.jpg\";}s:13:\"plugin_status\";a:4:{s:6:\"status\";s:7:\"install\";s:7:\"version\";s:5:\"1.1.0\";s:4:\"file\";b:0;s:3:\"url\";s:218:\"http://localhost/hamyarlearn/wp-admin/update.php?action=install-plugin&amp;plugin=learndash-event-espresso&amp;_wpnonce=7952212bb9&ld-return-addons=/hamyarlearn/wp-admin/admin.php?page=wpseo_tools&start-indexation=true\";}}s:17:\"learndash-samcart\";a:30:{s:4:\"name\";s:35:\"LearnDash LMS - Samcart Integration\";s:6:\"author\";s:45:\"<a href=\"https://learndash.com\">LearnDash</a>\";s:10:\"author_uri\";s:21:\"https://learndash.com\";s:10:\"plugin_uri\";s:41:\"https://www.learndash.com/add-on/samcart/\";s:20:\"ld_requires_at_least\";s:3:\"2.5\";s:4:\"slug\";s:17:\"learndash-samcart\";s:4:\"tags\";a:3:{i:0;s:11:\"integration\";i:1;s:7:\"samcart\";i:2;s:0:\"\";}s:17:\"requires_at_least\";s:3:\"4.9\";s:12:\"tested_up_to\";s:5:\"5.3.2\";s:12:\"requires_php\";s:3:\"7.0\";s:10:\"stable_tag\";s:3:\"1.0\";s:17:\"short_description\";s:38:\"Integrates LearnDash LMS with Samcart.\";s:12:\"is_truncated\";b:0;s:11:\"description\";a:3:{s:5:\"title\";s:11:\"Description\";s:11:\"content_raw\";s:566:\"Integrate LearnDash LMS with Samcart.\r\n\r\nSamCart is a hosted shopping cart built by marketers, for marketers. It is optimized for conversions so as to increase your total revenue. This integration makes it possible to sell LearnDash courses with this high-converting shopping cart.\r\n\r\n= Integration Features = \r\n\r\n* Automatic account creation\r\n* Easily map courses\r\n* Associate one, or multiple courses\r\n* Works with any SamCart payment gateway\r\n* Works with Subscriptions\r\n\r\nSee the [Add-on](https://www.learndash.com/add-on/samcart/) page for more information.\r\n\r\n\";s:7:\"content\";s:629:\"<p>Integrate LearnDash LMS with Samcart.</p>\n<p>SamCart is a hosted shopping cart built by marketers, for marketers. It is optimized for conversions so as to increase your total revenue. This integration makes it possible to sell LearnDash courses with this high-converting shopping cart.</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Automatic account creation</li>\n<li>Easily map courses</li>\n<li>Associate one, or multiple courses</li>\n<li>Works with any SamCart payment gateway</li>\n<li>Works with Subscriptions</li>\n</ul>\n<p>See the <a href=\"https://www.learndash.com/add-on/samcart/\">Add-on</a> page for more information.</p>\";}s:12:\"installation\";a:3:{s:5:\"title\";s:12:\"Installation\";s:11:\"content_raw\";s:601:\"If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS > SETTINGS > LMS LICENSE. \r\n\r\nAlternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. \r\n\r\n1. Deactivate and delete your current version of the add-on.\r\n1. Download the latest version of the add-on from our [support site](https://support.learndash.com/article-categories/free/).\r\n1. Upload the zipped file via PLUGINS > ADD NEW, or to wp-content/plugins.\r\n1. Activate the add-on plugin via the PLUGINS menu.\r\n\r\n\";s:7:\"content\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";}s:9:\"changelog\";a:3:{s:5:\"title\";s:9:\"Changelog\";s:11:\"content_raw\";s:106:\"= 1.0 =\r\n* Initial Release\r\n\r\nView the full changelog [here](https://www.learndash.com/add-on/samcart/).\r\n\";s:7:\"content\";s:141:\"<h4>1.0</h4>\n<ul>\n<li>Initial Release</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/samcart/\">here</a>.</p>\";}s:12:\"contributors\";a:0:{}s:8:\"sections\";a:3:{s:11:\"description\";s:629:\"<p>Integrate LearnDash LMS with Samcart.</p>\n<p>SamCart is a hosted shopping cart built by marketers, for marketers. It is optimized for conversions so as to increase your total revenue. This integration makes it possible to sell LearnDash courses with this high-converting shopping cart.</p>\n<h4>Integration Features</h4> \n<ul>\n<li>Automatic account creation</li>\n<li>Easily map courses</li>\n<li>Associate one, or multiple courses</li>\n<li>Works with any SamCart payment gateway</li>\n<li>Works with Subscriptions</li>\n</ul>\n<p>See the <a href=\"https://www.learndash.com/add-on/samcart/\">Add-on</a> page for more information.</p>\";s:12:\"installation\";s:657:\"<p>If the auto-update is not working, verify that you have a valid LearnDash LMS license via LEARNDASH LMS &gt; SETTINGS &gt; LMS LICENSE. </p>\n<p>Alternatively, you always have the option to update manually. Please note, a full backup of your site is always recommended prior to updating. </p>\n<ol>\n<li>Deactivate and delete your current version of the add-on.</li>\n<li>Download the latest version of the add-on from our <a href=\"https://support.learndash.com/article-categories/free/\">support site</a>.</li>\n<li>Upload the zipped file via PLUGINS &gt; ADD NEW, or to wp-content/plugins.</li>\n<li>Activate the add-on plugin via the PLUGINS menu.</li>\n</ol>\";s:9:\"changelog\";s:141:\"<h4>1.0</h4>\n<ul>\n<li>Initial Release</li>\n</ul>\n<p>View the full changelog <a href=\"https://www.learndash.com/add-on/samcart/\">here</a>.</p>\";}s:4:\"file\";s:92:\"C:/laragon/www/hamyarlearn/wp-content/uploads/learndash/add-ons/learndash-samcart_readme.txt\";s:10:\"last_check\";i:1594375649;s:8:\"external\";b:1;s:7:\"bb_slug\";s:17:\"learndash-samcart\";s:8:\"homepage\";s:41:\"https://www.learndash.com/add-on/samcart/\";s:12:\"last_updated\";s:19:\"2018-01-17 00:00:00\";s:7:\"version\";s:3:\"1.0\";s:8:\"requires\";s:3:\"4.9\";s:6:\"tested\";s:5:\"5.3.2\";s:5:\"icons\";a:3:{s:2:\"1x\";s:103:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-samcart_256x256.jpg\";s:2:\"2x\";s:103:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-samcart_256x256.jpg\";s:7:\"default\";s:103:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-samcart_256x256.jpg\";}s:7:\"banners\";a:3:{s:3:\"low\";s:102:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-samcart_banner.jpg\";s:4:\"high\";s:102:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-samcart_banner.jpg\";s:7:\"default\";s:102:\"//localhost/hamyarlearn/wp-content/plugins/sfwd-lms/assets/images-add-ons/learndash-samcart_banner.jpg\";}s:13:\"plugin_status\";a:4:{s:6:\"status\";s:7:\"install\";s:7:\"version\";s:3:\"1.0\";s:4:\"file\";b:0;s:3:\"url\";s:211:\"http://localhost/hamyarlearn/wp-admin/update.php?action=install-plugin&amp;plugin=learndash-samcart&amp;_wpnonce=3191fe5351&ld-return-addons=/hamyarlearn/wp-admin/admin.php?page=wpseo_tools&start-indexation=true\";}}}s:4:\"tags\";a:0:{}s:7:\"updates\";a:0:{}}", "no");
INSERT INTO `hm_options` VALUES("409", "_elementor_installed_time", "1594375649", "yes");
INSERT INTO `hm_options` VALUES("410", "elementor_remote_info_library", "a:3:{s:10:\"types_data\";a:2:{s:5:\"block\";a:1:{s:10:\"categories\";a:22:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:14:\"call to action\";i:4;s:7:\"clients\";i:5;s:7:\"contact\";i:6;s:3:\"faq\";i:7;s:8:\"features\";i:8;s:6:\"footer\";i:9;s:6:\"header\";i:10;s:4:\"hero\";i:11;s:9:\"portfolio\";i:12;s:7:\"pricing\";i:13;s:15:\"product archive\";i:14;s:8:\"services\";i:15;s:11:\"single page\";i:16;s:11:\"single post\";i:17;s:14:\"single product\";i:18;s:5:\"stats\";i:19;s:9:\"subscribe\";i:20;s:4:\"team\";i:21;s:12:\"testimonials\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}}s:10:\"categories\";a:22:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:14:\"call to action\";i:4;s:7:\"clients\";i:5;s:7:\"contact\";i:6;s:3:\"faq\";i:7;s:8:\"features\";i:8;s:6:\"footer\";i:9;s:6:\"header\";i:10;s:4:\"hero\";i:11;s:9:\"portfolio\";i:12;s:7:\"pricing\";i:13;s:15:\"product archive\";i:14;s:8:\"services\";i:15;s:11:\"single page\";i:16;s:11:\"single post\";i:17;s:14:\"single product\";i:18;s:5:\"stats\";i:19;s:9:\"subscribe\";i:20;s:4:\"team\";i:21;s:12:\"testimonials\";}s:9:\"templates\";a:763:{i:0;a:14:{s:2:\"id\";i:5525;s:5:\"title\";s:8:\"About 14\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_10.png\";s:12:\"tmpl_created\";i:1520443532;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:9;s:11:\"trend_index\";i:6;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:1;a:14:{s:2:\"id\";i:10107;s:5:\"title\";s:34:\"Classic | Promotion | Announcement\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/balls_small.png\";s:12:\"tmpl_created\";i:1547851373;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/classic-promotion-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:240;s:11:\"trend_index\";i:197;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:2;a:14:{s:2:\"id\";i:14790;s:5:\"title\";s:33:\"Luxury Real Estate &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/07/Header.png\";s:12:\"tmpl_created\";i:1595315760;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/luxury-real-estate-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:37:\"[\"header\",\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:320;s:11:\"trend_index\";i:12;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:3;a:14:{s:2:\"id\";i:5533;s:5:\"title\";s:8:\"About 15\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_10.png\";s:12:\"tmpl_created\";i:1520443534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:27;s:11:\"trend_index\";i:11;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:4;a:14:{s:2:\"id\";i:14799;s:5:\"title\";s:38:\"Luxury Real Estate &#8211; single post\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/07/Post.png\";s:12:\"tmpl_created\";i:1595315792;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/blocks/luxury-real-estate-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:28:\"[\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:586;s:11:\"trend_index\";i:129;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:5;a:14:{s:2:\"id\";i:5575;s:5:\"title\";s:5:\"CTA 7\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_3.png\";s:12:\"tmpl_created\";i:1520443543;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:14;s:11:\"trend_index\";i:13;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:6;a:14:{s:2:\"id\";i:14809;s:5:\"title\";s:45:\"Luxury Real Estate &#8211; Properties Archive\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/07/Properties.png\";s:12:\"tmpl_created\";i:1595315826;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/blocks/luxury-real-estate-properties-archive/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:28:\"[\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:598;s:11:\"trend_index\";i:195;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:7;a:14:{s:2:\"id\";i:5615;s:5:\"title\";s:10:\"Features 6\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_5.png\";s:12:\"tmpl_created\";i:1520443551;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:33;s:11:\"trend_index\";i:64;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:8;a:14:{s:2:\"id\";i:14816;s:5:\"title\";s:47:\"Luxury Real Estate &#8211; Property single post\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2020/07/Single-Property-.png\";s:12:\"tmpl_created\";i:1595315847;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/blocks/luxury-real-estate-property-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:28:\"[\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:646;s:11:\"trend_index\";i:278;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:9;a:14:{s:2:\"id\";i:5624;s:5:\"title\";s:10:\"Features 5\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_black_1.png\";s:12:\"tmpl_created\";i:1520443553;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:77;s:11:\"trend_index\";i:157;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:10;a:14:{s:2:\"id\";i:14827;s:5:\"title\";s:39:\"Slide-In | Contact | Luxury Real Estate\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/07/PopUp.png\";s:12:\"tmpl_created\";i:1595323523;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/slide-in-contact-luxury-real-estate/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:28:\"[\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:672;s:11:\"trend_index\";i:425;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:11;a:14:{s:2:\"id\";i:5684;s:5:\"title\";s:5:\"FAQ 8\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_1.png\";s:12:\"tmpl_created\";i:1520443565;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:67;s:11:\"trend_index\";i:75;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:12;a:14:{s:2:\"id\";i:10158;s:5:\"title\";s:17:\"Classic | Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/coco_small.png\";s:12:\"tmpl_created\";i:1547852227;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/classic-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:268;s:11:\"trend_index\";i:238;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:13;a:14:{s:2:\"id\";i:15052;s:5:\"title\";s:36:\"Flooring Company &#8211; Single post\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/08/Single.png\";s:12:\"tmpl_created\";i:1597738858;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/flooring-company-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:688;s:11:\"trend_index\";i:175;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:14;a:14:{s:2:\"id\";i:5693;s:5:\"title\";s:5:\"FAQ 9\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_1.png\";s:12:\"tmpl_created\";i:1520443567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:200;s:11:\"trend_index\";i:198;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:15;a:14:{s:2:\"id\";i:15007;s:5:\"title\";s:31:\"Flooring Company &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/08/Header.png\";s:12:\"tmpl_created\";i:1597738896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/flooring-company-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:48:\"[\"Flooring company\",\"Flooring website\",\"header\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:685;s:11:\"trend_index\";i:192;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:16;a:14:{s:2:\"id\";i:5703;s:5:\"title\";s:6:\"FAQ 13\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_2.png\";s:12:\"tmpl_created\";i:1520443569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/faq-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:28;s:11:\"trend_index\";i:25;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:17;a:14:{s:2:\"id\";i:15017;s:5:\"title\";s:31:\"Flooring Company &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/08/Footer.png\";s:12:\"tmpl_created\";i:1597738933;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/flooring-company-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:48:\"[\"Flooring company\",\"Flooring website\",\"footer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:632;s:11:\"trend_index\";i:83;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:18;a:14:{s:2:\"id\";i:5711;s:5:\"title\";s:5:\"FAQ 1\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_2.png\";s:12:\"tmpl_created\";i:1520443571;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:192;s:11:\"trend_index\";i:265;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:19;a:14:{s:2:\"id\";i:10190;s:5:\"title\";s:30:\"Classic | Register | Subscribe\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/engage_small.png\";s:12:\"tmpl_created\";i:1547885703;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-register-subscribe-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:246;s:11:\"trend_index\";i:137;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:20;a:14:{s:2:\"id\";i:15042;s:5:\"title\";s:32:\"Flooring Company &#8211; Archive\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/08/Blog.png\";s:12:\"tmpl_created\";i:1597739084;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/flooring-company-archive/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:635;s:11:\"trend_index\";i:88;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:21;a:14:{s:2:\"id\";i:5719;s:5:\"title\";s:5:\"FAQ 4\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_3.png\";s:12:\"tmpl_created\";i:1520443573;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:119;s:11:\"trend_index\";i:145;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:22;a:14:{s:2:\"id\";i:15033;s:5:\"title\";s:28:\"Flooring Company &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/08/404.png\";s:12:\"tmpl_created\";i:1597739459;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/flooring-company-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:45:\"[\"404\",\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:724;s:11:\"trend_index\";i:306;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:23;a:14:{s:2:\"id\";i:5729;s:5:\"title\";s:5:\"FAQ 5\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_3.png\";s:12:\"tmpl_created\";i:1520443575;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:304;s:11:\"trend_index\";i:368;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:24;a:14:{s:2:\"id\";i:15075;s:5:\"title\";s:34:\"Slide-In | Menu | Flooring Company\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/08/PopUp-1.png\";s:12:\"tmpl_created\";i:1597739605;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/slide-in-menu-flooring-company/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:690;s:11:\"trend_index\";i:255;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:25;a:14:{s:2:\"id\";i:5737;s:5:\"title\";s:6:\"FAQ 10\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_4.png\";s:12:\"tmpl_created\";i:1520443576;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/faq-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:157;s:11:\"trend_index\";i:115;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:26;a:14:{s:2:\"id\";i:15062;s:5:\"title\";s:35:\"Fly-In | Sign up | Flooring Company\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/08/PopUp.png\";s:12:\"tmpl_created\";i:1597739629;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/fly-in-sign-up-flooring-company/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:725;s:11:\"trend_index\";i:337;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:27;a:14:{s:2:\"id\";i:5746;s:5:\"title\";s:6:\"FAQ 11\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_4.png\";s:12:\"tmpl_created\";i:1520443578;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/faq-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:195;s:11:\"trend_index\";i:167;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:28;a:14:{s:2:\"id\";i:5755;s:5:\"title\";s:5:\"FAQ 6\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_5.png\";s:12:\"tmpl_created\";i:1520443580;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:99;s:11:\"trend_index\";i:140;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:29;a:14:{s:2:\"id\";i:5764;s:5:\"title\";s:5:\"FAQ 7\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_5.png\";s:12:\"tmpl_created\";i:1520443582;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:315;s:11:\"trend_index\";i:315;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:30;a:14:{s:2:\"id\";i:10256;s:5:\"title\";s:20:\"Classic | Sale | Pop\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/fruit_small.png\";s:12:\"tmpl_created\";i:1547888909;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:431;s:11:\"trend_index\";i:465;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:31;a:14:{s:2:\"id\";i:5773;s:5:\"title\";s:7:\"Hero 11\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_1.png\";s:12:\"tmpl_created\";i:1520443584;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/hero-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:34;s:11:\"trend_index\";i:51;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:32;a:14:{s:2:\"id\";i:10267;s:5:\"title\";s:29:\"Classic | Contact | Christmas\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/christmas_small.png\";s:12:\"tmpl_created\";i:1547889047;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/classic-contact-christmas/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:305;s:11:\"trend_index\";i:216;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:33;a:14:{s:2:\"id\";i:5783;s:5:\"title\";s:7:\"Hero 10\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_2.png\";s:12:\"tmpl_created\";i:1520443586;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/hero-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:344;s:11:\"trend_index\";i:514;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:34;a:14:{s:2:\"id\";i:5792;s:5:\"title\";s:6:\"Hero 9\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_3.png\";s:12:\"tmpl_created\";i:1520443588;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:220;s:11:\"trend_index\";i:308;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:35;a:14:{s:2:\"id\";i:5801;s:5:\"title\";s:6:\"Hero 7\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_4.png\";s:12:\"tmpl_created\";i:1520443589;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:16;s:11:\"trend_index\";i:14;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:36;a:14:{s:2:\"id\";i:5811;s:5:\"title\";s:6:\"Hero 8\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_5.png\";s:12:\"tmpl_created\";i:1520443591;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:116;s:11:\"trend_index\";i:63;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:37;a:14:{s:2:\"id\";i:10307;s:5:\"title\";s:43:\"Fly In | Promotion | Christmas | Teddy Bear\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/teddy_small.png\";s:12:\"tmpl_created\";i:1547893266;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/fly-in-promotion-christmas/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:599;s:11:\"trend_index\";i:578;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:38;a:14:{s:2:\"id\";i:5820;s:5:\"title\";s:9:\"Contact 2\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_white_1.png\";s:12:\"tmpl_created\";i:1520443593;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:173;s:11:\"trend_index\";i:251;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:39;a:14:{s:2:\"id\";i:10318;s:5:\"title\";s:27:\"Classic | Contact | Bicycle\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/01/by_small.png\";s:12:\"tmpl_created\";i:1547893367;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/popups/classic-contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:336;s:11:\"trend_index\";i:398;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:40;a:14:{s:2:\"id\";i:5828;s:5:\"title\";s:9:\"Contact 3\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_black_1.png\";s:12:\"tmpl_created\";i:1520443595;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:300;s:11:\"trend_index\";i:288;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:41;a:14:{s:2:\"id\";i:5836;s:5:\"title\";s:10:\"Contact 10\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_white_2.png\";s:12:\"tmpl_created\";i:1520443597;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:115;s:11:\"trend_index\";i:111;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:42;a:14:{s:2:\"id\";i:10339;s:5:\"title\";s:22:\"Fly In | Contact | Spa\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/spa_small.png\";s:12:\"tmpl_created\";i:1547893603;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/fly-in-contact-spa/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:397;s:11:\"trend_index\";i:600;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:43;a:14:{s:2:\"id\";i:15204;s:5:\"title\";s:24:\"Psychologist &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/09/404.jpg\";s:12:\"tmpl_created\";i:1600161419;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/psychologist-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:40:\"[\"404\",\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:44;a:14:{s:2:\"id\";i:5844;s:5:\"title\";s:10:\"Contact 11\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_black_2.png\";s:12:\"tmpl_created\";i:1520443599;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:285;s:11:\"trend_index\";i:317;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:45;a:14:{s:2:\"id\";i:10352;s:5:\"title\";s:23:\"Fly In | Contact | Wine\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/01/fly_wine_small.png\";s:12:\"tmpl_created\";i:1547915335;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/fly-in-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:440;s:11:\"trend_index\";i:445;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:46;a:14:{s:2:\"id\";i:15212;s:5:\"title\";s:28:\"Psychologist &#8211; Archive\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/09/Blog.jpg\";s:12:\"tmpl_created\";i:1600162340;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/psychologist-archive/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:47;a:14:{s:2:\"id\";i:5852;s:5:\"title\";s:6:\"CTA 34\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2018/03/form_1.png\";s:12:\"tmpl_created\";i:1520443600;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-34/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:510;s:11:\"trend_index\";i:615;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:48;a:14:{s:2:\"id\";i:15219;s:5:\"title\";s:27:\"Psychologist &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/09/Footer.jpg\";s:12:\"tmpl_created\";i:1600163069;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/psychologist-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:43:\"[\"footer\",\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:49;a:14:{s:2:\"id\";i:5947;s:5:\"title\";s:7:\"Stats 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_1.png\";s:12:\"tmpl_created\";i:1520443621;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:343;s:11:\"trend_index\";i:466;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:50;a:14:{s:2:\"id\";i:10372;s:5:\"title\";s:29:\"Fly In | Register | Subscribe\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/phone_small.png\";s:12:\"tmpl_created\";i:1547915554;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/fly-in-register-subscribe-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:596;s:11:\"trend_index\";i:661;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:51;a:14:{s:2:\"id\";i:15230;s:5:\"title\";s:27:\"Psychologist &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/09/Header.png\";s:12:\"tmpl_created\";i:1600163444;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/psychologist-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:43:\"[\"header\",\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:52;a:14:{s:2:\"id\";i:5956;s:5:\"title\";s:7:\"Stats 7\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_black_1.png\";s:12:\"tmpl_created\";i:1520443623;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:504;s:11:\"trend_index\";i:421;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:53;a:14:{s:2:\"id\";i:10382;s:5:\"title\";s:35:\"Bottom Bar | Announcement | Cookies\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2019/01/bottom_pink_small.png\";s:12:\"tmpl_created\";i:1547916616;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/bottom-bar-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:281;s:11:\"trend_index\";i:220;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:54;a:14:{s:2:\"id\";i:15240;s:5:\"title\";s:34:\"Psychologist &#8211; single post 1\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/09/Single-Post.png\";s:12:\"tmpl_created\";i:1600164087;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/psychologist-single-post-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:55;a:14:{s:2:\"id\";i:5963;s:5:\"title\";s:10:\"Features 7\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_2.png\";s:12:\"tmpl_created\";i:1520443626;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:63;s:11:\"trend_index\";i:60;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:56;a:14:{s:2:\"id\";i:15251;s:5:\"title\";s:34:\"Psychologist &#8211; single post 2\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2020/09/Single-Service-Page.png\";s:12:\"tmpl_created\";i:1600165179;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/psychologist-single-post-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:57;a:14:{s:2:\"id\";i:5974;s:5:\"title\";s:10:\"Features 4\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_3.png\";s:12:\"tmpl_created\";i:1520443629;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:62;s:11:\"trend_index\";i:103;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:58;a:14:{s:2:\"id\";i:15259;s:5:\"title\";s:31:\"Hello Bar | Menu | Psychologist\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/09/Menu-PopUp.png\";s:12:\"tmpl_created\";i:1600170209;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/hello-bar-menu-psychologist/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:59;a:14:{s:2:\"id\";i:5983;s:5:\"title\";s:10:\"Features 3\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_black_3.png\";s:12:\"tmpl_created\";i:1520443630;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:11:\"[\"featues\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:230;s:11:\"trend_index\";i:281;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:60;a:14:{s:2:\"id\";i:15272;s:5:\"title\";s:32:\"Classic | Contact | Psychologist\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/09/PopUp.png\";s:12:\"tmpl_created\";i:1600170487;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-contact-psychologist/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:61;a:14:{s:2:\"id\";i:5991;s:5:\"title\";s:11:\"Features 10\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_4.png\";s:12:\"tmpl_created\";i:1520443632;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/features-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:123;s:11:\"trend_index\";i:174;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:62;a:14:{s:2:\"id\";i:15414;s:5:\"title\";s:32:\"Classic | Contact | Dance Studio\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/10/PopUp.jpg\";s:12:\"tmpl_created\";i:1603180596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-contact-dance-studio/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"dance studio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:63;a:14:{s:2:\"id\";i:5999;s:5:\"title\";s:7:\"Team 14\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_10.png\";s:12:\"tmpl_created\";i:1520443634;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:89;s:11:\"trend_index\";i:135;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:64;a:14:{s:2:\"id\";i:10434;s:5:\"title\";s:27:\"Classic | Sale | Headphones\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/head_small.png\";s:12:\"tmpl_created\";i:1547961950;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:369;s:11:\"trend_index\";i:327;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:65;a:14:{s:2:\"id\";i:6008;s:5:\"title\";s:6:\"Team 6\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_10.png\";s:12:\"tmpl_created\";i:1520443636;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/team-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:66;s:11:\"trend_index\";i:99;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:66;a:14:{s:2:\"id\";i:10444;s:5:\"title\";s:17:\"Classic | Contact\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/plant_small.png\";s:12:\"tmpl_created\";i:1547962029;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/popups/classic-contact-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:396;s:11:\"trend_index\";i:484;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:67;a:14:{s:2:\"id\";i:6027;s:5:\"title\";s:7:\"About 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_1-1.png\";s:12:\"tmpl_created\";i:1520443639;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/about-5-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:39;s:11:\"trend_index\";i:49;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:68;a:14:{s:2:\"id\";i:6036;s:5:\"title\";s:7:\"About 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_1-1.png\";s:12:\"tmpl_created\";i:1520443641;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/about-6-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:86;s:11:\"trend_index\";i:85;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:69;a:14:{s:2:\"id\";i:10467;s:5:\"title\";s:27:\"Bottom Bar | Contact | Lego\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/tro_small.png\";s:12:\"tmpl_created\";i:1547962277;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/bottom-bar-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:669;s:11:\"trend_index\";i:694;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:70;a:14:{s:2:\"id\";i:6044;s:5:\"title\";s:11:\"Features 11\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_5.png\";s:12:\"tmpl_created\";i:1520443643;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/features-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:65;s:11:\"trend_index\";i:71;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:71;a:14:{s:2:\"id\";i:6053;s:5:\"title\";s:10:\"Features 1\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_black_5.png\";s:12:\"tmpl_created\";i:1520443645;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:168;s:11:\"trend_index\";i:205;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:72;a:14:{s:2:\"id\";i:10487;s:5:\"title\";s:18:\"Slide In | Contact\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/acc_small.png\";s:12:\"tmpl_created\";i:1547964527;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/slide-in-contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:520;s:11:\"trend_index\";i:503;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:73;a:14:{s:2:\"id\";i:6063;s:5:\"title\";s:7:\"Stats 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_2.png\";s:12:\"tmpl_created\";i:1520443647;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:161;s:11:\"trend_index\";i:257;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:74;a:14:{s:2:\"id\";i:10498;s:5:\"title\";s:14:\"Classic | Sale\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/pink_small-1.png\";s:12:\"tmpl_created\";i:1547964616;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:416;s:11:\"trend_index\";i:304;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:75;a:14:{s:2:\"id\";i:15407;s:5:\"title\";s:24:\"Dance Studio &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/10/404.jpg\";s:12:\"tmpl_created\";i:1603181958;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/dance-studio-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:22:\"[\"404\",\"dance studio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:76;a:14:{s:2:\"id\";i:6071;s:5:\"title\";s:8:\"Stats 13\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_3.png\";s:12:\"tmpl_created\";i:1520443649;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/stats-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:160;s:11:\"trend_index\";i:242;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:77;a:14:{s:2:\"id\";i:15400;s:5:\"title\";s:27:\"Dance Studio &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/10/Footer.jpg\";s:12:\"tmpl_created\";i:1603181989;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/dance-studio-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:25:\"[\"dance studio\",\"footer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:78;a:14:{s:2:\"id\";i:6079;s:5:\"title\";s:7:\"Stats 3\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_4.png\";s:12:\"tmpl_created\";i:1520443651;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:269;s:11:\"trend_index\";i:350;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:79;a:14:{s:2:\"id\";i:10519;s:5:\"title\";s:27:\"Hello Bar | Promotion | App\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/app_small-1.png\";s:12:\"tmpl_created\";i:1547964801;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/hello-bar-promotion-app-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:549;s:11:\"trend_index\";i:456;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:80;a:14:{s:2:\"id\";i:15391;s:5:\"title\";s:27:\"Dance Studio &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/10/Header.jpg\";s:12:\"tmpl_created\";i:1603182011;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/dance-studio-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:25:\"[\"dance studio\",\"header\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:81;a:14:{s:2:\"id\";i:6089;s:5:\"title\";s:7:\"Stats 4\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_5.png\";s:12:\"tmpl_created\";i:1520443653;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:183;s:11:\"trend_index\";i:292;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:82;a:14:{s:2:\"id\";i:15580;s:5:\"title\";s:31:\"Fullscreen | Menu | Travel Blog\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/11/PopUp-Menu.jpg\";s:12:\"tmpl_created\";i:1606215358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/fullscreen-menu-travel-blog/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:83;a:14:{s:2:\"id\";i:6097;s:5:\"title\";s:7:\"Stats 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_black_2.png\";s:12:\"tmpl_created\";i:1520443655;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:262;s:11:\"trend_index\";i:209;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:84;a:14:{s:2:\"id\";i:15570;s:5:\"title\";s:33:\"Classic | Subscribe | Travel Blog\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/11/PopUp.jpg\";s:12:\"tmpl_created\";i:1606215555;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/classic-subscribe-travel-blog/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:85;a:14:{s:2:\"id\";i:6106;s:5:\"title\";s:7:\"Stats 2\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_6.png\";s:12:\"tmpl_created\";i:1520443657;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:337;s:11:\"trend_index\";i:443;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:86;a:14:{s:2:\"id\";i:15556;s:5:\"title\";s:33:\"Travel Blog &#8211; Single Post 2\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/11/Single-2-350.jpg\";s:12:\"tmpl_created\";i:1606215613;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/travel-blog-single-post-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:87;a:14:{s:2:\"id\";i:6114;s:5:\"title\";s:7:\"Stats 1\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_black_6.png\";s:12:\"tmpl_created\";i:1520443659;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:378;s:11:\"trend_index\";i:439;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:88;a:14:{s:2:\"id\";i:15536;s:5:\"title\";s:26:\"Travel Blog &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/11/Header.jpg\";s:12:\"tmpl_created\";i:1606215625;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/travel-blog-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:26:\"[\"Blog\",\"Header\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:89;a:14:{s:2:\"id\";i:6122;s:5:\"title\";s:7:\"About 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_2-1.png\";s:12:\"tmpl_created\";i:1520443661;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/about-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:36;s:11:\"trend_index\";i:45;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:90;a:14:{s:2:\"id\";i:10569;s:5:\"title\";s:15:\"Slide In | Sale\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/off_small.png\";s:12:\"tmpl_created\";i:1547967812;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/popups/slide-in-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:501;s:11:\"trend_index\";i:556;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:91;a:14:{s:2:\"id\";i:15498;s:5:\"title\";s:23:\"Travel Blog &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/11/404.jpg\";s:12:\"tmpl_created\";i:1606215636;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/travel-blog-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:23:\"[\"404\",\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:92;a:14:{s:2:\"id\";i:6135;s:5:\"title\";s:8:\"About 10\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_2.png\";s:12:\"tmpl_created\";i:1520443663;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:83;s:11:\"trend_index\";i:121;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:93;a:14:{s:2:\"id\";i:15508;s:5:\"title\";s:29:\"Travel Blog &#8211; Archive 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2020/11/Archive-1-350.jpg\";s:12:\"tmpl_created\";i:1606215649;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/travel-blog-archive-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:94;a:14:{s:2:\"id\";i:6144;s:5:\"title\";s:7:\"Team 17\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_11.png\";s:12:\"tmpl_created\";i:1520443664;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:155;s:11:\"trend_index\";i:277;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:95;a:14:{s:2:\"id\";i:10590;s:5:\"title\";s:19:\"Full Screen | Login\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/pass1_small.png\";s:12:\"tmpl_created\";i:1547967978;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/classic-login-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:470;s:11:\"trend_index\";i:411;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:96;a:14:{s:2:\"id\";i:15518;s:5:\"title\";s:29:\"Travel Blog &#8211; Archive 2\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2020/11/Archive-2-350-Copy.jpg\";s:12:\"tmpl_created\";i:1606215663;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/travel-blog-archive-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:97;a:14:{s:2:\"id\";i:6152;s:5:\"title\";s:7:\"Stats 9\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_black_1.png\";s:12:\"tmpl_created\";i:1520443666;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:241;s:11:\"trend_index\";i:233;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:98;a:14:{s:2:\"id\";i:10600;s:5:\"title\";s:18:\"Slide In | Contact\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/orange_small.png\";s:12:\"tmpl_created\";i:1547968080;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/slide-in-contact-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:459;s:11:\"trend_index\";i:530;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:99;a:14:{s:2:\"id\";i:15528;s:5:\"title\";s:26:\"Travel Blog &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/11/Footer.jpg\";s:12:\"tmpl_created\";i:1606215673;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/travel-blog-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:26:\"[\"Blog\",\"Footer\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:100;a:14:{s:2:\"id\";i:6162;s:5:\"title\";s:11:\"Services 31\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_white_1.png\";s:12:\"tmpl_created\";i:1520443668;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-31/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:339;s:11:\"trend_index\";i:430;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:101;a:14:{s:2:\"id\";i:15545;s:5:\"title\";s:33:\"Travel Blog &#8211; Single Post 1\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/11/Single-1-350.jpg\";s:12:\"tmpl_created\";i:1606215684;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/travel-blog-single-post-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:102;a:14:{s:2:\"id\";i:6170;s:5:\"title\";s:8:\"Stats 11\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_black_2.png\";s:12:\"tmpl_created\";i:1520443670;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/stats-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:332;s:11:\"trend_index\";i:419;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:103;a:14:{s:2:\"id\";i:10622;s:5:\"title\";s:34:\"Full Screen | Contact | Headphones\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/full_hear_small.png\";s:12:\"tmpl_created\";i:1547969678;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/full-screen-contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:528;s:11:\"trend_index\";i:459;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:104;a:14:{s:2:\"id\";i:6178;s:5:\"title\";s:8:\"Stats 10\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_white_2.png\";s:12:\"tmpl_created\";i:1520443676;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/stats-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:383;s:11:\"trend_index\";i:549;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:105;a:14:{s:2:\"id\";i:10633;s:5:\"title\";s:23:\"Slide In | Login | Lego\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/tro_small-1.png\";s:12:\"tmpl_created\";i:1547969858;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/slide-in-login/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:620;s:11:\"trend_index\";i:573;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:106;a:14:{s:2:\"id\";i:6186;s:5:\"title\";s:8:\"Stats 12\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_white_3.png\";s:12:\"tmpl_created\";i:1520443678;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/stats-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:486;s:11:\"trend_index\";i:586;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:107;a:14:{s:2:\"id\";i:10644;s:5:\"title\";s:26:\"Fly In | Contact | Webinar\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/blue_small-1.png\";s:12:\"tmpl_created\";i:1547970814;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/fly-in-contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:456;s:11:\"trend_index\";i:436;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:108;a:14:{s:2:\"id\";i:6196;s:5:\"title\";s:10:\"Features 9\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_6.png\";s:12:\"tmpl_created\";i:1520443680;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:106;s:11:\"trend_index\";i:130;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:109;a:14:{s:2:\"id\";i:10654;s:5:\"title\";s:31:\"Full Screen | Login | Christmas\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2019/01/full_login_small.png\";s:12:\"tmpl_created\";i:1547970917;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/full-screen-login-christmas/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:615;s:11:\"trend_index\";i:638;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:110;a:14:{s:2:\"id\";i:6204;s:5:\"title\";s:10:\"Features 8\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_black_6.png\";s:12:\"tmpl_created\";i:1520443681;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:213;s:11:\"trend_index\";i:170;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:111;a:14:{s:2:\"id\";i:10664;s:5:\"title\";s:34:\"Slide In | Contact | Gym | Fitness\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/slide_gym_small.png\";s:12:\"tmpl_created\";i:1547973928;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/slide-in-contact-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:515;s:11:\"trend_index\";i:517;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:112;a:14:{s:2:\"id\";i:6212;s:5:\"title\";s:11:\"Features 12\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_7.png\";s:12:\"tmpl_created\";i:1520443684;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/features-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:76;s:11:\"trend_index\";i:67;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:113;a:14:{s:2:\"id\";i:10675;s:5:\"title\";s:35:\"Full Screen | Login | Gym | Fitness\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/01/gym_full_small.png\";s:12:\"tmpl_created\";i:1547974110;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/full-screen-login-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:496;s:11:\"trend_index\";i:510;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:114;a:14:{s:2:\"id\";i:6220;s:5:\"title\";s:10:\"Features 2\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_8.png\";s:12:\"tmpl_created\";i:1520443685;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:82;s:11:\"trend_index\";i:156;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:115;a:14:{s:2:\"id\";i:6230;s:5:\"title\";s:6:\"Hero 6\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_white_1.png\";s:12:\"tmpl_created\";i:1520443687;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:379;s:11:\"trend_index\";i:399;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:116;a:14:{s:2:\"id\";i:9719;s:5:\"title\";s:30:\"Classic | Subscribe | Register\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/01/register_small.png\";s:12:\"tmpl_created\";i:1547976107;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/classic-subscribe-register/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:414;s:11:\"trend_index\";i:194;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:117;a:14:{s:2:\"id\";i:6239;s:5:\"title\";s:6:\"Hero 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_1.png\";s:12:\"tmpl_created\";i:1520443689;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:26;s:11:\"trend_index\";i:24;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:118;a:14:{s:2:\"id\";i:6249;s:5:\"title\";s:6:\"Hero 5\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_2.png\";s:12:\"tmpl_created\";i:1520443691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:56;s:11:\"trend_index\";i:87;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:119;a:14:{s:2:\"id\";i:6258;s:5:\"title\";s:6:\"Hero 4\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_3.png\";s:12:\"tmpl_created\";i:1520443693;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:428;s:11:\"trend_index\";i:591;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:120;a:14:{s:2:\"id\";i:10137;s:5:\"title\";s:34:\"Full Screen | Contact | Restaurant\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/rest_small.png\";s:12:\"tmpl_created\";i:1547976342;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/full-screen-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:527;s:11:\"trend_index\";i:534;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:121;a:14:{s:2:\"id\";i:6266;s:5:\"title\";s:6:\"Hero 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_4.png\";s:12:\"tmpl_created\";i:1520443695;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:53;s:11:\"trend_index\";i:90;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:122;a:14:{s:2:\"id\";i:10244;s:5:\"title\";s:17:\"Bottom Bar | Sale\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/wow_small.png\";s:12:\"tmpl_created\";i:1547976402;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/bottom-bar-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:579;s:11:\"trend_index\";i:624;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:123;a:14:{s:2:\"id\";i:6274;s:5:\"title\";s:6:\"Hero 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_5.png\";s:12:\"tmpl_created\";i:1520443698;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:95;s:11:\"trend_index\";i:89;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:124;a:14:{s:2:\"id\";i:6017;s:5:\"title\";s:6:\"CTA 14\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_14.png\";s:12:\"tmpl_created\";i:1520520331;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:150;s:11:\"trend_index\";i:155;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:125;a:14:{s:2:\"id\";i:10127;s:5:\"title\";s:35:\"Fly In | Announcement | Maintenance\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/pizza_small.png\";s:12:\"tmpl_created\";i:1547984061;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/fly-in-announcement-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:637;s:11:\"trend_index\";i:666;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:126;a:14:{s:2:\"id\";i:4826;s:5:\"title\";s:14:\"Testimonial 24\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_1.png\";s:12:\"tmpl_created\";i:1520520544;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/testimonial-24-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:254;s:11:\"trend_index\";i:309;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:127;a:14:{s:2:\"id\";i:4835;s:5:\"title\";s:14:\"Testimonial 16\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_1.png\";s:12:\"tmpl_created\";i:1520520546;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:381;s:11:\"trend_index\";i:423;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:128;a:14:{s:2:\"id\";i:4843;s:5:\"title\";s:14:\"Testimonial 18\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_2.png\";s:12:\"tmpl_created\";i:1520520548;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:409;s:11:\"trend_index\";i:492;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:129;a:14:{s:2:\"id\";i:4854;s:5:\"title\";s:14:\"Testimonial 13\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_2.png\";s:12:\"tmpl_created\";i:1520520549;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:580;s:11:\"trend_index\";i:610;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:130;a:14:{s:2:\"id\";i:4863;s:5:\"title\";s:14:\"Testimonial 19\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_3.png\";s:12:\"tmpl_created\";i:1520520551;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-19/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:244;s:11:\"trend_index\";i:343;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:131;a:14:{s:2:\"id\";i:10776;s:5:\"title\";s:33:\"Fly In | Contact | Social | Share\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/01/social1_small.png\";s:12:\"tmpl_created\";i:1548047055;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/fly-in-contact-social-share/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:640;s:11:\"trend_index\";i:660;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:132;a:14:{s:2:\"id\";i:4871;s:5:\"title\";s:14:\"Testimonial 12\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_3.png\";s:12:\"tmpl_created\";i:1520520552;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:245;s:11:\"trend_index\";i:329;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:133;a:14:{s:2:\"id\";i:10785;s:5:\"title\";s:33:\"Fly In | Contact | Social | Share\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/01/social2_small.png\";s:12:\"tmpl_created\";i:1548047593;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/fly-in-contact-social-share-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:455;s:11:\"trend_index\";i:524;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:134;a:14:{s:2:\"id\";i:4880;s:5:\"title\";s:14:\"Testimonial 20\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/customers-1.jpg\";s:12:\"tmpl_created\";i:1520520554;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-20/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:394;s:11:\"trend_index\";i:427;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:135;a:14:{s:2:\"id\";i:4889;s:5:\"title\";s:14:\"Testimonial 11\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/customers-2.jpg\";s:12:\"tmpl_created\";i:1520520556;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:513;s:11:\"trend_index\";i:537;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:136;a:14:{s:2:\"id\";i:4897;s:5:\"title\";s:14:\"Testimonial 21\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_5.png\";s:12:\"tmpl_created\";i:1520520557;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-21/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:71;s:11:\"trend_index\";i:69;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:137;a:14:{s:2:\"id\";i:4905;s:5:\"title\";s:14:\"Testimonial 22\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_6.png\";s:12:\"tmpl_created\";i:1520520559;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-22/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:114;s:11:\"trend_index\";i:138;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:138;a:14:{s:2:\"id\";i:4913;s:5:\"title\";s:14:\"Testimonial 23\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_7.png\";s:12:\"tmpl_created\";i:1520520561;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-23/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:232;s:11:\"trend_index\";i:291;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:139;a:14:{s:2:\"id\";i:4921;s:5:\"title\";s:14:\"Testimonial 10\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_5.png\";s:12:\"tmpl_created\";i:1520520562;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:209;s:11:\"trend_index\";i:218;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:140;a:14:{s:2:\"id\";i:4929;s:5:\"title\";s:14:\"Testimonial 24\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_8.png\";s:12:\"tmpl_created\";i:1520520564;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-24/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:43;s:11:\"trend_index\";i:70;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:141;a:14:{s:2:\"id\";i:4939;s:5:\"title\";s:13:\"Testimonial 9\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_8.png\";s:12:\"tmpl_created\";i:1520520565;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/testimonial-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:90;s:11:\"trend_index\";i:133;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:142;a:14:{s:2:\"id\";i:4947;s:5:\"title\";s:14:\"Testimonial 27\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_9.png\";s:12:\"tmpl_created\";i:1520520567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-27/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:197;s:11:\"trend_index\";i:313;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:143;a:14:{s:2:\"id\";i:4955;s:5:\"title\";s:14:\"Testimonial 29\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_9.png\";s:12:\"tmpl_created\";i:1520520569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-29/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:346;s:11:\"trend_index\";i:416;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:144;a:14:{s:2:\"id\";i:4963;s:5:\"title\";s:14:\"Testimonial 25\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_10.png\";s:12:\"tmpl_created\";i:1520520570;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/testimonial-25-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:391;s:11:\"trend_index\";i:401;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:145;a:14:{s:2:\"id\";i:4971;s:5:\"title\";s:14:\"Testimonial 26\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_11.png\";s:12:\"tmpl_created\";i:1520520572;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-26/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:594;s:11:\"trend_index\";i:664;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:146;a:14:{s:2:\"id\";i:4979;s:5:\"title\";s:14:\"Testimonial 15\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_10.png\";s:12:\"tmpl_created\";i:1520520573;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:529;s:11:\"trend_index\";i:648;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:147;a:14:{s:2:\"id\";i:4987;s:5:\"title\";s:14:\"Testimonial 17\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_12-1.png\";s:12:\"tmpl_created\";i:1520520575;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:151;s:11:\"trend_index\";i:239;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:148;a:14:{s:2:\"id\";i:4995;s:5:\"title\";s:14:\"Testimonial 14\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_12.png\";s:12:\"tmpl_created\";i:1520520577;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:372;s:11:\"trend_index\";i:509;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:149;a:14:{s:2:\"id\";i:5007;s:5:\"title\";s:11:\"Portfolio 7\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_1.png\";s:12:\"tmpl_created\";i:1520520578;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:41;s:11:\"trend_index\";i:36;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:150;a:14:{s:2:\"id\";i:5019;s:5:\"title\";s:11:\"Portfolio 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_1.png\";s:12:\"tmpl_created\";i:1520520580;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:164;s:11:\"trend_index\";i:207;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:151;a:14:{s:2:\"id\";i:5027;s:5:\"title\";s:12:\"Portfolio 11\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_2.png\";s:12:\"tmpl_created\";i:1520520581;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:301;s:11:\"trend_index\";i:389;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:152;a:14:{s:2:\"id\";i:10794;s:5:\"title\";s:34:\"Classic | Contact | Social | Share\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/01/s_small.png\";s:12:\"tmpl_created\";i:1548067619;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-contact-social-share/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:430;s:11:\"trend_index\";i:296;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:153;a:14:{s:2:\"id\";i:5037;s:5:\"title\";s:12:\"Portfolio 12\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_3.png\";s:12:\"tmpl_created\";i:1520520583;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:265;s:11:\"trend_index\";i:346;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:154;a:14:{s:2:\"id\";i:5057;s:5:\"title\";s:12:\"Portfolio 13\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_4.png\";s:12:\"tmpl_created\";i:1520520586;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:231;s:11:\"trend_index\";i:334;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:155;a:14:{s:2:\"id\";i:5071;s:5:\"title\";s:12:\"Portfolio 14\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_5.png\";s:12:\"tmpl_created\";i:1520520588;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:272;s:11:\"trend_index\";i:271;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:156;a:14:{s:2:\"id\";i:10871;s:5:\"title\";s:20:\"Bottom Bar | Contact\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/01/m_small.png\";s:12:\"tmpl_created\";i:1548074396;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/bottom-bar-contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:649;s:11:\"trend_index\";i:681;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:157;a:14:{s:2:\"id\";i:5082;s:5:\"title\";s:11:\"Portfolio 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_4.png\";s:12:\"tmpl_created\";i:1520520589;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:490;s:11:\"trend_index\";i:448;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:158;a:14:{s:2:\"id\";i:10936;s:5:\"title\";s:25:\"Full Screen | Toggle Menu\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/menu_small.png\";s:12:\"tmpl_created\";i:1548874587;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/full-screen-toggle-menu/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:442;s:11:\"trend_index\";i:511;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:159;a:14:{s:2:\"id\";i:5090;s:5:\"title\";s:12:\"Portfolio 15\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_6.png\";s:12:\"tmpl_created\";i:1520520591;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:171;s:11:\"trend_index\";i:191;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:160;a:14:{s:2:\"id\";i:5098;s:5:\"title\";s:12:\"Portfolio 16\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_7.png\";s:12:\"tmpl_created\";i:1520520593;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:152;s:11:\"trend_index\";i:142;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:161;a:14:{s:2:\"id\";i:5107;s:5:\"title\";s:11:\"Portfolio 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_7.png\";s:12:\"tmpl_created\";i:1520520594;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:359;s:11:\"trend_index\";i:433;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:162;a:14:{s:2:\"id\";i:10964;s:5:\"title\";s:59:\"Classic | Promotion | Coupon | Love | Valentine&#8217;s Day\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/02/love_small.png\";s:12:\"tmpl_created\";i:1550039106;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/popups/classic-promotion-coupon/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:581;s:11:\"trend_index\";i:486;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:163;a:14:{s:2:\"id\";i:5115;s:5:\"title\";s:12:\"Portfolio 17\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_8.png\";s:12:\"tmpl_created\";i:1520520596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:22;s:11:\"trend_index\";i:18;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:164;a:14:{s:2:\"id\";i:10992;s:5:\"title\";s:59:\"Classic | Promotion | Coupon | Love | Valentine&#8217;s Day\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/02/h_small.png\";s:12:\"tmpl_created\";i:1550072007;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/classic-promotion-coupon-love-valentines-day/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:631;s:11:\"trend_index\";i:698;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:165;a:14:{s:2:\"id\";i:5125;s:5:\"title\";s:11:\"Portfolio 6\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_8.png\";s:12:\"tmpl_created\";i:1520520597;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:223;s:11:\"trend_index\";i:236;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:166;a:14:{s:2:\"id\";i:11005;s:5:\"title\";s:50:\"Classic | Promotion | Love | Valentine&#8217;s Day\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/02/bear_small.png\";s:12:\"tmpl_created\";i:1550073303;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-promotion-love-valentines-day/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:628;s:11:\"trend_index\";i:609;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:167;a:14:{s:2:\"id\";i:5133;s:5:\"title\";s:12:\"Portfolio 18\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_9.png\";s:12:\"tmpl_created\";i:1520520599;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:170;s:11:\"trend_index\";i:149;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:168;a:14:{s:2:\"id\";i:5141;s:5:\"title\";s:12:\"Portfolio 10\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_10.png\";s:12:\"tmpl_created\";i:1520520601;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:371;s:11:\"trend_index\";i:454;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:169;a:14:{s:2:\"id\";i:5149;s:5:\"title\";s:11:\"Portfolio 2\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_10.png\";s:12:\"tmpl_created\";i:1520520602;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:365;s:11:\"trend_index\";i:546;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:170;a:14:{s:2:\"id\";i:5542;s:5:\"title\";s:6:\"CTA 19\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_1.png\";s:12:\"tmpl_created\";i:1520520681;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-19/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:159;s:11:\"trend_index\";i:212;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:171;a:14:{s:2:\"id\";i:5550;s:5:\"title\";s:6:\"CTA 33\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_1.png\";s:12:\"tmpl_created\";i:1520520682;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-33/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:249;s:11:\"trend_index\";i:268;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:172;a:14:{s:2:\"id\";i:5558;s:5:\"title\";s:5:\"CTA 1\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_2.png\";s:12:\"tmpl_created\";i:1520520684;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:135;s:11:\"trend_index\";i:146;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:173;a:14:{s:2:\"id\";i:5567;s:5:\"title\";s:5:\"CTA 2\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_2.png\";s:12:\"tmpl_created\";i:1520520685;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:146;s:11:\"trend_index\";i:80;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:174;a:14:{s:2:\"id\";i:11231;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/07/Post_small1.png\";s:12:\"tmpl_created\";i:1564642380;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/digital-agency/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:166;s:11:\"trend_index\";i:158;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:175;a:14:{s:2:\"id\";i:5583;s:5:\"title\";s:6:\"CTA 26\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_3.png\";s:12:\"tmpl_created\";i:1520520689;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-26/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:131;s:11:\"trend_index\";i:42;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:176;a:14:{s:2:\"id\";i:11220;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/08/Archive_small1.png\";s:12:\"tmpl_created\";i:1564642385;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/digital-agency-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:121;s:11:\"trend_index\";i:48;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:177;a:14:{s:2:\"id\";i:5591;s:5:\"title\";s:5:\"CTA 5\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_4.png\";s:12:\"tmpl_created\";i:1520520691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:128;s:11:\"trend_index\";i:179;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:178;a:14:{s:2:\"id\";i:11204;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/07/404_small.jpg\";s:12:\"tmpl_created\";i:1564642389;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/digital-agency-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:36:\"[\"404\",\"Digital Agency\",\"marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:327;s:11:\"trend_index\";i:237;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:179;a:14:{s:2:\"id\";i:5599;s:5:\"title\";s:5:\"CTA 6\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_4.png\";s:12:\"tmpl_created\";i:1520520693;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:251;s:11:\"trend_index\";i:234;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:180;a:14:{s:2:\"id\";i:11198;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-digital-marketing-agency.png\";s:12:\"tmpl_created\";i:1564642395;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/digital-agency-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:39:\"[\"Digital Agency\",\"header\",\"marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:46;s:11:\"trend_index\";i:17;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:181;a:14:{s:2:\"id\";i:5607;s:5:\"title\";s:6:\"CTA 13\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_5.png\";s:12:\"tmpl_created\";i:1520520695;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:51;s:11:\"trend_index\";i:9;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:182;a:14:{s:2:\"id\";i:11192;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/07/Footer_small.jpg\";s:12:\"tmpl_created\";i:1564642399;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/digital-agency-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:39:\"[\"Digital Agency\",\"footer\",\"marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:191;s:11:\"trend_index\";i:159;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:183;a:14:{s:2:\"id\";i:5634;s:5:\"title\";s:6:\"CTA 24\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_6.png\";s:12:\"tmpl_created\";i:1520520699;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-24/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:172;s:11:\"trend_index\";i:256;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:184;a:14:{s:2:\"id\";i:5642;s:5:\"title\";s:6:\"CTA 25\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_6.png\";s:12:\"tmpl_created\";i:1520520701;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-25/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:212;s:11:\"trend_index\";i:246;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:185;a:14:{s:2:\"id\";i:5650;s:5:\"title\";s:5:\"CTA 9\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_7.png\";s:12:\"tmpl_created\";i:1520520702;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:91;s:11:\"trend_index\";i:81;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:186;a:14:{s:2:\"id\";i:5658;s:5:\"title\";s:5:\"CTA 8\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_7.png\";s:12:\"tmpl_created\";i:1520520704;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:180;s:11:\"trend_index\";i:163;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:187;a:14:{s:2:\"id\";i:5667;s:5:\"title\";s:5:\"CTA 3\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_8.png\";s:12:\"tmpl_created\";i:1520520705;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:158;s:11:\"trend_index\";i:182;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:188;a:14:{s:2:\"id\";i:5675;s:5:\"title\";s:5:\"CTA 4\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_8.png\";s:12:\"tmpl_created\";i:1520520707;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:361;s:11:\"trend_index\";i:418;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:189;a:14:{s:2:\"id\";i:5860;s:5:\"title\";s:6:\"CTA 17\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_9.png\";s:12:\"tmpl_created\";i:1520520746;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:125;s:11:\"trend_index\";i:86;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:190;a:14:{s:2:\"id\";i:5869;s:5:\"title\";s:6:\"CTA 18\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_10.png\";s:12:\"tmpl_created\";i:1520520747;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:312;s:11:\"trend_index\";i:374;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:191;a:14:{s:2:\"id\";i:5877;s:5:\"title\";s:6:\"CTA 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_10.png\";s:12:\"tmpl_created\";i:1520520749;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:505;s:11:\"trend_index\";i:564;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:192;a:14:{s:2:\"id\";i:11468;s:5:\"title\";s:20:\"Classic | Sale | Gym\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/08/PopUp_Small.png\";s:12:\"tmpl_created\";i:1567393182;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/classic-sale-gym/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:643;s:11:\"trend_index\";i:676;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:193;a:14:{s:2:\"id\";i:5885;s:5:\"title\";s:6:\"CTA 15\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_11.png\";s:12:\"tmpl_created\";i:1520520751;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:270;s:11:\"trend_index\";i:402;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:194;a:14:{s:2:\"id\";i:11461;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-gym-and-fitness.png\";s:12:\"tmpl_created\";i:1567393219;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:100:\"https://library.elementor.com/blocks/gym/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:16:\"[\"Gym\",\"header\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:228;s:11:\"trend_index\";i:124;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:195;a:14:{s:2:\"id\";i:5893;s:5:\"title\";s:6:\"CTA 21\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_12.png\";s:12:\"tmpl_created\";i:1520520752;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-21/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:250;s:11:\"trend_index\";i:326;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:196;a:14:{s:2:\"id\";i:11453;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/08/Footer_Small.png\";s:12:\"tmpl_created\";i:1567393224;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/gym-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:16:\"[\"footer\",\"Gym\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:296;s:11:\"trend_index\";i:164;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:197;a:14:{s:2:\"id\";i:5904;s:5:\"title\";s:6:\"CTA 27\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_13.png\";s:12:\"tmpl_created\";i:1520520754;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-27/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:473;s:11:\"trend_index\";i:567;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:198;a:14:{s:2:\"id\";i:11445;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/08/Post_Small.png\";s:12:\"tmpl_created\";i:1567393229;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/gym-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:432;s:11:\"trend_index\";i:428;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:199;a:14:{s:2:\"id\";i:5912;s:5:\"title\";s:6:\"CTA 28\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_11.png\";s:12:\"tmpl_created\";i:1520520755;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-28/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:602;s:11:\"trend_index\";i:662;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:200;a:14:{s:2:\"id\";i:11435;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/08/Archiv_Small.png\";s:12:\"tmpl_created\";i:1567393296;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/gym-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:410;s:11:\"trend_index\";i:471;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:201;a:14:{s:2:\"id\";i:5921;s:5:\"title\";s:6:\"CTA 12\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_14.png\";s:12:\"tmpl_created\";i:1520520757;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:261;s:11:\"trend_index\";i:338;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:202;a:14:{s:2:\"id\";i:11424;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/08/404_Small.png\";s:12:\"tmpl_created\";i:1567393309;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/gym-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:13:\"[\"404\",\"Gym\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:630;s:11:\"trend_index\";i:629;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:203;a:14:{s:2:\"id\";i:5930;s:5:\"title\";s:6:\"CTA 11\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_15.png\";s:12:\"tmpl_created\";i:1520520758;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:73;s:11:\"trend_index\";i:120;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:204;a:14:{s:2:\"id\";i:5939;s:5:\"title\";s:6:\"CTA 10\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_13-1.png\";s:12:\"tmpl_created\";i:1520520760;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:177;s:11:\"trend_index\";i:186;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:205;a:14:{s:2:\"id\";i:7596;s:5:\"title\";s:8:\"Header 1\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.12.jpg\";s:12:\"tmpl_created\";i:1521546999;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:10:\"[\"header\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:35;s:11:\"trend_index\";i:33;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:206;a:14:{s:2:\"id\";i:7615;s:5:\"title\";s:8:\"Header 2\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.1.jpg\";s:12:\"tmpl_created\";i:1521547237;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:10:\"[\"header\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:29;s:11:\"trend_index\";i:29;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:207;a:14:{s:2:\"id\";i:7627;s:5:\"title\";s:8:\"Footer 8\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/footer_hero_1.png\";s:12:\"tmpl_created\";i:1521547332;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/footer-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:10:\"[\"footer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:113;s:11:\"trend_index\";i:94;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:208;a:14:{s:2:\"id\";i:11822;s:5:\"title\";s:30:\"Full Screen | Menu | Portfolio\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/09/PopUp_small.png\";s:12:\"tmpl_created\";i:1569429896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/full-screen-menu-portfolio/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:606;s:11:\"trend_index\";i:628;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:209;a:14:{s:2:\"id\";i:7638;s:5:\"title\";s:8:\"Footer 9\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/footer_hero_2.png\";s:12:\"tmpl_created\";i:1521547502;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/footer-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:10:\"[\"footer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:120;s:11:\"trend_index\";i:136;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:210;a:14:{s:2:\"id\";i:11877;s:5:\"title\";s:27:\"Portfolio &#8211; Project 3\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Project3_small.png\";s:12:\"tmpl_created\";i:1569429954;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/portfolio-project-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:626;s:11:\"trend_index\";i:613;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:211;a:14:{s:2:\"id\";i:7663;s:5:\"title\";s:13:\"Single Post 2\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/single_post_2_v2.jpg\";s:12:\"tmpl_created\";i:1521547761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:24:\"[\"Blog\",\"Post\",\"Single\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:50;s:11:\"trend_index\";i:65;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:212;a:14:{s:2:\"id\";i:11870;s:5:\"title\";s:27:\"Portfolio &#8211; Project 2\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Project2_small.png\";s:12:\"tmpl_created\";i:1569429964;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/portfolio-project-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:604;s:11:\"trend_index\";i:619;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:213;a:14:{s:2:\"id\";i:7650;s:5:\"title\";s:13:\"Single Post 1\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/single_post_1_v2.jpg\";s:12:\"tmpl_created\";i:1521557736;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:24:\"[\"Blog\",\"Post\",\"Single\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:109;s:11:\"trend_index\";i:113;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:214;a:14:{s:2:\"id\";i:11861;s:5:\"title\";s:27:\"Portfolio &#8211; Project 1\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Project1_small.png\";s:12:\"tmpl_created\";i:1569429975;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/portfolio-project-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:593;s:11:\"trend_index\";i:703;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:215;a:14:{s:2:\"id\";i:7686;s:5:\"title\";s:12:\"Blog Posts 1\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2018/03/blog_posts.png\";s:12:\"tmpl_created\";i:1521558047;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/blog-posts-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:26:\"[\"archive\",\"Blog\",\"posts\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:124;s:11:\"trend_index\";i:193;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:216;a:14:{s:2:\"id\";i:11854;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/09/Post_small.png\";s:12:\"tmpl_created\";i:1569429983;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/portfolio/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:472;s:11:\"trend_index\";i:404;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:217;a:14:{s:2:\"id\";i:4676;s:5:\"title\";s:8:\"Footer 7\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/footer_7.png\";s:12:\"tmpl_created\";i:1522014215;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/footer_7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:10:\"[\"footer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:235;s:11:\"trend_index\";i:190;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:218;a:14:{s:2:\"id\";i:11847;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Archiv_small.png\";s:12:\"tmpl_created\";i:1569430010;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:326;s:11:\"trend_index\";i:222;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:219;a:14:{s:2:\"id\";i:7997;s:5:\"title\";s:10:\"footer 014\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.1.jpg\";s:12:\"tmpl_created\";i:1524582343;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/footer-014/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:79;s:11:\"trend_index\";i:35;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:220;a:14:{s:2:\"id\";i:11839;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Header_small.png\";s:12:\"tmpl_created\";i:1569430015;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:43:\"[\"creative portfolio\",\"header\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:280;s:11:\"trend_index\";i:176;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:221;a:14:{s:2:\"id\";i:7982;s:5:\"title\";s:10:\"footer 013\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.2.jpg\";s:12:\"tmpl_created\";i:1524582468;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/footer-013/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:219;s:11:\"trend_index\";i:126;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:222;a:14:{s:2:\"id\";i:11832;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Footer_small.png\";s:12:\"tmpl_created\";i:1569430019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-19/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:43:\"[\"creative portfolio\",\"footer\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:298;s:11:\"trend_index\";i:144;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:223;a:14:{s:2:\"id\";i:7959;s:5:\"title\";s:10:\"footer 012\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.3.jpg\";s:12:\"tmpl_created\";i:1524582605;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/footer-012/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:185;s:11:\"trend_index\";i:181;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:224;a:14:{s:2:\"id\";i:11807;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/09/404_small.png\";s:12:\"tmpl_created\";i:1569430070;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-20/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:40:\"[\"404\",\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:514;s:11:\"trend_index\";i:360;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:225;a:14:{s:2:\"id\";i:7950;s:5:\"title\";s:10:\"footer 011\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.4.jpg\";s:12:\"tmpl_created\";i:1524582631;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/footer-011/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:255;s:11:\"trend_index\";i:235;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:226;a:14:{s:2:\"id\";i:7937;s:5:\"title\";s:10:\"footer 010\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.5.jpg\";s:12:\"tmpl_created\";i:1524582665;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/footer-010/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:203;s:11:\"trend_index\";i:154;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:227;a:14:{s:2:\"id\";i:11897;s:5:\"title\";s:27:\"Portfolio &#8211; Project 2\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Project2_small.png\";s:12:\"tmpl_created\";i:1569494236;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/portfolio-project-2-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:683;s:11:\"trend_index\";i:583;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:228;a:14:{s:2:\"id\";i:7927;s:5:\"title\";s:9:\"footer 09\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.6.jpg\";s:12:\"tmpl_created\";i:1524582691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-09/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:174;s:11:\"trend_index\";i:141;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:229;a:14:{s:2:\"id\";i:11890;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-design-portfolio.png\";s:12:\"tmpl_created\";i:1571907344;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:43:\"[\"creative portfolio\",\"header\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:323;s:11:\"trend_index\";i:213;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:230;a:14:{s:2:\"id\";i:7917;s:5:\"title\";s:9:\"footer 08\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.7.jpg\";s:12:\"tmpl_created\";i:1524582788;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-08/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:97;s:11:\"trend_index\";i:110;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:231;a:14:{s:2:\"id\";i:7904;s:5:\"title\";s:9:\"footer 07\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.8.jpg\";s:12:\"tmpl_created\";i:1524582814;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-07/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:204;s:11:\"trend_index\";i:226;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:232;a:14:{s:2:\"id\";i:7837;s:5:\"title\";s:9:\"footer 01\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.14.jpg\";s:12:\"tmpl_created\";i:1524582852;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:448;s:11:\"trend_index\";i:489;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:233;a:14:{s:2:\"id\";i:7852;s:5:\"title\";s:9:\"footer 02\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.13.jpg\";s:12:\"tmpl_created\";i:1524582875;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-02/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:216;s:11:\"trend_index\";i:188;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:234;a:14:{s:2:\"id\";i:7862;s:5:\"title\";s:9:\"footer 03\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.12.jpg\";s:12:\"tmpl_created\";i:1524582903;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-03/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:143;s:11:\"trend_index\";i:128;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:235;a:14:{s:2:\"id\";i:12212;s:5:\"title\";s:28:\"Law Firm &#8211; Single Post\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2019/11/single.png\";s:12:\"tmpl_created\";i:1572846914;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/law-firm-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:364;s:11:\"trend_index\";i:272;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:236;a:14:{s:2:\"id\";i:7871;s:5:\"title\";s:9:\"footer 04\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.11.jpg\";s:12:\"tmpl_created\";i:1524582927;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-04/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:107;s:11:\"trend_index\";i:125;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:237;a:14:{s:2:\"id\";i:12203;s:5:\"title\";s:30:\"Law Firm &#8211; Search Archiv\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/11/search_result.png\";s:12:\"tmpl_created\";i:1572846925;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/law-firm-search-archiv/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:533;s:11:\"trend_index\";i:540;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:238;a:14:{s:2:\"id\";i:7884;s:5:\"title\";s:9:\"footer 05\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.10.jpg\";s:12:\"tmpl_created\";i:1524582944;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-05/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:84;s:11:\"trend_index\";i:172;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:239;a:14:{s:2:\"id\";i:12194;s:5:\"title\";s:23:\"Law Firm &#8211; Header\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-law-firm.png\";s:12:\"tmpl_created\";i:1572846935;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/law-firm-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:27:\"[\"header\",\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:126;s:11:\"trend_index\";i:28;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:240;a:14:{s:2:\"id\";i:7892;s:5:\"title\";s:9:\"footer 06\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.9.jpg\";s:12:\"tmpl_created\";i:1524583015;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-06/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:127;s:11:\"trend_index\";i:224;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:241;a:14:{s:2:\"id\";i:12179;s:5:\"title\";s:23:\"Law Firm &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2019/11/footer.png\";s:12:\"tmpl_created\";i:1572846958;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/law-firm-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:27:\"[\"footer\",\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:418;s:11:\"trend_index\";i:294;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:242;a:14:{s:2:\"id\";i:4212;s:5:\"title\";s:11:\"Services 23\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_1.png\";s:12:\"tmpl_created\";i:1520443248;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-23/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:130;s:11:\"trend_index\";i:109;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:243;a:14:{s:2:\"id\";i:7825;s:5:\"title\";s:9:\"header 12\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.11.jpg\";s:12:\"tmpl_created\";i:1524583273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/header-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:75;s:11:\"trend_index\";i:52;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:244;a:14:{s:2:\"id\";i:12170;s:5:\"title\";s:23:\"Law Firm &#8211; Archiv\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2019/11/archiv.png\";s:12:\"tmpl_created\";i:1572846967;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/law-firm-archiv/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:423;s:11:\"trend_index\";i:377;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:245;a:14:{s:2:\"id\";i:4227;s:5:\"title\";s:11:\"Services 30\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_1.png\";s:12:\"tmpl_created\";i:1520443250;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-30/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:329;s:11:\"trend_index\";i:431;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:246;a:14:{s:2:\"id\";i:7812;s:5:\"title\";s:9:\"header 11\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.10.jpg\";s:12:\"tmpl_created\";i:1524583298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/header-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:111;s:11:\"trend_index\";i:97;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:247;a:14:{s:2:\"id\";i:12164;s:5:\"title\";s:20:\"Law Firm &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/11/404.png\";s:12:\"tmpl_created\";i:1572846979;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/law-firm-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:24:\"[\"404\",\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:679;s:11:\"trend_index\";i:642;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:248;a:14:{s:2:\"id\";i:4235;s:5:\"title\";s:11:\"Services 18\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_2.png\";s:12:\"tmpl_created\";i:1520443251;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:282;s:11:\"trend_index\";i:342;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:249;a:14:{s:2:\"id\";i:7724;s:5:\"title\";s:8:\"header 4\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.3.jpg\";s:12:\"tmpl_created\";i:1524583367;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:31;s:11:\"trend_index\";i:19;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:250;a:14:{s:2:\"id\";i:4244;s:5:\"title\";s:11:\"Services 26\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_2.png\";s:12:\"tmpl_created\";i:1520443253;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-26/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:483;s:11:\"trend_index\";i:548;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:251;a:14:{s:2:\"id\";i:7734;s:5:\"title\";s:8:\"header 5\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.4.jpg\";s:12:\"tmpl_created\";i:1524583436;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:40;s:11:\"trend_index\";i:34;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:252;a:14:{s:2:\"id\";i:4252;s:5:\"title\";s:10:\"Services 9\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_3.png\";s:12:\"tmpl_created\";i:1520443255;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/services-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:42;s:11:\"trend_index\";i:27;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:253;a:14:{s:2:\"id\";i:7771;s:5:\"title\";s:8:\"header 8\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.7.jpg\";s:12:\"tmpl_created\";i:1524583540;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:100;s:11:\"trend_index\";i:118;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:254;a:14:{s:2:\"id\";i:4260;s:5:\"title\";s:11:\"Services 25\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_3.png\";s:12:\"tmpl_created\";i:1520443257;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-25/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:176;s:11:\"trend_index\";i:162;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:255;a:14:{s:2:\"id\";i:7787;s:5:\"title\";s:8:\"header 9\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.8.jpg\";s:12:\"tmpl_created\";i:1524583598;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:108;s:11:\"trend_index\";i:98;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:256;a:14:{s:2:\"id\";i:4268;s:5:\"title\";s:10:\"Services 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_4.png\";s:12:\"tmpl_created\";i:1520443259;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/services-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:167;s:11:\"trend_index\";i:252;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:257;a:14:{s:2:\"id\";i:7801;s:5:\"title\";s:9:\"header 10\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.9.jpg\";s:12:\"tmpl_created\";i:1524583659;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/header-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:55;s:11:\"trend_index\";i:73;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:258;a:14:{s:2:\"id\";i:4276;s:5:\"title\";s:11:\"Services 24\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_4.png\";s:12:\"tmpl_created\";i:1520443261;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-24/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:342;s:11:\"trend_index\";i:347;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:259;a:14:{s:2:\"id\";i:7754;s:5:\"title\";s:8:\"header 7\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.6.jpg\";s:12:\"tmpl_created\";i:1524583712;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:96;s:11:\"trend_index\";i:254;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:260;a:14:{s:2:\"id\";i:4284;s:5:\"title\";s:10:\"Services 7\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_5.png\";s:12:\"tmpl_created\";i:1520443263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/services-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:30;s:11:\"trend_index\";i:8;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:261;a:14:{s:2:\"id\";i:7713;s:5:\"title\";s:8:\"header 3\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.2.jpg\";s:12:\"tmpl_created\";i:1524584780;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:47;s:11:\"trend_index\";i:37;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:262;a:14:{s:2:\"id\";i:4293;s:5:\"title\";s:10:\"Services 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_6.png\";s:12:\"tmpl_created\";i:1520443265;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/services-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:276;s:11:\"trend_index\";i:267;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:263;a:14:{s:2:\"id\";i:7744;s:5:\"title\";s:8:\"Header 6\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.5.jpg\";s:12:\"tmpl_created\";i:1524584784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:61;s:11:\"trend_index\";i:100;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:264;a:14:{s:2:\"id\";i:4302;s:5:\"title\";s:10:\"Services 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_7.png\";s:12:\"tmpl_created\";i:1520443266;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/services-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:58;s:11:\"trend_index\";i:46;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:265;a:14:{s:2:\"id\";i:12229;s:5:\"title\";s:33:\"Slide In | Law Firm | Information\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2019/11/popup.png\";s:12:\"tmpl_created\";i:1572847842;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/slide-in-law-firm-information/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:532;s:11:\"trend_index\";i:485;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:266;a:14:{s:2:\"id\";i:4313;s:5:\"title\";s:11:\"Services 13\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_8.png\";s:12:\"tmpl_created\";i:1520443268;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:118;s:11:\"trend_index\";i:91;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:267;a:14:{s:2:\"id\";i:8523;s:5:\"title\";s:11:\"404 page 06\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/006.jpg\";s:12:\"tmpl_created\";i:1526415291;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-06/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:309;s:11:\"trend_index\";i:376;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:268;a:14:{s:2:\"id\";i:12550;s:5:\"title\";s:32:\"Fly-in | Sale | Travel and Tours\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_s.png\";s:12:\"tmpl_created\";i:1575960263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/flyin-sale-travel-and-tours/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:704;s:11:\"trend_index\";i:678;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:269;a:14:{s:2:\"id\";i:4324;s:5:\"title\";s:11:\"Services 14\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_9.png\";s:12:\"tmpl_created\";i:1520443270;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:286;s:11:\"trend_index\";i:248;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:270;a:14:{s:2:\"id\";i:8524;s:5:\"title\";s:11:\"404 page 07\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/007.jpg\";s:12:\"tmpl_created\";i:1526415337;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-07/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:318;s:11:\"trend_index\";i:386;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:271;a:14:{s:2:\"id\";i:12540;s:5:\"title\";s:33:\"Classic | Menu | Travel and tours\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_Menu_s.png\";s:12:\"tmpl_created\";i:1575960267;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/classic-menu-travel-and-tours/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:638;s:11:\"trend_index\";i:621;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:272;a:14:{s:2:\"id\";i:4332;s:5:\"title\";s:11:\"Services 22\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_10.png\";s:12:\"tmpl_created\";i:1520443272;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-22/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:139;s:11:\"trend_index\";i:160;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:273;a:14:{s:2:\"id\";i:8525;s:5:\"title\";s:11:\"404 page 08\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/008.jpg\";s:12:\"tmpl_created\";i:1526415374;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-08/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:491;s:11:\"trend_index\";i:364;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:274;a:14:{s:2:\"id\";i:12492;s:5:\"title\";s:14:\"Travel -Footer\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/12/Footer_s.png\";s:12:\"tmpl_created\";i:1575960358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/travel-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:27:\"[\"footer\",\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:477;s:11:\"trend_index\";i:469;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:275;a:14:{s:2:\"id\";i:4341;s:5:\"title\";s:11:\"Services 21\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_11.png\";s:12:\"tmpl_created\";i:1520443274;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-21/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:141;s:11:\"trend_index\";i:171;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:276;a:14:{s:2:\"id\";i:8513;s:5:\"title\";s:11:\"404 page 04\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/004.jpg\";s:12:\"tmpl_created\";i:1526415417;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-04/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:445;s:11:\"trend_index\";i:501;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:277;a:14:{s:2:\"id\";i:12500;s:5:\"title\";s:21:\"Travel &#8211; Header\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-travel-and-tours.png\";s:12:\"tmpl_created\";i:1575960371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/travel-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:27:\"[\"header\",\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:436;s:11:\"trend_index\";i:394;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:278;a:14:{s:2:\"id\";i:4349;s:5:\"title\";s:11:\"Services 29\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_11.png\";s:12:\"tmpl_created\";i:1520443275;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-29/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:316;s:11:\"trend_index\";i:410;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:279;a:14:{s:2:\"id\";i:8512;s:5:\"title\";s:11:\"404 page 03\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/003.jpg\";s:12:\"tmpl_created\";i:1526415449;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-03/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:481;s:11:\"trend_index\";i:474;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:280;a:14:{s:2:\"id\";i:12509;s:5:\"title\";s:18:\"Travel &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/12/404.png\";s:12:\"tmpl_created\";i:1575960378;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/travel-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:24:\"[\"404\",\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:692;s:11:\"trend_index\";i:0;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:281;a:14:{s:2:\"id\";i:4357;s:5:\"title\";s:11:\"Services 20\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_12.png\";s:12:\"tmpl_created\";i:1520443277;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-20/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:45;s:11:\"trend_index\";i:53;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:282;a:14:{s:2:\"id\";i:8526;s:5:\"title\";s:11:\"404 page 09\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/009.jpg\";s:12:\"tmpl_created\";i:1526415474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-09/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:484;s:11:\"trend_index\";i:535;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:283;a:14:{s:2:\"id\";i:12516;s:5:\"title\";s:27:\"Travel &#8211; Archive Blog\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/12/Archiv_s.png\";s:12:\"tmpl_created\";i:1575960387;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/travel-archive-blog/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:478;s:11:\"trend_index\";i:312;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:284;a:14:{s:2:\"id\";i:4368;s:5:\"title\";s:11:\"Services 16\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_13.png\";s:12:\"tmpl_created\";i:1520443279;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:64;s:11:\"trend_index\";i:74;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:285;a:14:{s:2:\"id\";i:8505;s:5:\"title\";s:11:\"404 page 01\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/001.jpg\";s:12:\"tmpl_created\";i:1526415501;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:585;s:11:\"trend_index\";i:647;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:286;a:14:{s:2:\"id\";i:12524;s:5:\"title\";s:26:\"Travel &#8211; Single Post\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/12/Single_Post_s.png\";s:12:\"tmpl_created\";i:1575960397;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/travel-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:555;s:11:\"trend_index\";i:571;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:287;a:14:{s:2:\"id\";i:4376;s:5:\"title\";s:11:\"Services 28\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_12.png\";s:12:\"tmpl_created\";i:1520443281;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-28/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:148;s:11:\"trend_index\";i:122;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:288;a:14:{s:2:\"id\";i:8511;s:5:\"title\";s:11:\"404 page 02\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/002.jpg\";s:12:\"tmpl_created\";i:1526415528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-02/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:377;s:11:\"trend_index\";i:576;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:289;a:14:{s:2:\"id\";i:12531;s:5:\"title\";s:31:\"Travel &#8211; Single Post Tour\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/12/Single_Tour_s.png\";s:12:\"tmpl_created\";i:1575960404;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/travel-single-post-tour/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:597;s:11:\"trend_index\";i:640;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:290;a:14:{s:2:\"id\";i:4391;s:5:\"title\";s:11:\"Services 17\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_14.png\";s:12:\"tmpl_created\";i:1520443283;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:153;s:11:\"trend_index\";i:165;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:291;a:14:{s:2:\"id\";i:8514;s:5:\"title\";s:11:\"404 Page 05\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/005.jpg\";s:12:\"tmpl_created\";i:1526415558;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-05/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:439;s:11:\"trend_index\";i:455;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:292;a:14:{s:2:\"id\";i:4400;s:5:\"title\";s:11:\"Services 27\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_13.png\";s:12:\"tmpl_created\";i:1520443285;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-27/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:266;s:11:\"trend_index\";i:381;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:293;a:14:{s:2:\"id\";i:8676;s:5:\"title\";s:13:\"single page 1\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.6.jpg\";s:12:\"tmpl_created\";i:1527682423;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:335;s:11:\"trend_index\";i:300;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:294;a:14:{s:2:\"id\";i:4411;s:5:\"title\";s:9:\"Contact 3\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_white_1.png\";s:12:\"tmpl_created\";i:1520443287;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/contact-3-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:101;s:11:\"trend_index\";i:150;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:295;a:14:{s:2:\"id\";i:8678;s:5:\"title\";s:13:\"single page 2\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.2.jpg\";s:12:\"tmpl_created\";i:1527682780;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:179;s:11:\"trend_index\";i:72;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:296;a:14:{s:2:\"id\";i:4420;s:5:\"title\";s:9:\"Contact 1\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_black_1.png\";s:12:\"tmpl_created\";i:1520443289;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/contact-1-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:184;s:11:\"trend_index\";i:259;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:297;a:14:{s:2:\"id\";i:8679;s:5:\"title\";s:13:\"single page 3\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.3.jpg\";s:12:\"tmpl_created\";i:1527682847;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:189;s:11:\"trend_index\";i:54;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:298;a:14:{s:2:\"id\";i:4428;s:5:\"title\";s:9:\"Contact 4\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_white_2.png\";s:12:\"tmpl_created\";i:1520443291;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:110;s:11:\"trend_index\";i:117;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:299;a:14:{s:2:\"id\";i:8680;s:5:\"title\";s:13:\"single page 4\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.1.jpg\";s:12:\"tmpl_created\";i:1527682896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:421;s:11:\"trend_index\";i:318;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:300;a:14:{s:2:\"id\";i:4436;s:5:\"title\";s:11:\"Contact  16\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_black_2.png\";s:12:\"tmpl_created\";i:1520443293;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:165;s:11:\"trend_index\";i:177;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:301;a:14:{s:2:\"id\";i:8681;s:5:\"title\";s:13:\"single page 5\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.5.jpg\";s:12:\"tmpl_created\";i:1527682969;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:319;s:11:\"trend_index\";i:230;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:302;a:14:{s:2:\"id\";i:4444;s:5:\"title\";s:9:\"Contact 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_1.png\";s:12:\"tmpl_created\";i:1520443295;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:85;s:11:\"trend_index\";i:66;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:303;a:14:{s:2:\"id\";i:8682;s:5:\"title\";s:13:\"single page 6\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.4.jpg\";s:12:\"tmpl_created\";i:1527683026;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:454;s:11:\"trend_index\";i:299;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:304;a:14:{s:2:\"id\";i:4452;s:5:\"title\";s:9:\"Contact 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_black_1.png\";s:12:\"tmpl_created\";i:1520443296;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:138;s:11:\"trend_index\";i:107;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:305;a:14:{s:2:\"id\";i:8703;s:5:\"title\";s:13:\"single page 7\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.7.jpg\";s:12:\"tmpl_created\";i:1527683072;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:413;s:11:\"trend_index\";i:314;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:306;a:14:{s:2:\"id\";i:4460;s:5:\"title\";s:9:\"Contact 9\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_2.png\";s:12:\"tmpl_created\";i:1520443298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:104;s:11:\"trend_index\";i:82;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:307;a:14:{s:2:\"id\";i:8961;s:5:\"title\";s:9:\"archive 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.1.jpg\";s:12:\"tmpl_created\";i:1528639909;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:94;s:11:\"trend_index\";i:105;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:308;a:14:{s:2:\"id\";i:4468;s:5:\"title\";s:9:\"Contact 7\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_3.png\";s:12:\"tmpl_created\";i:1520443301;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"contact\",\"form\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:133;s:11:\"trend_index\";i:96;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:309;a:14:{s:2:\"id\";i:8969;s:5:\"title\";s:9:\"archive 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.2.jpg\";s:12:\"tmpl_created\";i:1528700014;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:252;s:11:\"trend_index\";i:496;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:310;a:14:{s:2:\"id\";i:12716;s:5:\"title\";s:30:\"Magazine &#8211; Single Post 3\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/01/Post4_s.png\";s:12:\"tmpl_created\";i:1579060659;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/magazine-single-post-3-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:536;s:11:\"trend_index\";i:396;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:311;a:14:{s:2:\"id\";i:4476;s:5:\"title\";s:10:\"Contact 15\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_4.png\";s:12:\"tmpl_created\";i:1520443303;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"contact\",\"form\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:234;s:11:\"trend_index\";i:244;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:312;a:14:{s:2:\"id\";i:8973;s:5:\"title\";s:9:\"archive 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.3.jpg\";s:12:\"tmpl_created\";i:1528700205;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:188;s:11:\"trend_index\";i:215;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:313;a:14:{s:2:\"id\";i:12707;s:5:\"title\";s:30:\"Magazine &#8211; Single Post 3\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/01/Post1_s.png\";s:12:\"tmpl_created\";i:1579060669;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/magazine-single-post-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:512;s:11:\"trend_index\";i:330;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:314;a:14:{s:2:\"id\";i:4484;s:5:\"title\";s:9:\"Contact 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_black_3.png\";s:12:\"tmpl_created\";i:1520443305;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"contact\",\"form\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:324;s:11:\"trend_index\";i:397;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:315;a:14:{s:2:\"id\";i:8977;s:5:\"title\";s:9:\"archive 4\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.4.jpg\";s:12:\"tmpl_created\";i:1528700326;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:349;s:11:\"trend_index\";i:490;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:316;a:14:{s:2:\"id\";i:12699;s:5:\"title\";s:30:\"Magazine &#8211; Single Post 2\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/01/Post3_s.png\";s:12:\"tmpl_created\";i:1579060680;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/magazine-single-post-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:408;s:11:\"trend_index\";i:269;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:317;a:14:{s:2:\"id\";i:4492;s:5:\"title\";s:9:\"Contact 5\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_white_3.png\";s:12:\"tmpl_created\";i:1520443307;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/contact-5-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:38;s:11:\"trend_index\";i:23;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:318;a:14:{s:2:\"id\";i:8981;s:5:\"title\";s:9:\"archive 5\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.5.jpg\";s:12:\"tmpl_created\";i:1528700484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:321;s:11:\"trend_index\";i:393;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:319;a:14:{s:2:\"id\";i:12688;s:5:\"title\";s:30:\"Magazine &#8211; Single Post 1\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/01/Post2_s.png\";s:12:\"tmpl_created\";i:1579060692;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/magazine-single-post-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:400;s:11:\"trend_index\";i:243;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:320;a:14:{s:2:\"id\";i:4500;s:5:\"title\";s:9:\"Pricing 7\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_1.png\";s:12:\"tmpl_created\";i:1520443308;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:469;s:11:\"trend_index\";i:481;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:321;a:14:{s:2:\"id\";i:8985;s:5:\"title\";s:9:\"archive 6\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.6.jpg\";s:12:\"tmpl_created\";i:1528700612;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:211;s:11:\"trend_index\";i:250;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:322;a:14:{s:2:\"id\";i:12678;s:5:\"title\";s:23:\"Magazine &#8211; Header\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-magazine.png\";s:12:\"tmpl_created\";i:1579060701;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/magazine-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:28:\"[\"Blog\",\"header\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:313;s:11:\"trend_index\";i:240;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:323;a:14:{s:2:\"id\";i:4509;s:5:\"title\";s:9:\"Pricing 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_1.png\";s:12:\"tmpl_created\";i:1520443310;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:652;s:11:\"trend_index\";i:687;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:324;a:14:{s:2:\"id\";i:8989;s:5:\"title\";s:9:\"archive 7\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.7.jpg\";s:12:\"tmpl_created\";i:1528701063;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:205;s:11:\"trend_index\";i:290;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:325;a:14:{s:2:\"id\";i:12669;s:5:\"title\";s:23:\"Magazine &#8211; Footer\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/01/Footer_s.png\";s:12:\"tmpl_created\";i:1579060715;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/magazine-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:28:\"[\"Blog\",\"footer\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:463;s:11:\"trend_index\";i:336;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:326;a:14:{s:2:\"id\";i:4521;s:5:\"title\";s:9:\"Pricing 8\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_2.png\";s:12:\"tmpl_created\";i:1520443312;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:310;s:11:\"trend_index\";i:344;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:327;a:14:{s:2:\"id\";i:8996;s:5:\"title\";s:9:\"archive 8\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.8.jpg\";s:12:\"tmpl_created\";i:1528701290;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:215;s:11:\"trend_index\";i:452;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:328;a:14:{s:2:\"id\";i:12661;s:5:\"title\";s:23:\"Magazine &#8211; Search\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/01/Search_s.png\";s:12:\"tmpl_created\";i:1579060722;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/magazine-search/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:443;s:11:\"trend_index\";i:214;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:329;a:14:{s:2:\"id\";i:4529;s:5:\"title\";s:9:\"Pricing 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_2.png\";s:12:\"tmpl_created\";i:1520443314;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:568;s:11:\"trend_index\";i:553;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:330;a:14:{s:2:\"id\";i:9001;s:5:\"title\";s:9:\"archive 9\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.9.jpg\";s:12:\"tmpl_created\";i:1528701433;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:267;s:11:\"trend_index\";i:429;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:331;a:14:{s:2:\"id\";i:12652;s:5:\"title\";s:17:\"Magazine- Archiv2\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/01/Archiv2_s.png\";s:12:\"tmpl_created\";i:1579060730;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/magazine-archiv2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:525;s:11:\"trend_index\";i:516;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:332;a:14:{s:2:\"id\";i:4537;s:5:\"title\";s:9:\"Pricing 9\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_3.png\";s:12:\"tmpl_created\";i:1520443315;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:538;s:11:\"trend_index\";i:562;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:333;a:14:{s:2:\"id\";i:9119;s:5:\"title\";s:10:\"footer 015\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/Footer_GetStarted_350.png\";s:12:\"tmpl_created\";i:1532428138;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/blocks/demo/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:253;s:11:\"trend_index\";i:266;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:334;a:14:{s:2:\"id\";i:12643;s:5:\"title\";s:24:\"Magazine &#8211; Archiv1\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/01/Archiv1_s.png\";s:12:\"tmpl_created\";i:1579060737;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/magazine-archiv1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:386;s:11:\"trend_index\";i:287;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:335;a:14:{s:2:\"id\";i:4545;s:5:\"title\";s:9:\"Pricing 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_3.png\";s:12:\"tmpl_created\";i:1520443317;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:648;s:11:\"trend_index\";i:658;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:336;a:14:{s:2:\"id\";i:9127;s:5:\"title\";s:9:\"header 13\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2018/07/Header_get_started_1200V3.png\";s:12:\"tmpl_created\";i:1532428699;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/header-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:60;s:11:\"trend_index\";i:106;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:337;a:14:{s:2:\"id\";i:12635;s:5:\"title\";s:20:\"Magazine &#8211; 404\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/01/404_s.png\";s:12:\"tmpl_created\";i:1579060746;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/magazine-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:25:\"[\"404\",\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:611;s:11:\"trend_index\";i:528;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:338;a:14:{s:2:\"id\";i:4553;s:5:\"title\";s:10:\"Pricing 10\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_4.png\";s:12:\"tmpl_created\";i:1520443319;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/pricing-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:482;s:11:\"trend_index\";i:453;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:339;a:14:{s:2:\"id\";i:12736;s:5:\"title\";s:41:\"Slide In | Contact Us | Magazine and Blog\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_contact_s.png\";s:12:\"tmpl_created\";i:1579060978;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/slide-in-contact-us/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:691;s:11:\"trend_index\";i:670;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:340;a:14:{s:2:\"id\";i:4562;s:5:\"title\";s:9:\"Pricing 4\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_4.png\";s:12:\"tmpl_created\";i:1520443322;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:636;s:11:\"trend_index\";i:709;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:341;a:14:{s:2:\"id\";i:12726;s:5:\"title\";s:52:\"Classic | Newsletter | Subscribe | Magazine and Blog\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_Newsletter_s.png\";s:12:\"tmpl_created\";i:1579061019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-newsletter-subscribe-magazine-and-blog/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:417;s:11:\"trend_index\";i:274;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:342;a:14:{s:2:\"id\";i:4572;s:5:\"title\";s:10:\"Pricing 11\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_5.png\";s:12:\"tmpl_created\";i:1520443324;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/pricing-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:308;s:11:\"trend_index\";i:310;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:343;a:14:{s:2:\"id\";i:9174;s:5:\"title\";s:17:\"single product 01\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/07/single_product01_350.png\";s:12:\"tmpl_created\";i:1532950125;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/single-product-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"single product\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:44;s:11:\"trend_index\";i:16;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:344;a:14:{s:2:\"id\";i:13089;s:5:\"title\";s:23:\"Photography &#8211; 404\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/02/404_s.png\";s:12:\"tmpl_created\";i:1582091623;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/photography-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:33:\"[\"404\",\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:681;s:11:\"trend_index\";i:580;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:345;a:14:{s:2:\"id\";i:4580;s:5:\"title\";s:10:\"Pricing 12\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_6.png\";s:12:\"tmpl_created\";i:1520443326;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/pricing-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:537;s:11:\"trend_index\";i:588;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:346;a:14:{s:2:\"id\";i:9178;s:5:\"title\";s:17:\"single product 02\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2018/07/single_product02_350new.png\";s:12:\"tmpl_created\";i:1532951997;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/single-product-02/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"single product\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:87;s:11:\"trend_index\";i:55;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:347;a:14:{s:2:\"id\";i:13096;s:5:\"title\";s:32:\"Photography &#8211; Archiv Media\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/02/Archiv_s.png\";s:12:\"tmpl_created\";i:1582091742;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/photography-archiv-media/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:609;s:11:\"trend_index\";i:447;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:348;a:14:{s:2:\"id\";i:4589;s:5:\"title\";s:9:\"Pricing 5\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_6.png\";s:12:\"tmpl_created\";i:1520443327;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:659;s:11:\"trend_index\";i:713;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:349;a:14:{s:2:\"id\";i:9180;s:5:\"title\";s:17:\"single product 03\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/07/single_product03_350.png\";s:12:\"tmpl_created\";i:1532952302;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/single-product-03/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"single product\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:129;s:11:\"trend_index\";i:61;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:350;a:14:{s:2:\"id\";i:13103;s:5:\"title\";s:26:\"Photography &#8211; Footer\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/02/Footer_s.png\";s:12:\"tmpl_created\";i:1582091903;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/photography-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:36:\"[\"footer\",\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:465;s:11:\"trend_index\";i:341;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:351;a:14:{s:2:\"id\";i:4597;s:5:\"title\";s:10:\"Pricing 13\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_7.png\";s:12:\"tmpl_created\";i:1520443330;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/pricing-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:561;s:11:\"trend_index\";i:715;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:352;a:14:{s:2:\"id\";i:9182;s:5:\"title\";s:17:\"single product 04\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/single_product040_350.png\";s:12:\"tmpl_created\";i:1532952606;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/single-product-04/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"single product\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:144;s:11:\"trend_index\";i:93;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:353;a:14:{s:2:\"id\";i:13120;s:5:\"title\";s:31:\"Photography &#8211; Single Post\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/02/Post_s.png\";s:12:\"tmpl_created\";i:1582092351;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/photography-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:650;s:11:\"trend_index\";i:590;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:354;a:14:{s:2:\"id\";i:4605;s:5:\"title\";s:9:\"Pricing 6\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_7.png\";s:12:\"tmpl_created\";i:1520443332;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:678;s:11:\"trend_index\";i:650;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:355;a:14:{s:2:\"id\";i:9239;s:5:\"title\";s:17:\"product archive 1\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/product-archive-350-1.png\";s:12:\"tmpl_created\";i:1532953482;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/product-archive-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:15:\"product archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:80;s:11:\"trend_index\";i:30;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:356;a:14:{s:2:\"id\";i:13112;s:5:\"title\";s:26:\"Photography &#8211; Header\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-photography-portfolio.png\";s:12:\"tmpl_created\";i:1582092483;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/photography-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:36:\"[\"header\",\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:347;s:11:\"trend_index\";i:199;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:357;a:14:{s:2:\"id\";i:4613;s:5:\"title\";s:10:\"Pricing 14\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_8.png\";s:12:\"tmpl_created\";i:1520443334;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/pricing-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:535;s:11:\"trend_index\";i:599;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:358;a:14:{s:2:\"id\";i:9247;s:5:\"title\";s:17:\"product archive 2\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/product-archive-350-2.png\";s:12:\"tmpl_created\";i:1532953793;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/product-archive-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:15:\"product archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:93;s:11:\"trend_index\";i:43;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:359;a:14:{s:2:\"id\";i:13129;s:5:\"title\";s:28:\"Classic | Menu | Photography\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/PopUp_s.png\";s:12:\"tmpl_created\";i:1582092645;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/popups/classic-menu-photography/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:616;s:11:\"trend_index\";i:699;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:360;a:14:{s:2:\"id\";i:9254;s:5:\"title\";s:17:\"product archive 3\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/product-archive-350-3.png\";s:12:\"tmpl_created\";i:1532954032;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/product-archive-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:15:\"product archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:103;s:11:\"trend_index\";i:39;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:361;a:14:{s:2:\"id\";i:9301;s:5:\"title\";s:13:\"Single Post 4\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3003.jpg\";s:12:\"tmpl_created\";i:1537440661;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:227;s:11:\"trend_index\";i:380;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:362;a:14:{s:2:\"id\";i:9296;s:5:\"title\";s:13:\"Single Post 3\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3002.jpg\";s:12:\"tmpl_created\";i:1537440673;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:202;s:11:\"trend_index\";i:295;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:363;a:14:{s:2:\"id\";i:9313;s:5:\"title\";s:13:\"Single Post 5\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3001.jpg\";s:12:\"tmpl_created\";i:1537440798;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:181;s:11:\"trend_index\";i:301;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:364;a:14:{s:2:\"id\";i:9343;s:5:\"title\";s:13:\"Single Post 6\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3004.jpg\";s:12:\"tmpl_created\";i:1537443531;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:208;s:11:\"trend_index\";i:385;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:365;a:14:{s:2:\"id\";i:9349;s:5:\"title\";s:13:\"Single Post 7\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3005.jpg\";s:12:\"tmpl_created\";i:1537443903;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:147;s:11:\"trend_index\";i:166;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:366;a:14:{s:2:\"id\";i:4690;s:5:\"title\";s:6:\"Team 7\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_1.png\";s:12:\"tmpl_created\";i:1520443348;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/team-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:233;s:11:\"trend_index\";i:204;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:367;a:14:{s:2:\"id\";i:4698;s:5:\"title\";s:7:\"Team 15\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_1.png\";s:12:\"tmpl_created\";i:1520443350;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:402;s:11:\"trend_index\";i:446;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:368;a:14:{s:2:\"id\";i:4706;s:5:\"title\";s:6:\"Team 5\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_2.png\";s:12:\"tmpl_created\";i:1520443352;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/team-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:142;s:11:\"trend_index\";i:119;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:369;a:14:{s:2:\"id\";i:4718;s:5:\"title\";s:6:\"Team 4\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_3.png\";s:12:\"tmpl_created\";i:1520443354;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/team-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:178;s:11:\"trend_index\";i:221;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:370;a:14:{s:2:\"id\";i:4727;s:5:\"title\";s:7:\"Team 13\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_2.png\";s:12:\"tmpl_created\";i:1520443356;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:360;s:11:\"trend_index\";i:369;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:371;a:14:{s:2:\"id\";i:4736;s:5:\"title\";s:7:\"Team 20\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_4.png\";s:12:\"tmpl_created\";i:1520443358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-20/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:140;s:11:\"trend_index\";i:114;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:372;a:14:{s:2:\"id\";i:4746;s:5:\"title\";s:7:\"Team 23\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_4.png\";s:12:\"tmpl_created\";i:1520443360;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-23/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:263;s:11:\"trend_index\";i:223;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:373;a:14:{s:2:\"id\";i:4759;s:5:\"title\";s:7:\"Team 22\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_5.png\";s:12:\"tmpl_created\";i:1520443362;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-22/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:290;s:11:\"trend_index\";i:422;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:374;a:14:{s:2:\"id\";i:4770;s:5:\"title\";s:7:\"Team 12\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_6.png\";s:12:\"tmpl_created\";i:1520443364;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/team-12-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:393;s:11:\"trend_index\";i:403;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:375;a:14:{s:2:\"id\";i:4781;s:5:\"title\";s:7:\"Team 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_7.png\";s:12:\"tmpl_created\";i:1520443365;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:258;s:11:\"trend_index\";i:479;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:376;a:14:{s:2:\"id\";i:9611;s:5:\"title\";s:16:\"Hello Bar | Sale\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2019/01/Top-Bar_Sale_small_01.png\";s:12:\"tmpl_created\";i:1546965350;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/popups/hello-bar-sale-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:571;s:11:\"trend_index\";i:463;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:377;a:14:{s:2:\"id\";i:13274;s:5:\"title\";s:38:\"Interior Design &#8211; Single Project\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/04/Single-Project-.png\";s:12:\"tmpl_created\";i:1586148723;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/blocks/interior-design-single-project/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:30:\"[\"business\",\"interior design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:619;s:11:\"trend_index\";i:497;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:378;a:14:{s:2:\"id\";i:4793;s:5:\"title\";s:7:\"Team 18\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_8.png\";s:12:\"tmpl_created\";i:1520443367;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:194;s:11:\"trend_index\";i:210;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:379;a:14:{s:2:\"id\";i:9622;s:5:\"title\";s:19:\"Classic | Promotion\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2019/01/classic_promotion_small_02.png\";s:12:\"tmpl_created\";i:1546965896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/classic-promotion-02/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:575;s:11:\"trend_index\";i:533;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:380;a:14:{s:2:\"id\";i:13267;s:5:\"title\";s:35:\"Interior Design &#8211; Single News\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/04/Post.png\";s:12:\"tmpl_created\";i:1586148728;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/blocks/interior-design-single-news/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:30:\"[\"business\",\"interior design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:544;s:11:\"trend_index\";i:491;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:381;a:14:{s:2:\"id\";i:4801;s:5:\"title\";s:7:\"Team 11\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_8.png\";s:12:\"tmpl_created\";i:1520443369;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:333;s:11:\"trend_index\";i:328;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:382;a:14:{s:2:\"id\";i:9631;s:5:\"title\";s:38:\"Slide-in | Sale | Register | Subscribe\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2019/01/Slide-in_Sale_small_01.png\";s:12:\"tmpl_created\";i:1546968270;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/slide-in-sale-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:601;s:11:\"trend_index\";i:618;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:383;a:14:{s:2:\"id\";i:13259;s:5:\"title\";s:36:\"Interior Design &#8211; News Archive\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/04/Archiv-Blog.png\";s:12:\"tmpl_created\";i:1586148733;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/interior-design-news-archive/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:30:\"[\"business\",\"interior design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:509;s:11:\"trend_index\";i:351;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:384;a:14:{s:2:\"id\";i:4809;s:5:\"title\";s:7:\"Team 19\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_9.png\";s:12:\"tmpl_created\";i:1520443371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-19/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:283;s:11:\"trend_index\";i:458;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:385;a:14:{s:2:\"id\";i:13251;s:5:\"title\";s:27:\"Interior Design &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/04/404.png\";s:12:\"tmpl_created\";i:1586148737;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/interior-design-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:30:\"[\"business\",\"interior design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:698;s:11:\"trend_index\";i:686;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:386;a:14:{s:2:\"id\";i:4818;s:5:\"title\";s:7:\"Team 21\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_9.png\";s:12:\"tmpl_created\";i:1520443373;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-21/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:466;s:11:\"trend_index\";i:520;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:387;a:14:{s:2:\"id\";i:13244;s:5:\"title\";s:30:\"Interior Design &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/04/Footer.png\";s:12:\"tmpl_created\";i:1586148742;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/interior-design-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:39:\"[\"business\",\"footer\",\"interior design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:405;s:11:\"trend_index\";i:219;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:388;a:14:{s:2:\"id\";i:5045;s:5:\"title\";s:11:\"Portfolio 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_2.png\";s:12:\"tmpl_created\";i:1520443423;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:578;s:11:\"trend_index\";i:684;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:389;a:14:{s:2:\"id\";i:9662;s:5:\"title\";s:33:\"Bottom Bar | Register | Subscribe\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2019/01/Bottom-Bar_Register_small_01.png\";s:12:\"tmpl_created\";i:1547009087;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/popups/bottom-bar-register-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:625;s:11:\"trend_index\";i:0;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:390;a:14:{s:2:\"id\";i:13236;s:5:\"title\";s:30:\"Interior Design &#8211; Header\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-interior-design.png\";s:12:\"tmpl_created\";i:1586148746;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/interior-design-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:39:\"[\"business\",\"header\",\"interior design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:222;s:11:\"trend_index\";i:78;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:391;a:14:{s:2:\"id\";i:5157;s:5:\"title\";s:11:\"Subscribe 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_white_1.png\";s:12:\"tmpl_created\";i:1520443448;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/subscribe-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"form\",\"subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:341;s:11:\"trend_index\";i:323;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:392;a:14:{s:2:\"id\";i:13281;s:5:\"title\";s:37:\"Hello Bar | Contact | Interior Design\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp.png\";s:12:\"tmpl_created\";i:1586148801;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/hello-bar-contact-interior-design/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:19:\"[\"interior design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:718;s:11:\"trend_index\";i:685;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:393;a:14:{s:2:\"id\";i:5165;s:5:\"title\";s:11:\"Subscribe 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_black_1.png\";s:12:\"tmpl_created\";i:1520443450;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/subscribe-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"form\",\"subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:498;s:11:\"trend_index\";i:505;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:394;a:14:{s:2:\"id\";i:5173;s:5:\"title\";s:11:\"Subscribe 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_white_2.png\";s:12:\"tmpl_created\";i:1520443452;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/subscribe-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"form\",\"subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:271;s:11:\"trend_index\";i:228;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:395;a:14:{s:2:\"id\";i:9690;s:5:\"title\";s:17:\"Classic | Contact\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2019/01/Classic_Contact_small_01.png\";s:12:\"tmpl_created\";i:1547011716;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/classic-contact-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:380;s:11:\"trend_index\";i:426;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:396;a:14:{s:2:\"id\";i:5181;s:5:\"title\";s:11:\"Subscribe 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_black_2.png\";s:12:\"tmpl_created\";i:1520443454;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/subscribe-2-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"form\",\"subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:426;s:11:\"trend_index\";i:440;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:397;a:14:{s:2:\"id\";i:9699;s:5:\"title\";s:33:\"Classic | Contact | Gym | Fitness\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2019/01/Classic_Contact_small_02.png\";s:12:\"tmpl_created\";i:1547015827;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/classic-contact-02/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:449;s:11:\"trend_index\";i:536;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:398;a:14:{s:2:\"id\";i:5189;s:5:\"title\";s:6:\"CTA 29\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_1.png\";s:12:\"tmpl_created\";i:1520443456;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-29/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:435;s:11:\"trend_index\";i:475;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:399;a:14:{s:2:\"id\";i:5198;s:5:\"title\";s:6:\"CTA 30\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_1.png\";s:12:\"tmpl_created\";i:1520443458;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-30/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:517;s:11:\"trend_index\";i:563;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:400;a:14:{s:2:\"id\";i:9571;s:5:\"title\";s:14:\"Fly In | Login\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2019/01/FlyIn_Login_01_small.png\";s:12:\"tmpl_created\";i:1547726151;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/fly-in-login-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:583;s:11:\"trend_index\";i:577;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:401;a:14:{s:2:\"id\";i:13395;s:5:\"title\";s:34:\"Online Course &#8211; Start Lesson\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/04/Lesson-Start.jpg\";s:12:\"tmpl_created\";i:1587474673;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/online-course-start-lesson/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:662;s:11:\"trend_index\";i:515;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:402;a:14:{s:2:\"id\";i:5206;s:5:\"title\";s:6:\"CTA 31\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_2.png\";s:12:\"tmpl_created\";i:1520443459;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-31/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:548;s:11:\"trend_index\";i:550;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:403;a:14:{s:2:\"id\";i:13387;s:5:\"title\";s:32:\"Online Course &#8211; End Lesson\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/04/Lesson-End-.jpg\";s:12:\"tmpl_created\";i:1587474682;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/online-course-end-lesson/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:663;s:11:\"trend_index\";i:487;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:404;a:14:{s:2:\"id\";i:5214;s:5:\"title\";s:10:\"Contact 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_2.png\";s:12:\"tmpl_created\";i:1520443462;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/contact-16-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"contact\",\"form\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:196;s:11:\"trend_index\";i:152;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:405;a:14:{s:2:\"id\";i:13378;s:5:\"title\";s:28:\"Online Course &#8211; Header\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-education-online-courses.jpg\";s:12:\"tmpl_created\";i:1587474693;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/online-course-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:38:\"[\"Course Online\",\"Education\",\"header\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:519;s:11:\"trend_index\";i:359;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:406;a:14:{s:2:\"id\";i:5222;s:5:\"title\";s:11:\"Subscribe 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_black_3.png\";s:12:\"tmpl_created\";i:1520443464;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/subscribe-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"form\",\"subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:387;s:11:\"trend_index\";i:461;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:407;a:14:{s:2:\"id\";i:9740;s:5:\"title\";s:25:\"Classic | Promotion | App\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/app_small.png\";s:12:\"tmpl_created\";i:1547822836;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/classic-promotion-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:576;s:11:\"trend_index\";i:566;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:408;a:14:{s:2:\"id\";i:13369;s:5:\"title\";s:28:\"Online Course &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/04/Footer.jpg\";s:12:\"tmpl_created\";i:1587474701;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/online-course-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:38:\"[\"Course Online\",\"Education\",\"footer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:480;s:11:\"trend_index\";i:371;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:409;a:14:{s:2:\"id\";i:5230;s:5:\"title\";s:10:\"Contact 17\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_3.png\";s:12:\"tmpl_created\";i:1520443466;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"contact\",\"form\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:325;s:11:\"trend_index\";i:356;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:410;a:14:{s:2:\"id\";i:13361;s:5:\"title\";s:25:\"Online Course &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/04/404.jpg\";s:12:\"tmpl_created\";i:1587474710;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/online-course-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:35:\"[\"404\",\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:677;s:11:\"trend_index\";i:435;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:411;a:14:{s:2:\"id\";i:5238;s:5:\"title\";s:7:\"Hero 12\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_4.png\";s:12:\"tmpl_created\";i:1520443468;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/hero-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:564;s:11:\"trend_index\";i:570;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:412;a:14:{s:2:\"id\";i:9762;s:5:\"title\";s:36:\"Classic | Register | Subscribe | Spa\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2019/01/spa_small_classic.png\";s:12:\"tmpl_created\";i:1547824145;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/classic-register-subscribe-spa/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:451;s:11:\"trend_index\";i:349;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:413;a:14:{s:2:\"id\";i:13413;s:5:\"title\";s:33:\"Classic | Contact | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Help.jpg\";s:12:\"tmpl_created\";i:1587474761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/classic-contact-online-course/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:590;s:11:\"trend_index\";i:407;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:414;a:14:{s:2:\"id\";i:5249;s:5:\"title\";s:6:\"CTA 32\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_4.png\";s:12:\"tmpl_created\";i:1520443470;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-32/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:492;s:11:\"trend_index\";i:499;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:415;a:14:{s:2:\"id\";i:9772;s:5:\"title\";s:27:\"Hello bar | Promotion | App\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/app_hello_small.png\";s:12:\"tmpl_created\";i:1547824279;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/hello-bar-promotion-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:696;s:11:\"trend_index\";i:708;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:416;a:14:{s:2:\"id\";i:13402;s:5:\"title\";s:29:\"Classic | CTA | Online Course\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2020/04/Popup-Course-Completed.jpg\";s:12:\"tmpl_created\";i:1587474772;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/classic-cta-online-course/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:624;s:11:\"trend_index\";i:523;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:417;a:14:{s:2:\"id\";i:5257;s:5:\"title\";s:10:\"Contact 18\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_5.png\";s:12:\"tmpl_created\";i:1520443472;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:407;s:11:\"trend_index\";i:495;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:418;a:14:{s:2:\"id\";i:13422;s:5:\"title\";s:30:\"Classic | Menu | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Menu.jpg\";s:12:\"tmpl_created\";i:1587474782;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/classic-menu-online-course/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:572;s:11:\"trend_index\";i:519;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"1\";}i:419;a:14:{s:2:\"id\";i:5266;s:5:\"title\";s:9:\"Clients 4\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_1.png\";s:12:\"tmpl_created\";i:1520443474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/clients-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:98;s:11:\"trend_index\";i:92;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:420;a:14:{s:2:\"id\";i:9793;s:5:\"title\";s:13:\"Fly In | Sale\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2019/01/flyin_black_small.png\";s:12:\"tmpl_created\";i:1547831151;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/popups/fly-in-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:618;s:11:\"trend_index\";i:541;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:421;a:14:{s:2:\"id\";i:13621;s:5:\"title\";s:30:\"Barbershop &#8211; Single Post\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/05/Single-Page.jpg\";s:12:\"tmpl_created\";i:1589893137;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/barbershop-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:723;s:11:\"trend_index\";i:623;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:422;a:14:{s:2:\"id\";i:5275;s:5:\"title\";s:9:\"Clients 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_1.png\";s:12:\"tmpl_created\";i:1520443476;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/clients-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:322;s:11:\"trend_index\";i:258;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:423;a:14:{s:2:\"id\";i:13612;s:5:\"title\";s:25:\"Barbershop &#8211; Header\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2020/06/barber-shop-header.jpg\";s:12:\"tmpl_created\";i:1589893142;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/barbershop-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:37:\"[\"Barber Shop\",\"Barbershop\",\"header\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:476;s:11:\"trend_index\";i:225;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:424;a:14:{s:2:\"id\";i:5283;s:5:\"title\";s:9:\"Clients 1\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_2.png\";s:12:\"tmpl_created\";i:1520443478;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/clients-1-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:297;s:11:\"trend_index\";i:460;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:425;a:14:{s:2:\"id\";i:13604;s:5:\"title\";s:25:\"Barbershop &#8211; Footer\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/05/Footer-Small.jpg\";s:12:\"tmpl_created\";i:1589893147;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/barbershop-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:37:\"[\"Barber Shop\",\"Barbershop\",\"footer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:622;s:11:\"trend_index\";i:405;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:426;a:14:{s:2:\"id\";i:5290;s:5:\"title\";s:9:\"Clients 3\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_2.png\";s:12:\"tmpl_created\";i:1520443480;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/clients-3-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:518;s:11:\"trend_index\";i:565;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:427;a:14:{s:2:\"id\";i:13528;s:5:\"title\";s:22:\"Barbershop &#8211; 404\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/05/404-Page.jpg\";s:12:\"tmpl_created\";i:1589893152;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/barbershop-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:34:\"[\"404\",\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:727;s:11:\"trend_index\";i:675;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:428;a:14:{s:2:\"id\";i:5298;s:5:\"title\";s:10:\"Clients 15\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_3.png\";s:12:\"tmpl_created\";i:1520443482;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:437;s:11:\"trend_index\";i:506;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:429;a:14:{s:2:\"id\";i:9836;s:5:\"title\";s:21:\"Classic | Login | Pop\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/01/login_b_small.png\";s:12:\"tmpl_created\";i:1547835635;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/popups/classic-login/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:584;s:11:\"trend_index\";i:552;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:430;a:14:{s:2:\"id\";i:13518;s:5:\"title\";s:26:\"Barbershop &#8211; Archive\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/05/Blog-Page.jpg\";s:12:\"tmpl_created\";i:1589893157;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/barbershop-archive/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:717;s:11:\"trend_index\";i:649;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:431;a:14:{s:2:\"id\";i:5306;s:5:\"title\";s:10:\"Clients 10\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_3.png\";s:12:\"tmpl_created\";i:1520443484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:605;s:11:\"trend_index\";i:677;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:432;a:14:{s:2:\"id\";i:9847;s:5:\"title\";s:25:\"Fly In | Promotion | Lego\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2019/01/fly_in_promotion_tro.png\";s:12:\"tmpl_created\";i:1547836956;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/fly-in-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:686;s:11:\"trend_index\";i:692;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:433;a:14:{s:2:\"id\";i:5315;s:5:\"title\";s:10:\"Clients 12\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_4-1.png\";s:12:\"tmpl_created\";i:1520443486;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:485;s:11:\"trend_index\";i:568;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:434;a:14:{s:2:\"id\";i:9858;s:5:\"title\";s:27:\"Slide In | Promotion | Wine\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2019/01/slide-in_promotion_wine_small.png\";s:12:\"tmpl_created\";i:1547837100;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/slide-in-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:712;s:11:\"trend_index\";i:0;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:435;a:14:{s:2:\"id\";i:5324;s:5:\"title\";s:9:\"Clients 8\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_5-1.png\";s:12:\"tmpl_created\";i:1520443488;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/clients-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:511;s:11:\"trend_index\";i:603;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:436;a:14:{s:2:\"id\";i:5333;s:5:\"title\";s:10:\"Clients 13\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_6.png\";s:12:\"tmpl_created\";i:1520443489;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:238;s:11:\"trend_index\";i:324;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:437;a:14:{s:2:\"id\";i:5341;s:5:\"title\";s:10:\"Clients 11\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_4.png\";s:12:\"tmpl_created\";i:1520443491;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:566;s:11:\"trend_index\";i:646;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:438;a:14:{s:2:\"id\";i:5349;s:5:\"title\";s:9:\"Clients 7\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_7.png\";s:12:\"tmpl_created\";i:1520443493;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/clients-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:243;s:11:\"trend_index\";i:261;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:439;a:14:{s:2:\"id\";i:13538;s:5:\"title\";s:32:\"Fly-In | Newsletter | Barbershop\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/05/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1589893364;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/fly-in-newsletter-barbershop/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:701;s:11:\"trend_index\";i:551;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:440;a:14:{s:2:\"id\";i:5357;s:5:\"title\";s:9:\"Clients 2\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_7.png\";s:12:\"tmpl_created\";i:1520443495;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/clients-2-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:330;s:11:\"trend_index\";i:320;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:441;a:14:{s:2:\"id\";i:5368;s:5:\"title\";s:9:\"Clients 9\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_8.png\";s:12:\"tmpl_created\";i:1520443497;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/clients-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:247;s:11:\"trend_index\";i:273;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:442;a:14:{s:2:\"id\";i:5381;s:5:\"title\";s:10:\"Clients 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_9.png\";s:12:\"tmpl_created\";i:1520443499;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:186;s:11:\"trend_index\";i:264;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:443;a:14:{s:2:\"id\";i:5389;s:5:\"title\";s:10:\"Clients 14\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_9.png\";s:12:\"tmpl_created\";i:1520443501;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:385;s:11:\"trend_index\";i:420;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:444;a:14:{s:2:\"id\";i:9944;s:5:\"title\";s:33:\"Slide In | Promotion | Headphones\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2019/01/slidein_head_small.png\";s:12:\"tmpl_created\";i:1547841939;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/slide-in-promotion-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:689;s:11:\"trend_index\";i:652;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:445;a:14:{s:2:\"id\";i:5397;s:5:\"title\";s:8:\"About 11\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_1.png\";s:12:\"tmpl_created\";i:1520443503;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:154;s:11:\"trend_index\";i:151;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:446;a:14:{s:2:\"id\";i:9955;s:5:\"title\";s:14:\"Fly In | Login\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2019/01/flyin_login_lock_small.png\";s:12:\"tmpl_created\";i:1547842065;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/popups/fly-in-login/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:524;s:11:\"trend_index\";i:522;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:447;a:14:{s:2:\"id\";i:5405;s:5:\"title\";s:8:\"About 12\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_1.png\";s:12:\"tmpl_created\";i:1520443505;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:224;s:11:\"trend_index\";i:348;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:448;a:14:{s:2:\"id\";i:9965;s:5:\"title\";s:30:\"Classic | Register | Subscribe\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2019/01/classic_moon_small.png\";s:12:\"tmpl_created\";i:1547842174;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-register-subscribe-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:539;s:11:\"trend_index\";i:606;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:449;a:14:{s:2:\"id\";i:5413;s:5:\"title\";s:8:\"About 21\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_2.png\";s:12:\"tmpl_created\";i:1520443507;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-21/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:92;s:11:\"trend_index\";i:38;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:450;a:14:{s:2:\"id\";i:14058;s:5:\"title\";s:36:\"Japanese restaurant &#8211; 404 page\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/06/404-Page.jpg\";s:12:\"tmpl_created\";i:1592290211;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/japanese-restaurant-404-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:38:\"[\"404\",\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:721;s:11:\"trend_index\";i:512;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:451;a:14:{s:2:\"id\";i:5421;s:5:\"title\";s:8:\"About 13\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_3.png\";s:12:\"tmpl_created\";i:1520443509;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:226;s:11:\"trend_index\";i:247;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:452;a:14:{s:2:\"id\";i:14050;s:5:\"title\";s:34:\"Japanese restaurant &#8211; Footer\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/06/Footer-Small.jpg\";s:12:\"tmpl_created\";i:1592290247;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/japanese-restaurant-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:41:\"[\"Food\",\"footer\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:522;s:11:\"trend_index\";i:147;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:453;a:14:{s:2:\"id\";i:5429;s:5:\"title\";s:8:\"About 16\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_4.png\";s:12:\"tmpl_created\";i:1520443510;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:74;s:11:\"trend_index\";i:56;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:454;a:14:{s:2:\"id\";i:9995;s:5:\"title\";s:27:\"Slide In | Sale | Christmas\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2019/01/slidein_christmas_small.png\";s:12:\"tmpl_created\";i:1547844802;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/slide-in-sale-christmas/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:719;s:11:\"trend_index\";i:693;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:455;a:14:{s:2:\"id\";i:14042;s:5:\"title\";s:34:\"Japanese restaurant &#8211; Header\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2020/06/japanese-restaurant-header.jpg\";s:12:\"tmpl_created\";i:1592290277;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/japanese-restaurant-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:41:\"[\"Food\",\"header\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:559;s:11:\"trend_index\";i:196;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:456;a:14:{s:2:\"id\";i:5438;s:5:\"title\";s:7:\"About 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_4.png\";s:12:\"tmpl_created\";i:1520443512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/about-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:182;s:11:\"trend_index\";i:148;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:457;a:14:{s:2:\"id\";i:5447;s:5:\"title\";s:7:\"About 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_5.png\";s:12:\"tmpl_created\";i:1520443514;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/about-3-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:54;s:11:\"trend_index\";i:47;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:458;a:14:{s:2:\"id\";i:10016;s:5:\"title\";s:16:\"Hello Bar | Sale\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2019/01/Hello-Bar_Promotion_bag_small.png\";s:12:\"tmpl_created\";i:1547845062;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/hello-bar-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:726;s:11:\"trend_index\";i:0;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:459;a:14:{s:2:\"id\";i:14067;s:5:\"title\";s:37:\"Slide In | Japanese restaurant | Menu\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/06/Menu-Pop-Up-Small.jpg\";s:12:\"tmpl_created\";i:1592290352;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/slide-in-japanese-restaurant-menu/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:675;s:11:\"trend_index\";i:476;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:460;a:14:{s:2:\"id\";i:5455;s:5:\"title\";s:8:\"About 20\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_6.png\";s:12:\"tmpl_created\";i:1520443516;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-20/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:137;s:11:\"trend_index\";i:169;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:461;a:14:{s:2:\"id\";i:10026;s:5:\"title\";s:46:\"Classic | Register | Subscribe | Gym | Fitness\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2019/01/classic_register_small.png\";s:12:\"tmpl_created\";i:1547845205;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-register-subscribe-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:556;s:11:\"trend_index\";i:620;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:462;a:14:{s:2:\"id\";i:5464;s:5:\"title\";s:8:\"About 17\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_6.png\";s:12:\"tmpl_created\";i:1520443518;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:229;s:11:\"trend_index\";i:249;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:463;a:14:{s:2:\"id\";i:10036;s:5:\"title\";s:43:\"Full Screen | Sale | Promotion | Headphones\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2019/01/full_sale_head_small.png\";s:12:\"tmpl_created\";i:1547845409;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/full-screen-sale-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:574;s:11:\"trend_index\";i:467;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:464;a:14:{s:2:\"id\";i:14111;s:5:\"title\";s:36:\"Classic | Japanese restaurant | Sale\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/06/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1592300400;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-japanese-restaurant-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:715;s:11:\"trend_index\";i:587;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:465;a:14:{s:2:\"id\";i:5472;s:5:\"title\";s:7:\"About 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_7.png\";s:12:\"tmpl_created\";i:1520443520;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/about-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:214;s:11:\"trend_index\";i:178;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:466;a:14:{s:2:\"id\";i:5480;s:5:\"title\";s:7:\"About 4\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_7-1.png\";s:12:\"tmpl_created\";i:1520443522;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/about-4-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:424;s:11:\"trend_index\";i:417;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:467;a:14:{s:2:\"id\";i:10057;s:5:\"title\";s:48:\"Hello Bar | Register | Subscribe | Gym | Fitness\";s:9:\"thumbnail\";s:91:\"https://library.elementor.com/wp-content/uploads/2019/01/hello-bar_register_sport_small.png\";s:12:\"tmpl_created\";i:1547847938;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/hello-bar-register-subscribe/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:702;s:11:\"trend_index\";i:674;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:468;a:14:{s:2:\"id\";i:5488;s:5:\"title\";s:7:\"About 7\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_8.png\";s:12:\"tmpl_created\";i:1520443524;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/about-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:314;s:11:\"trend_index\";i:355;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:469;a:14:{s:2:\"id\";i:5496;s:5:\"title\";s:7:\"About 9\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_8-1.png\";s:12:\"tmpl_created\";i:1520443526;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/about-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:508;s:11:\"trend_index\";i:575;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:470;a:14:{s:2:\"id\";i:5504;s:5:\"title\";s:8:\"About 18\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_9.png\";s:12:\"tmpl_created\";i:1520443528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:112;s:11:\"trend_index\";i:161;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:471;a:14:{s:2:\"id\";i:10087;s:5:\"title\";s:25:\"Full Screen | Login | Spa\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2019/01/full-screen_login_spa_small.png\";s:12:\"tmpl_created\";i:1547848301;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/full-screen-login-spa/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:595;s:11:\"trend_index\";i:625;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:472;a:14:{s:2:\"id\";i:14772;s:5:\"title\";s:35:\"Luxury Real Estate &#8211; 404 page\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/07/404.png\";s:12:\"tmpl_created\";i:1595315728;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/blocks/luxury-real-estate-404-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:34:\"[\"404\",\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:728;s:11:\"trend_index\";i:626;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:473;a:14:{s:2:\"id\";i:5515;s:5:\"title\";s:8:\"About 19\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_9.png\";s:12:\"tmpl_created\";i:1520443530;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-19/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:275;s:11:\"trend_index\";i:280;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:474;a:14:{s:2:\"id\";i:10097;s:5:\"title\";s:37:\"Classic | Register | Subscribe | Lego\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2019/01/classic_lego_small.png\";s:12:\"tmpl_created\";i:1547848411;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-register-subscribe-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:633;s:11:\"trend_index\";i:632;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:475;a:14:{s:2:\"id\";i:14779;s:5:\"title\";s:33:\"Luxury Real Estate &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/07/Footer.png\";s:12:\"tmpl_created\";i:1595315743;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/luxury-real-estate-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:37:\"[\"footer\",\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:666;s:11:\"trend_index\";i:263;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:476;a:14:{s:2:\"id\";i:1190;s:5:\"title\";s:26:\"Landing Page &#8211; Hotel\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2017/03/lp2-l.png\";s:12:\"tmpl_created\";i:1490707391;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/landing-page-hotel/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:3;s:11:\"trend_index\";i:1;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:477;a:14:{s:2:\"id\";i:9816;s:5:\"title\";s:30:\"Classic | Sale | Gym | Fitness\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2019/01/classic_sale_sport_small.png\";s:12:\"tmpl_created\";i:1547991876;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:655;s:11:\"trend_index\";i:0;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:478;a:14:{s:2:\"id\";i:9602;s:5:\"title\";s:35:\"Bottom Bar | Announcement | Cookies\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2019/01/Bottombar_Announcement_small_01.png\";s:12:\"tmpl_created\";i:1546964559;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/bottom-bar-announcement-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:560;s:11:\"trend_index\";i:663;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:479;a:14:{s:2:\"id\";i:225;s:5:\"title\";s:27:\"Homepage &#8211; Restaurant\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0016.png\";s:12:\"tmpl_created\";i:1470829872;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/homepage-restaurant/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Homepage\",\"Restaurant\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:1;s:11:\"trend_index\";i:3;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:480;a:14:{s:2:\"id\";i:463;s:5:\"title\";s:22:\"Homepage &#8211; Study\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/10/0022.png\";s:12:\"tmpl_created\";i:1477388340;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/homepage-study/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Education\",\"Homepage\",\"Study\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:5;s:11:\"trend_index\";i:4;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:481;a:14:{s:2:\"id\";i:10277;s:5:\"title\";s:36:\"Bottom Bar | Promotion | Sale | Book\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/book_small.png\";s:12:\"tmpl_created\";i:1548055999;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/bottom-bar-promotion-book/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:674;s:11:\"trend_index\";i:654;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:482;a:14:{s:2:\"id\";i:11241;s:5:\"title\";s:36:\"Classic | Digital Agency | Marketing\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/07/PopUp_small.jpg\";s:12:\"tmpl_created\";i:1564643043;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-digital-agency-marketing/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:370;s:11:\"trend_index\";i:311;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:483;a:14:{s:2:\"id\";i:181;s:5:\"title\";s:23:\"Homepage &#8211; Agency\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0019.png\";s:12:\"tmpl_created\";i:1470826567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/homepage-agency/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Agency\",\"Creative\",\"Homepage\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:2;s:11:\"trend_index\";i:2;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:484;a:14:{s:2:\"id\";i:9903;s:5:\"title\";s:34:\"Bottom Bar | Promotion | Olive Oil\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2019/01/bottom-bar_promotion_olive_small.png\";s:12:\"tmpl_created\";i:1547838896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/bottom-bar-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:705;s:11:\"trend_index\";i:712;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:485;a:14:{s:2:\"id\";i:150;s:5:\"title\";s:19:\"Product &#8211; App\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0003.png\";s:12:\"tmpl_created\";i:1470829879;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/product-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:6;s:11:\"trend_index\";i:5;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:486;a:14:{s:2:\"id\";i:10549;s:5:\"title\";s:33:\"Bottom Bar | Register | Subscribe\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/com_small.png\";s:12:\"tmpl_created\";i:1547967595;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/bottom-bar-register-subscribe/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:661;s:11:\"trend_index\";i:671;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:487;a:14:{s:2:\"id\";i:15486;s:5:\"title\";s:25:\"Travel Blog &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/11/About.jpg\";s:12:\"tmpl_created\";i:1606215720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/travel-blog-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:488;a:14:{s:2:\"id\";i:15478;s:5:\"title\";s:27:\"Travel Blog &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/11/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1606215735;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/travel-blog-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:489;a:14:{s:2:\"id\";i:15467;s:5:\"title\";s:24:\"Travel Blog &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/11/Home.jpg\";s:12:\"tmpl_created\";i:1606215756;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/travel-blog-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:490;a:14:{s:2:\"id\";i:15317;s:5:\"title\";s:25:\"Dance Studio &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/10/Home.jpg\";s:12:\"tmpl_created\";i:1603181291;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/dance-studio-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"dance studio\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:491;a:14:{s:2:\"id\";i:10529;s:5:\"title\";s:36:\"Classic | Announcement | Maintenance\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/icon_small.png\";s:12:\"tmpl_created\";i:1548046309;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/classic-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:452;s:11:\"trend_index\";i:408;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:492;a:14:{s:2:\"id\";i:15334;s:5:\"title\";s:26:\"Dance Studio &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/10/About.jpg\";s:12:\"tmpl_created\";i:1603181364;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/dance-studio-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"dance studio\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:493;a:14:{s:2:\"id\";i:15349;s:5:\"title\";s:28:\"Dance Studio &#8211; Classes\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/10/Classes.jpg\";s:12:\"tmpl_created\";i:1603181425;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/dance-studio-classes/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"dance studio\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:494;a:14:{s:2:\"id\";i:15366;s:5:\"title\";s:29:\"Dance Studio &#8211; Schedule\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2020/10/Classes-Schedule.jpg\";s:12:\"tmpl_created\";i:1603181056;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/dance-studio-schedule/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"dance studio\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:495;a:14:{s:2:\"id\";i:15373;s:5:\"title\";s:28:\"Dance Studio &#8211; Pricing\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/10/Pricing.jpg\";s:12:\"tmpl_created\";i:1603181678;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/dance-studio-pricing/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"dance studio\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:496;a:14:{s:2:\"id\";i:15384;s:5:\"title\";s:28:\"Dance Studio &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/10/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1603181738;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/dance-studio-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"dance studio\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:497;a:14:{s:2:\"id\";i:15158;s:5:\"title\";s:26:\"Psychologist &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/09/About.jpg\";s:12:\"tmpl_created\";i:1600157561;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/psychologist-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:498;a:14:{s:2:\"id\";i:15197;s:5:\"title\";s:28:\"Psychologist &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/09/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1600160499;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/psychologist-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:499;a:14:{s:2:\"id\";i:15142;s:5:\"title\";s:25:\"Psychologist &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/09/Home.jpg\";s:12:\"tmpl_created\";i:1600156308;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/psychologist-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:500;a:14:{s:2:\"id\";i:10413;s:5:\"title\";s:28:\"Classic | Content Lock | Pop\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/hot_small.png\";s:12:\"tmpl_created\";i:1547961774;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/classic-content-lock/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:687;s:11:\"trend_index\";i:680;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:501;a:14:{s:2:\"id\";i:15188;s:5:\"title\";s:28:\"Psychologist &#8211; Pricing\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/09/Pricing.jpg\";s:12:\"tmpl_created\";i:1600159731;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/psychologist-pricing/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:502;a:14:{s:2:\"id\";i:10223;s:5:\"title\";s:15:\"Classic | Login\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/01/welcome_small.png\";s:12:\"tmpl_created\";i:1547887343;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/classic-login-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:471;s:11:\"trend_index\";i:437;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:503;a:14:{s:2:\"id\";i:15167;s:5:\"title\";s:29:\"Psychologist &#8211; Services\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/09/Services.jpg\";s:12:\"tmpl_created\";i:1600158206;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/psychologist-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_in