<?php
namespace Elementor;

class hm_PE_addtocart_btn extends Widget_Base
{
    public function get_name()
    {
        return 'hm_PE_addtocart_btn';
    }
    public function get_title()
    {
        return __('نمایش دکمه‌ی افزودن به سبد خرید', 'hamyarlearn');
    }
    public function get_icon()
    {
        return 'eicon-product-add-to-cart';
    }
    public function get_categories()
    {
        return [ 'HL-Products-Elements' ];
    }
    protected function _register_controls()
    {
        //start section control (tab:content)
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('محتوا', 'hamyarlearn'),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'note_about_woo_atc',
			[
				'label' => __( 'توضیحاتی در مورد این المان', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::RAW_HTML,
				'raw' => __( '<div style="font-size:16px; color:#fff; border-radius:10px; padding:10px; line-height:1.9; display:block; background:#F50057; font-weight:500;">این المان، برای قالب همیار لرن می‌باشد.<br>
        با این المان می‌توانید دکمه‌ی افزودن به سبد خرید را نمایش دهید. برای تغییر ظاهر به تب استایل بروید.<br><br>
        نکته: در حالت عادی، این المان بصورت تمام عرض هست. برای اینکه از این حالت تمام عرض در بیاید و با عرض محدود شود،
        به تب پیشرفته>موقعیت‌یابی>عرض بروید. این گزینه را روی "سفارشی" تنظیم کنید. سپس در بخش "عرض سفارشی"، گزینه‌ی
        درصد را انتخاب کنید و درصدی دلخواه (مثلا 80 درصد) را وارد کنید.
        </div>', 'hamyarlearn' ),
				'content_classes' => 'element_title_note',
			]
		);

    $this->add_control(
			'refresh_element',
			[
				'label' => __( 'رفرش المان', 'hamyarlearn' ),
        'description' => __('اگر این المان در این صفحه‌ی ویرایشگر المنتور نمایش داده نمی‌شد،
         فقط یکبار این دکمه را خاموش و روشن کنید. این دکمه هیچ کاربرد دیگری ندارد و فقط
          برای رفرش کردن المان هست. هیچ تاثیری روی نمایش دکمه ندارد.
        ','hamyarlearn'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'رفرش', 'hamyarlearn' ),
				'label_off' => __( 'رفرش', 'hamyarlearn' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);



    		$this->end_controls_section();

        $this->start_controls_section(
			'style_section',
			[
				'label' => __( 'استایل عنوان دوره', 'hamyarlearn' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

    $this->add_control(
			'PE_atc_color',
			[
				'label' => __( 'رنگ متن سبد خرید', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .ele-cource-atc button.single_add_to_cart_button, {{WRAPPER}} .ele-cource-atc button.single_add_to_cart_button.button.alt' => 'color: {{VALUE}} !important',
				],
			]
		);

    $this->add_control(
			'PE_atc_bg_color',
			[
				'label' => __( 'رنگ پس‌زمینه‌ی دکمه‌ی سبد خرید', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#f22d33',
				'selectors' => [
					'{{WRAPPER}} .ele-cource-atc button.single_add_to_cart_button, {{WRAPPER}} .ele-cource-atc button.single_add_to_cart_button.button.alt' => 'background: {{VALUE}} !important; box-shadow: 0 2px 12px {{VALUE}} !important',
				],
			]
		);

    $this->add_control(
			'PE_atc_bg_hover_color',
			[
				'label' => __( 'رنگ هاور پس‌زمینه‌ی دکمه‌ی سبد خرید', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#C51162',
				'selectors' => [
					'{{WRAPPER}} .ele-cource-atc button.single_add_to_cart_button:hover, {{WRAPPER}} .ele-cource-atc button.single_add_to_cart_button.button.alt:hover' => 'background: {{VALUE}} !important; box-shadow: 0 2px 30px {{VALUE}} !important',
				],
			]
		);

    $this->end_controls_section();

    }

    protected function render(){
      $settings = $this->get_settings_for_display(); ?>

      <div class="ele-cource-atc">
        <?php woocommerce_template_single_add_to_cart(); ?>
      </div>

  <?php } }
