<?php
namespace Elementor;
class hm_courses extends Widget_Base {
	public function get_name() {
		return 'hm_courses';
	}
	public function get_title() {
		return __( 'دوره‌های آموزشی همیار لرن', 'hamyarlearn' );
	}
	public function get_icon() {
		return 'eicon-products-archive';
	}
	public function get_categories() {
		return [ 'HL-Elements' ];
	}

	public function get_product_cat()
	{
			$terms = get_terms(array(
					'taxonomy' => 'product_cat',
					'hide_empty' => false,
			));

			if (! empty($terms) && ! is_wp_error($terms)) {
					foreach ($terms as $term) {
							$options[ $term->term_id ] = $term->name;
					}
					return $options;
			}
	}

	public function get_product_tag()
	{
			$terms = get_terms(array(
					'taxonomy' => 'product_tag',
					'hide_empty' => false,
			));

			if (! empty($terms) && ! is_wp_error($terms)) {
					foreach ($terms as $term) {
							$options[ $term->term_id ] = $term->name;
					}
					return $options;
			}
	}

	protected function _register_controls() {
    //start section control (tab:content)
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'محتوا', 'hamyarlearn' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

    $this->add_control(
			'posts-number',
			[
				'label' => __( 'تعداد دوره‌ها', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 100,
				'step' => 1,
				'default' => 3,
			]
		);

		$this->add_control(
			'pros-cols',
			[
				'label' => __( 'تعداد ستون‌ها', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 4,
				'step' => 1,
				'default' => 3,
				'condition' => [
            'is_carousel' => 'no',
        ],
			]
		);

		$this->add_control(
				'is_carousel',
				[
						'label' => __('فعالسازی کروسل', 'hamyarlearn'),
						'type' => \Elementor\Controls_Manager::SELECT,
						'default' => 'no',
						'options' => [
								'yes'  => __('فعال', 'hamyarlearn'),
								'no' => __('غیرفعال', 'hamyarlearn'),
						],
				]
		);

		$this->add_control(
			'note_about_carousel_status_yes',
			[
				'label' => '',
				'type' => \Elementor\Controls_Manager::RAW_HTML,
				'raw' => __( 'کروسل فعال است!', 'hamyarlearn' ),
				'content_classes' => 'carousel-status',
				'condition' => [
            'is_carousel' => 'yes',
        ],
			]
		);

		$this->add_control(
			'note_about_carousel_status_no',
			[
				'label' => '',
				'type' => \Elementor\Controls_Manager::RAW_HTML,
				'raw' => __( 'کروسل غیرفعال است.', 'hamyarlearn' ),
				'content_classes' => 'carousel-status',
				'condition' => [
            'is_carousel' => 'no',
        ],
			]
		);

		$this->add_control(
			'title_for_carousel_options',
			[
				'label' => __( 'تنظیمات کروسل', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => [
            'is_carousel' => 'yes',
        ],
			]
		);

		// $this->add_control(
		// 	'note_require_id',
		// 	[
		// 		'label' => '',
		// 		'type' => \Elementor\Controls_Manager::RAW_HTML,
		// 		'raw' => __( '
		// 		<div style="line-height:1.9;">
		// 		<strong>نکات در مورد آی‌دی:</strong>
		// 		<br>
		// 		<ol>
		// 			<li>وارد کردن این فیلد الزامی است.</li>
		// 			<li>این آی‌دی، باید یونیک باشد. (متفاوت باشد و قبلا وارد نکرده باشید)</li>
		// 			<li>تنها موارد مجاز: تنها می‌تواند شامل حروف انگلیسی باشد. بدون فاصله باشد.</li>
		// 			<li></li>
		// 		</ol>
		// 		</div>', 'hamyarlearn' ),
		// 		'content_classes' => 'carousel-status',
		// 		'condition' => [
    //         'is_carousel' => 'yes',
    //     ],
		// 	]
		// );

		// $this->add_control(
		// 	'cl_id',
		// 	[
		// 		'label' => __( 'آی‌دی کروسل (ضروری)', 'hamyarlearn' ),
		// 		'type' => \Elementor\Controls_Manager::TEXT,
		// 		'default' => '',
		// 		'placeholder' => __( 'الزامی است', 'hamyarlearn' ),
		// 		'condition' => [
    //         'is_carousel' => 'yes',
    //     ],
		// 	]
		// );


		$this->add_control(
			'cl_loop',
			[
				'label' => __( 'فعال بودن لوپ تکرار', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'فعال', 'hamyarlearn' ),
				'label_off' => __( 'غیرفعال', 'hamyarlearn' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [
            'is_carousel' => 'yes',
        ],
			]
		);


		$this->add_control(
			'cl_autoplay',
			[
				'label' => __( 'پخش خودکار', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'فعال', 'hamyarlearn' ),
				'label_off' => __( 'غیرفعال', 'hamyarlearn' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [
            'is_carousel' => 'yes',
						'cl_loop' => 'yes',
        ],
			]
		);

		$this->add_control(
			'cl_autoplay_time',
			[
				'label' => __( 'زمان پخش خودکار (به میلی‌ثانیه)', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 100,
				'max' => 120000,
				'step' => 100,
				'default' => 5000,
				'condition' => [
					'is_carousel' => 'yes',
					'cl_autoplay' => 'yes',
					'cl_loop' => 'yes',
				],
			]
		);


		$this->add_control(
			'cl_autoplay_hover',
			[
				'label' => __( 'توقف حرکت در هاور (برای پخش خودکار)', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'فعال', 'hamyarlearn' ),
				'label_off' => __( 'غیرفعال', 'hamyarlearn' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [
					'is_carousel' => 'yes',
					'cl_autoplay' => 'yes',
					'cl_loop' => 'yes',
				],
			]
		);

    $this->add_control(
			'title_for_course_options',
			[
				'label' => __( 'تنظیمات محتوای باکس', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);


    $this->add_control(
			'show_course_options',
			[
				'label' => __( 'نمایش موارد اضافه‌ی باکس دوره', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'فعال', 'hamyarlearn' ),
				'label_off' => __( 'غیرفعال', 'hamyarlearn' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

    $this->add_control(
			'show_price',
			[
				'label' => __( 'قیمت', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'فعال', 'hamyarlearn' ),
				'label_off' => __( 'غیرفعال', 'hamyarlearn' ),
				'return_value' => 'yes',
				'default' => 'yes',
        'condition' => [
            'show_course_options' => 'yes',
        ],
			]
		);

    $this->add_control(
			'show_under_metas',
			[
				'label' => __( 'نمایش متای دوره', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'فعال', 'hamyarlearn' ),
				'label_off' => __( 'غیرفعال', 'hamyarlearn' ),
				'return_value' => 'yes',
				'default' => 'yes',
        'condition' => [
            'show_course_options' => 'yes',
        ],
			]
		);

    $this->add_control(
			'show_number_users',
			[
				'label' => __( 'نمایش تعداد شرکت‌کنندگان دوره', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'فعال', 'hamyarlearn' ),
				'label_off' => __( 'غیرفعال', 'hamyarlearn' ),
				'return_value' => 'yes',
				'default' => 'yes',
        'condition' => [
          'show_course_options' => 'yes',
          'show_under_metas' => 'yes',
        ],
			]
		);

    $this->add_control(
			'users_txt',
			[
				'label' => __( 'متن جایگزین برای "تعداد شرکت‌کنندگان"', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'تعداد شرکت‌کنندگان', 'hamyarlearn' ),
				'placeholder' => __( 'تعداد شرکت‌کنندگان', 'hamyarlearn' ),
        'condition' => [
          'show_course_options' => 'yes',
          'show_under_metas' => 'yes',
          'show_number_users' => 'yes',
        ],
			]
		);

    $this->add_control(
			'show_number_comments',
			[
				'label' => __( 'نمایش تعداد دیدگاه‌های دوره', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'فعال', 'hamyarlearn' ),
				'label_off' => __( 'غیرفعال', 'hamyarlearn' ),
				'return_value' => 'yes',
				'default' => 'yes',
        'condition' => [
          'show_course_options' => 'yes',
          'show_under_metas' => 'yes',
        ],
			]
		);

    $this->add_control(
			'comments_txt',
			[
				'label' => __( 'متن جایگزین برای "تعداد دیدگاه‌ها"', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'تعداد دیدگاه‌ها', 'hamyarlearn' ),
				'placeholder' => __( 'تعداد دیدگاه‌ها', 'hamyarlearn' ),
        'condition' => [
          'show_course_options' => 'yes',
          'show_number_comments' => 'yes',
          'show_under_metas' => 'yes',
        ],
			]
		);

		$this->add_control(
			'post_order',
			[
				'label' => __('مرتب‌سازی براساس', 'hamyarlearn'),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'default' => 'DESC',
				'options' => [
					'ASC' => [
						'title' => __('صعودی', 'hamyarlearn'),
						'icon' => 'fa fa-arrow-up'
					],
					'DESC' => [
						'title' => __('نزولی', 'hamyarlearn'),
						'icon' => 'fa fa-arrow-down'
					],
				],
				'toggle' => true
			]
		);

    $this->end_controls_section();

		$this->start_controls_section(
			'query_section',
			[
				'label' => __( 'نمایش براساس دسته‌بندی/برچسب', 'hamyarlearn' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
				'products_orderby',
				[
						'label'   => esc_html__('نمایش دوره‌ها براساس', 'hamyarlearn'),
						'type'    => Controls_Manager::SELECT,
						'default' => 'date',
						'options' => [
								'date'     => esc_html__('تاریخ', 'hamyarlearn'),
								'title'    => esc_html__('عنوان', 'hamyarlearn'),
								'total_sales'     => esc_html__('فروش', 'hamyarlearn'),
								'modified' => esc_html__('آخرین تغییر (بروزرسانی)', 'hamyarlearn'),
						],
				]
		);

		$this->add_control(
				'pros_category_tags_select',
				[
						'label'   => esc_html__('نمایش از دسته‌بندی یا برچسب؟', 'hamyarlearn'),
						'type'    => Controls_Manager::SELECT,
						'default' => 'no',
						'options' => [
								'category' => esc_html__('دسته‌بندی', 'hamyarlearn'),
								'tag' => esc_html__('برچسب', 'hamyarlearn'),
								'no' => esc_html__('هیچ کدام!', 'hamyarlearn'),
						],
				]
		);

		$this->add_control(
				'courses_category',
				[
						'label'   => esc_html__('دسته‌بندی', 'hamyarlearn'),
						'type'    => \Elementor\Controls_Manager::SELECT2,
						'label_block' => true,
						'options' => $this->get_product_cat(),
						'multiple'  => true,
						'condition' => [
								'pros_category_tags_select' => 'category',
						],
				]
		);

		$this->add_control(
				'courses_tag',
				[
						'label'   => esc_html__('برچسب', 'hamyarlearn'),
						'type'    => \Elementor\Controls_Manager::SELECT2,
						'label_block' => true,
						'options' => $this->get_product_tag(),
						'multiple'  => true,
						'condition' => [
								'pros_category_tags_select' => 'tag',
						],
				]
		);

		$this->end_controls_section();

    $this->start_controls_section(
      'style_section',
      [
    'label' => __( 'ظاهر بخش نمایش مطالب', 'hamyarlearn' ),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );

		$this->add_control(
			'title_intro',
			[
				'label' => __( 'تنظیمات ظاهر عنوان مطالب', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

    $this->add_control(
			'show_title',
			[
				'label' => __( 'نمایش عنوان مطلب', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'فعال', 'hamyarlearn' ),
				'label_off' => __( 'غیرفعال', 'hamyarlearn' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

    $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'تایپوگرافی عنوان مطلب', 'hamyarlearn' ),
				'scheme' => Scheme_Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .prodetail > .atitlepro > a',
        'condition' => [
            'show_title' => 'yes',
        ],
			]
		);

    $this->add_control(
			'title_color',
			[
				'label'   => __( 'رنگ عنوان', 'hamyarlearn' ),
				'type'    => \Elementor\Controls_Manager::COLOR,
				'default' => 'rgb(51, 122, 183)',
				'selectors' =>
				[
					'{{WRAPPER}} .prodetail > .atitlepro > a' => 'color: {{VALUE}}'
				],
        'condition' => [
          'show_title' => 'yes',
        ],
			]
		);

    $this->add_control(
			'title_hover_color',
			[
				'label'   => __( 'رنگ هاور عنوان', 'hamyarlearn' ),
				'type'    => \Elementor\Controls_Manager::COLOR,
				'default' => 'rgb(35, 82, 124)',
				'selectors' =>
				[
					'{{WRAPPER}} .prodetail > .atitlepro > a:hover' => 'color: {{VALUE}}'
				],
        'condition' => [
          'show_title' => 'yes',
        ],
			]
		);

    $this->add_control(
			'title_characters',
			[
				'label' => __( 'تعداد کاراکترهای عنوان', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 1000,
				'step' => 1,
				'default' => 58,
        'condition' => [
          'show_title' => 'yes',
        ],
			]
		);

    $this->add_control(
			'excpert_intro',
			[
				'label' => __( 'تنظیمات ظاهر متن توضیحات دوره', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

    $this->add_control(
			'show_excpert',
			[
				'label' => __( 'نمایش توضیح دوره', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'فعال', 'hamyarlearn' ),
				'label_off' => __( 'غیرفعال', 'hamyarlearn' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

    $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'excpert_typography',
				'label' => __( 'تایپوگرافی متن  توضیح دوره', 'hamyarlearn' ),
				'scheme' => Scheme_Typography::TYPOGRAPHY_1,
        'condition' => [
          'show_excpert' => 'yes',
        ],
				'selector' => '{{WRAPPER}} .prodetail > p',
			]
		);

    $this->add_control(
			'excpert_color',
			[
				'label'   => __( 'رنگ متن توضیح دوره', 'hamyarlearn' ),
				'type'    => \Elementor\Controls_Manager::COLOR,
				'default' => '#333',
        'condition' => [
          'show_excpert' => 'yes',
        ],
				'selectors' =>
				[
					'{{WRAPPER}} .prodetail > p' => 'color: {{VALUE}}'
				]
			]
		);

    $this->add_control(
			'meta_intro',
			[
				'label' => __( 'تنظیمات ظاهر متای دوره', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

    $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'meta_num_typography',
				'label' => __( 'تایپوگرافی عدد متا', 'hamyarlearn' ),
				'scheme' => Scheme_Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .everypro .prodetail .product_meta .product_metas ul li span.f-number',
			]
		);


    $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'meta_title_typography',
				'label' => __( 'تایپوگرافی عنوان متا', 'hamyarlearn' ),
				'scheme' => Scheme_Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .everypro .prodetail .product_meta .product_metas ul li span.f-title',
			]
		);

    $this->add_control(
			'meta_color',
			[
				'label'   => __( 'رنگ متا', 'hamyarlearn' ),
				'type'    => \Elementor\Controls_Manager::COLOR,
				'default' => '#333',
				'selectors' =>
				[
					'{{WRAPPER}} .product_metas' => 'color: {{VALUE}}'
				]
			]
		);


    $this->add_control(
			'meta_price_color',
			[
				'label'   => __( 'رنگ بخش قیمت', 'hamyarlearn' ),
				'type'    => \Elementor\Controls_Manager::COLOR,
				'default' => '#333',
				'selectors' =>
				[
					'{{WRAPPER}} .everypro .prodetail .product_meta .product_price, .elementor-277 .elementor-element.elementor-element-d97f1e6 .everypro .prodetail .product_meta .product_price ins .woocommerce-Price-amount .woocommerce-Price-currencySymbol' => 'color: {{VALUE}}'
				]
			]
		);

    $this->add_control(
			'meta_price_sell_color',
			[
				'label'   => __( 'رنگ قیمت فروش ویژه', 'hamyarlearn' ),
				'type'    => \Elementor\Controls_Manager::COLOR,
				'default' => '#F50057',
				'selectors' =>
				[
					'{{WRAPPER}} .everypro .prodetail .product_meta .product_price ins .woocommerce-Price-amount' => 'color: {{VALUE}}'
				]
			]
		);


    $this->add_control(
			'allbox_intro',
			[
				'label' => __( 'تنظیمات باکس دوره', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

    $this->add_control(
			'postbox_shadowon_back_color',
			[
				'label'   => __( 'رنگ پس‌زمینه', 'hamyarlearn' ),
				'type'    => \Elementor\Controls_Manager::COLOR,
				'default' => '#fff',
				'selectors' =>
				[
					'{{WRAPPER}} .everypro' => 'background: {{VALUE}}'
				]
			]
		);

		$this->end_controls_section();

	}

  protected function render() {
  $settings = $this->get_settings_for_display();
	$element_ID = 'owl-course-'.$this->get_id();
  //$categoryid   = $settings['categoryid'];
  $post_order = $settings['post_order'];
	//
	$args=array(
    'posts_per_page' => $settings['posts-number'],
    'order'         =>  $post_order,
    'post_type' => 'product',
		'post_status'         => 'publish',
		'ignore_sticky_posts' => 1,
  );
	if ($settings['products_orderby'] == 'total_sales') {
		$args=array(
	    'posts_per_page' => $settings['posts-number'],
	    'order'         =>  $post_order,
	    'post_type' => 'product',
			'post_status'         => 'publish',
			'ignore_sticky_posts' => 1,
			// if is por_foroosh:
			'meta_key'            => 'total_sales',
			'orderby'             => 'meta_value_num',
	  );
	}elseif ($settings['products_orderby'] == 'modified') {
		$args=array(
	    'posts_per_page' => $settings['posts-number'],
	    'order'         =>  $post_order,
	    'post_type' => 'product',
			'post_status'         => 'publish',
			'ignore_sticky_posts' => 1,
			// if is modified:
			'orderby'  => 'modified',
	  );
	}else {
		$args=array(
	    'posts_per_page' => $settings['posts-number'],
	    'order'         =>  $post_order,
	    'post_type' => 'product',
			'post_status'         => 'publish',
			'ignore_sticky_posts' => 1,
			// if is other...:
			'orderby'  => $settings['products_orderby'],
	  );
	}
	//
	if ($settings['pros_category_tags_select'] == 'category') {
		$arg_tax=[
			'tax_query' => [
				[
					'taxonomy' => 'product_cat',
					'field' => 'term_id',
					'terms' => $settings['courses_category'],
				],
			]
		];
		$args = array_merge($args, $arg_tax);
	}elseif ($settings['pros_category_tags_select'] == 'tag') {
		$arg_tax=[
			'tax_query' => [
				[
					'taxonomy' => 'product_tag',
					'field' => 'term_id',
					'terms' => $settings['courses_tag'],
				],
			]
		];
		$args = array_merge($args, $arg_tax);
	}
	$prosquery = new \WP_Query($args);
  if ( $prosquery->have_posts() ) :
		//
		if ($settings['is_carousel'] == 'no') {
			echo '<div class="row pros rowkill">';
		}else {
			echo '<div class="owl-carousel '.$element_ID.' pros colswpsh">';
		}
		?>
      <?php
      $i=1;
      while($prosquery->have_posts()):
        $prosquery->the_post(); $bg_size = $i==5 ? 'full' : 'stthumb'; ?>

				<?php if ($settings['is_carousel'] == 'no') { ?>
					<div class="<?php
					if ($settings['pros-cols'] == '1') {
						echo "col-12";
					}elseif ($settings['pros-cols'] == '2') {
						echo "col-lg-6 col-12";
					}elseif ($settings['pros-cols'] == '3') {
						echo "col-lg-4 col-sm-6 col-12";
					}elseif ($settings['pros-cols'] == '4') {
						echo "col-xl-3 col-lg-4 col-sm-6 col-12";
					}else {
						echo "col-lg-4 col-sm-6 col-12";
					} ?>">
        <?php } ?>
          <div class="everypro colswpsh">
            <a href="<?php echo the_permalink(); ?>">
              <div class="proheader">
								<?php
								if ($settings['pros-cols'] == '1') {
									the_post_thumbnail( '' );
								}else {
									the_post_thumbnail( 'wwshthumb' );
								}
								?>
              </div>
            </a>
            <div class="prodetail">
              <?php if ( 'yes' === $settings['show_title'] ) { ?>
                <div class="atitlepro">
                  <a href="<?php echo the_permalink(); ?>">
                    <?php echo mb_strimwidth(get_the_title(), 0, $settings['title_characters'], '...'); ?>
                  </a>
                </div>
              <?php }
              if ( 'yes' === $settings['show_excpert'] ) { ?>
                <p>
                  <?php global $product;
                  echo $product->get_short_description(); ?>
                </p>
              <?php }
              if ( 'yes' === $settings['show_course_options'] ) { ?>
                <div class="product_meta">
                  <?php if ( 'yes' === $settings['show_price'] ) { ?>
                    <div class="product_price">
                      <?php echo woocommerce_template_single_price(); ?>
                    </div>
                    <?php }
                    if ( 'yes' === $settings['show_under_metas'] ) { ?>
                    <div class="product_metas">
                      <ul class="d-flex bd-highlight">
                        <?php if ( 'yes' === $settings['show_number_users'] ) { ?>
                          <li class="flex-fill bd-highlight">
                            <span class="f-number"><?php echo the_field('sidebar-count-webamasters'); ?></span>
                            <span class="f-title"><?php echo $settings["users_txt"] ?></span>
                          </li>
                        <?php }
                        if ( 'yes' === $settings['show_number_comments'] ) { ?>
                          <li class="flex-fill bd-highlight">
                            <span class="f-number"><?php echo get_comments_number(); ?></span>
                            <span class="f-title"><?php echo $settings["comments_txt"] ?></span>
                          </li>
                      <?php } ?>
                      </ul>
                    </div>
                  <?php } ?>
                </div>
              <?php } ?>
            </div>
          </div>
        <?php if ($settings['is_carousel'] == 'no') { ?></div> <?php } ?>

        <?php $i++;endwhile; ?>
    </div>

    <?php wp_reset_postdata(); ?>
  <?php endif; ?>
	<?php if ($settings['is_carousel'] == 'yes') { ?>
	<script type="text/javascript">
	jQuery(document).ready(function() {
	jQuery(".<?php echo $element_ID ?>").owlCarousel({
		<?php if ( is_rtl() ) { ?>
		'rtl': true,
		<?php } ?>
		'item': <?php
		echo "3";
		?>,
		'loop': <?php
		if ( 'yes' === $settings['cl_loop'] ) {
			echo "true";
		}else {
			echo "false";
		}
		?>,
		'lazyLoad': true,
		<?php if ( 'yes' === $settings['cl_loop'] ) { ?>
		'autoplay': <?php
		if ( 'yes' === $settings['cl_autoplay'] ) {
			echo "true";
		}else {
			echo "false";
		}
		?>,
		<?php
		if ( 'yes' === $settings['cl_autoplay'] ) { ?>
		'autoplayTimeout': <?php
		echo $settings['cl_autoplay_time'];
		?>,
		'autoplayHoverPause': <?php
		if ( 'yes' === $settings['cl_autoplay_hover'] ) {
			echo "true";
		}else {
			echo "false";
		}
		?>,
		<?php }
		} ?>
		'nav': <?php
		echo "false";
		?>,
		'dots': <?php echo "false"; ?>,
		responsive: {
			0 : {
				items: 1,
			},
			768 : {
				items: 2,
			},
			1200 : {
				items: 3,
			}
		}
	});
	});
	</script>
	<?php } ?>
      <div class="clear"></div>
  <?php
}
}
