jQuery(document).ready(function($) {
    var ajax_url = "<?php echo admin_url('admin-ajax.php'); ?>";
    jQuery(document).on('submit', '.register_version_form', function(event) {
        event.preventDefault();
        var starter = jQuery(this).find('.license_key').val(),
            thisEl = jQuery(this);
        thisEl.addClass('waiting');
        thisEl.find('.result').slideDown(300).addClass('show');
        thisEl.find('.button').addClass('disabled');
        thisEl.find('.result_text').slideUp(300).html('');
        jQuery.ajax({
            url: ajax_url,
            type: 'POST',
            dataType: 'json',
            data: {
                action: '<?php echo $this->slug; ?>',
                starter: starter
            },
        })
            .done(function(result) {
                thisEl.find('.result_text').append(result.data).slideDown(150)
            })
            .fail(function(result) {
                thisEl.find('.result_text').append('<div class="zhk_guard_danger"><?php _e('مشکلی پیش آمد. لطفا بعدا تلاش کنید...',$this->text_domain); ?></div>').slideDown(150)
            })
            .always(function(result) {
                console.log(result);
                thisEl.removeClass('waiting');
                thisEl.find('.result').removeClass('show');
                thisEl.find('.button').removeClass('disabled');
            });
    });
    $(document).on('click', '.wpmlr_revalidate', function(event) {
        event.preventDefault();
        var starter = $(this).data('key'),
            thisEl = $(this).parents('.current_license');
        thisEl.addClass('waiting');
        thisEl.find('.check_result').slideDown(300);
        thisEl.find('.button').addClass('disabled');
        thisEl.find('.result_text').slideUp(300).html('');
        thisEl.find('.register_version_form').slideUp(300)
        $.ajax({
            url: ajax_url,
            type: 'POST',
            dataType: 'json',
            data: {
                action: '<?php echo $this->slug; ?>_revalidate',
                starter: starter
            },
        })
            .done(function(result) {
                thisEl.find('.check_result .result_text').append(result.data).slideDown(150)
            })
            .fail(function(result) {
                thisEl.find('.check_result .result_text').append('<div class="wpmlr_danger"><?php _e('Something goes wrong please try again.',$this->text_domain); ?></div>').slideDown(150)
            })
            .always(function(result) {
                thisEl.removeClass('waiting');
                thisEl.find('.button').removeClass('disabled');
            });
    });
    $(document).on('click', '.zhk_guard_new_key', function(event) {
        event.preventDefault();
        var thisEl = $(this).parents('.current_license');
        thisEl.find('.result_text').slideUp(300).html('');
        thisEl.find('.register_version_form').slideDown(300)
    });
});
