<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked wc_print_notices - 10
 */
do_action( 'woocommerce_before_single_product' );

if ( post_password_required() ) {
	echo get_the_password_form(); // WPCS: XSS ok.
	return;
}
?>


<div id="product-<?php the_ID(); ?>" <?php wc_product_class( '', $product ); ?>>


	<?php
		$remove_course_intro = ot_get_option( 'remove_course_intro' , false );
		if ( $remove_course_intro !== 'off' ) {

	if(get_field('remove-course-intro')) {}
		else{ ?>
			<div id="course-intro">

				<?php
				if(get_field('remove-course-intro-title')) {
				}else{ ?>
				<h2 class="all-areas-title">
					<?php echo ot_get_option('text_course_intro' , esc_html__( 'معرفی دوره', 'hamyarlearn' )) ?>
				</h2>
			<?php } ?>

<?php if(get_field('remove-course-intro-video')) {
	?>
	<style media="screen">
		#course-intro{
			background: #fff;
			border-radius: 10px;
			padding: 10px 0 10px 10px;
			color:#333;
		}
		#course-intro p,#course-intro p, #course-intro h2.all-areas-title, #course-intro ul , #course-intro li, #course-intro h1, #course-intro h2, #course-intro h3, #course-intro h4, #course-intro h5, #course-intro h6{
			color: #333;
		}
		<?php $dark_mode = ot_get_option('darkmode', false);
		if ($dark_mode == 'on') { ?>
			#course-intro{
				padding: 10px;
			}
		<?php } ?>
		@media (max-width:767px){
			#course-intro{
				background: unset;
				border-radius: unset;
				padding: 0;
			}
			<?php if ($dark_mode == 'on') { ?>
				#course-intro p,#course-intro p, #course-intro h2.all-areas-title, #course-intro ul , #course-intro li, #course-intro h1, #course-intro h2, #course-intro h3, #course-intro h4, #course-intro h5, #course-intro h6{
					color: #fff;
				}
			<?php } ?>
		}
	</style>
	<?php
}
	else{ ?>
				<div class="course-wp-content">
					<video width="100%" controls>
						<source src="<?php
						the_field('wwsh-video'); ?>" type="video/mp4">
						<?php echo __('مروگر شما از HTML5 پشتیبانی نمی‌کند.' , 'hamyarlearn'); ?>
					</video>
				</div>
			<?php } ?>


			<?php if(get_field('remove-course-intro-detail')) {} else{ ?>
<div class="course-wp-content">
					<?php echo the_content(); ?>

				</div>
<?php } ?>


			</div>
<?php } } ?>






<?php
$remove_course_lessons = ot_get_option( 'remove_course_lessons' , false );
if ( $remove_course_lessons !== 'off' ) {
	if(get_field('remove-lessons')) {}
		else{ ?>
<div id="course-lessons">
<h2 class="all-areas-title">
	<?php echo ot_get_option('text_course_lessons' , esc_html__('سرفصل‌های دوره', 'hamyarlearn')) ?>
</h2>
    <div class="lessoncards">
			<div class="lessons">

				<?php
				$boxnum=1;
				$lessons = get_field('lessons');
				if( $lessons ): ?>
				<ul class="row lessonsboxes">
				    <?php foreach( $lessons as $lesson ): ?>
				        <div class="backlessons col-md-4 <?php echo 'boxnum-'.$boxnum ?>"><li class="lessonbox"><div class="inboxnum"></div><?php echo $lesson; ?></li></div>

				    <?php
						$boxnum = $boxnum+1;
					 endforeach; ?>
				</ul>
				<?php endif; ?>


				<?php
				$stylenum=1;
				$lessonsimgs = get_field('lessonsimgs');
				if( $lessonsimgs ): ?>
				<style>
						<?php foreach( $lessonsimgs as $lessonsimg ): ?>
						<?php echo '.boxnum-'.$stylenum ?> .inboxnum{
							background-image: url('<?php echo $lessonsimg ?>');
							background-size: cover;
							background-repeat: no-repeat;
						}
								<?php
						$stylenum = $stylenum+1;
					 endforeach; ?>

				</style>
				<?php endif; ?>


      </div>
    </div>
</div>


<?php } } ?>






<?php
$remove_course_requirement = ot_get_option( 'remove_course_requirement' , false );
if ( $remove_course_requirement !== 'off' ) {

if (get_field('remove-course-requirement')) {} else {?>
			<div id="course-requirement">
				<?php if (get_field('remove-course-requirement-title')) {} else {?>
				<h2 class="all-areas-title">
					<?php echo ot_get_option('text_course_requirement' , esc_html__('مخاطبین دوره', 'hamyarlearn')) ?>
				</h2>
			<?php } ?>
				<div class="row">
					<div class="col-xl-7">
<?php if (get_field('remove-course-requirement-littledetail')) {} else {?>
						<p>
							<?php echo the_title(); ?>
							<?php echo __('دارای پیش نیازهایی می باشد که قبل از ثبت نام می بایست به آنها توجه کنید تا در ادامه آموزش به مشکل نخورید.' , 'hamyarlearn'); ?>
						</p>
							<?php } ?>

							<?php if (get_field('remove-course-requirement-reqbox')) {} else {?>

						<div class="req">
							<div class="req-title">
								<?php the_field('course-requirement-reqtitle'); ?>
							</div>
							<?php
							$values = get_field('course-requirement-reqli');
							if($values)
							{
								echo '<ul>';
								foreach($values as $value)
								{
									echo '<li>' . $value . '</li>';
								}
								echo '</ul>';
							}
							?>
						</div>
					<?php } ?>


<?php if (get_field('remove-course-requirement-unreqbox')) {} else {?>
						<div class="unreq">
							<div class="unreq-title">
								<?php the_field('course-requirement-unreqtitle'); ?>
							</div>
							<?php
							$values = get_field('course-requirement-unreqli');
							if($values)
							{
								echo '<ul>';
								foreach($values as $value)
								{
									echo '<li>' . $value . '</li>';
								}
								echo '</ul>';
							}
							?>
						</div>

						<?php } ?>



					</div>

<?php if (get_field('remove-course-requirement-imgs')) {} else {?>
					<div class="col-md-5 d-none d-xl-block requirement-left">

						<div class="reqphotos">
							<div class="req-photo1"></div>
							<div class="req-photo2"></div>
							<div class="req-photo3"></div>
							<div class="req-photo4"></div>
						</div>
					</div>
					<?php } ?>

				</div>
				<?php // Change REQ IMGs with css ?>
				<style media="screen">
				<?php if( get_field('req-photo1') ): ?>
						.requirement-left .req-photo1 { background: url(<?php the_field('req-photo1'); ?>) no-repeat;background-size: cover}
				<?php endif; ?>
				<?php if( get_field('req-photo2') ): ?>
						.requirement-left .req-photo2 { background: url(<?php the_field('req-photo2'); ?>) no-repeat;background-size: cover}
				<?php endif; ?>
				<?php if( get_field('req-photo3') ): ?>
						.requirement-left .req-photo3 { background: url(<?php the_field('req-photo3'); ?>) no-repeat;background-size: cover}
				<?php endif; ?>
				<?php if( get_field('req-photo4') ): ?>
						.requirement-left .req-photo4 { background: url(<?php the_field('req-photo4'); ?>) no-repeat;background-size: cover}
				<?php endif; ?>
				</style>
			</div>
<?php } } ?>



<?php
$remove_course_teachers = ot_get_option( 'remove_course_teachers' , false );
if ( $remove_course_teachers !== 'off' ) {


if (get_field('remove-course-teachers')) {} else {?>
			<div id="course-teachers">
				<h2 class="all-areas-title">
					<?php echo ot_get_option('text_course_teachers' , esc_html__('مدرسین دوره', 'hamyarlearn')) ?>
				</h2>


<?php
$posts = get_field('choose-course-teachers');
if( $posts ): ?>
<?php foreach( $posts as $post): ?>

				<div class="col-12">
					<div class="row">
						<div class="teacher-author">
							<div class="col-sm-4 colswpsh teacher-author-avatar">
								<?php the_post_thumbnail(); ?>
							</div>
							<div class="col-sm-7 colswpsh teacher-author-desk">
								<div class="teacher-name">
									<h4><?php the_title() ?></h4>
									<div class="teacher-about"><?php the_field('teacher-summery-desk') ?></div>
								</div>
								<div class="teacher-info">
									<p><?php the_field('teacher-all-desk') ?></p>
								</div>
							</div>
						</div>
					</div>
				</div>

<?php endforeach; ?>
<?php wp_reset_postdata(); // IMPORTANT - reset the $post object so the rest of the page works correctly ?>
<?php endif; ?>


			</div>
<?php } } ?>



<?php
$remove_course_faq = ot_get_option( 'remove_course_faq' , false );
if ( $remove_course_faq == 'on' ) {
	if (get_field('remove-course-faq')) {} else {
 ?>
<div id="course-faq">

	<div class="faqtitle">
		<h2 class="all-areas-title">
			<?php echo ot_get_option('text_course_faq' , esc_html__('سوالات متداول', 'hamyarlearn')) ?>
		</h2>
	</div>

	<div class="faqcontent">
		<?php
		$elefaq = get_field('elementor-faq-shortcode');
		echo do_shortcode($elefaq);
		?>
	</div>

<?php
if (get_field('hm-elementor-faq-style')) {} else{
?>
<style>
.elementor-accordion .elementor-accordion-item {
	border: none !important;
	border-bottom: 1px solid #E5E5E5 !important;
	border-radius: 0;
}
</style>
<?php } ?>

</div>
<?php } } ?>


<?php
$remove_course_advice = ot_get_option( 'remove_course_advice' , false );
if ( $remove_course_advice !== 'off' ) {

if (get_field('remove-course-advice')) {} else {?>

			<div id="course-advice">
				<h2 class="all-areas-title">
					<?php echo ot_get_option('text_course_advice' , esc_html__('درخواست مشاوره', 'hamyarlearn')) ?>
				</h2>

				<div class="course-advice-box pro-advice colswpsh">
					<div class="col-md-7 col-12 colswpsh">
						<div class="contentform">
							<p>
								<?php echo ot_get_option('top_form_p' , esc_html__('شما این فرصت را دارید، با تکمیل فرم زیر، قبل از انتخاب دوره آموزشی مناسب خود، از مشاوره رایگان کارشناسان آموزشی مجموعه همیار آکادمی استفاده نمائید.', 'hamyarlearn')) ?>
							</p>
							<div class="form-advice">
								<?php
								if (ot_get_option( 'form_saaz' , false ) == 'selected_gravity_advice' and ot_get_option( 'advice_gravityforms' , false ) !== false) {
									$gravityformwwsh = ot_get_option( 'advice_gravityforms' , false );
									echo do_shortcode('[gravityform id="'.$gravityformwwsh.'" title="false" description="false" ajax="true"]');
								} elseif (ot_get_option( 'form_saaz' , false ) == 'selected_form7_advice' and ot_get_option( 'advice_contactform7' , false ) !== false) {
									$contact7formwwsh = ot_get_option( 'advice_contactform7' , false );
									echo do_shortcode($contact7formwwsh);
								}elseif (ot_get_option( 'form_saaz' , false ) == 'selected_others_advice' and ot_get_option( 'advice_others' , false ) !== false) {
									$otherformswwsh = ot_get_option( 'advice_others' , false );
									echo do_shortcode($otherformswwsh);
								}else{
									?>
									<form>
										<label for="name"><?php echo esc_html__('نام و نام خانوادگی', 'hamyarlearn'); ?></label>
										<input type="text" name="name" placeholder="<?php echo esc_html__('مثلا: شایان فرهنگ پژوه', 'hamyarlearn'); ?>">

										<label for="mobile"><?php echo esc_html__('شماره موبایل', 'hamyarlearn'); ?></label>
										<input type="tel" name="mobile" placeholder="<?php echo esc_html__('مثلا: 09123456789', 'hamyarlearn'); ?>">

										<button type="button" name="button"><?php echo esc_html__('ثبت درخواست مشاوره‌ی رایگان', 'hamyarlearn'); ?></button>
									</form>
									<?php
								}
								 ?>
							</div>

						</div>

					</div>
					<div class="col-md-5 d-none d-md-block piccontent colswpsh">
						<h3><?php echo ot_get_option('first_advice_h',esc_html__('مشاوران آموزشی', 'hamyarlearn')) ?>
							<br>
							<?php echo ot_get_option('second_advice_h' , esc_html__('همیار لرن', 'hamyarlearn')) ?></h3>
						<p><?php echo ot_get_option('third_advice_p' , esc_html__('پاسخگوی شما هستند', 'hamyarlearn')) ?></p>

						<div class="bottom-area-advice">
							<?php
							$show_number_advice = ot_get_option('show_number_advice' , false);
							$call_number_advice = ot_get_option('call_number_advice','02123456');
							$phone_link_advice = ot_get_option('phone_link_advice','tel://+98 2123456');
							if ($show_number_advice == 'on') {
								?>
								<p class="tel-adivice">
									<a class="a1" href="<?php echo $phone_link_advice ?>"><?php echo esc_html__('شماره تماس:', 'hamyarlearn'); ?></a>
									<a class="a2" href="<?php echo $phone_link_advice ?>"><?php echo $call_number_advice ?></a>
								</p>
								<?php } ?>

							 <?php
 							$show_telegram_advice = ot_get_option('show_telegram_advice' , false);
							$telegram_id_advice = ot_get_option('telegram_id_advice' , 't.me/wpwithsh');
 							if ($show_telegram_advice == 'on') {
 								?>
							<p class="tm-advice">
								<a class="a1" target="_blank" href="http://<?php echo $telegram_id_advice ?>"><?php echo esc_html__('تلگرام:', 'hamyarlearn'); ?></a>
								<a class="a2" target="_blank" href="http://<?php echo $telegram_id_advice ?>"><?php echo $telegram_id_advice ?></a>
							</p>
							<?php } ?>

						</div>
					</div>
				</div>



			</div>



<?php } } ?>








<?php
$remove_course_register = ot_get_option( 'remove_course_register' , false );
if ( $remove_course_register !== 'off' ) {

if (get_field('remove-course-register')) {} else {?>
			<div class="course-register-area">
				<h2 id="course-register" class="all-areas-title">
					<?php echo ot_get_option('text_course_register' , esc_html__('ثبت نام در دوره', 'hamyarlearn')); ?>
				</h2>
				<div class="col-12">


					<div class="register-cource-box colswpsh ele-all">
						<div class="col-md-7 col-12 colswpsh">
							<h3><?php echo esc_html__('اطلاعات دوره', 'hamyarlearn'); ?></h3>

							<?php
							$values = get_field('infos-course-reg');
							if($values)
							{
								echo '<ul>';
								foreach($values as $value)
								{
									echo '<li> <span>' . $value . '</span> </li>';
								}
								echo '</ul>';
							}
							?>

						</div>


						<div class="col-md-5 col-12 colswpsh">


								<div class="pricearea-wwsh">
									<?php
									if ( is_a( $product, 'WC_Product_Variable' ) ) {
										?>
										<div class="price-variable">
											<?php woocommerce_template_single_price(); ?>
									 </div>
									 <?php woocommerce_template_single_add_to_cart(); ?>
									<?php
									}else {
										if ($product->get_price() == "0") {
											?>
										<div class="price-area">
										<div class="priceisfree">
											<?php if ($product->get_regular_price() == "0") {
											}else { ?>
											<del><?php echo $product->get_regular_price() ?> <?php
											//echo esc_html__('تومان', 'hamyarlearn');
											echo get_woocommerce_currency_symbol();
											?></del>
										<?php } ?>
											<span class="freeprice"><?php echo esc_html__('رایگان!', 'hamyarlearn'); ?></span>
										</div>
									</div>
										<?php
										woocommerce_template_single_add_to_cart();
									}else {
										?>
										<div class="price-area">
										<?php
								 		woocommerce_template_single_price();
									?>
							 			</div>
							 		<?php
								 		woocommerce_template_single_add_to_cart();
									?>
								<?php } }
								 ?>
							</div>
						</div>
					</div>
				</div>
			</div>
<?php } } ?>



<?php
$remove_comments = ot_get_option( 'remove_comments' , false );
if ( $remove_comments !== 'off' ) {

if (get_field('remove-comments')) {} else {?>
			<div class="col-12">
				<div id="comments" class="colswpsh cmnts-area cmntpro">

						<h2 class="all-areas-title">
							<?php echo ot_get_option('text_comments' , esc_html__('نظرات', 'hamyarlearn')); ?>
						</h2>


<?php comments_template(); ?>


				</div>
			</div>


		<?php } } ?>




</div>




<?php do_action( 'woocommerce_after_single_product' ); ?>
