<?php
namespace Elementor;

class hm_PE_breadcrumb extends Widget_Base
{
    public function get_name()
    {
        return 'hm_PE_breadcrumb';
    }
    public function get_title()
    {
        return __('نمایش بردکرامب دوره', 'hamyarlearn');
    }
    public function get_icon()
    {
        return 'eicon-product-breadcrumbs';
    }
    public function get_categories()
    {
        return [ 'HL-Products-Elements' ];
    }
    protected function _register_controls()
    {
        //start section control (tab:content)
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('محتوا', 'hamyarlearn'),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'note_about_woo_title',
			[
				'label' => __( 'توضیحاتی در مورد این المان', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::RAW_HTML,
				'raw' => __( '<div style="font-size:16px; color:#fff; border-radius:10px; padding:10px; line-height:1.9; display:block; background:#F50057; font-weight:500;">این المان، برای قالب همیار لرن می‌باشد.<br>
        با کمک المان‌های محصول (دوره) در همیار لرن، می‌توانید صفحات معرفی دوره که با ووکامرس هستند را
        با المنتور طراحی کنید.<br>
        برای تغییر ظاهر این بردکرامب، به تب استایل بروید.</div>', 'hamyarlearn' ),
				'content_classes' => 'element_title_note',
			]
		);



    		$this->end_controls_section();

        $this->start_controls_section(
			'style_section',
			[
				'label' => __( 'استایل بردکرامب دوره', 'hamyarlearn' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'PE_breadcrumb_typography',
				'label' => __( 'تایپوگرافی بردکرامب دوره', 'hamyarlearn' ),
				'selector' => '.woocommerce {{WRAPPER}} .broadc .woocommerce-breadcrumb',
			]
		);

    $this->add_control(
			'PE_breadcrumb_color',
			[
				'label' => __( 'رنگ متن بردکرامب دوره', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#31576E',
				'selectors' => [
					'.woocommerce {{WRAPPER}} .broadc .woocommerce-breadcrumb a' => 'color: {{VALUE}}',
				],
			]
		);

    $this->add_control(
			'PE_breadcrumb_now_color',
			[
				'label' => __( 'رنگ صفحه‌ی کنونی بردکرامب دوره', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#767676',
				'selectors' => [
					'.woocommerce {{WRAPPER}} .broadc .woocommerce-breadcrumb' => 'color: {{VALUE}}',
				],
			]
		);

    $this->add_control(
			'PE_breadcrumb_sep_color',
			[
				'label' => __( 'رنگ آیکون فاصله در بردکرامب دوره', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#e8e8e8',
				'selectors' => [
					'.woocommerce {{WRAPPER}} .broadc .woocommerce-breadcrumb i' => 'color: {{VALUE}}',
				],
			]
		);

    $this->end_controls_section();

    }

    protected function render(){
      $settings = $this->get_settings_for_display(); ?>

      <div
      class="ele-breadcrumb-title broadc"
      style="text-align:<?php if (is_rtl()) {echo 'right';}else {echo 'left';} ?>;">
				<?php echo woocommerce_breadcrumb(); ?>
			</div>

  <?php } }
