<?php
namespace Elementor;

class hm_PE_course_lessons extends Widget_Base
{
    public function get_name()
    {
        return 'hm_PE_course_lessons';
    }
    public function get_title()
    {
        return __('درس‌های دوره', 'hamyarlearn');
    }
    public function get_icon()
    {
        return 'eicon-archive';
    }
    public function get_categories()
    {
        return [ 'HL-Products-Elements' ];
    }
    protected function _register_controls()
    {
        //start section control (tab:content)
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('محتوا', 'hamyarlearn'),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

    		$repeater->add_control(
    			'list_title', [
    				'label' => __( 'عنوان درس', 'hamyarlearn' ),
    				'type' => \Elementor\Controls_Manager::TEXT,
    				'default' => __( 'آموزش همیار لرن' , 'hamyarlearn' ),
    				'label_block' => true,
    			]
    		);

    		$repeater->add_control(
    			'lessons_img',
    			[
    				'label' => __( 'تصویر درس (سایز پیشنهادی: 80 پیکسل در 80 پیکسل)', 'hamyarlearn' ),
    				'type' => \Elementor\Controls_Manager::MEDIA,
    				'default' => [
    					'url' => \Elementor\Utils::get_placeholder_image_src(),
    				],
    			]
    		);

    	$this->add_control(
    			'list',
    			[
    				'label' => __( 'جلسات دوره' , 'hamyarlearn' ),
    				'type' => \Elementor\Controls_Manager::REPEATER,
    				'fields' => $repeater->get_controls(),
    				'default' => [
    					[
    						'list_title' => __( 'آموزش نصب همیار لرن', 'hamyarlearn' ),
    					],
    					[
    						'list_title' => __( 'آموزش تنظیمات قالب', 'hamyarlearn' ),
    					],
              [
    						'list_title' => __( 'آموزش اضافه کردن دوره', 'hamyarlearn' ),
    					],
    				],
    				'title_field' => '{{{ list_title }}}',
    			]
    		);

    // finish repeter for show lessons list

    		$this->end_controls_section();

        $this->start_controls_section(
			'style_section',
			[
				'label' => __( 'استایل عنوان دوره', 'hamyarlearn' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'PE_lessons_title_typography',
				'label' => __( 'تایپوگرافی عنوان درس‌ها', 'hamyarlearn' ),
				'selector' => '{{WRAPPER}} .backlessons .lessonbox',
			]
		);

    $this->add_control(
			'PE_lessons_title_color',
			[
				'label' => __( 'رنگ متن عنوان درس‌ها', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#333',
				'selectors' => [
					'{{WRAPPER}} .backlessons .lessonbox' => 'color: {{VALUE}}',
				],
			]
		);

    $this->add_control(
			'PE_bgcolor_boxes',
			[
				'label' => __( 'رنگ پس‌زمینه‌ی باکس درس‌ها', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .backlessons .lessonbox' => 'background: {{VALUE}}',
				],
			]
		);

    $this->add_control(
			'shadow_element',
			[
				'label' => __( 'فعال بودن سایه‌ی المان', 'hamyarlearn' ),
        'description' => __('این گزینه را بهتر است زمانی فعال کنید که بک‌گراند صفحه‌ی پشتی، فقط سفید باشد.<br>
        با فعال کردن این تنظیم، هر باکس جلسه یک سایه بطور پیش‌فرض خواهد گرفت و فقط در حالت هاور نخواهد بود.','hamyarlearn'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'فعال', 'hamyarlearn' ),
				'label_off' => __( 'غیرفعال', 'hamyarlearn' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

    $this->end_controls_section();

    }

    protected function render(){
      $settings = $this->get_settings_for_display();
      $element_ID = $this->get_id();
      ?>

      <div class="lessoncards lessons-<?php echo $element_ID; ?>">
  			<div class="lessons">
  				<ul class="row lessonsboxes">
            <?php $boxnum=1;
            foreach ( $settings['list'] as $item ) {
              $lesson_title = $item['list_title']; ?>
              <div class="backlessons col-md-4 <?php echo 'boxnum-'.$boxnum ?>">
                <li class="lessonbox">
                  <div class="inboxnum"></div>
                  <?php echo $lesson_title; ?>
                </li>
              </div>
              <?php
              $boxnum = $boxnum+1;
            }
            ?>
          </ul>

          <style>
          <?php $boxnum=1;
          foreach ( $settings['list'] as $item ) {
            $lessons_img = $item['lessons_img']['url']; ?>

  						<?php echo '.boxnum-'.$boxnum ?> .inboxnum{
  							background-image: url('<?php echo $lessons_img ?>');
  							background-size: cover;
  							background-repeat: no-repeat;
  						}
              <?php
              $boxnum = $boxnum+1;
            }
            ?>

  				</style>

        </div>
      </div>

      <style media="screen">
      <?php echo '.lessoncards.lessons-' . $element_ID; ?> li.lessonbox{
        <?php
        if ( 'yes' === $settings['shadow_element'] ) {
          echo "box-shadow:0 0 40px rgba(0,0,0,0.1)";
        } ?>
      }
      <?php echo '.lessoncards.lessons-' . $element_ID; ?> li.lessonbox:hover{
        box-shadow: 3px 3px 100px rgba(0,0,0,0.2);
      }
      </style>

      <?php } }
