<?php
namespace Elementor;

class hm_PE_single_lesson extends Widget_Base
{
    public function get_name()
    {
        return 'hm_PE_single_lesson';
    }
    public function get_title()
    {
        return __('فصل تکی (آکاردئونی)', 'hamyarlearn');
    }
    public function get_icon()
    {
        return 'eicon-nav-menu';
    }
    public function get_categories()
    {
        return [ 'HL-Products-Elements' ];
    }
    protected function _register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => __('محتوا', 'hamyarlearn'),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
          'lesson_img',
          [
            'label' => __( 'تصویر فصل (سایز پیشنهادی: 50 پیکسل در 50 پیکسل)', 'hamyarlearn' ),
            'type' => \Elementor\Controls_Manager::MEDIA,
            'default' => [
              'url' => \Elementor\Utils::get_placeholder_image_src(),
            ],
          ]
        );

        $this->add_control(
			'sl_lesson_title',
			[
				'label' => __( 'عنوان درس', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('آموزش کار با قالب همیار لرن','hamyarlearn'),
				'placeholder' => __( 'مثلا: آموزش کار با قالب همیار لرن', 'hamyarlearn' ),
			]
		);

    $this->add_control(
			'sl_lesson_subtitle',
			[
				'label' => __( 'زیر عنوان فصل (خیلی طولانی نباشد!)', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'rows' => 3,
				'default' => __('متن زیرعنوان فصل','hamyarlearn'),
				'placeholder' => __( 'مثلا: یاد می‌گیریم قالب آموزش آنلاین همیار لرن را نصب، راه‌اندازی و تنظیم کنیم و سپس با این قالب بی‌نظیر سایت‌مان را طراحی کنیم.', 'hamyarlearn' ),
			]
		);

        //start section control (tab:content)
        $repeater = new \Elementor\Repeater();

    		$repeater->add_control(
    			'list_title', [
    				'label' => __( 'عنوان درس از فصل دوره', 'hamyarlearn' ),
    				'type' => \Elementor\Controls_Manager::TEXT,
    				'default' => __( 'جلسه‌ی 0: افتتاحیه‌ی دوره‌ی جامع وبمستران هوشمند' , 'hamyarlearn' ),
    				'label_block' => true,
    			]
    		);

        $repeater->add_control(
    			'list_content', [
    				'label' => __( 'محتوای درس', 'hamyarlearn' ),
    				'type' => \Elementor\Controls_Manager::WYSIWYG,
    				'default' => __( '<ul> <li>چرا کسب و کار آنلاین را انتخاب کنیم؟</li>
              <li>اصطلاحات دنیای کارآفرینی که در قرار است زیاد به گوشمان بخورد را می‌شناسیم</li>
              <li>شبکه‌سازی می‌کنیم و با دوستان جدیدمان آشنا می‌شویم</li> </ul>' , 'hamyarlearn' ),
    				'show_label' => false,
    			]
    		);

    	$this->add_control(
    			'list',
    			[
    				'label' => __( 'درس‌های فصل' , 'hamyarlearn' ),
    				'type' => \Elementor\Controls_Manager::REPEATER,
    				'fields' => $repeater->get_controls(),
    				'default' => [
    					[
    						'list_title' => __( 'جلسه‌ی 0: افتتاحیه‌ی دوره‌ی جامع وبمستران هوشمند', 'hamyarlearn' ),
                'list_content' => __( '<ul> <li>چرا کسب و کار آنلاین را انتخاب کنیم؟</li>
                  <li>اصطلاحات دنیای کارآفرینی که در قرار است زیاد به گوشمان بخورد را می‌شناسیم</li>
                  <li>شبکه‌سازی می‌کنیم و با دوستان جدیدمان آشنا می‌شویم</li> </ul>' , 'hamyarlearn' ),
    					],
    				],
    				'title_field' => '{{{ list_title }}}',
    			]
    		);

    // finish repeter for show lessons list

    		$this->end_controls_section();

        $this->start_controls_section(
			'style_section',
			[
				'label' => __( 'استایل المان فصل تکی', 'hamyarlearn' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

    $this->add_control(
			'show_subtitle_in_mobile',
			[
				'label' => __( 'عدم نمایش زیرعنوان فصل در موبایل', 'hamyarlearn' ),
        'description' => __('اگر از یک متن طولانی برای زیر عنوان فصل استفاده می‌کنید، توصیه می‌کنیم این گزینه را غیرفعال کنید.','hamyarlearn'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'غیرفعال', 'hamyarlearn' ),
				'label_off' => __( 'فعال', 'hamyarlearn' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'PE_lesson_title_typography',
				'label' => __( 'تایپوگرافی متن سرفصل', 'hamyarlearn' ),
				'selector' => '{{WRAPPER}} .sl-ele-shweb .sl-lesson-box .card-header button.btn.btn-link .ls-lesson-titlebar .ls-lesson-title',
			]
		);

    $this->add_control(
			'PE_lesson_title_color',
			[
				'label' => __( 'رنگ متن سرفصل', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#000',
				'selectors' => [
					'{{WRAPPER}} .sl-ele-shweb .sl-lesson-box .card-header button.btn.btn-link .ls-lesson-titlebar .ls-lesson-title' => 'color: {{VALUE}} !important',
				],
			]
		);

    $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'PE_lesson_subtitle_typography',
				'label' => __( 'تایپوگرافی متن زیرعنوان سرفصل', 'hamyarlearn' ),
				'selector' => '{{WRAPPER}} .sl-ele-shweb .sl-lesson-box .card-header button.btn.btn-link .ls-lesson-titlebar p.sl_lesson_subtitle',
			]
		);

    $this->add_control(
			'PE_lesson_subtitle_color',
			[
				'label' => __( 'رنگ متن زیرعنوان سرفصل', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#AAA',
				'selectors' => [
					'{{WRAPPER}} .sl-ele-shweb .sl-lesson-box .card-header button.btn.btn-link .ls-lesson-titlebar p.sl_lesson_subtitle' => 'color: {{VALUE}}',
				],
			]
		);

    $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'PE_lesson_subtitle_typography',
				'label' => __( 'تایپوگرافی متن زیرعنوان سرفصل', 'hamyarlearn' ),
				'selector' => '{{WRAPPER}} .sl-ele-shweb .sl-lesson-box .card-header button.btn.btn-link .ls-lesson-titlebar p.sl_lesson_subtitle',
			]
		);

    $this->add_control(
			'PE_lesson_subtitle_color',
			[
				'label' => __( 'رنگ متن زیرعنوان سرفصل', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#AAA',
				'selectors' => [
					'{{WRAPPER}} .sl-ele-shweb .sl-lesson-box .card-header button.btn.btn-link .ls-lesson-titlebar p.sl_lesson_subtitle' => 'color: {{VALUE}}',
				],
			]
		);

    $this->add_control(
			'PE_lesson_border_color',
			[
				'label' => __( 'رنگ آیکون فلش سرفصل', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#d0d0d0',
				'selectors' => [
					'{{WRAPPER}} .sl-ele-shweb .sl-lesson-box .card-header button.btn.btn-link .ls-lesson-titlebar i.arrow' => 'border-color: {{VALUE}}',
				],
			]
		);

    $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'PE_topic_title_typography',
				'label' => __( 'تایپوگرافی متن عنوان درس', 'hamyarlearn' ),
				'selector' => '{{WRAPPER}} .sl-ele-shweb .sl-lesson-box .ls-topic-content .card-header button.btn.btn-link',
			]
		);

    $this->add_control(
			'PE_topic_title_color',
			[
				'label' => __( 'رنگ متن عنوان درس', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#000',
				'selectors' => [
					'{{WRAPPER}} .sl-ele-shweb .sl-lesson-box .ls-topic-content .card-header button.btn.btn-link' => 'color: {{VALUE}} !important',
				],
			]
		);

    $this->add_control(
			'PE_topic_boletlist_color',
			[
				'label' => __( 'رنگ بولِتِ لیست در محتوای درس', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#f8c44f',
				'selectors' => [
					'{{WRAPPER}} .sl-ele-shweb .ls-topic-content .topic-content ul li::before' => 'color: {{VALUE}}',
				],
			]
		);

    $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'PE_topic_content_typography',
				'label' => __( 'تایپوگرافی محتوای درس', 'hamyarlearn' ),
				'selector' => '{{WRAPPER}} .sl-ele-shweb .sl-lesson-box .ls-topic-content .topic-content',
			]
		);

    $this->end_controls_section();

    }

    protected function render(){
      $settings = $this->get_settings_for_display();
      $element_ID = $this->get_id();
      ?>

      <div class="sl-ele-shweb">
        <div id="accordion">

          <div class="sl-lesson-box">
            <div class="card-header" id="<?php echo "header-$element_ID" ?>">
              <h5 class="mb-0">
                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="<?php echo "#collapse-$element_ID" ?>" aria-expanded="false" aria-controls="<?php echo "#collapse-$element_ID" ?>">
                  <i class="img-i">
                    <?php echo wp_get_attachment_image( $settings['lesson_img']['id'], 'woocommerce_gallery_thumbnail' ); ?>
                  </i>
                  <div class="ls-lesson-titlebar">
                    <span class="ls-lesson-title">
                      <?php echo $settings['sl_lesson_title']; ?>
                    </span>
                    <p class="sl_lesson_subtitle<?php
                    if ($settings['show_subtitle_in_mobile'] === 'yes') {
                      echo " d-none d-sm-block";
                    }
                    ?>">
                      <?php echo $settings['sl_lesson_subtitle']; ?>
                    </p>
                    <i class="arrow down"></i>
                  </div>
                </button>
              </h5>
            </div>

            <div id="<?php echo "collapse-$element_ID" ?>" class="collapse" aria-labelledby="<?php echo "heading-$element_ID" ?>" data-parent="#accordion">
              <div class="card-body">

                <ul id="accordion" class="ls-list">
                  <?php $boxnum=1;
                  foreach ( $settings['list'] as $item ) { ?>
                  <li>
                      <div class="ls-topic-content">
                        <div class="card-header" id="<?php echo "header-$element_ID-$boxnum" ?>">
                          <h5 class="mb-0">
                            <button class="btn btn-link collapsed" data-toggle="collapse" data-target="<?php echo "#collapse-$element_ID-$boxnum" ?>" aria-expanded="false" aria-controls="<?php echo "#collapse-$element_ID-$boxnum" ?>">
                              <i class="sub-btn"></i>
                              <?php echo $item['list_title']; ?>
                            </button>
                          </h5>
                        </div>

                        <div id="<?php echo "collapse-$element_ID-$boxnum" ?>" class="collapse" aria-labelledby="<?php echo "heading-$element_ID-$boxnum" ?>" data-parent="#accordion">
                          <div class="card-body">
                            <div class="topic-content">
                              <?php echo $item['list_content']; ?>
                            </div>
                          </div>
                        </div>
                      </div>

                  </li>
                  <?php $boxnum = $boxnum+1;
                  } ?>
                </ul>

              </div>
            </div>
          </div>

        </div>
      </div>











      <!-- <div id="accordion">

        <?php $boxnum=1;
        foreach ( $settings['list'] as $item ) {
          $lesson_title = $item['list_title']; ?>

        <div class="faqcard">
          <div class="card-header" id="<?php echo "header-$element_ID-$boxnum" ?>">
            <h5 class="mb-0">
              <button class="btn btn-link<?php
              if (!$boxnum=='1') {
                echo " collapsed";
              }
              ?>" data-toggle="collapse" data-target="<?php echo "#collapse-$element_ID-$boxnum" ?>" aria-expanded="<?php
              if (!$boxnum=='1') {
                echo "false";
              }else {
                echo "true";
              }
              ?>" aria-controls="<?php echo "#collapse-$element_ID-$boxnum" ?>">
                <?php echo $item['list_title']; ?>
              </button>
            </h5>
          </div>

          <div id="<?php echo "collapse-$element_ID-$boxnum" ?>" class="collapse<?php
          if ($boxnum=='1') {
            echo " show";
          }
          ?>" aria-labelledby="<?php echo "heading-$element_ID-$boxnum" ?>" data-parent="#accordion">
            <div class="card-body">
              <?php echo $item['list_content']; ?>
            </div>
          </div>
        </div>

      <?php $boxnum = $boxnum+1;
      } ?>

      </div> -->








      <?php } }
