<?php
namespace Elementor;

class hm_PE_teachers extends Widget_Base
{
    public function get_name()
    {
        return 'hm_PE_teachers';
    }
    public function get_title()
    {
        return __('مدرسان دوره', 'hamyarlearn');
    }
    public function get_icon()
    {
        return 'eicon-archive-posts';
    }
    public function get_categories()
    {
        return [ 'HL-Products-Elements' ];
    }
    protected function _register_controls()
    {
        //start section control (tab:content)
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('محتوا', 'hamyarlearn'),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'teachers_style',
            [
                'label' => __('استایل باکس مدرسان', 'hamyarlearn'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'little',
                'options' => [
                    'little'  => __('کوچک', 'hamyarlearn'),
                    'full' => __('بزرگ', 'hamyarlearn'),
                ],
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
    			'list_img',
    			[
    				'label' => __( 'تصویر مدرس', 'hamyarlearn' ),
    				'type' => \Elementor\Controls_Manager::MEDIA,
    				'default' => [
    					'url' => \Elementor\Utils::get_placeholder_image_src(),
    				],
    			]
    		);

        $repeater->add_control(
    			'note_imgsize',
    			[
    				'label' => __( 'یادداشت سایز پیشنهادی تصویر', 'hamyarlearn' ),
    				'type' => \Elementor\Controls_Manager::RAW_HTML,
    				'raw' => __( '
            <div style="font-size:12px; color:#333; border-radius:10px; padding:10px; line-height:1.9; display:block; background:#f5f5f5; font-weight:500;">
            سایز پیشنهادی تصویر در استایل کوچک: 150 پیکسل در 150 پیکسل<br>
            <hr>
            سایز پیشنهادی تصویر در استایل بزرگ: 250 پیکسل در 250 پیکسل
            </div>
            ', 'hamyarlearn' ),
    				'content_classes' => '',
    			]
    		);

    		$repeater->add_control(
    			'list_title', [
    				'label' => __( 'نام مدرس', 'hamyarlearn' ),
    				'type' => \Elementor\Controls_Manager::TEXT,
    				'default' => __( 'شایان فرهنگ پژوه' , 'hamyarlearn' ),
    				'label_block' => true,
    			]
    		);

        $repeater->add_control(
			'list_subtitle',
			[
				'label' => __( 'توضیحات کوتاه مدرس', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'rows' => 3,
				'default' => __( 'بنیانگذار مجموعه‌ی شایان وب', 'hamyarlearn' ),
				'placeholder' => __( 'مثلا: بنیانگذار مجموعه‌ی شایان وب', 'hamyarlearn' ),
			]
		);

    $repeater->add_control(
      'note_nocontent',
      [
        'label' => __( 'یادداشت عدم استفاده از بیوگرافی', 'hamyarlearn' ),
        'type' => \Elementor\Controls_Manager::RAW_HTML,
        'raw' => __( '
        <div style="font-size:12px; color:#333; border-radius:10px; padding:10px; line-height:1.9; display:block; background:#f5f5f5; font-weight:500;">
        توجه داشته باشید که از بیوگرافی (توضیحات طولانی مدرس) که تنظیم آن در زیر قرار دارد،
        فقط در استایل بزرگ این المان استفاده می‌شود و در استایل کوچک، کاربردی ندارد. (پر کردن یا نکردن آن هیچ تاثیری ندارد)
        </div>
        ', 'hamyarlearn' ),
        'content_classes' => '',
      ]
    );
        $repeater->add_control(
    			'list_content', [
    				'label' => __( 'بیوگرافی مدرس / توضیحات طولانی', 'hamyarlearn' ),
    				'type' => \Elementor\Controls_Manager::WYSIWYG,
    				'default' => __( 'شایان فرهنگ پژوه هستم و 14 سالم هست. 2 سال و نیم میشه بصورت حرفه‌ای دارم در این زمینه فعالیت می‌کنم. من بنیانگذار وبسایت شایان وب، مدرس دوره‌های آموزشی شایان آکادمی و طراح و برنامه‌نویس قالب‌های وردپرس و HTML در شایان مارکت هستم.' , 'hamyarlearn' ),
    				'show_label' => false,
    			]
    		);

    	$this->add_control(
    			'list',
    			[
    				'label' => __( 'مدرس/مدرسان دوره' , 'hamyarlearn' ),
    				'type' => \Elementor\Controls_Manager::REPEATER,
    				'fields' => $repeater->get_controls(),
    				'default' => [
    					[
    						'list_title' => __( 'شایان فرهنگ پژوه', 'hamyarlearn' ),
                'list_subtitle' => __( 'بنیانگذار مجموعه‌ی شایان وب', 'hamyarlearn' ),
                'list_content' => __( 'شایان فرهنگ پژوه هستم و 14 سالم هست. 2 سال و نیم میشه بصورت حرفه‌ای دارم در این زمینه فعالیت می‌کنم. من بنیانگذار وبسایت شایان وب، مدرس دوره‌های آموزشی شایان آکادمی و طراح و برنامه‌نویس قالب‌های وردپرس و HTML در شایان مارکت هستم.' , 'hamyarlearn' ),
    					],
    				],
    				'title_field' => '{{{ list_title }}}',
    			]
    		);

    // finish repeter for show lessons list

    		$this->end_controls_section();

        $this->start_controls_section(
			'style_section',
			[
				'label' => __( 'استایل سوالات متداول', 'hamyarlearn' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'PE_teachers_title_typography',
				'label' => __( 'تایپوگرافی عنوان مدرس', 'hamyarlearn' ),
				'selector' => '{{WRAPPER}} .teacher-card div.text-right .teacher-name',
			]
		);

    $this->add_control(
			'PE_teachers_title_color',
			[
				'label' => __( 'رنگ متن عنوان مدرس', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#333',
				'selectors' => [
					'{{WRAPPER}} .teacher-card div.text-right .teacher-name' => 'color: {{VALUE}}',
				],
			]
		);

    $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'PE_teachers_subtitle_typography',
				'label' => __( 'تایپوگرافی زیرعنوان مدرس', 'hamyarlearn' ),
				'selector' => '{{WRAPPER}} .teacher-card div.text-right .teacher-position',
			]
		);

    $this->add_control(
			'PE_teachers_subtitle_color',
			[
				'label' => __( 'رنگ متن زیرعنوان مدرس', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#333',
				'selectors' => [
					'{{WRAPPER}} .teacher-card div.text-right .teacher-position' => 'color: {{VALUE}}',
				],
			]
		);

    $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'PE_teachers_content_typography',
				'label' => __( 'تایپوگرافی توضیحات طولانی', 'hamyarlearn' ),
        'condition' => [
            'teachers_style' => 'full',
        ],
				'selector' => '{{WRAPPER}} .teacher-card.full-card div.text-right .teacher-description',
			]
		);

    $this->add_control(
			'PE_teachers_content_color',
			[
				'label' => __( 'رنگ متن توضیحات طولانی', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#666',
        'condition' => [
            'teachers_style' => 'full',
        ],
				'selectors' => [
					'{{WRAPPER}} .teacher-card.full-card div.text-right .teacher-description' => 'color: {{VALUE}}',
				],
			]
		);

    $this->end_controls_section();

    }

    protected function render(){
      $settings = $this->get_settings_for_display();
      $element_ID = $this->get_id();
      ?>

      <div class="teachers-ele-shweb">

            <div class="teachers-ele-shweb">

                <?php $boxnum=1;
                foreach ( $settings['list'] as $item ) {
                  //
                  if ($settings['teachers_style'] == 'full') { ?>

                    <div class="teacher-card full-card">
                      <div class="row">
                        <figure class="col-xs-12 col-sm-4 col-lg-4 teacher_img">
                          <?php echo wp_get_attachment_image( $item['list_img']['id'] , 'post-thumbnails' ); ?>
                        </figure>
                        <div class="col-sm-6 col-xs-12 text-right">
                          <div class="content-left-padding"></div>
                          <div class="teacher-name">
                            <?php echo $item['list_title']; ?>
                            <div class="teacher-position">
                              <?php echo $item['list_subtitle']; ?>
                            </div>
                          </div>
                          <div class="teacher-description">
                            <?php echo $item['list_content']; ?>
                          </div>
                          <div class="content-left-padding"></div>
                        </div>
                      </div>
                    </div>

                    <?php }else { ?>
                    <div class="teacher-card small-card">
                        <figure class="teacher_img">
                          <?php echo wp_get_attachment_image( $item['list_img']['id'] , 'post-thumbnails' ); ?>
                        </figure>
                        <div class="text-right">
                          <div class="teacher-name">
                            <?php echo $item['list_title']; ?>
                            <div class="teacher-position">
                              <?php echo $item['list_subtitle']; ?>
                            </div>
                          </div>
                        </div>
                    </div>
                    <?php }

              $boxnum = $boxnum+1;
            } ?>

            </div>

          </div>



      <?php } }
