<?php
namespace Elementor;

class hm_PE_title extends Widget_Base
{
    public function get_name()
    {
        return 'hm_PE_title';
    }
    public function get_title()
    {
        return __('نمایش عنوان اصلی دوره', 'hamyarlearn');
    }
    public function get_icon()
    {
        return 'eicon-editor-h1';
    }
    public function get_categories()
    {
        return [ 'HL-Products-Elements' ];
    }
    protected function _register_controls()
    {
        //start section control (tab:content)
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('محتوا', 'hamyarlearn'),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'note_about_woo_title',
			[
				'label' => __( 'توضیحاتی در مورد این المان', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::RAW_HTML,
				'raw' => __( '<div style="font-size:16px; color:#fff; border-radius:10px; padding:10px; line-height:1.9; display:block; background:#F50057; font-weight:500;">این المان، برای قالب همیار لرن می‌باشد.<br>
        با کمک المان‌های محصول (دوره) در همیار لرن، می‌توانید صفحات معرفی دوره که با ووکامرس هستند را
        با المنتور طراحی کنید.<br>
        برای تغییر ظاهر این عنوان صفحه، به تب استایل بروید.</div>', 'hamyarlearn' ),
				'content_classes' => 'element_title_note',
			]
		);



    		$this->end_controls_section();

        $this->start_controls_section(
			'style_section',
			[
				'label' => __( 'استایل عنوان دوره', 'hamyarlearn' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

    $this->add_control(
			'PE_title_text_align',
			[
				'label' => __( 'چیدمان عنوان', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
          'right' => [
						'title' => __( 'راست', 'hamyarlearn' ),
						'icon' => 'fa fa-align-right',
					],
					'center' => [
						'title' => __( 'وسط', 'hamyarlearn' ),
						'icon' => 'fa fa-align-center',
					],
          'left' => [
						'title' => __( 'چپ', 'hamyarlearn' ),
						'icon' => 'fa fa-align-left',
					],
				],
				'default' => 'right',
				'toggle' => true,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'PE_title_typography',
				'label' => __( 'تایپوگرافی عنوان دوره', 'hamyarlearn' ),
				'selector' => '{{WRAPPER}} .ele-cource-title',
			]
		);

    $this->add_control(
			'PE_title_color',
			[
				'label' => __( 'رنگ متن عنوان دوره', 'hamyarlearn' ),
				'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#31576E',
				'selectors' => [
					'{{WRAPPER}} .ele-cource-title' => 'color: {{VALUE}}',
				],
			]
		);

    $this->end_controls_section();

    }

    protected function render(){
      $settings = $this->get_settings_for_display(); ?>

      <h1 style="<?php
      if (!$settings['PE_title_text_align']) {
        $shweb_align = 'right';
      }else {
        $shweb_align = $settings['PE_title_text_align'];
      }
      echo 'text-align:' . $shweb_align ;
      ?>" class="ele-cource-title"><?php the_title(); ?></h1>

  <?php } }
